/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ProjectStatusListPlugin
extends AbstractListPlugin {
    private static final String STATUS_PERM_BTL = "tblstatusperm";

    public void packageData(PackageDataEvent packageDataEvent) {
        if (packageDataEvent.getSource() instanceof ColumnDesc) {
            ColumnDesc column;
            DynamicObject dObject = packageDataEvent.getRowData();
            DynamicObject projectKind = dObject.getDynamicObject("projectkind");
            if (projectKind == null && "projectkind.name".equals((column = (ColumnDesc)packageDataEvent.getSource()).getFieldKey())) {
                packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\uff08\u901a\u7528\uff09", (String)"ProjectStatusListPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
            if (STATUS_PERM_BTL.equals((column = (ColumnDesc)packageDataEvent.getSource()).getFieldKey())) {
                packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u6743\u9650\u5217\u8868", (String)"ProjectStatusListPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String formId = this.getView().getEntityId();
        if ("bos_listf7".equals(formId)) {
            List listColumns = args.getListColumns();
            for (IListColumn listColumn : listColumns) {
                if (!STATUS_PERM_BTL.equals(listColumn.getListFieldKey())) continue;
                listColumn.setVisible(0);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String formId = this.getView().getEntityId();
        Object openFromStatus = this.getView().getFormShowParameter().getCustomParam("open_from_status");
        if ("bos_listf7".equals(formId) && openFromStatus == null) {
            String baseEntityId;
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            if (StringUtils.isBlank((CharSequence)parentPageId)) {
                return;
            }
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)parentView.getEntityId());
            if (dataEntityType == null) {
                return;
            }
            String appId = dataEntityType.getAppId();
            if ("bos".equals(appId)) {
                return;
            }
            Map propertyMap = dataEntityType.getAllFields();
            String projectKindId = null;
            boolean addProjectKindFilter = false;
            for (Map.Entry propertyEntry : propertyMap.entrySet()) {
                if (!(propertyEntry.getValue() instanceof BasedataProp) || !StringUtils.equals((CharSequence)(baseEntityId = ((BasedataProp)propertyEntry.getValue()).getBaseEntityId()), (CharSequence)"bd_projectkind")) continue;
                projectKindId = (String)propertyEntry.getKey();
                break;
            }
            if (projectKindId != null) {
                DynamicObject projectKind = (DynamicObject)parentView.getModel().getValue(projectKindId);
                if (projectKind != null) {
                    e.getQFilters().add(new QFilter("projectkind", "=", projectKind.getPkValue()).or("projectkind", "=", (Object)0L));
                    addProjectKindFilter = true;
                }
            } else {
                for (Map.Entry propertyEntry : propertyMap.entrySet()) {
                    DynamicObject group;
                    DynamicObject bdProject;
                    DynamicObject project;
                    String projectId;
                    if (!(propertyEntry.getValue() instanceof BasedataProp) || !StringUtils.equals((CharSequence)(baseEntityId = ((BasedataProp)propertyEntry.getValue()).getBaseEntityId()), (CharSequence)"bd_project") || !kd.bos.util.StringUtils.isNotEmpty((String)(projectId = (String)propertyEntry.getKey())) || (project = (DynamicObject)parentView.getModel().getValue(projectId)) == null || (bdProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project")) == null || (group = bdProject.getDynamicObject("group")) == null) continue;
                    e.getQFilters().add(new QFilter("projectkind", "=", group.getPkValue()).or("projectkind", "=", (Object)0L));
                    addProjectKindFilter = true;
                }
            }
            if (!addProjectKindFilter) {
                e.getQFilters().add(new QFilter("projectkind", "=", (Object)0L));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkValue = list.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if (STATUS_PERM_BTL.equals(fieldName)) {
            boolean viewPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"basedata", (String)"bd_projectstatus", (String)"4JFHJ5OL3I1O");
            boolean editPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"basedata", (String)"bd_projectstatus", (String)"4JFHKU/TETYO");
            if (!viewPerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u9879\u76ee\u72b6\u6001\u4e1a\u52a1\u5355\u636e\u6743\u9650\u8303\u56f4\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u5411\u7ba1\u7406\u5458\u54a8\u8be2\u3002", (String)"ProjectStatusListPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter proStatusFilter = new QFilter("projectstatus", "=", pkValue);
            DynamicObject statusPerm = BusinessDataServiceHelper.loadSingle((String)"bd_projectstatus_perm", (QFilter[])new QFilter[]{proStatusFilter});
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("bd_projectstatus_perm");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("statusPkValue", pkValue);
            if (statusPerm != null) {
                showParameter.setPkId(statusPerm.getPkValue());
                if (!editPerm) {
                    showParameter.setStatus(OperationStatus.VIEW);
                } else {
                    showParameter.setStatus(OperationStatus.EDIT);
                }
            } else if (!editPerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u72b6\u6001\u672a\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u6743\u9650\u8fc7\u6ee4\u5217\u8868\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"ProjectStatusListPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getView().showForm((FormShowParameter)showParameter);
            args.setCancel(true);
        }
    }
}

