/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListModel;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BDUIWithF7UtilFormPlugin
extends AbstractFormPlugin {
    private static final String ALGO = BDUIWithF7UtilFormPlugin.class.getName();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        String requestId = RequestContext.get().getRequestId();
        IPageCache pageCache = this.getPageCache();
        String alreadyDone = pageCache.get("alreadyDone");
        if (alreadyDone != null && alreadyDone.equals(requestId)) {
            return;
        }
        pageCache.put("alreadyDone", requestId);
        ListShowParameter param = (ListShowParameter)view.getFormShowParameter();
        Map customParams = param.getCustomParams();
        Object beforeF7SelectListeners = customParams.get("er.f7util.beforeF7SelectListeners");
        if (beforeF7SelectListeners != null) {
            ITreeModel treeModel;
            StringBuilder sb = new StringBuilder();
            sb.append("#beforeF7SelectListeners \n");
            sb.append(beforeF7SelectListeners.toString().replace(",", "\n"));
            sb.append("\n\n");
            List<String> pluginsHasSetFilterMethod = this.collectListPluginDefindedMethod("setFilter", new Class[]{SetFilterEvent.class});
            sb.append("#pluginsHasSetFilterMethod \n");
            sb.append(this.join(pluginsHasSetFilterMethod, "\n")).append("\n\n");
            List<String> pluginsHasRefreshNodeMethod = this.collectListPluginDefindedMethod("refreshNode", new Class[]{RefreshNodeEvent.class});
            sb.append("#pluginsHasRefreshNodeMethod \n");
            sb.append(this.join(pluginsHasRefreshNodeMethod, "\n")).append("\n\n");
            ListModel listModel = (ListModel)((BillList)e.getSource()).getListModel();
            List qFilters = listModel.getFilterParameter().getQFilters();
            sb.append("#listFilters \n");
            sb.append(qFilters.toString()).append("\n\n");
            ITreeListView treeListView = ((ListView)this.getView()).getTreeListView();
            if (treeListView != null && null != (treeModel = treeListView.getTreeModel())) {
                List treeFilters = treeModel.getTreeFilter();
                sb.append("#treeFilters \n");
                sb.append(treeFilters.toString()).append("\n\n");
            }
            Object basedataid = customParams.get("er.f7util.basedataid");
            Object basedatano = customParams.get("er.f7util.basedatano");
            if (basedataid != null || basedatano != null) {
                sb.append("#basedata \n");
                sb.append(this.getBasedataInfo(basedataid, basedatano, qFilters));
            }
            String content = sb.toString();
            try {
                String appNumberFile = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("f7util.txt", content.getBytes("utf-8"), 5000);
                this.getView().openUrl(appNumberFile);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private List<String> collectListPluginDefindedMethod(String methodName, Class[] args) {
        ArrayList<String> pluginsHasSetFilterMethod = new ArrayList<String>();
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        List plugIns = proxy.getPlugIns();
        for (IFormPlugin listPlugin : plugIns) {
            Class<?> clazz = listPlugin.getClass();
            try {
                clazz.getMethod(methodName, args);
                pluginsHasSetFilterMethod.add(clazz.getName());
            }
            catch (NoSuchMethodException ex) {}
        }
        return pluginsHasSetFilterMethod;
    }

    private String getBasedataInfo(Object basedataid, Object basedatano, List<QFilter> qFilters) {
        HashSet<String> selectFieldSet = new HashSet<String>();
        for (QFilter qFilter : qFilters) {
            this.getFilterProp(qFilter, selectFieldSet);
        }
        String entityName = ((ListView)this.getView()).getBillFormId();
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        QFilter[] filters = null;
        if (basedataid != null) {
            filters = new QFilter(entityType.getPrimaryKey().getName(), "=", (Object)Long.parseLong(basedataid.toString())).toArray();
        } else if (basedatano != null) {
            filters = new QFilter(entityType.getNumberProperty(), "=", (Object)basedatano.toString()).toArray();
        }
        String selectFields = this.join(selectFieldSet, ",");
        StringBuilder sb = new StringBuilder();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityName, (String)selectFields, (QFilter[])filters, null);){
            String[] fieldNames = ds.getRowMeta().getFieldNames();
            for (String fieldName : fieldNames) {
                sb.append(fieldName).append("\t");
            }
            sb.replace(sb.length() - 1, sb.length(), "\n");
            for (Row row : ds) {
                for (String fieldName : fieldNames) {
                    sb.append(row.get(fieldName)).append("\t");
                }
                sb.replace(sb.length() - 1, sb.length(), "\n");
            }
        }
        return sb.toString();
    }

    private void getFilterProp(QFilter qFilter, Set<String> propSet) {
        String property = qFilter.getProperty();
        propSet.add(property);
        List nests = qFilter.getNests(false);
        for (QFilter.QFilterNest qFilterNest : nests) {
            this.getFilterProp(qFilterNest.getFilter(), propSet);
        }
    }

    private String join(Collection col, String sep) {
        return col.stream().map(v -> v != null ? v.toString() : "null").collect(Collectors.joining(sep));
    }
}

