/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;

public class ExpItemRelCenterQuery
extends AbstractFormPlugin
implements RowClickEventListener,
TabSelectListener {
    public static final String TAB_ITEM_REL_CENTER = "expitemview";
    public static final String TAB_CENTER_REL_ITEM = "centerview";
    protected static final String EXP_EXP_ENTRY = "expitementry";
    protected static final String EXP_CENTER_ENTRY = "expcenterentry";
    protected static final String EXP_CENTER_EXP = "expitem";
    private static final String EXP_CENTER_CENTER = "expcenter";
    private static final String CENTER_EXP_ENTRY = "centerlist";
    private static final String CENTER = "center";
    private static final String CENTER_EXP_EXP_ENTRY = "expitemlist";
    private static final String CENTER_EXP_EXP = "relexpitem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid expEntry = (EntryGrid)this.getControl(EXP_EXP_ENTRY);
        expEntry.addRowClickListener((RowClickEventListener)this);
        EntryGrid centerList = (EntryGrid)this.getControl(CENTER_EXP_ENTRY);
        centerList.addRowClickListener((RowClickEventListener)this);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.activeTab(TAB_ITEM_REL_CENTER);
        this.initExpitemEntry();
        this.initCenterEntryAsyn();
    }

    private void initCenterEntryAsyn() {
        ThreadPools.executeOnce((String)"initCenterEntry", (Runnable)new Runnable(){

            @Override
            public void run() {
                ExpItemRelCenterQuery.this.initCenterEntry();
            }
        });
    }

    private void initExpitemEntry() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List expItems = (List)showParameter.getCustomParam("expitems");
        if (expItems.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(EXP_EXP_ENTRY);
        for (Object expItemId : expItems) {
            int rowIndex = this.getModel().createNewEntryRow(EXP_EXP_ENTRY);
            this.getModel().setValue(EXP_CENTER_EXP, expItemId, rowIndex);
        }
        this.getView().updateView(EXP_EXP_ENTRY);
        int expRowCount = this.getModel().getEntryRowCount(EXP_EXP_ENTRY);
        if (expRowCount > 0) {
            EntryGrid expEntry = (EntryGrid)this.getControl(EXP_EXP_ENTRY);
            expEntry.selectRows(0);
            DynamicObject expItem = (DynamicObject)this.getModel().getValue(EXP_CENTER_EXP, 0);
            this.refreshRelCenters(expItem);
        }
    }

    private void refreshRelCenters(DynamicObject expItem) {
        Object expItemId = expItem.getPkValue();
        Map relCenters = BusinessDataServiceHelper.loadFromCache((String)"bd_expitemrelcenter", (String)"expenseitem, relcenter", (QFilter[])new QFilter("expenseitem", "=", expItemId).toArray());
        ArrayList<Long> relCenterIds = new ArrayList<Long>(relCenters.size());
        for (Map.Entry entry : relCenters.entrySet()) {
            Long relCenterId = (Long)((DynamicObject)entry.getValue()).getDynamicObject("relcenter").getPkValue();
            relCenterIds.add(relCenterId);
        }
        Map centerDyms = BusinessDataServiceHelper.loadFromCache((Object[])relCenterIds.toArray(), (String)"bos_costcenter");
        this.getModel().deleteEntryData(EXP_CENTER_ENTRY);
        for (Map.Entry entry : centerDyms.entrySet()) {
            int centerEntryRow = this.getModel().createNewEntryRow(EXP_CENTER_ENTRY);
            this.getModel().setValue(EXP_CENTER_CENTER, entry.getValue(), centerEntryRow);
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView(EXP_CENTER_ENTRY);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid actEntry = (EntryGrid)evt.getSource();
        String entryKey = actEntry.getEntryKey();
        int[] selectRows = actEntry.getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        switch (entryKey) {
            case "expcenterentry": {
                DynamicObject expItem = (DynamicObject)this.getModel().getValue(EXP_CENTER_EXP, selectRows[0]);
                this.refreshRelCenters(expItem);
                break;
            }
            case "centerlist": {
                DynamicObject center = (DynamicObject)this.getModel().getValue(CENTER, selectRows[0]);
                this.refreshRelExpItems(center);
                break;
            }
        }
    }

    private void refreshRelExpItems(DynamicObject center) {
        Object centerId = center.getPkValue();
        Map relCenters = BusinessDataServiceHelper.loadFromCache((String)"bd_expitemrelcenter", (String)"expenseitem, relcenter", (QFilter[])new QFilter("relcenter", "=", centerId).toArray());
        ArrayList<Long> relItemIds = new ArrayList<Long>(relCenters.size());
        for (Map.Entry entry : relCenters.entrySet()) {
            Long relItemId = (Long)((DynamicObject)entry.getValue()).getDynamicObject("expenseitem").getPkValue();
            relItemIds.add(relItemId);
        }
        Map centerDyms = BusinessDataServiceHelper.loadFromCache((Object[])relItemIds.toArray(), (String)"er_expenseitemedit");
        this.getModel().deleteEntryData(CENTER_EXP_EXP_ENTRY);
        for (Map.Entry entry : centerDyms.entrySet()) {
            int centerEntryRow = this.getModel().createNewEntryRow(CENTER_EXP_EXP_ENTRY);
            this.getModel().setValue(CENTER_EXP_EXP, entry.getValue(), centerEntryRow);
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView(CENTER_EXP_EXP_ENTRY);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        this.initCenterEntry();
    }

    private void initCenterEntry() {
        int expRowCount = this.getModel().getEntryRowCount(CENTER_EXP_ENTRY);
        if (expRowCount > 0) {
            return;
        }
        Map allCenters = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (String)"id,parent", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        allCenters.entrySet().removeIf(entry -> {
            DynamicObject center = (DynamicObject)entry.getValue();
            return center.getDynamicObject("parent") == null;
        });
        this.getModel().deleteEntryData(CENTER_EXP_ENTRY);
        for (Map.Entry entry2 : allCenters.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow(CENTER_EXP_ENTRY);
            this.getModel().setValue(CENTER, entry2.getKey(), rowIndex);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        String key = e.getTabKey();
        if (key.equals(TAB_CENTER_REL_ITEM)) {
            this.getView().updateView(CENTER_EXP_ENTRY);
            int expRowCount = this.getModel().getEntryRowCount(CENTER_EXP_ENTRY);
            if (expRowCount > 0) {
                EntryGrid expEntry = (EntryGrid)this.getControl(CENTER_EXP_ENTRY);
                expEntry.selectRows(0);
                DynamicObject center = (DynamicObject)this.getModel().getValue(CENTER, 0);
                this.refreshRelExpItems(center);
            }
        }
    }
}

