/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ExpenseItemList
extends AbstractTreeListPlugin
implements IConfirmCallBack {
    private static final Log logger = LogFactory.getLog(ExpenseItemList.class);
    private static final String ALGO = ExpenseItemList.class.getName();

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("number asc");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_setrelation".equals(itemKey) || "bar_reldept".equals(itemKey) || "bar_viewreldept".equals(itemKey) || "bar_reldeptnew".equals(itemKey) || "bar_relcenter".equals(itemKey)) {
            ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)this.getSelectedFirstRowKey();
            if (selectedRowCollection == null || selectedRowCollection.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ExpenseItemList_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Set<Long> createOrgs = this.getSelectDataCreateOrg(selectedRowCollection);
            long useOrgId = Long.parseLong(this.getPageCache().get("createOrg"));
            if (createOrgs.stream().filter(v -> !v.equals(useOrgId)).findAny().isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"ExpenseItemList_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String limitInfo = this.getExpenseItemRealSizeLimitInfo();
            if (("bar_reldept".equals(itemKey) || "bar_reldeptnew".equals(itemKey)) && StringUtils.isNotEmpty((CharSequence)limitInfo)) {
                this.getView().showTipNotification(limitInfo);
                evt.setCancel(true);
            }
        }
    }

    private Set<Long> getSelectDataCreateOrg(ListSelectedRowCollection selectedRowCollection) {
        List pks = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_expenseitemedit", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        return loadFromCache.values().stream().map(v -> v.getLong("createorg.id")).collect(Collectors.toSet());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_updateallhaverelorg".equals(itemKey)) {
            this.updateAllHaveRelOrg();
        }
    }

    public void updateAllHaveRelOrg() {
        String sql = "select distinct fexpitemid from t_bd_expitemreldept where 1=1;";
        HashSet<Long> expItemIds = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.basedata, (String)sql);){
            for (Row row : ds) {
                expItemIds.add(row.getLong("fexpitemid"));
            }
        }
        if (expItemIds.size() == 0) {
            return;
        }
        Lists.partition(new ArrayList(expItemIds), (int)3000).forEach(ids -> {
            DynamicObject[] expItems;
            QFilter idsFilter = new QFilter("id", "in", ids);
            for (DynamicObject expItem : expItems = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,haverelorg", (QFilter[])new QFilter[]{idsFilter})) {
                expItem.set("haverelorg", (Object)true);
            }
            SaveServiceHelper.update((DynamicObject[])expItems);
        });
        this.getView().showSuccessNotification("update all expenseitem haverelorg success.");
    }

    private void buildExpItemParam(Map<String, Object> params) {
        ListView list = (ListView)this.getView();
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        ArrayList<Long> expItems = new ArrayList<Long>();
        for (ListSelectedRow row : selectedRows) {
            if (row == null || row.getPrimaryKeyValue() == null) continue;
            expItems.add((Long)row.getPrimaryKeyValue());
        }
        params.put("expitems", expItems);
        ControlFilters filters = list.getControlFilters();
        List orgs = filters.getFilter("useorg.id");
        if (orgs != null && !orgs.isEmpty()) {
            String org = orgs.get(0).toString();
            params.put("org", org);
        } else {
            String createOrg = this.getPageCache().get("createOrg");
            if (StringUtils.isNotBlank((CharSequence)createOrg)) {
                params.put("org", createOrg);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("er_expenseitem_setting".equals(closedCallBackEvent.getActionId())) {
            IListView view = (IListView)this.getView();
            view.refresh();
        }
    }

    private FormShowParameter createShowEditPageParameter(String formId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        this.fillShowParameter(showParameter);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    protected <T> T getSelectedFirstRowKey() {
        IFormView iFormView = this.getView();
        if (!(iFormView instanceof IListView)) {
            return null;
        }
        IListView listView = (IListView)iFormView;
        return (T)listView.getSelectedRows();
    }

    protected void fillShowParameter(FormShowParameter formShowParameter) {
        ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)this.getSelectedFirstRowKey();
        ArrayList<Object> selectedAllPkList = new ArrayList<Object>();
        for (ListSelectedRow selectedRow : selectedRowCollection) {
            selectedAllPkList.add(selectedRow.getPrimaryKeyValue());
        }
        formShowParameter.setCustomParam("id", selectedAllPkList);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        try {
            Boolean isWFCondition;
            String filterString = (String)customParams.get("preFilters");
            if (filterString != null) {
                QFilter preFilters = QFilter.fromSerializedString((String)filterString);
                e.getQFilters().add(preFilters);
            }
            if ((isWFCondition = (Boolean)customParams.get("WFCONDITION")) != null && isWFCondition.booleanValue()) {
                e.getQFilters().add(new QFilter("enable", "=", (Object)Boolean.TRUE));
            }
        }
        catch (Exception exp) {
            logger.error("ExpenseItemList_setFilter>>>", (Throwable)exp);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List _listFilters = null;
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter _param = (ListShowParameter)formShowParameter;
            _listFilters = _param.getListFilterParameter().getQFilters();
        }
        if (_listFilters != null && _listFilters.size() > 0) {
            HashSet<Long> parentIdSet = new HashSet<Long>();
            HashSet<Long> selfIdSet = new HashSet<Long>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"er_expenseitemedit", (String)"parent,id", (QFilter[])_listFilters.toArray(new QFilter[0]), null);){
                for (Row row : ds) {
                    Long parentId = row.getLong("parent");
                    if (parentId != 0L) {
                        parentIdSet.add(parentId);
                    }
                    selfIdSet.add(row.getLong("id"));
                }
            }
            int loopCount = 0;
            HashSet<Long> curParentIdSet = new HashSet<Long>(parentIdSet);
            HashSet<Long> allParentIdSet = new HashSet<Long>();
            while (loopCount <= 10 && !allParentIdSet.containsAll(curParentIdSet)) {
                ++loopCount;
                allParentIdSet.addAll(curParentIdSet);
                DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"er_expenseitemedit", (String)"parent", (QFilter[])new QFilter("id", "in", curParentIdSet).toArray(), null);
                Throwable throwable = null;
                try {
                    curParentIdSet.clear();
                    for (Row row : ds) {
                        Long parentId = row.getLong("parent");
                        if (parentId <= 0L) continue;
                        curParentIdSet.add(parentId);
                        parentIdSet.add(parentId);
                    }
                    if (!curParentIdSet.isEmpty()) continue;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
            List treeFilters = this.getTreeModel().getTreeFilter();
            parentIdSet.addAll(selfIdSet);
            treeFilters.clear();
            treeFilters.add(new QFilter("id", "in", parentIdSet));
        }
        TreeListModel treeListModel = (TreeListModel)e.getSource();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("order", "number asc");
        treeListModel.setQueryParas(map);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Object source;
        super.beforeDoOperation(e);
        String createorg = this.getPageCache().get("createOrg");
        if (StringUtils.isEmpty((CharSequence)createorg)) {
            // empty if block
        }
        if ((source = e.getSource()) instanceof Donothing) {
            Donothing opt = (Donothing)source;
            String operateKey = opt.getOperateKey();
            if (StringUtils.equals((CharSequence)"multimodify", (CharSequence)operateKey)) {
                OperateOption option = opt.getOption();
                if (option != null) {
                    option.setVariableValue("createorg", createorg);
                }
            } else if (StringUtils.equals((CharSequence)"reldept", (CharSequence)operateKey)) {
                String info = ResManager.loadKDString((String)"\u6b64\u6309\u94ae\u9002\u7528\u4e8e\u5bf9\u201c\u5173\u8054\u90e8\u95e8\u201d\u5b8c\u5168\u76f8\u540c\u7684\u8d39\u7528\u9879\u76ee\u8fdb\u884c\u6279\u91cf\u64cd\u4f5c\u3002\u5982\u679c\u52fe\u9009\u7684\u8d39\u7528\u9879\u76ee\u201c\u5173\u8054\u90e8\u95e8\u201d\u4e0d\u540c\uff0c\u7cfb\u7edf\u4f1a\u81ea\u52a8\u5c06\u201c\u5173\u8054\u90e8\u95e8\u201d\u8303\u56f4\u5408\u5e76\uff0c\u4e0e\u8d39\u7528\u9879\u76ee\u91cd\u65b0\u5173\u8054\uff0c\u5e76\u57fa\u4e8e\u91cd\u65b0\u5173\u8054\u7684\u90e8\u95e8\u6570\u636e\u8fdb\u884c\u589e\u52a0\u6216\u79fb\u9664\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ExpenseItemList_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("reldept", (IFormPlugin)this);
                this.getView().showConfirm(info, MessageBoxOptions.YesNo, confirmCallBacks);
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("reldept".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            FormShowParameter showParameter = this.createShowEditPageParameter("bd_expitemreldeptedit");
            Map params = showParameter.getCustomParams();
            params = params == null ? new HashMap() : params;
            this.buildExpItemParam(params);
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object source = e.getSource();
        boolean isSuccess = false;
        if (e.getOperationResult() != null) {
            isSuccess = e.getOperationResult().isSuccess();
        }
        if (source instanceof Donothing) {
            FormShowParameter showParameter;
            OperationResult operationResult;
            Donothing opt = (Donothing)source;
            String operateKey = opt.getOperateKey();
            if (StringUtils.equals((CharSequence)"multimodify", (CharSequence)operateKey) && (operationResult = e.getOperationResult()) != null && !operationResult.getSuccessPkIds().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"ExpenseItemList_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                this.getView().updateView();
            }
            if (StringUtils.equals((CharSequence)"viewreldept", (CharSequence)operateKey) && isSuccess) {
                showParameter = this.createShowEditPageParameter("bd_expitemreldeptview");
                Map params = showParameter.getCustomParams();
                params = params == null ? new HashMap() : params;
                this.buildExpItemParam(params);
                showParameter.setCustomParams(params);
                this.getView().showForm(showParameter);
            } else if (StringUtils.equals((CharSequence)"reldeptnew", (CharSequence)operateKey) && isSuccess) {
                showParameter = this.createShowEditPageParameter("bd_expitemreldeptedit");
                Map params = showParameter.getCustomParams();
                params = params == null ? new HashMap() : params;
                this.buildExpItemParam(params);
                params.put("reldeptnew", "true");
                showParameter.setCustomParams(params);
                this.getView().showForm(showParameter);
            } else if (StringUtils.equals((CharSequence)"setrelation", (CharSequence)operateKey) && isSuccess) {
                FormShowParameter parameter = this.createShowEditPageParameter("er_expenseitem_setting");
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_expenseitem_setting"));
                parameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm(parameter);
            } else if (StringUtils.equals((CharSequence)"relcenter", (CharSequence)operateKey) && isSuccess) {
                showParameter = this.createShowEditPageParameter("bd_expitemrelcenteredit");
                Map params = showParameter.getCustomParams();
                params = params == null ? new HashMap() : params;
                this.buildExpItemParam(params);
                showParameter.setCustomParams(params);
                this.getView().showForm(showParameter);
            } else if (StringUtils.equals((CharSequence)"viewrelcenter", (CharSequence)operateKey) && isSuccess) {
                showParameter = this.createShowEditPageParameter("bd_expitemrelcenterview");
                Map params = showParameter.getCustomParams();
                params = params == null ? new HashMap() : params;
                this.buildExpItemParam(params);
                showParameter.setCustomParams(params);
                this.getView().showForm(showParameter);
            }
        }
    }

    private String getExpenseItemRealSizeLimitInfo() {
        ListView list = (ListView)this.getView();
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        ArrayList<Long> expItems = new ArrayList<Long>();
        for (ListSelectedRow row : selectedRows) {
            if (row == null || row.getPrimaryKeyValue() == null) continue;
            expItems.add((Long)row.getPrimaryKeyValue());
        }
        HashSet<Long> relExpItems = new HashSet<Long>(expItems);
        relExpItems.addAll(expItems);
        HashSet<Long> levelExpItems = new HashSet<Long>(relExpItems);
        while (!levelExpItems.isEmpty()) {
            QFilter[] filters = new QFilter("parent", "in", levelExpItems).toArray();
            DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"er_expenseitemedit", (String)"id", (QFilter[])filters, null);
            Throwable throwable = null;
            try {
                levelExpItems.clear();
                for (Row row : ds) {
                    levelExpItems.add(row.getLong("id"));
                }
                relExpItems.addAll(levelExpItems);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        String msg = "";
        if (relExpItems.size() > 1000) {
            msg = String.format(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u9879\u76ee\u53ca\u5176\u5b50\u7ea7\u8d39\u7528\u9879\u76ee\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc71000\u4e2a\uff0c\u5f53\u524d\u4e3a%d\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EM-E-732311", (String)"bd-assistant-formplugin", (Object[])new Object[0]), relExpItems.size());
        }
        return msg;
    }
}

