/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.ORM;
import org.apache.commons.lang3.StringUtils;

public class ExpenseItemSelectPic
extends AbstractBasePlugIn
implements RowClickEventListener {
    public void initialize() {
        super.initialize();
        for (int i = 0; i < 18; ++i) {
            this.addClickListeners(new String[]{"btn_confirm", "btn_cancle", "label_1", "label_2", "label_3", "label_4", "label_5", "label_6", "label_7"});
        }
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        ORM orm = ORM.create();
        DynamicObject expenseItemPic = orm.newDynamicObject("er_expenseitempic");
        DynamicObjectCollection entry = expenseItemPic.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection expenseItemIcons = orm.query("er_expenseitempic", "id,icon", null);
        String server = RequestContext.get().getClientFullContextPath();
        for (DynamicObject expenseItemIcon : expenseItemIcons) {
            DynamicObject entryObj = entry.addNew();
            String iconUrl = (String)expenseItemIcon.get("icon");
            if (!StringUtils.isBlank((CharSequence)iconUrl) && StringUtils.startsWith((CharSequence)iconUrl, (CharSequence)"icon")) {
                iconUrl = server + iconUrl;
            }
            String iconValue = iconUrl + ",#6286F5";
            entryObj.set("iconfield", (Object)iconValue);
        }
        e.setDataEntity((Object)expenseItemPic);
    }

    public void changeIconBackColor(String color) {
        ORM orm = ORM.create();
        IDataModel model = this.getModel();
        DynamicObjectCollection expenseItemIcons = orm.query("er_expenseitempic", "id,icon", null);
        String server = RequestContext.get().getClientFullContextPath();
        for (int i = 0; i < expenseItemIcons.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)expenseItemIcons.get(i);
            String iconUrl = entryObj.getString("icon");
            if (!StringUtils.isBlank((CharSequence)iconUrl) && StringUtils.startsWith((CharSequence)iconUrl, (CharSequence)"icon")) {
                iconUrl = server + iconUrl;
            }
            String iconValue = iconUrl + "," + color;
            model.setValue("iconfield", (Object)iconValue, i);
        }
        model.setValue("color", (Object)color);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IDataModel model = this.getModel();
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_confirm": {
                String iconfield = this.getPageCache().get("iconfield");
                String color = model.getDataEntity().getString("color");
                if (" ".equals(color)) {
                    color = "#6286F5";
                }
                if (iconfield == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fe\u6807\u3002", (String)"ExpenseItemSelectPic_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    break;
                }
                iconfield = iconfield + "," + color;
                this.getView().returnDataToParent((Object)iconfield);
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
            case "btn_cancle": {
                this.getView().close();
                break;
            }
            case "label_1": {
                this.changeIconBackColor("#6286F5");
                break;
            }
            case "label_2": {
                this.changeIconBackColor("#55A0F5");
                break;
            }
            case "label_3": {
                this.changeIconBackColor("#2EC6C8");
                break;
            }
            case "label_4": {
                this.changeIconBackColor("#99CA71");
                break;
            }
            case "label_5": {
                this.changeIconBackColor("#F4984E");
                break;
            }
            case "label_6": {
                this.changeIconBackColor("#E5809D");
                break;
            }
            case "label_7": {
                this.changeIconBackColor("#B5A1DD");
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent rowClickEvent) {
        int index = rowClickEvent.getRow();
        if (index < 0) {
            return;
        }
        DynamicObject iconObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(index);
        String iconfield = iconObject.getString("iconfield");
        this.getPageCache().put("iconfield", iconfield);
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }
}

