/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.taxc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaxCategoryPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getView().getControl("taxarea");
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("taxarea".equalsIgnoreCase(fieldKey)) {
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsysid");
            if (taxationsys == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxCategoryPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long countryId = taxationsys.getLong("countryid.id");
            List<Long> ids = this.getTaxAreaByCountryId(countryId);
            QFilter idFilter = ids.size() > 0 ? new QFilter("id", "in", ids) : new QFilter("id", "=", (Object)-1L);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(idFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("taxationsysid".equals(propertyName)) {
            Long countryId;
            List<Long> ids;
            DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
            if (newValue != null && (ids = this.getTaxAreaByCountryId(countryId = Long.valueOf(newValue.getLong("countryid.id")))).size() > 0) {
                this.getModel().setValue("taxarea", (Object)new Object[]{ids.get(0)});
                return;
            }
            this.getModel().setValue("taxarea", null);
        }
    }

    private List<Long> getTaxAreaByCountryId(Long countryId) {
        List<Long> ids = new ArrayList<Long>();
        Date now = new Date();
        QFilter qFilter = new QFilter("country", "=", (Object)countryId).and("enable", "=", (Object)"1").and("group.enable", "=", (Object)"1").and("startdate", "<=", (Object)now).and(QFilter.isNull((String)"enddate").or("enddate", ">=", (Object)now));
        DynamicObject[] taxareaObjects = BusinessDataServiceHelper.load((String)"bastax_taxarea", (String)"id,group", (QFilter[])new QFilter[]{qFilter});
        if (taxareaObjects != null && taxareaObjects.length > 0) {
            ids = Arrays.stream(taxareaObjects).map(o -> o.getLong("group.id")).collect(Collectors.toList());
        }
        return ids;
    }
}

