/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orgview.costcenter.strategy.IColsSelectStrategy;
import kd.bos.orgview.costcenter.strategy.MetaHelper;
import kd.bos.orgview.costcenter.strategy.SelectParams;
import kd.bos.orgview.costcenter.strategy.TypeSelectStrategy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CostCenterFieldEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"costcenterfieldname", "sourcefieldname"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("costcenterfieldname".equals(key)) {
            this.clickField(true);
        }
        if ("sourcefieldname".equals(key)) {
            this.clickField(false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        model.beginInit();
        String closeKey = e.getActionId();
        int index = model.getEntryCurrentRowIndex("entryentity");
        JSONArray data = this.parseReturnData(e);
        if (data != null && data.size() > 0) {
            JSONObject info = data.getJSONObject(0);
            if (!data.isEmpty()) {
                if ("costCenterFieldNameCol".equals(closeKey)) {
                    String costCenterField = info.getString("id");
                    model.setValue("costcenterfieldname", (Object)info.getString("text"), index);
                    model.setValue("costcenterfield", (Object)costCenterField, index);
                    this.getView().updateView("costcenterfieldname", index);
                    this.getView().updateView("costcenterfield", index);
                }
                if ("sourceFieldNameCol".equals(closeKey)) {
                    String businessBillId = this.getModel().getDataEntity().getString("businessbill.id");
                    String sourceField = info.getString("id");
                    model.setValue("sourcefieldname", (Object)info.getString("text"), index);
                    model.setValue("sourcefield", (Object)sourceField, index);
                    IDataEntityProperty fieldType = this.getFieldType(businessBillId, sourceField);
                    if (fieldType instanceof BasedataProp) {
                        BasedataProp basedataProp = (BasedataProp)fieldType;
                        if (basedataProp instanceof OrgProp) {
                            OrgProp orgProp = (OrgProp)basedataProp;
                            String orgFunc = orgProp.getOrgFunc();
                            String baseEntityId = basedataProp.getBaseEntityId();
                            if (!StringUtils.isEmpty((CharSequence)orgFunc) && "01".equals(orgFunc)) {
                                model.setValue("sourcefieldtype", (Object)"bos_adminorg", index);
                                this.getView().updateView("sourcefieldtype", index);
                            } else {
                                model.setValue("sourcefieldtype", (Object)baseEntityId, index);
                                this.getView().updateView("sourcefieldtype", index);
                            }
                        } else {
                            String baseEntityId = basedataProp.getBaseEntityId();
                            model.setValue("sourcefieldtype", (Object)baseEntityId, index);
                            this.getView().updateView("sourcefieldtype", index);
                        }
                    }
                    this.getView().updateView("sourcefieldname", index);
                    this.getView().updateView("sourcefield", index);
                }
            }
            model.endInit();
        }
    }

    private IDataEntityProperty getFieldType(String entityNumber, String costField) {
        String[] split = costField.split("\\.");
        costField = split.length == 1 ? split[0] : split[split.length - 1];
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = mainEntityType.getAllFields();
        return (IDataEntityProperty)allFields.get(costField);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "businessbill": {
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "costcenterfieldname": 
            case "sourcefieldname": {
                this.clearSourceField(e, proName);
                break;
            }
        }
    }

    private void clearSourceField(PropertyChangedArgs e, String proName) {
        ChangeData[] data;
        this.getModel().beginInit();
        ChangeData[] var3 = data = e.getChangeSet();
        int var4 = data.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            ChangeData changeData = var3[var5];
            int rowIndex = changeData.getRowIndex();
            if ("costcenterfieldname".equals(proName)) {
                this.getModel().setValue("costcenterfieldname", null, rowIndex);
                this.getModel().setValue("costcenterfield", null, rowIndex);
                this.getView().updateView("costcenterfieldname", rowIndex);
                this.getView().updateView("costcenterfield", rowIndex);
                continue;
            }
            if (!"sourcefieldname".equals(proName)) continue;
            this.getModel().setValue("sourcefieldname", null, rowIndex);
            this.getModel().setValue("sourcefield", null, rowIndex);
            this.getModel().setValue("sourcefieldtype", null, rowIndex);
            this.getView().updateView("sourcefieldname", rowIndex);
            this.getView().updateView("sourcefield", rowIndex);
            this.getView().updateView("sourcefieldtype", rowIndex);
        }
        this.getModel().endInit();
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter;
        Object businessBill;
        super.afterCreateNewData(e);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        boolean isAddNew = OperationStatus.ADDNEW.equals((Object)os);
        if (isAddNew && (businessBill = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("businessbill")) != null) {
            this.getModel().setValue("businessbill", businessBill);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                DynamicObject businessBill = (DynamicObject)this.getModel().getValue("businessbill");
                if (businessBill == null) break;
                String businessBillNumber = businessBill.getString("number");
                QFilter qFilter = new QFilter("businessbill", "=", (Object)businessBillNumber);
                DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
                if (billType != null) {
                    Long billTypeId = billType.getLong("id");
                    qFilter.and("billtype", "=", (Object)billTypeId);
                }
                Long id = (Long)this.getModel().getValue("id");
                qFilter.and("id", "!=", (Object)id);
                DynamicObject existFieldMap = QueryServiceHelper.queryOne((String)"bos_costcenterfieldmap", (String)"number,name", (QFilter[])qFilter.toArray());
                if (existFieldMap == null) break;
                args.setCancel(true);
                String tip = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61\u4e0e\u53d6\u503c\u914d\u7f6e\u5355\u201c%1$s/%2$s\u201d\u91cd\u590d\u3002", (String)"CostCenterFieldEditPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), existFieldMap.getString("number"), existFieldMap.getString("name"));
                this.getView().showTipNotification(tip);
                return;
            }
        }
    }

    private JSONArray parseReturnData(ClosedCallBackEvent evt) {
        Object data = evt.getReturnData();
        try {
            return JSON.parseArray((String)((String)data));
        }
        catch (Exception var3) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a%1$s \u53c2\u6570\uff1a%2$s\u3002", (String)"CostCenterFieldEditPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]), var3.getMessage(), data));
        }
    }

    private void clickField(Boolean isCostCenter) {
        IDataModel model = this.getModel();
        DynamicObject businessBill = (DynamicObject)model.getValue("businessbill");
        if (businessBill == null) {
            String tips = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"CostCenterFieldEditPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
        } else {
            String caption;
            String actionId;
            String sourceBillNumber = businessBill.getString("number");
            TypeSelectStrategy typeSelectStrategy = new TypeSelectStrategy((IDataEntityProperty)new BasedataProp());
            typeSelectStrategy.setUnLimitBaseData(true);
            if (isCostCenter.booleanValue()) {
                actionId = "costCenterFieldNameCol";
                caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u4e2d\u5fc3\u5b57\u6bb5", (String)"CostCenterFieldEditPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]);
            } else {
                actionId = "sourceFieldNameCol";
                caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u503c\u5b57\u6bb5", (String)"CostCenterFieldEditPlugin_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            SelectParams params = new SelectParams();
            MetaHelper metaHelper = new MetaHelper((IColsSelectStrategy)typeSelectStrategy, sourceBillNumber);
            if (isCostCenter.booleanValue()) {
                HashSet<String> existFields = new HashSet<String>(10);
                DynamicObjectCollection fieldMap = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject colMap : fieldMap) {
                    String selectField = colMap.getString("costcenterfield");
                    if (!StringUtils.isNotEmpty((CharSequence)selectField)) continue;
                    String[] splitKey = selectField.split("\\.");
                    if (splitKey.length > 1) {
                        selectField = splitKey[splitKey.length - 1];
                    }
                    existFields.add(selectField);
                }
                metaHelper.setExistFields(existFields);
            }
            metaHelper.setCostCenter(isCostCenter);
            String jsonTree = metaHelper.buildTree2JSON();
            params.setJsonTree(jsonTree);
            FormShowParameter fp = this.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, actionId));
            if (StringUtils.isNotEmpty((CharSequence)caption)) {
                fp.setCaption(caption);
            }
            this.getView().showForm(fp);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_enable": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u542f\u7528\u914d\u7f6e\uff0c\u914d\u7f6e\u5355\u636e\u4e1a\u52a1\u6267\u884c\u65f6\u5c06\u81ea\u52a8\u586b\u5145\u6210\u672c\u4e2d\u5fc3\u5b57\u6bb5\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostCenterFieldEditPlugin_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("enable", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
            case "bar_disable": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u914d\u7f6e\uff0c\u5355\u636e\u7684\u6210\u672c\u4e2d\u5fc3\u5b57\u6bb5\u5c06\u505c\u6b62\u81ea\u52a8\u586b\u5145\u670d\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostCenterFieldEditPlugin_6", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("disable", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("enable".equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getView().invokeOperation("enable");
        } else if ("disable".equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getView().invokeOperation("disable");
        }
    }

    private FormShowParameter readyColsTreePage(SelectParams params, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }
}

