/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.ParentBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orgview.costcenter.CostCenterTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CostCenterFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(CostCenterFormPlugin.class);
    public static final String OP_SEARCH_UP = "searchup";
    public static final String OP_SAVE = "save";
    public static final String ACTION_OPENDATAF7 = "openDataF7";
    private static final String SOURCE_TYPE = "sourcetype";
    private static final String CHANGE_FIELD = "changeFiled";
    public static final String ENTITY_COSTCENTERSOURCE_MAP = "bos_costcentersourcemap";
    public static final String DATE_TO_STRING_DETAIAL_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ParentBasedataEdit parentEdit = (ParentBasedataEdit)this.getControl("parent");
        parentEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent arg0) {
                Object longNumber = CostCenterFormPlugin.this.getModel().getValue("longnumber");
                if (StringUtils.isNotBlank((Object)longNumber)) {
                    ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
                    QFilter longnumberFilter = new QFilter("longnumber", "!=", longNumber);
                    QFilter subFilter = new QFilter("longnumber", "not like", (Object)(longNumber + CostCenterTreeUtils.getLongNumberDML() + "%"));
                    longnumberFilter = longnumberFilter.and(subFilter);
                    listShowParameter.getListFilterParameter().getQFilters().add(longnumberFilter);
                }
            }
        });
        ItemClassEdit dataEdit = (ItemClassEdit)this.getControl("data");
        dataEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent arg0) {
                EntryGrid eg = (EntryGrid)CostCenterFormPlugin.this.getControl("entryentity");
                int focusRowIndex = eg.getEntryState().getFocusRow();
                DynamicObject focusRowData = CostCenterFormPlugin.this.getModel().getEntryRowEntity("entryentity", focusRowIndex);
                if (focusRowData == null) {
                    arg0.setCancel(true);
                    CostCenterFormPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u6dfb\u52a0\u6765\u6e90\u6570\u636e\u7684\u884c\u3002", (String)"CostCenterFormPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject sourceTypeObj = focusRowData.getDynamicObject(CostCenterFormPlugin.SOURCE_TYPE);
                if (sourceTypeObj == null) {
                    arg0.setCancel(true);
                    CostCenterFormPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u7c7b\u578b", (String)"CostCenterFormPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
                listShowParameter.setMultiSelect(true);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)CostCenterFormPlugin.this, CostCenterFormPlugin.ACTION_OPENDATAF7));
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (ACTION_OPENDATAF7.equals(actionId)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)evt.getReturnData();
            this.fillbackSelectedData(selectedRows);
        }
    }

    private void fillbackSelectedData(ListSelectedRowCollection selectedRows) {
        int remindCount;
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        int focusRowIndex = eg.getEntryState().getFocusRow();
        DynamicObject focusRowData = this.getModel().getEntryRowEntity("entryentity", focusRowIndex);
        DynamicObject sourceTypeObj = focusRowData.getDynamicObject(SOURCE_TYPE);
        long currentSourceTypeId = sourceTypeObj.getLong("id");
        DynamicObject bizObj = sourceTypeObj.getDynamicObject("bizobject");
        if (bizObj == null) {
            return;
        }
        String bizObjNumber = bizObj.getString("number");
        ArrayList<String> selectedIds = new ArrayList<String>(selectedRows.size());
        boolean isSettedFocusRow = false;
        for (ListSelectedRow row : selectedRows) {
            if (isSettedFocusRow) {
                selectedIds.add(row.getPrimaryKeyValue().toString());
                continue;
            }
            isSettedFocusRow = true;
            this.getModel().setValue("data", row.getPrimaryKeyValue(), focusRowIndex);
        }
        if (!selectedIds.isEmpty()) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            int entryRowIndex = -1;
            for (DynamicObject entityRow : entryentity) {
                DynamicObject sourcetypeObj;
                DynamicObject dataObj;
                if (focusRowIndex == ++entryRowIndex || (dataObj = entityRow.getDynamicObject("data")) != null || (sourcetypeObj = entityRow.getDynamicObject(SOURCE_TYPE)) == null || currentSourceTypeId != sourcetypeObj.getLong("id")) continue;
                this.getModel().setValue("data", selectedIds.get(0), entryRowIndex);
                selectedIds.remove(0);
                if (!selectedIds.isEmpty()) continue;
                break;
            }
        }
        if ((remindCount = selectedIds.size()) != 0) {
            this.getPageCache().put("isLoadData", "1");
            int[] newRowIndexArr = this.getModel().batchCreateNewEntryRow("entryentity", remindCount);
            for (Object newRowIndex : (Object)newRowIndexArr) {
                this.getModel().setValue(SOURCE_TYPE, (Object)currentSourceTypeId, (int)newRowIndex);
                this.getModel().setValue("sourcetypeobj", (Object)bizObjNumber, (int)newRowIndex);
                this.getModel().setValue("data", selectedIds.get(0), (int)newRowIndex);
                selectedIds.remove(0);
                if (selectedIds.isEmpty()) break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_SAVE.equals(operateKey)) {
            Long costCenterId = (Long)this.getModel().getDataEntity().getPkValue();
            if (costCenterId != null && costCenterId != 0L) {
                QFilter qFilter;
                boolean isExist;
                String orgDutyChange;
                boolean isEnableNameVersion = BaseDataServiceHelper.isEnableNameVersion((String)"bos_costcenter");
                String dataChange = this.getPageCache().get(CHANGE_FIELD);
                if (isEnableNameVersion && "true".equals(dataChange) && "1".equals(CostCenterTreeUtils.getCadBgParamForString("checkCostCenterReference", "0"))) {
                    ArrayList<String> ignoreRefEntityIds = new ArrayList<String>();
                    ignoreRefEntityIds.add("bos_costcentersource");
                    ignoreRefEntityIds.add("bos_costcenter");
                    Map referenceResultMap = BaseDataRefrenceHelper.checkRefrenced((String)"bos_costcenter", (Object[])new Object[]{costCenterId}, ignoreRefEntityIds, null, null);
                    if (!CollectionUtils.isEmpty((Map)referenceResultMap)) {
                        args.setCancel(true);
                        String tip = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6709\u4e1a\u52a1\u53d1\u751f\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CostCenterFormPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
                        StringBuilder sb = new StringBuilder();
                        for (BaseDataCheckRefrenceResult baseData : referenceResultMap.values()) {
                            sb.append(baseData.getRefenceKey()).append(";");
                        }
                        logger.info("referenceResultMap -> {}", (Object)sb.toString());
                        this.getView().showTipNotification(tip);
                        return;
                    }
                }
                if ("true".equals(orgDutyChange = this.getPageCache().get("orgdutychange")) && (isExist = QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])(qFilter = new QFilter("costcenter", "=", (Object)costCenterId)).toArray()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6210\u672c\u4e2d\u5fc3\u7c7b\u578b\u3002", (String)"CostCenterFormPlugin_6", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            this.checkSourceTypeData(args);
        } else if (OP_SEARCH_UP.equals(operateKey)) {
            this.searchUpMappingBill();
        }
    }

    private void searchUpMappingBill() {
        Long costCenterId = (Long)this.getModel().getDataEntity().getPkValue();
        if (costCenterId == null || costCenterId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u67e5\u6620\u5c04\u914d\u7f6e\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCenterFormPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("costcenter", "=", (Object)costCenterId);
        List costCenterMapIds = QueryServiceHelper.queryPrimaryKeys((String)ENTITY_COSTCENTERSOURCE_MAP, (QFilter[])qFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)costCenterMapIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u4e2d\u5fc3\u672a\u5173\u8054\u6709\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u914d\u7f6e\u3002", (String)"CostCenterFormPlugin_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(ENTITY_COSTCENTERSOURCE_MAP);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setShowFilter(false);
        listShowParameter.setShowQuickFilter(false);
        listShowParameter.setCustomParam("costCenterMapIds", (Object)costCenterMapIds);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.equals((CharSequence)"sca", (CharSequence)appId) || StringUtils.equals((CharSequence)"aca", (CharSequence)appId)) {
            BasedataEdit accountOrgEdit = (BasedataEdit)this.getControl("accountorg");
            accountOrgEdit.setMustInput(true);
        }
        String costCenterID = this.getModel().getDataEntity().getPkValue().toString();
        this.setDataSourceEntry(costCenterID);
        this.lockRootParent();
        this.getModel().setDataChanged(false);
    }

    private void lockRootParent() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        boolean isParentMustInput = true;
        if (StringUtils.isBlank((Object)pkValue) || "0".equals(pkValue.toString())) {
            QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
            QFilter[] qFilters = new QFilter[]{parentFilter};
            if (!QueryServiceHelper.exists((String)"bos_costcenter", (QFilter[])qFilters)) {
                isParentMustInput = false;
                this.getView().setEnable(Boolean.FALSE, new String[]{"parent"});
                this.getModel().setValue("id", (Object)100000L);
            }
        } else {
            DynamicObject parentObj = (DynamicObject)this.getModel().getValue("parent");
            if (parentObj == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"parent"});
                isParentMustInput = false;
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"parent"});
            }
        }
        ParentBasedataEdit parentEdit = (ParentBasedataEdit)this.getControl("parent");
        parentEdit.setMustInput(isParentMustInput);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        switch (proName = e.getProperty().getName()) {
            case "sourcetype": {
                this.changeSourceTypeBizObject();
                break;
            }
            case "number": 
            case "name": 
            case "parent": 
            case "accountorg": {
                this.getPageCache().put(CHANGE_FIELD, "true");
                break;
            }
            case "orgduty": {
                this.getPageCache().put(CHANGE_FIELD, "true");
                this.getPageCache().put("orgdutychange", "true");
                break;
            }
        }
    }

    private void loadSourceTypeBizObject(String bizObjNumber) {
        if (StringUtils.isBlank((CharSequence)bizObjNumber)) {
            return;
        }
        ItemClassTypeEdit typeEdit = (ItemClassTypeEdit)this.getControl("sourcetypeobj");
        if (typeEdit == null) {
            return;
        }
        ItemClassTypeProp typeProp = (ItemClassTypeProp)typeEdit.getProperty();
        Map itemTypeMap = typeProp.getItemTypes();
        if (itemTypeMap == null || itemTypeMap.containsKey(bizObjNumber)) {
            return;
        }
        typeProp.setItemType((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)bizObjNumber));
    }

    public void afterDoOperation(AfterDoOperationEventArgs adoe) {
        super.afterDoOperation(adoe);
        this.changeSourceTypeBizObject();
        if (adoe.getOperateKey().equals(OP_SAVE)) {
            String costCenterID = this.getModel().getDataEntity().getPkValue().toString();
            this.setDataSourceEntry(costCenterID);
            this.setCostCenterSourceMap(costCenterID);
            this.getModel().setDataChanged(false);
        }
    }

    private void setCostCenterSourceMap(String costCenterID) {
        QFilter qFilter = new QFilter("costcenter", "=", (Object)Long.parseLong(costCenterID));
        boolean isExitSourceMap = QueryServiceHelper.exists((String)ENTITY_COSTCENTERSOURCE_MAP, (QFilter[])qFilter.toArray());
        if (isExitSourceMap) {
            return;
        }
        if (this.isExistCostCenterSource(Long.parseLong(costCenterID))) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            DynamicObject costCenterSourceMap = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_COSTCENTERSOURCE_MAP);
            costCenterSourceMap.set("number", this.getModel().getValue("number"));
            costCenterSourceMap.set("name", this.getModel().getValue("name"));
            costCenterSourceMap.set("costcenter", (Object)Long.parseLong(costCenterID));
            costCenterSourceMap.set("longnumber", this.getModel().getValue("longnumber"));
            costCenterSourceMap.set("parent", this.getModel().getValue("parent"));
            costCenterSourceMap.set("effectdate", (Object)CostCenterFormPlugin.getDeFaultEffectDate());
            costCenterSourceMap.set("expdate", (Object)CostCenterFormPlugin.getDeFaultExpDate());
            costCenterSourceMap.set("creator", this.getModel().getValue("creator"));
            costCenterSourceMap.set("createtime", this.getModel().getValue("createtime"));
            DynamicObjectCollection mapEntryEntity = costCenterSourceMap.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                DynamicObject sourceType = entry.getDynamicObject(SOURCE_TYPE);
                DynamicObject sourceData = entry.getDynamicObject("data");
                DynamicObject mapEntry = mapEntryEntity.addNew();
                mapEntry.set(SOURCE_TYPE, sourceType.get("number"));
                mapEntry.set("sourcedata", (Object)sourceData);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{costCenterSourceMap});
        }
    }

    private boolean isExistCostCenterSource(Long costCenterId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return Boolean.FALSE;
        }
        ArrayList<Long> sourceDataIds = new ArrayList<Long>(10);
        for (DynamicObject entry : entryEntity) {
            DynamicObject sourceData = entry.getDynamicObject("data");
            if (sourceData == null) continue;
            sourceDataIds.add(sourceData.getLong("id"));
        }
        if (sourceDataIds.size() == 0) {
            return Boolean.FALSE;
        }
        QFilter qfCostCenter = new QFilter("costcenter", "!=", (Object)costCenterId);
        QFilter qfDataId = new QFilter("entryentity.sourcedata", "in", (Object)sourceDataIds.toArray());
        qfCostCenter.and("effectdate", "<=", (Object)new Date());
        qfCostCenter.and("expdate", ">", (Object)new Date());
        DynamicObjectCollection centerSource = QueryServiceHelper.query((String)ENTITY_COSTCENTERSOURCE_MAP, (String)"entryentity.sourcetype sourcetype,entryentity.sourcedata sourcedata", (QFilter[])new QFilter[]{qfCostCenter, qfDataId});
        if (centerSource == null || centerSource.size() == 0) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject curRow = (DynamicObject)entryEntity.get(i);
            if (centerSource.stream().filter(p -> p.getString(SOURCE_TYPE).equals(curRow.getString("sourcetype.number")) && p.getLong("sourcedata") == curRow.getLong("data.id")).count() == 0L) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Date getDeFaultEffectDate() {
        return CostCenterFormPlugin.parseDate("2000-01-01 00:00:00");
    }

    private static Date getDeFaultExpDate() {
        return CostCenterFormPlugin.parseDate("2999-12-31 23:59:59");
    }

    public static Date parseDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return date;
    }

    private void setDataSourceEntry(String costCenterID) {
        if ("0".equals(costCenterID)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("costcenter.id", "=", (Object)Long.valueOf(costCenterID))};
        String selectFields = "id,costcenter,sourcetype,sourcetype.bizobject.number bizobjnumber,data";
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_costcentersource", (String)"id,costcenter,sourcetype,sourcetype.bizobject.number bizobjnumber,data", (QFilter[])filters);
        if (!col.isEmpty()) {
            int entrySize;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity != null && entryEntity.size() > 0) {
                entrySize = entryEntity.size();
            } else {
                entrySize = col.size();
                this.getModel().deleteEntryData("entryentity");
                this.getModel().batchCreateNewEntryRow("entryentity", entrySize);
            }
            for (int index = 0; index < entrySize && index < col.size(); ++index) {
                DynamicObject object = (DynamicObject)col.get(index);
                if (object == null) continue;
                this.getPageCache().put("isLoadData", "1");
                this.getModel().setValue("entryid", object.get("id"), index);
                this.getModel().setValue(SOURCE_TYPE, object.get(SOURCE_TYPE), index);
                String bizObjNumber = object.getString("bizobjnumber");
                this.loadSourceTypeBizObject(bizObjNumber);
                this.getModel().setValue("sourcetypeobj", (Object)bizObjNumber, index);
                this.getModel().setValue("data", (Object)object.getLong("data"), index);
            }
        }
    }

    private void changeSourceTypeBizObject() {
        EntryGrid entryentityObj = (EntryGrid)this.getControl("entryentity");
        int focusRowIndex = entryentityObj.getEntryState().getFocusRow();
        if (focusRowIndex < 0) {
            return;
        }
        DynamicObject focusRowObj = this.getModel().getEntryRowEntity("entryentity", focusRowIndex);
        if (focusRowObj == null) {
            return;
        }
        DynamicObject sourcetype = focusRowObj.getDynamicObject(SOURCE_TYPE);
        if (sourcetype == null) {
            return;
        }
        DynamicObject bizobject = sourcetype.getDynamicObject("bizobject");
        if (bizobject == null) {
            return;
        }
        String bizObjNumber = bizobject.getString("number");
        this.loadSourceTypeBizObject(bizObjNumber);
        this.getModel().setValue("sourcetypeobj", (Object)bizObjNumber, focusRowIndex);
    }

    private void checkSourceTypeData(BeforeDoOperationEventArgs args) {
        QFilter qfDataId;
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        HashSet dataId = new HashSet(16);
        entry.forEach(p -> dataId.add(p.getLong("data.id")));
        if (dataId.size() == 0) {
            return;
        }
        String costCenterId = this.getModel().getDataEntity().getPkValue().toString();
        QFilter qfCostCenter = new QFilter("costcenter", "!=", (Object)Long.valueOf(costCenterId));
        DynamicObjectCollection centerSource = QueryServiceHelper.query((String)"bos_costcentersource", (String)"costcenter.name,sourcetype,data", (QFilter[])new QFilter[]{qfCostCenter, qfDataId = new QFilter("data", "in", (Object)dataId.toArray())});
        if (centerSource == null || centerSource.size() == 0) {
            return;
        }
        StringBuilder sg = new StringBuilder();
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject curRow = (DynamicObject)entry.get(i);
            if (centerSource.stream().filter(p -> p.getLong(SOURCE_TYPE) == curRow.getLong("sourcetype.id") && p.getLong("data") == curRow.getLong("data.id")).count() == 0L) continue;
            args.cancel = true;
            centerSource.stream().filter(p -> p.getLong(SOURCE_TYPE) == curRow.getLong("sourcetype.id") && p.getLong("data") == curRow.getLong("data.id")).forEach(p -> sg.append(p.getString("costcenter.name")).append('\u3001'));
            String tip = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e1a\u52a1\u4fe1\u606f\u4e2d\u7b2c%1$s\u884c%2$s\u6240\u9009\u7684\u6765\u6e90\u6570\u636e\u5df2\u7ecf\u88ab\u6210\u672c\u4e2d\u5fc3\u201c%3$s\u201d \u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostCenterFormPlugin_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]), i + 1, curRow.getString("sourcetype.name"), sg.substring(0, sg.length() - 1));
            this.getView().showTipNotification(tip);
            break;
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("addtype", "execl");
    }
}

