/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CostCenterSourceMapFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(CostCenterSourceMapFormPlugin.class);
    public static final String ENTITY_COSTCENTERSOURCE_MAP = "bos_costcentersourcemap";
    public static final String DATE_TO_STRING_DETAIAL_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costCenterEdit = (BasedataEdit)this.getControl("costcenter");
        costCenterEdit.addBeforeF7SelectListener(arg -> {
            DataSet costCenterSource = QueryServiceHelper.queryDataSet((String)"CostCenterSourceFormPlugin.queryCostCenter", (String)ENTITY_COSTCENTERSOURCE_MAP, (String)"costcenter", null, null);
            HashSet<Long> costCenterIds = new HashSet<Long>(16);
            for (Row row : costCenterSource) {
                costCenterIds.add(row.getLong("costcenter"));
            }
            if (costCenterIds.size() > 0) {
                QFilter qFilter = new QFilter("id", "not in", costCenterIds);
                ListShowParameter listShowParameter = (ListShowParameter)arg.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object costCenter = formShowParameter.getCustomParam("costcenter");
        if (costCenter != null) {
            this.getModel().setValue("costcenter", costCenter);
        }
        this.getModel().setValue("effectdate", (Object)CostCenterSourceMapFormPlugin.getDeFaultEffectDate());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initForm();
        this.setSourceDataName();
        this.getModel().setDataChanged(false);
    }

    private void initForm() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        boolean isAddNew = OperationStatus.ADDNEW.equals((Object)os);
        boolean hasBusiness = false;
        DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
        if (costCenter != null && !isAddNew) {
            hasBusiness = this.hasBusiness(costCenter.getLong("id"));
        }
        this.getView().setVisible(Boolean.valueOf(!hasBusiness), new String[]{"bar_save", "bar_delete"});
        this.getView().setVisible(Boolean.valueOf(hasBusiness), new String[]{"bar_change"});
        this.getView().setEnable(Boolean.valueOf(!hasBusiness), new String[]{"number", "name", "costcenter", "sourcetype", "effectdate", "addrow", "deleterow", "entryentity"});
    }

    private boolean hasBusiness(long costCenterId) {
        QFilter costCenterQFilter = new QFilter("costcenter", "=", (Object)costCenterId);
        boolean isExistCostObject = QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{costCenterQFilter});
        boolean isExistPlan = QueryServiceHelper.exists((String)"cad_plannedoutputbill", (QFilter[])new QFilter[]{costCenterQFilter});
        boolean isExistFact = QueryServiceHelper.exists((String)"cad_factnedoutputbill", (QFilter[])new QFilter[]{costCenterQFilter});
        boolean isExistResource = QueryServiceHelper.exists((String)"sca_resourceuse", (QFilter[])new QFilter[]{costCenterQFilter});
        boolean isExistMat = QueryServiceHelper.exists((String)"aca_matusecollect", (QFilter[])new QFilter[]{costCenterQFilter});
        return isExistCostObject || isExistPlan || isExistFact || isExistResource || isExistMat;
    }

    private void setSourceDataName() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                QFilter qFilter;
                DynamicObject dynamicObject;
                long workCenterId;
                String sourceType;
                DynamicObject sourceData = ((DynamicObject)entryEntity.get(i)).getDynamicObject("sourcedata");
                if (sourceData != null) {
                    this.getModel().setValue("sourcedataname", sourceData.get("name"), i);
                }
                if (StringUtils.isBlank((String)(sourceType = ((DynamicObject)entryEntity.get(i)).getString("sourcetype"))) || !"mpdm_workcentre".equals(sourceType) || sourceData == null || (workCenterId = sourceData.getLong("id")) == 0L || (dynamicObject = QueryServiceHelper.queryOne((String)"mpdm_workcentre", (String)"createorg", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)workCenterId)})) == null) continue;
                this.getModel().setValue("manuorg", (Object)dynamicObject.getLong("createorg"), i);
            }
        }
    }

    private static Date getDeFaultEffectDate() {
        return CostCenterSourceMapFormPlugin.parseDate("2000-01-01 00:00:00");
    }

    public static Date getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date parseDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return date;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        switch (proName = e.getProperty().getName()) {
            case "sourcedata": {
                this.clearSourceField(e, false);
                this.setSourceDataName();
                break;
            }
            case "sourcetype": {
                this.clearSourceField(e, true);
                break;
            }
        }
    }

    private void clearSourceField(PropertyChangedArgs e, boolean isSourceType) {
        ChangeData[] data;
        this.getModel().beginInit();
        ChangeData[] var3 = data = e.getChangeSet();
        int var4 = data.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            ChangeData changeData = var3[var5];
            Object newValue = changeData.getNewValue();
            if (newValue != null && !isSourceType) continue;
            int rowIndex = changeData.getRowIndex();
            this.getModel().setValue("sourcedata", null, rowIndex);
            this.getModel().setValue("sourcedataname", null, rowIndex);
            this.getView().updateView("sourcedata", rowIndex);
            this.getView().updateView("sourcedataname", rowIndex);
        }
        this.getModel().endInit();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "change": {
                Object costCenter = this.getModel().getValue("costcenter");
                if (costCenter != null) {
                    QFilter qFilter = new QFilter("costcenter", "=", (Object)((DynamicObject)costCenter).getLong("id"));
                    List costCenterMapIds = QueryServiceHelper.queryPrimaryKeys((String)ENTITY_COSTCENTERSOURCE_MAP, (QFilter[])qFilter.toArray(), null, (int)-1);
                    Object number = this.getModel().getValue("number");
                    if (number != null) {
                        String changeNumber = String.format("%s-%s", number, costCenterMapIds.size() + 1);
                        QFilter numberQFilter = new QFilter("number", "=", (Object)changeNumber);
                        if (QueryServiceHelper.exists((String)ENTITY_COSTCENTERSOURCE_MAP, (QFilter[])numberQFilter.toArray())) {
                            changeNumber = String.format("%s-%s", changeNumber, 1);
                        }
                        this.getModel().setValue("number", (Object)changeNumber);
                    }
                }
                this.getModel().setValue("changer", (Object)RequestContext.get().getUserId());
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", "costcenter"});
                this.getModel().setValue("effectdate", (Object)CostCenterSourceMapFormPlugin.getDayStartTime(new Date()));
                this.getModel().setDataChanged(false);
                break;
            }
            case "save": {
                this.initForm();
                break;
            }
            case "new_delete": {
                OperationResult operationResult = e.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"CostCenterSourceMapFormPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("new");
                break;
            }
        }
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Map searchResult = e.getSearchResult();
        for (Map.Entry entry : searchResult.entrySet()) {
            DynamicObject workCenter;
            List baseData = (List)entry.getValue();
            BasedataItem basedataItem = (BasedataItem)entry.getKey();
            if (baseData == null || baseData.size() <= 1 || !"sourcedata".equals(basedataItem.getFieldKey())) continue;
            Object source = e.getSource();
            Map sourceObj = ((RowMapper)source).getSourceObj();
            Map manuOrgMap = (Map)sourceObj.get("manuorg");
            long manuOrgId = 0L;
            if (manuOrgMap != null) {
                String manuOrgNum;
                QFilter numberQFilter;
                DynamicObject manuOrg;
                Object id = manuOrgMap.get("id");
                if (id != null) {
                    manuOrgId = Long.parseLong(String.valueOf(id));
                }
                if (manuOrgId == 0L && (manuOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])(numberQFilter = new QFilter("number", "=", (Object)(manuOrgNum = String.valueOf(manuOrgMap.get("number"))))).toArray())) != null) {
                    manuOrgId = manuOrg.getLong("id");
                }
            }
            if (manuOrgId == 0L) continue;
            ArrayList<QFilter> allQf = new ArrayList<QFilter>(2);
            allQf.add(new QFilter("createorg", "=", (Object)manuOrgId));
            if ("number".equals(basedataItem.getSearchKey())) {
                allQf.add(new QFilter("number", "=", (Object)basedataItem.getSearchValue()));
            }
            if ((workCenter = QueryServiceHelper.queryOne((String)basedataItem.getEntityNumber(), (String)"id", (QFilter[])allQf.toArray(new QFilter[0]))) == null) continue;
            baseData.retainAll(Collections.singletonList(workCenter.getLong("id")));
        }
    }
}

