/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CostOrgViewSchemaTreeUtils {
    public static final String CACHE_KEY_LONGNUMBER = "_longNumberCacheKey_";
    public static final String CACHE_KEY_SEARCH_NODES = "_searchNodes_";
    public static final String CACHE_KEY_OLD_SEARCH_TEXT = "_oldSearchText_";
    public static final String CACHE_KEY_PARENTID = "_parentIdCacheKey_";

    public static void removeSearchCache(IFormView formView, String viewId) {
        IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
        pageCache.remove(CostOrgViewSchemaTreeUtils.getLongNumberCacheKey(formView, viewId));
        pageCache.remove(CostOrgViewSchemaTreeUtils.getSearchNodesCacheKey(formView, viewId));
        pageCache.remove(CostOrgViewSchemaTreeUtils.getOldSearchTextCacheKey(formView, viewId));
        pageCache.remove(CostOrgViewSchemaTreeUtils.getParentIdCacheKey(formView, viewId));
    }

    private static String getLongNumberCacheKey(IFormView formView, String viewId) {
        return formView.getPageId() + CACHE_KEY_LONGNUMBER + viewId;
    }

    private static String getSearchNodesCacheKey(IFormView formView, String viewId) {
        return formView.getPageId() + CACHE_KEY_SEARCH_NODES + viewId;
    }

    private static String getOldSearchTextCacheKey(IFormView formView, String viewId) {
        return formView.getPageId() + CACHE_KEY_OLD_SEARCH_TEXT + viewId;
    }

    private static String getParentIdCacheKey(IFormView formView, String viewId) {
        return formView.getPageId() + CACHE_KEY_PARENTID + viewId;
    }

    public static void searchTreeNode(IFormView formView, TreeView treeView, String viewId, String searchText) {
        Map<String, String> longNumMap = new HashMap<String, String>();
        List<Object> treeNodes = new ArrayList<TreeNode>();
        IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
        String longNumberCacheKey = CostOrgViewSchemaTreeUtils.getLongNumberCacheKey(formView, viewId);
        String searchNodesCacheKey = CostOrgViewSchemaTreeUtils.getSearchNodesCacheKey(formView, viewId);
        String oldSearchTextCacheKey = CostOrgViewSchemaTreeUtils.getOldSearchTextCacheKey(formView, viewId);
        String parentIdCacheKey = CostOrgViewSchemaTreeUtils.getParentIdCacheKey(formView, viewId);
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        boolean showFreezeUnit = (Boolean)formView.getModel().getValue("showfreezeunit");
        boolean showDisableUnit = (Boolean)formView.getModel().getValue("showdisableunit");
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
                String longNumCache = pageCache.get(longNumberCacheKey);
                longNumMap = StringUtils.isBlank((CharSequence)longNumCache) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)longNumCache, Map.class);
            }
            if (Utils.isListEmpty(treeNodes)) {
                pageCache.put(searchNodesCacheKey, "");
                pageCache.remove(oldSearchTextCacheKey);
                formView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5c55\u793a\u5168\u90e8\u641c\u7d22\u7ed3\u679c\uff0c\u5c06\u91cd\u65b0\u5f00\u59cb\u5faa\u73af\u641c\u7d22\u3002", (String)"CostOrgViewSchemaTreeUtils_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
        } else {
            CostOrgViewSchemaTreeUtils.searchTreeNode(searchText, treeNodes, viewId, longNumMap, showDisableUnit, showFreezeUnit);
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(longNumberCacheKey, SerializationUtils.toJsonString(longNumMap));
        }
        if (Utils.isListNotEmpty(treeNodes)) {
            TreeNode node;
            String parentId;
            String parentIdCache = pageCache.get(parentIdCacheKey);
            ArrayList<String> parentIds = null;
            if (StringUtils.isNotBlank((CharSequence)parentIdCache)) {
                parentIds = (ArrayList<String>)SerializationUtils.fromJsonString((String)parentIdCache, List.class);
            }
            if (parentIds == null) {
                parentIds = new ArrayList<String>();
            }
            if (parentIds.contains(parentId = (node = (TreeNode)treeNodes.get(0)).getParentid())) {
                String nodeId = node.getId();
                TreeNode checkNode = new TreeNode(parentId, nodeId, node.getText());
                treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
                treeView.queryTreeNodeChildren(parentId, nodeId);
                treeView.expand(nodeId);
                treeView.checkNode(checkNode);
                treeView.focusNode(checkNode);
            } else {
                CostOrgViewSchemaTreeUtils.queryTreeNodeWithParent(treeView, longNumMap, node, parentIds, viewId, showDisableUnit, showFreezeUnit);
                pageCache.put(parentIdCacheKey, SerializationUtils.toJsonString(parentIds));
            }
            treeNodes.remove(0);
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private static void searchTreeNode(String searchText, List<TreeNode> treeNodes, String orgViewId, Map<String, String> longNumMap, boolean showDisableUnit, boolean showFreezeUnit) {
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter viewFilter = new QFilter("view", "=", (Object)Long.parseLong(orgViewId));
        QFilter nameFilter = new QFilter("org.name", "like", (Object)("%" + searchText + "%"));
        nameFilter.or("org.number", "like", (Object)("%" + searchText + "%"));
        if (!showDisableUnit) {
            QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
            viewFilter = viewFilter.and(enableFilter);
        }
        if (!showFreezeUnit) {
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            viewFilter = viewFilter.and(freezeFilter);
        }
        viewFilter = viewFilter.and(nameFilter);
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        if (Utils.isListEmpty((List)orgCol)) {
            return;
        }
        for (DynamicObject org : orgCol) {
            String orgId = org.getString("org");
            TreeNode treeNode = new TreeNode(org.getString("parent"), orgId, org.getString("name"));
            treeNode.setExpend(true);
            treeNodes.add(treeNode);
            longNumMap.put(orgId, org.getString("longnumber"));
        }
    }

    private static void queryTreeNodeWithParent(TreeView treeView, Map<String, String> longNumMap, TreeNode node, List<String> parentIds, String orgViewId, boolean showDisableUnit, boolean showFreezeUnit) {
        QFilter[] filters;
        DynamicObjectCollection orgCol;
        String nodeId = node.getId();
        String longNumber = longNumMap.get(nodeId);
        ArrayList<String> longNumList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            longNumList.add(longNumber);
        }
        CostOrgViewSchemaTreeUtils.getParentLongNumber(longNumber, longNumList);
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter longNumberFilter = new QFilter("longnumber", "in", longNumList);
        QFilter viewFilter = new QFilter("view", "=", (Object)Long.parseLong(orgViewId));
        if (!showDisableUnit) {
            QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
            viewFilter = viewFilter.and(enableFilter);
        }
        if (!showFreezeUnit) {
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            viewFilter = viewFilter.and(freezeFilter);
        }
        if (Utils.isListEmpty((List)(orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])(filters = new QFilter[]{longNumberFilter, viewFilter}), (String)"longnumber")))) {
            return;
        }
        for (DynamicObject org : orgCol) {
            String parentId = org.getString("parent");
            String orgId = org.getString("org");
            if (parentIds.contains(orgId)) continue;
            parentIds.add(parentId);
            TreeNode checkNode = new TreeNode(parentId, orgId, org.getString("name"));
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.queryTreeNodeChildren(parentId, orgId);
            treeView.expand(orgId);
            treeView.checkNode(checkNode);
            treeView.focusNode(checkNode);
        }
    }

    private static void getParentLongNumber(String longNumber, List<String> longNumList) {
        if (StringUtils.isBlank((CharSequence)longNumber) || longNumber.indexOf(33) == -1) {
            return;
        }
        String parentLongNumber = StringUtils.substringBeforeLast((String)longNumber, (String)"!");
        longNumList.add(parentLongNumber);
        CostOrgViewSchemaTreeUtils.getParentLongNumber(parentLongNumber, longNumList);
    }
}

