/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BankAcctVirtualValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntity = this.getDataEntities();
        String entityKey = this.getEntityKey();
        for (ExtendedDataEntity bankAcctEntitity : dataEntity) {
            HashSet<Pair> exsitEntry = new HashSet<Pair>(16);
            DynamicObject bankAcct = bankAcctEntitity.getDataEntity();
            Long checkBankAcctId = bankAcct.getLong("id");
            DynamicObjectCollection virtualEntity = bankAcct.getDynamicObjectCollection("virtualentity");
            for (DynamicObject virtualEntry : virtualEntity) {
                DynamicObject exsitAcct;
                int seq = virtualEntry.getInt("seq");
                String virtualAccount = virtualEntry.getString("virtualaccount");
                if (StringUtils.isEmpty((String)virtualAccount)) {
                    this.addErrorMessage(bankAcctEntitity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u201c\u5173\u8054\u865a\u62df\u8d26\u53f7\u201d\u4e3a\u7a7a\u3002", (String)"BankAcctVirtualValidator_01", (String)"bd-assistant-opplugin", (Object[])new Object[0]), seq));
                    continue;
                }
                DynamicObject openBank = virtualEntry.getDynamicObject("openbank");
                Pair entryMap = Pair.of((Object)virtualAccount, null == openBank ? null : Long.valueOf(openBank.getLong("id")));
                if (exsitEntry.contains(entryMap)) {
                    this.addErrorMessage(bankAcctEntitity, String.format(ResManager.loadKDString((String)"\u865a\u62df\u8d26\u53f7\u201c%1$s-%2$s\u201d\u5b58\u5728\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"BankAcctVirtualValidator_02", (String)"bd-assistant-opplugin", (Object[])new Object[0]), virtualAccount, null == openBank ? "" : openBank.getString("name")));
                    continue;
                }
                exsitEntry.add(entryMap);
                if ("am_changeapply".equals(entityKey)) {
                    checkBankAcctId = virtualEntry.getDynamicObject("virtualbankaccount").getLong("id");
                }
                QFilter filter = new QFilter("acctstatus", "!=", (Object)"closed");
                filter.and("id", "!=", (Object)checkBankAcctId).and("virtualentity.virtualaccount", "=", (Object)virtualAccount);
                if (null != openBank) {
                    filter.and("virtualentity.openbank", "=", openBank.getPkValue());
                    exsitAcct = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"bankaccountnumber", (QFilter[])new QFilter[]{filter});
                    if (null == exsitAcct) continue;
                    this.addErrorMessage(bankAcctEntitity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u865a\u62df\u8d26\u53f7\u201c%2$s-%3$s\u201d\u5df2\u88ab\u94f6\u884c\u8d26\u53f7\u201c%4$s\u201d\u5173\u8054\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"BankAcctVirtualValidator_03", (String)"bd-assistant-opplugin", (Object[])new Object[0]), seq, virtualAccount, openBank.getString("name"), exsitAcct.getString("bankaccountnumber")));
                    continue;
                }
                exsitAcct = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"bankaccountnumber", (QFilter[])new QFilter[]{filter});
                if (null == exsitAcct) continue;
                this.addErrorMessage(bankAcctEntitity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u865a\u62df\u8d26\u53f7\u201c%2$s\u201d\u5df2\u88ab\u5173\u8054\uff0c\u5efa\u8bae\u586b\u5199\u5f00\u6237\u884c\uff0c\u7cfb\u7edf\u901a\u8fc7\u201c\u5173\u8054\u865a\u62df\u8d26\u53f7\u201d\u4e0e\u201c\u5f00\u6237\u884c\u201d\u7ec4\u5408\u5224\u65ad\u552f\u4e00\u6027\u3002", (String)"BankAcctVirtualValidator_04", (String)"bd-assistant-opplugin", (Object[])new Object[0]), seq, virtualAccount));
            }
        }
    }
}

