/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class NetBankAcctSaveOp
extends AbstractOperationServicePlugIn {
    public static final String FBASEDATAID = "fbasedataid";
    public static final String NETBANK = "netbank";
    public static final String BANKACCT = "bankacct";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bankAcct");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List opNetBankAcctIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] netBankAcctsFromDB = BusinessDataServiceHelper.load((Object[])opNetBankAcctIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_netbankacct"));
        HashMap netBankAcctsFromDBMap = Arrays.stream(netBankAcctsFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        List SelectBankacctIds = Stream.concat(Arrays.stream(dataEntities), Arrays.stream(netBankAcctsFromDB)).map(v -> v.getDynamicObject(BANKACCT).getPkValue()).collect(Collectors.toList());
        DynamicObject[] SelectBankaccts = BusinessDataServiceHelper.load((Object[])SelectBankacctIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        HashMap SelectBankacctsMap = Arrays.stream(SelectBankaccts).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        for (DynamicObject netBankAcct : dataEntities) {
            Long netBankAcctId = netBankAcct.getLong("id");
            Object selectBankAcctId = netBankAcct.getDynamicObject(BANKACCT).getPkValue();
            DynamicObject selectBankAcct = (DynamicObject)SelectBankacctsMap.get(selectBankAcctId);
            DynamicObject netBankAcctFromDB = netBankAcctsFromDBMap.getOrDefault(netBankAcctId, null);
            if (null != netBankAcctFromDB) {
                Object BankAcctIdFromDB = netBankAcctFromDB.getDynamicObject(BANKACCT).getPkValue();
                if (BankAcctIdFromDB.equals(selectBankAcctId)) continue;
                DynamicObject BankAcctFromDB = (DynamicObject)SelectBankacctsMap.get(BankAcctIdFromDB);
                DynamicObjectCollection netbankFromDB = BankAcctFromDB.getDynamicObjectCollection(NETBANK);
                netbankFromDB.removeIf(v -> v.getDynamicObject(FBASEDATAID).getLong("id") == netBankAcctId.longValue());
                BankAcctFromDB.set(NETBANK, (Object)netbankFromDB);
                this.setMultiNetBankAcct(selectBankAcct, netBankAcct);
                continue;
            }
            this.setMultiNetBankAcct(selectBankAcct, netBankAcct);
        }
        Collection bankaccts = SelectBankacctsMap.values();
        SaveServiceHelper.save((DynamicObject[])bankaccts.toArray(new DynamicObject[bankaccts.size()]));
    }

    private static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, String propName, DynamicObject ... objs) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity.getDataEntityType().getName());
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty(propName);
        DynamicObjectCollection collection = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entity);
        for (DynamicObject obj : objs) {
            if (null == obj) continue;
            DynamicObject newObj = new DynamicObject(currencyProp.getDynamicCollectionItemPropertyType());
            newObj.set(FBASEDATAID, (Object)obj);
            newObj.set("fbasedataid_id", obj.getPkValue());
            collection.add((Object)newObj);
        }
        return collection;
    }

    private void setMultiNetBankAcct(DynamicObject bankAcct, DynamicObject addNetBank) {
        DynamicObjectCollection netBankCollection = bankAcct.getDynamicObjectCollection(NETBANK);
        ArrayList<DynamicObject> netBanks = new ArrayList<DynamicObject>(10);
        netBanks.add(addNetBank);
        if (CollectionUtils.isNotEmpty((Collection)netBankCollection)) {
            ArrayList netBankIds = new ArrayList(netBankCollection.size());
            netBankCollection.stream().forEach(v -> netBankIds.add(v.getDynamicObject(FBASEDATAID).getLong("id")));
            DynamicObject[] oldnetBanks = BusinessDataServiceHelper.load((Object[])netBankIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_netbankacct"));
            netBanks.addAll(Arrays.asList(oldnetBanks));
        }
        bankAcct.set(NETBANK, (Object)NetBankAcctSaveOp.generateMultiPropValue(bankAcct, NETBANK, netBanks.toArray(new DynamicObject[netBanks.size()])));
    }
}

