/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bom;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bd.assistant.plugin.constant.BomVersionImportConst;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BomVersionImportOp
extends BatchImportPlugin
implements IImportDataPlugin {
    private static Log log = LogFactory.getLog(BomVersionImportOp.class);

    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        Iterator var4 = this.ctx.getAllUrls().iterator();
        BomVersionImportConst.bomVersionIDMap.clear();
        BomVersionImportConst.bomVersionRuleIDMap.clear();
        while (var4.hasNext()) {
            String url = (String)var4.next();
            InputStream in = service.getInputStream(url);
            try {
                this.readExcel(in);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    this.ctx.getLogger(url).log(Integer.valueOf(0), (Throwable)e);
                } else {
                    Throwable cause = e.getCause();
                    String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"BomVersionImportOp_0", (String)"bd-assistant-opplugin", (Object[])new Object[0]);
                    this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                }
                this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
            }
        }
        super.resolveExcel();
    }

    private void readExcel(InputStream inputStream) {
        try (XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);){
            int number = xssfWorkbook.getNumberOfSheets();
            HashSet<String> bomVersionRuleInfoSet = new HashSet<String>(16);
            HashSet<String> bomVersionRuleNameInfoSet = new HashSet<String>(16);
            HashSet<String> bomVersionInfoSet = new HashSet<String>(16);
            boolean descSetFlag = false;
            for (int i = 0; i < number; ++i) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(i);
                int rownum = xssfSheet.getPhysicalNumberOfRows();
                if (rownum <= 4) continue;
                HashSet<Integer> bomVersionRuleSet = new HashSet<Integer>(10);
                HashSet<Integer> bomVersionRuleNameSet = new HashSet<Integer>(10);
                HashSet<Integer> bomVersionSet = new HashSet<Integer>(10);
                XSSFRow columnRow = xssfSheet.getRow(2);
                int lastCellNum = columnRow.getLastCellNum();
                if (!descSetFlag) {
                    for (int cellIndex = 0; cellIndex < lastCellNum; ++cellIndex) {
                        XSSFCell cell = columnRow.getCell(cellIndex);
                        String columnName = cell.getStringCellValue();
                        if ("versionname.version".equals(columnName)) {
                            bomVersionSet.add(cellIndex);
                        }
                        if ("bomversionrule.number".equals(columnName)) {
                            bomVersionRuleSet.add(cellIndex);
                        }
                        if (!"bomversionrule.name".equals(columnName)) continue;
                        bomVersionRuleNameSet.add(cellIndex);
                    }
                    if (bomVersionRuleSet.isEmpty() || bomVersionRuleNameSet.isEmpty() && bomVersionRuleSet.isEmpty()) continue;
                }
                for (int row = 4; row < rownum; ++row) {
                    XSSFRow rowInfo = xssfSheet.getRow(row);
                    if (rowInfo == null) continue;
                    Set<String> mapInfo = this.getMapInfo(bomVersionRuleSet, rowInfo);
                    if (mapInfo != null && !mapInfo.isEmpty()) {
                        bomVersionRuleInfoSet.addAll(mapInfo);
                    } else {
                        bomVersionRuleNameInfoSet.addAll(this.getMapInfo(bomVersionRuleNameSet, rowInfo));
                    }
                    bomVersionInfoSet.addAll(this.getMapInfo(bomVersionSet, rowInfo));
                }
            }
            BomVersionImportConst.bomVersionIDMap.putAll(this.queryBomVersionRule(bomVersionRuleInfoSet, bomVersionRuleNameInfoSet, bomVersionInfoSet));
            xssfWorkbook.close();
            inputStream.close();
        }
        catch (Exception e) {
            try {
                inputStream.close();
            }
            catch (IOException e1) {
                throw new KDBizException((Throwable)e1, new ErrorCode("readExcel-exeption", ResManager.loadKDString((String)"IO\u5173\u95ed\u5f02\u5e38\u3002", (String)"MFTBOMImportOp_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0])), new Object[0]);
            }
            throw new KDBizException((Throwable)e, new ErrorCode("readExcel-exeption", ResManager.loadKDString((String)"\u8bfb\u53d6EXCEL\u5931\u8d25\u3002", (String)"MFTBOMImportOp_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    private Map<String, Long> queryBomVersionRule(Set<String> bomVersionRuleInfoSet, Set<String> bomVersionRuleNameInfoSet, Set<String> bomVersionInfoSet) {
        ArrayList<QFilter> versionQfilterList = new ArrayList<QFilter>(4);
        QFilter ruleQFilter = null;
        if (bomVersionRuleInfoSet != null && !bomVersionRuleInfoSet.isEmpty()) {
            ruleQFilter = new QFilter("number", "in", bomVersionRuleInfoSet);
            log.info("BOM\u7248\u672c\u8fc7\u6ee4\u6761\u4ef6\uff1a" + ruleQFilter.toString());
        }
        if (bomVersionRuleNameInfoSet != null && !bomVersionRuleNameInfoSet.isEmpty()) {
            QFilter ruleNameQFilter = new QFilter("name", "in", bomVersionRuleNameInfoSet);
            if (ruleQFilter != null) {
                ruleQFilter.or(ruleNameQFilter);
            } else {
                ruleQFilter = ruleNameQFilter;
            }
            log.info("BOM\u7248\u672c\u8fc7\u6ee4\u6761\u4ef6\uff1a" + ruleQFilter.toString());
        }
        if (ruleQFilter != null) {
            versionQfilterList.add(ruleQFilter);
        }
        if (bomVersionInfoSet != null && !bomVersionInfoSet.isEmpty()) {
            versionQfilterList.add(new QFilter("entryentity.version", "in", bomVersionInfoSet));
        }
        if (versionQfilterList.isEmpty()) {
            return new HashMap<String, Long>(1);
        }
        HashMap<String, Long> resultMap = new HashMap<String, Long>(16);
        HashMap<String, DynamicObject> ruleMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection bomVerObjCol = QueryServiceHelper.query((String)"bd_bomversionrule_new", (String)"id,number,name,multype,entryentity.version version,entryentity.id entryid", (QFilter[])versionQfilterList.toArray(new QFilter[versionQfilterList.size()]));
        for (int i = 0; i < bomVerObjCol.size(); ++i) {
            Object entryidObj;
            DynamicObject bomVerObj = (DynamicObject)bomVerObjCol.get(i);
            StringBuilder ruleNumberStr = new StringBuilder();
            StringBuilder ruleNameStr = new StringBuilder();
            String ruleNumber = bomVerObj.getString("number");
            log.info("BOM\u7248\u672c\u89c4\u5219\u7f16\u7801\uff1a" + ruleNumber);
            ruleNumberStr.append(ruleNumber);
            ruleNumberStr.append(':');
            String ruleName = bomVerObj.getString("name");
            log.info("BOM\u7248\u672c\u89c4\u5219\u540d\u79f0\uff1a" + ruleName);
            ruleNameStr.append(ruleName);
            ruleNameStr.append(':');
            Object versionObj = bomVerObj.get("version");
            if (versionObj instanceof String) {
                ruleNumberStr.append(String.valueOf(versionObj));
                ruleNameStr.append(String.valueOf(versionObj));
            }
            if ((entryidObj = bomVerObj.get("entryid")) instanceof Long) {
                resultMap.put(ruleNumberStr.toString(), (Long)entryidObj);
                resultMap.put(ruleNameStr.toString(), (Long)entryidObj);
            }
            ruleMap.put(ruleNumber + "_number", bomVerObj);
            ruleMap.put(ruleName + "_name", bomVerObj);
        }
        BomVersionImportConst.bomVersionRuleIDMap.putAll(ruleMap);
        return resultMap;
    }

    public Set<String> getSetValue(Set<Integer> bomVersionRuleSet, XSSFRow rowInfo) {
        HashSet<String> valueInfo = new HashSet<String>(32);
        if (rowInfo == null) {
            return valueInfo;
        }
        for (Integer index : bomVersionRuleSet) {
            XSSFCell cell = rowInfo.getCell(index.intValue());
            if (cell == null) continue;
            String cellValue = "";
            CellType cellType = cell.getCellType();
            if (cellType.name().equals("STRING")) {
                cellValue = cell.getStringCellValue();
            } else if (cellType.name().equals("NUMERIC")) {
                double numericCellValue = cell.getNumericCellValue();
                BigDecimal bigDecimal = BigDecimal.valueOf(numericCellValue);
                cellValue = bigDecimal.toPlainString();
            } else if (cellType.name().equals("BOOLEAN")) {
                cellValue = cell.getBooleanCellValue() + "";
            } else if (cellType.name().equals("FORMULA")) {
                cellValue = cell.getCellFormula() + "";
            }
            if (!StringUtils.isNotEmpty((CharSequence)cellValue)) continue;
            valueInfo.add(cellValue);
        }
        return valueInfo;
    }

    public Set<String> getMapInfo(Set<Integer> sets, XSSFRow rowInfo) {
        Set<String> valueInfo = new HashSet<String>(32);
        if (rowInfo == null) {
            return valueInfo;
        }
        valueInfo = this.getSetValue(sets, rowInfo);
        return valueInfo;
    }
}

