/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.util.ExpenseItemUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ExpenseItemSavePlugin
extends AbstractOperationServicePlugIn {
    private static String REG = ";";
    private static Log log = LogFactory.getLog(ExpenseItemSavePlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List list = e.getFieldKeys();
        list.add("id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        OperateOption option = this.getOption();
        StringBuilder stringBuilder = new StringBuilder();
        option.getVariables().forEach((key, value) -> stringBuilder.append("[key:").append((String)key).append("-value:").append((String)value).append("]"));
        log.info("ExpenseItemSavePlugin>>>endOperationTransaction:" + stringBuilder);
        String isImport = (String)option.getVariables().get("importtag_of_datasource");
        if (isImport != null && !isImport.isEmpty() && isImport.equals("true")) {
            List list = Arrays.stream(e.getDataEntities()).map(bill -> bill.getLong("id")).collect(Collectors.toList());
            ArrayListMultimap groupMap = ArrayListMultimap.create();
            DynamicObject[] expenseItems = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,relbilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
            if (expenseItems.length > 0) {
                for (DynamicObject expenseItem : expenseItems) {
                    String relBillType = expenseItem.getString("relbilltype");
                    if (!StringUtils.isNotBlank((CharSequence)relBillType)) continue;
                    groupMap.put((Object)relBillType, expenseItem.getPkValue());
                }
                for (String relBillType : groupMap.keySet()) {
                    Collection expenseItemPks = groupMap.get((Object)relBillType);
                    String importtype = option.getVariableValue("importtype");
                    if ("override".equals(importtype)) {
                        DynamicObjectCollection expenseItemBill = QueryServiceHelper.query((String)"er_expenseitembill", (String)"id", (QFilter[])new QFilter[]{new QFilter("expenseitem.id", "in", (Object)expenseItemPks.toArray())});
                        Set expenseItemBillPKs = expenseItemBill.stream().map(v -> v.get("id")).collect(Collectors.toSet());
                        DeleteServiceHelper.delete((String)"er_expenseitembill", (QFilter[])new QFilter[]{new QFilter("id", "in", expenseItemBillPKs)});
                    }
                    ExpenseItemUtils.saveRelation((Object[])expenseItemPks.toArray(), (Object[])this.getBillTypePks(relBillType));
                }
            }
        }
    }

    private Object[] getBillTypePks(String relBillType) {
        Map<String, Object> billtypeMap = this.getBillTypeMap();
        String[] split = relBillType.split(REG);
        Object[] billtypePks = new Object[split.length];
        for (int i = 0; i < split.length; ++i) {
            billtypePks[i] = billtypeMap.get(split[i]);
        }
        return billtypePks;
    }

    private Map<String, Object> getBillTypeMap() {
        HashMap billtypeMap = Maps.newHashMapWithExpectedSize((int)16);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"name,number", (QFilter[])new QFilter[]{QFilter.isNotNull((String)"name")});
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject billtype = (DynamicObject)iterator.next().getValue();
            billtypeMap.put(billtype.getString("name"), billtype.getPkValue());
        }
        return billtypeMap;
    }
}

