/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.taxc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaxCategoryImportPlugin
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = billdatas.iterator();
        Map option = this.ctx.getOption();
        String importType = option.get("importtype").toString();
        List<Object> numberList = new ArrayList();
        if ("override".equalsIgnoreCase(importType) || "overridenew".equalsIgnoreCase(importType)) {
            QFilter qFilter = new QFilter("issystem", "=", (Object)"1");
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)"bd_taxcategory", (String)"number", (QFilter[])qFilter.toArray());
            numberList = Arrays.stream(cols).map(o -> o.getString("number")).collect(Collectors.toList());
        }
        while (it.hasNext()) {
            String number;
            ImportBillData data = it.next();
            int index = data.getStartIndex();
            if (data.getData().get((Object)"number") != null && numberList.contains(number = data.getData().getString("number"))) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"%s: \u7cfb\u7edf\u9884\u8bbe\u6570\u636e\u4e0d\u53ef\u4fee\u6539\u3002", (String)"TaxCategoryImportPlugin_0", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number)).fail();
                it.remove();
                continue;
            }
            String taxsysNumber = (String)((Map)data.getData().get((Object)"taxationsysid")).get("number");
            if (data.getData().get((Object)"taxationsysid") == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryImportPlugin_1", (String)"bd-assistant-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            DynamicObject taxsysObj = QueryServiceHelper.queryOne((String)"bd_taxationsys", (String)"id,countryid.id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxsysNumber)});
            if (taxsysObj == null) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u6570\u636e\u4e0d\u5b58\u5728:%s\u3002", (String)"TaxCategoryImportPlugin_2", (String)"bd-assistant-opplugin", (Object[])new Object[0]), taxsysNumber)).fail();
                it.remove();
                continue;
            }
            if (data.getData().get((Object)"taxarea") == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7a0e\u6536\u8f96\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryImportPlugin_3", (String)"bd-assistant-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            Long countryid = taxsysObj.getLong("countryid.id");
            String taxareaNumber = (String)((Map)data.getData().get((Object)"taxarea")).get("number");
            Date now = new Date();
            QFilter qFilter = new QFilter("country", "=", (Object)countryid).and("enable", "=", (Object)"1").and("issystem", "=", (Object)"1").and("group.enable", "=", (Object)"1").and("group.number", "=", (Object)taxareaNumber).and("startdate", "<=", (Object)now).and(QFilter.isNull((String)"enddate").or("enddate", ">=", (Object)now));
            DynamicObject[] taxareaObjects = BusinessDataServiceHelper.load((String)"bastax_taxarea", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (taxareaObjects != null && taxareaObjects.length > 0) continue;
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u7a0e\u6536\u8f96\u533a\u6570\u636e\u4e0d\u5b58\u5728:%s\u3002", (String)"TaxCategoryImportPlugin_4", (String)"bd-assistant-opplugin", (Object[])new Object[0]), taxareaNumber)).fail();
            it.remove();
        }
        super.beforeSave(billdatas, logger);
    }
}

