/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bd.master.helper.BankInfoDataInitHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SiteSupplierFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TBMAIN = "tbmain";
    private static final String BTNSAVE = "bar_save";
    private static final String[] FIELDS = new String[]{"bankaccount", "accountname", "bank", "currency", "isdefault_bank", "bankaccounttype", "settlment", "commissionbearer", "liquidationparam", "agentbankaccount", "agentbank"};
    private static ThreadLocal<Boolean> currentflag = new ThreadLocal();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TBMAIN});
        BasedataEdit addressEdit = (BasedataEdit)this.getView().getControl("address");
        addressEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billaddressEdit = (BasedataEdit)this.getView().getControl("billaddress");
        billaddressEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject supplier;
        String fieldKey = arg0.getProperty().getName();
        if (("address".equals(fieldKey) || "billaddress".equals(fieldKey)) && (supplier = (DynamicObject)this.getModel().getValue("supplier")) != null) {
            Object supplierid = supplier.getPkValue();
            QFilter qf1 = new QFilter("supplierid", "=", (Object)String.valueOf(supplierid));
            QFilter qf2 = new QFilter("invalid", "=", (Object)"0");
            ArrayList<QFilter> qfs = new ArrayList<QFilter>();
            qfs.add(qf1);
            qfs.add(qf2);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qfs);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (BTNSAVE.equals(evt.getItemKey()) && currentflag.get().booleanValue()) {
            currentflag.remove();
        }
    }

    public void afterBindData(EventObject e) {
        Object supplierid;
        DynamicObject sup;
        this.init();
        Object pk = this.getModel().getDataEntity().getPkValue();
        if ((pk == null || Long.parseLong(String.valueOf(pk)) == 0L) && (sup = BusinessDataServiceHelper.loadSingle((Object)(supplierid = this.getView().getFormShowParameter().getCustomParam("id")), (String)"bd_supplier")) != null) {
            this.getModel().setValue("settlementcyid", sup.get("settlementcyid"));
            this.getModel().setValue("taxrate", sup.get("taxrate"));
            this.getModel().setValue("paymentcurrency", sup.get("paymentcurrency"));
            this.getModel().setValue("settlementtypeid", sup.get("settlementtypeid"));
            this.getModel().setValue("paycond", sup.get("paycond"));
            this.getModel().setValue("invoicetype", sup.get("invoicetype"));
            this.getModel().setValue("paymentunit", sup.get("paymentunit"));
            this.getModel().setValue("supplier", this.getView().getFormShowParameter().getCustomParam("id"));
            this.getModel().setValue("matchingrule", sup.get("matchingrule"));
            this.getModel().setValue("billaddress", sup.get("billaddress"));
            this.getModel().setValue("invoiceaddress", sup.get("invoiceaddress"));
            this.getModel().setValue("supmasterid", sup.get("masterid"));
            this.getModel().setValue("ctrlstrategy", (Object)2);
            Long userOrgId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("useOrg").toString());
            this.getModel().setValue("createorg", (Object)userOrgId);
            this.getModel().setValue("useorg", (Object)userOrgId);
            DynamicObjectCollection banks = sup.getDynamicObjectCollection("entry_bank");
            if (banks.size() > 0) {
                IDataModel model = this.getModel();
                this.getModel().beginInit();
                TableValueSetter vs = new TableValueSetter(FIELDS);
                for (int i = 0; i < banks.size(); ++i) {
                    DynamicObject bankInfo = (DynamicObject)banks.get(i);
                    Object[] value = new Object[FIELDS.length];
                    value[0] = bankInfo.get("bankaccount");
                    value[1] = bankInfo.get("accountname");
                    DynamicObject bank = bankInfo.getDynamicObject("bank");
                    value[2] = bank == null ? bank : bank.getPkValue();
                    DynamicObject currency = bankInfo.getDynamicObject("currency");
                    value[3] = currency == null ? currency : currency.getPkValue();
                    value[4] = bankInfo.get("isdefault_bank");
                    value[5] = bankInfo.get("bankaccounttype");
                    DynamicObject settlment = bankInfo.getDynamicObject("settlment");
                    value[6] = settlment == null ? settlment : settlment.getPkValue();
                    value[7] = bankInfo.get("commissionbearer");
                    value[8] = bankInfo.get("liquidationparam");
                    value[9] = bankInfo.get("agentbankaccount");
                    DynamicObject agentbank = bankInfo.getDynamicObject("agentbank");
                    value[10] = agentbank == null ? agentbank : agentbank.getPkValue();
                    vs.addRow(value);
                }
                AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
                dataModel.batchCreateNewEntryRow("entry_bank", vs);
                this.getModel().endInit();
                this.getView().updateView("entry_bank");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey)) {
            if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                currentflag.set(Boolean.FALSE);
            } else if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                currentflag.set(Boolean.TRUE);
            }
        }
    }

    private void init() {
        List items = BankInfoDataInitHelper.getBankAccountTypeComboList();
        ComboEdit operCombo = (ComboEdit)this.getControl("bankaccounttype");
        if (items != null && !items.isEmpty()) {
            operCombo.setComboItems(items);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }
}

