/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.helper.MasterSiteHelper;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bd.master.util.MasterQuerySiteSql;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class SupplierSiteFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
TabSelectListener {
    private static final String TABAP = "tabap";
    private static final String TBMAIN = "tbmain";
    private static final String TABPAGEAP_SITE = "tabpageap_site";
    private static final String ADDRESS_ADD = "address_add";
    private static final String ADDRESS_MANGER = "address_manger";
    private static final String PRO_BILLADDRESS = "billaddress";
    private static final String[] FIELDS = new String[]{"sitenumber", "sitename", "siteaddress", "sitebizfunction", "sitestatus", "siteid", "sitecreateorg", "siteuseorg"};

    public void registerListener(EventObject e) {
        BasedataEdit billaddressEdit;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TBMAIN});
        this.addItemClickListeners(new String[]{TABAP});
        EntryGrid siteEntryGrid = (EntryGrid)this.getView().getControl("entry_site");
        if (siteEntryGrid != null) {
            siteEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((billaddressEdit = (BasedataEdit)this.getView().getControl(PRO_BILLADDRESS)) != null) {
            billaddressEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addTabSelectListener(this, new String[]{TABAP});
    }

    private void addTabSelectListener(TabSelectListener form, String[] tabName) {
        Tab tab = null;
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Map paramMap;
        super.itemClick(evt);
        String key = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        if (TABPAGEAP_SITE.equals(key)) {
            this.programaMg(operationKey);
        } else if (!"close".equals(operationKey) && (paramMap = MasterSiteHelper.getSystemParam()) != null && !paramMap.isEmpty() && paramMap.get("enablesuppliersite") != null && Boolean.parseBoolean(paramMap.get("enablesuppliersite").toString())) {
            this.getModel().deleteEntryData("entry_site");
            List<Map<String, Object>> sites = this.querySiteData();
            this.fillEntry(sites);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        if ("sitenumber".equals(fieldName)) {
            Object addressid = this.getModel().getValue("siteid");
            BillShowParameter formShowParameter = null;
            formShowParameter = FormShowParameterUtil.createFormShowParameter((String)"bd_suppliersite", (Object)addressid, (String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5730\u70b9", (String)"SupplierSiteFormPlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]), (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "suppliersite"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void afterBindData(EventObject e) {
        Map paramMap = MasterSiteHelper.getSystemParam();
        if (paramMap != null && !paramMap.isEmpty() && paramMap.get("enablesuppliersite") != null && Boolean.parseBoolean(paramMap.get("enablesuppliersite").toString())) {
            List<Map<String, Object>> sites = this.querySiteData();
            this.fillEntry(sites);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGEAP_SITE});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String fieldKey = paramBeforeF7SelectEvent.getProperty().getName();
        if (PRO_BILLADDRESS.equals(fieldKey)) {
            Object pk = this.getModel().getDataEntity().getPkValue();
            DynamicObject supplier = null;
            if (pk != null && Long.parseLong(String.valueOf(pk)) != 0L) {
                supplier = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bd_supplier");
            }
            Object supplierid = 0;
            if (supplier != null) {
                supplierid = supplier.getPkValue();
            }
            QFilter qf1 = new QFilter("supplierid", "=", (Object)String.valueOf(supplierid));
            QFilter qf2 = new QFilter("enable", "=", (Object)"1");
            ArrayList<QFilter> qfs = new ArrayList<QFilter>();
            qfs.add(qf1);
            qfs.add(qf2);
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qfs);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("suppliersite".equals(closedCallBackEvent.getActionId())) {
            List<Map<String, Object>> sites = this.querySiteData();
            this.fillEntry(sites);
        }
    }

    public void tabSelected(TabSelectEvent paramTabSelectEvent) {
        String tabKey = paramTabSelectEvent.getTabKey();
        if (TABPAGEAP_SITE.equals(tabKey)) {
            List<Map<String, Object>> sites = this.querySiteData();
            this.fillEntry(sites);
        }
    }

    private void programaMg(String operationKey) {
        DynamicObject userorg = (DynamicObject)this.getModel().getValue("useorg");
        Long useOrgPk = 0L;
        if (userorg != null) {
            useOrgPk = Long.parseLong(userorg.getPkValue().toString());
        }
        switch (operationKey) {
            case "address_add": {
                Object pk = this.getModel().getDataEntity().getPkValue();
                Map<String, Object> result = this.checkEnable(pk);
                if (!((Boolean)result.get("result")).booleanValue()) break;
                this.addSiteData(result.get("supplierid"), "bd_suppliersite", ShowType.MainNewTabPage, "suppliersite", useOrgPk);
                break;
            }
            case "address_manger": {
                this.mangerAddress("bd_suppliersite", ShowType.MainNewTabPage, useOrgPk);
                break;
            }
        }
    }

    private void addSiteData(Object id, String entityKey, ShowType modal, String closeCallBackKey, Long useOrgPk) {
        BaseShowParameter fsp = FormShowParameterUtil.getShowParamter((String)entityKey, (boolean)true, (ShowType)modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackKey));
        fsp.setCustomParam("id", id);
        fsp.setCustomParam("useOrg", (Object)useOrgPk);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void mangerAddress(String entityKey, ShowType modal, Long useOrgPk) {
        ListShowParameter lsp = FormShowParameterUtil.getListShowParameter((String)entityKey, (String)"bos_list", (ShowType)modal, (String)"_toolbar_");
        ArrayList<QFilter> qfs = new ArrayList<QFilter>();
        Object masterid = this.getModel().getValue("masterid");
        QFilter qf1 = new QFilter("createorg", "=", (Object)useOrgPk);
        QFilter qf2 = new QFilter("supmasterid", "=", (Object)String.valueOf(masterid));
        qfs.add(qf1);
        qfs.add(qf2);
        lsp.getListFilterParameter().setQFilters(qfs);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private Map<String, Object> checkEnable(Object dataEntitypK) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (dataEntitypK == null || Long.parseLong(dataEntitypK.toString()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u4f9b\u5e94\u5546\u4fe1\u606f\u3002", (String)"SupplierSiteFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
            result.put("result", Boolean.FALSE);
        } else {
            result.put("result", Boolean.TRUE);
            result.put("supplierid", dataEntitypK);
        }
        return result;
    }

    private List<Map<String, Object>> querySiteData() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String useOrg = null;
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            useOrg = pageCache.get("createOrg");
        }
        if (useOrg == null || StringUtils.isEmpty(useOrg)) {
            return list;
        }
        HashSet<Long> orgId = new HashSet<Long>();
        HashSet<Long> addressValue = new HashSet<Long>();
        list.addAll(this.querySiteData(orgId, addressValue, String.valueOf(this.getModel().getValue("masterid")), useOrg));
        Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])orgId.toArray(), (String)"bos_org");
        Map address = BusinessDataServiceHelper.loadFromCache((Object[])addressValue.toArray(), (String)"bd_address");
        if (list.size() > 0) {
            for (Map map : list) {
                map.put("createorg", ((DynamicObject)orgs.get(map.get("createorg"))).getString("name"));
                map.put("useorg", ((DynamicObject)orgs.get(map.get("useorg"))).getString("name"));
                map.put("address", address.get(map.get("address")) != null ? ((DynamicObject)address.get(map.get("address"))).getString("name") : null);
            }
        }
        return list;
    }

    private List<Map<String, Object>> querySiteData(Set<Long> orgId, Set<Long> addressValue, String fsupmasterid, String useOrg) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.basedata, (String)MasterQuerySiteSql.getSupplierSiteQuerySql((String)fsupmasterid, (String)useOrg), null);){
            if (!ds.isEmpty()) {
                String[] fieldNames = ds.getRowMeta().getFieldNames();
                for (Row row : ds) {
                    HashMap<String, Object> map = new HashMap<String, Object>(fieldNames.length);
                    map.put("number", row.getString("fnumber"));
                    map.put("name", row.getString("fname"));
                    map.put("address", row.getLong("faddress"));
                    if (row.getLong("faddress") != 0L) {
                        addressValue.add(row.getLong("faddress"));
                    }
                    map.put("bizfunction", row.getString("fbizfunction"));
                    String enable = row.getString("fenable");
                    enable = "0".equals(enable) ? ResManager.loadKDString((String)"\u7981\u7528", (String)"SiteFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53ef\u7528", (String)"SiteFormPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]);
                    map.put("enable", enable);
                    map.put("id", row.getLong("fid"));
                    map.put("createorg", row.getLong("fcreateorgid"));
                    map.put("useorg", row.getLong("fuseorgid"));
                    orgId.add(row.getLong("fuseorgid"));
                    orgId.add(row.getLong("fcreateorgid"));
                    list.add(map);
                }
            }
        }
        return list;
    }

    private void fillEntry(List<Map<String, Object>> sites) {
        if (sites != null && sites.size() > 0) {
            this.getModel().deleteEntryData("entry_site");
            IDataModel model = this.getModel();
            this.getModel().beginInit();
            TableValueSetter vs = new TableValueSetter(FIELDS);
            for (Map<String, Object> map : sites) {
                Object[] value = new Object[FIELDS.length];
                value[0] = map.get("number");
                value[1] = map.get("name");
                value[2] = map.get("address");
                value[3] = map.get("bizfunction");
                value[4] = map.get("enable");
                value[5] = map.get("id");
                value[6] = map.get("createorg");
                value[7] = map.get("useorg");
                vs.addRow(value);
            }
            AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
            dataModel.batchCreateNewEntryRow("entry_site", vs);
            this.getModel().endInit();
            this.getView().updateView("entry_site");
            this.getModel().setDataChanged(false);
        }
    }
}

