/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import kd.bd.master.enums.StatusEnum;
import kd.bd.master.util.ErrorInfoConverUtil;
import kd.bd.master.vo.OpResultVo;
import kd.bd.master.vo.OperationApiVo;
import kd.bd.master.webapi.model.GenMTAndBizInfoRespModel;
import kd.bd.master.webapi.service.MaterialWebpiService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

@ApiController(desc="\u751f\u6210\u7269\u6599\u548c\u7269\u6599\u4e1a\u52a1\u4fe1\u606fOpenAPI", value="bd")
public class GenerateMaterialAndBizInfoApiServiceV2
implements Serializable {
    private static final long serialVersionUID = 4434540944862847555L;
    private static Log logger = LogFactory.getLog(GenerateMaterialAndBizInfoApiServiceV2.class);
    private static final String ERR_CODE_OPERATE_FAILED = "777";
    private static final String ERR_CODE_SYS_EX = "999";
    private MaterialWebpiService apiService = new MaterialWebpiService();

    @ApiPostMapping(value="/generatemtbizinfo")
    public CustomApiResult<List<GenMTAndBizInfoRespModel>> doCustomService(@NotEmpty @ApiParam(value="\u7269\u6599\u53c2\u6570\uff0cList\u8868\u793a\u652f\u6301\u4f20\u5165\u591a\u4e2a\u7269\u6599\uff0cMap\u4ee3\u8868\u4e00\u4e2a\u7269\u6599\uff0ckey\u4e3a\u7269\u6599\u5143\u6570\u636e\u4e0a\u7684\u5b57\u6bb5\uff0cvalue\u4e3a\u5b57\u6bb5\u503c\u3002") @NotEmpty @ApiParam(value="\u7269\u6599\u53c2\u6570\uff0cList\u8868\u793a\u652f\u6301\u4f20\u5165\u591a\u4e2a\u7269\u6599\uff0cMap\u4ee3\u8868\u4e00\u4e2a\u7269\u6599\uff0ckey\u4e3a\u7269\u6599\u5143\u6570\u636e\u4e0a\u7684\u5b57\u6bb5\uff0cvalue\u4e3a\u5b57\u6bb5\u503c\u3002") List<Map<String, Object>> materialsList) {
        CustomApiResult result = null;
        boolean resultSuccess = true;
        LinkedList<GenMTAndBizInfoRespModel> apiResult = new LinkedList<GenMTAndBizInfoRespModel>();
        try {
            String dataStr = JSON.toJSONString(materialsList);
            JSONArray materials = JSON.parseArray((String)dataStr);
            logger.info("materials record size:" + materials.size());
            OpResultVo materialResult = this.generateMaterial(materials);
            Map materialResultMap = materialResult.getMap();
            OpResultVo bizInfoResult = this.generateMaterialBizInfo(materialResultMap);
            Map bizInfoResultMap = bizInfoResult.getMap();
            GenMTAndBizInfoRespModel apiDataModel = null;
            for (Map.Entry mapEntry : materialResultMap.entrySet()) {
                apiDataModel = new GenMTAndBizInfoRespModel();
                String materialId = (String)mapEntry.getKey();
                OperationApiVo materialApiVo = (OperationApiVo)mapEntry.getValue();
                String materialNumber = materialApiVo.getNumber();
                String invKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_materialinventoryinfo");
                OperationApiVo invInfoApiVo = Optional.ofNullable(bizInfoResultMap.get(invKey)).orElseGet(OperationApiVo::successEmpty);
                String purKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_materialpurchaseinfo");
                OperationApiVo purInfoApiVo = Optional.ofNullable(bizInfoResultMap.get(purKey)).orElseGet(OperationApiVo::successEmpty);
                String saleKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_materialsalinfo");
                OperationApiVo saleInfoApiVo = Optional.ofNullable(bizInfoResultMap.get(saleKey)).orElseGet(OperationApiVo::successEmpty);
                String mftKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_materialmftinfo");
                OperationApiVo mftInfoApiVo = Optional.ofNullable(bizInfoResultMap.get(mftKey)).orElseGet(OperationApiVo::successEmpty);
                String inspectCfgKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey((String)materialId, (String)"bd_inspect_cfg");
                OperationApiVo inspectCfgApiVo = Optional.ofNullable(bizInfoResultMap.get(inspectCfgKey)).orElseGet(OperationApiVo::successEmpty);
                boolean isSuccess = Boolean.parseBoolean(materialApiVo.getIsSuccesss()) && Boolean.parseBoolean(invInfoApiVo.getIsSuccesss()) && Boolean.parseBoolean(purInfoApiVo.getIsSuccesss()) && Boolean.parseBoolean(saleInfoApiVo.getIsSuccesss()) && Boolean.parseBoolean(mftInfoApiVo.getIsSuccesss()) && Boolean.parseBoolean(inspectCfgApiVo.getIsSuccesss());
                StringJoiner msgJoiner = new StringJoiner(" ");
                msgJoiner.add(((OperationApiVo)mapEntry.getValue()).getMessage()).add(invInfoApiVo.getMessage()).add(purInfoApiVo.getMessage()).add(saleInfoApiVo.getMessage()).add(mftInfoApiVo.getMessage()).add(inspectCfgApiVo.getMessage());
                apiDataModel.setMaterialId(materialId);
                apiDataModel.setMaterialNumber(materialNumber);
                apiDataModel.setMaterialInvInfoId(invInfoApiVo.getId());
                apiDataModel.setMaterialPurInfoId(purInfoApiVo.getId());
                apiDataModel.setMaterialSalesInfoId(saleInfoApiVo.getId());
                apiDataModel.setMaterialMftInfoId(mftInfoApiVo.getId());
                apiDataModel.setMaterialInspectCfgId(inspectCfgApiVo.getId());
                apiDataModel.setSuccess(isSuccess);
                apiDataModel.setMessage(msgJoiner.toString().trim());
                apiResult.add(apiDataModel);
                if (isSuccess) continue;
                resultSuccess = false;
            }
            if (resultSuccess) {
                result = CustomApiResult.success(apiResult);
            } else {
                result = CustomApiResult.fail((String)ERR_CODE_OPERATE_FAILED, (String)"operate fail.");
                result.setData(apiResult);
            }
        }
        catch (Throwable e) {
            logger.error("GenerateMaterialAndBizInfoApiServiceV2 exception", e);
            result = CustomApiResult.fail((String)ERR_CODE_SYS_EX, (String)e.getMessage());
            result.setData(apiResult);
        }
        return result;
    }

    private OpResultVo generateMaterial(JSONArray materials) throws Throwable {
        HashMap<Long, JSONObject> needUpdateDatas = new HashMap<Long, JSONObject>(materials.size());
        ArrayList<Long> needUpdateDataIds = new ArrayList<Long>(materials.size());
        ArrayList<JSONObject> newDatas = new ArrayList<JSONObject>(materials.size());
        for (Object material : materials) {
            JSONObject mst = JSON.parseObject((String)material.toString());
            Long id = mst.getLong("id");
            if (id != null && id != 0L) {
                this.apiService.forceSetStatusAndEnable(mst);
                needUpdateDataIds.add(id);
                needUpdateDatas.put(id, mst);
                continue;
            }
            this.apiService.forceSetStatusAndEnable(mst);
            newDatas.add(mst);
        }
        OpResultVo opResultVo = new OpResultVo();
        OpResultVo createOpResultVo = new OpResultVo();
        OpResultVo updateOpResultVo = new OpResultVo();
        logger.info("before save material, newDatas size:" + newDatas.size() + ",needUpdateDatas size:" + needUpdateDatas.size());
        if (!newDatas.isEmpty() && !needUpdateDataIds.isEmpty()) {
            createOpResultVo = this.apiService.createMasterData(newDatas, "bd_material");
            updateOpResultVo = this.apiService.updateMasterData(needUpdateDataIds, needUpdateDatas, "bd_material");
            opResultVo.setResult(createOpResultVo.isResult() && updateOpResultVo.isResult());
            opResultVo.getMap().putAll(createOpResultVo.getMap());
            opResultVo.getMap().putAll(updateOpResultVo.getMap());
        } else if (!newDatas.isEmpty()) {
            opResultVo = createOpResultVo = this.apiService.createMasterData(newDatas, "bd_material");
        } else if (!needUpdateDataIds.isEmpty()) {
            opResultVo = updateOpResultVo = this.apiService.updateMasterData(needUpdateDataIds, needUpdateDatas, "bd_material");
        }
        Map resultMap = opResultVo.getMap();
        List saveSuccessPkIds = resultMap.values().stream().filter(m -> "true".equals(m.getIsSuccesss())).map(m -> Long.valueOf(m.getId())).collect(Collectors.toList());
        logger.info("before submit material, size:" + saveSuccessPkIds.size());
        if (saveSuccessPkIds.isEmpty()) {
            return opResultVo;
        }
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"bd_material", (Object[])saveSuccessPkIds.toArray(), (OperateOption)OperateOption.create());
        if (!submitResult.isSuccess()) {
            ErrorInfoConverUtil.billPKErrorMapping((Map)resultMap, (OperationResult)submitResult);
        }
        List submitSuccessPkIds = submitResult.getSuccessPkIds();
        logger.info("before audit material, size:" + submitSuccessPkIds.size());
        if (submitSuccessPkIds.isEmpty()) {
            return opResultVo;
        }
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"bd_material", (Object[])submitSuccessPkIds.toArray(), (OperateOption)OperateOption.create());
        if (!auditResult.isSuccess()) {
            ErrorInfoConverUtil.billPKErrorMapping((Map)resultMap, (OperationResult)auditResult);
        }
        return opResultVo;
    }

    private OpResultVo generateMaterialBizInfo(Map<String, OperationApiVo> materialInfoMap) {
        OpResultVo result = new OpResultVo(true, new HashMap(1));
        List allMaterialIds = materialInfoMap.values().stream().filter(m -> StringUtils.isNotEmpty((String)m.getId())).map(m -> Long.valueOf(m.getId())).collect(Collectors.toList());
        logger.info("generateMaterialBizInfo, allMaterialIds size:" + allMaterialIds.size());
        if (allMaterialIds.isEmpty()) {
            return result;
        }
        QFilter condition1 = new QFilter("id", "in", allMaterialIds);
        QFilter condition2 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getCode());
        QFilter[] conditions = new QFilter[]{condition1, condition2};
        DynamicObject[] materialArr = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,number,createorg,baseunit,enablepur,enablesale,enableinv,enableproduct,enableinspect,configproperties", (QFilter[])conditions);
        logger.info("generateMaterialBizInfo query material, result size:" + materialArr.length);
        if (materialArr.length == 0) {
            return result;
        }
        ArrayList<DynamicObject> enablePurMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        ArrayList<DynamicObject> enableSaleMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        ArrayList<DynamicObject> enableInvMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        ArrayList<DynamicObject> enableProductMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        ArrayList<DynamicObject> enableInspectMaterialList = new ArrayList<DynamicObject>(materialArr.length);
        for (DynamicObject material : materialArr) {
            if (material.getBoolean("enablepur")) {
                enablePurMaterialList.add(material);
            }
            if (material.getBoolean("enablesale")) {
                enableSaleMaterialList.add(material);
            }
            if (material.getBoolean("enableinv")) {
                enableInvMaterialList.add(material);
            }
            if (material.getBoolean("enableproduct")) {
                enableProductMaterialList.add(material);
            }
            if (!material.getBoolean("enableinspect")) continue;
            enableInspectMaterialList.add(material);
        }
        OpResultVo materialInvInfoResult = new OpResultVo(true, new HashMap(1));
        if (!enableInvMaterialList.isEmpty()) {
            materialInvInfoResult = this.apiService.initMaterialBizInfoByMaterial(enableInvMaterialList, "bd_materialinventoryinfo");
        }
        OpResultVo materialPurInfoResult = new OpResultVo(true, new HashMap(1));
        if (!enablePurMaterialList.isEmpty()) {
            materialPurInfoResult = this.apiService.initMaterialBizInfoByMaterial(enablePurMaterialList, "bd_materialpurchaseinfo");
        }
        OpResultVo materialSaleInfoResult = new OpResultVo(true, new HashMap(1));
        if (!enableSaleMaterialList.isEmpty()) {
            materialSaleInfoResult = this.apiService.initMaterialBizInfoByMaterial(enableSaleMaterialList, "bd_materialsalinfo");
        }
        OpResultVo materialProductInfoResult = new OpResultVo(true, new HashMap(1));
        if (!enableProductMaterialList.isEmpty()) {
            materialProductInfoResult = this.apiService.initMaterialBizInfoByMaterial(enableProductMaterialList, "bd_materialmftinfo");
        }
        OpResultVo materialInspectResult = new OpResultVo(true, new HashMap(1));
        if (!enableInspectMaterialList.isEmpty()) {
            materialInspectResult = this.apiService.initMaterialBizInfoByMaterial(enableInspectMaterialList, "bd_inspect_cfg");
        }
        boolean isSuccess = materialInvInfoResult.isResult() && materialPurInfoResult.isResult() && materialSaleInfoResult.isResult() && materialProductInfoResult.isResult() && materialInspectResult.isResult();
        HashMap resultMap = new HashMap(materialArr.length);
        resultMap.putAll(materialInvInfoResult.getMap());
        resultMap.putAll(materialPurInfoResult.getMap());
        resultMap.putAll(materialSaleInfoResult.getMap());
        resultMap.putAll(materialProductInfoResult.getMap());
        resultMap.putAll(materialInspectResult.getMap());
        result.setResult(isSuccess);
        result.setMap(resultMap);
        return result;
    }
}

