/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bd.master.webapi.service.MasterWebApiService;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class SupplierSaveApiService
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(SupplierSaveApiService.class);
    private MasterWebApiService apiService = new MasterWebApiService();

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult apiResult = null;
        try {
            apiResult = this.executeSupplierInfo(params);
        }
        catch (Throwable e) {
            apiResult = ApiResult.fail((String)e.toString());
            logger.error("supplierSaveApiService errorinfo:" + e);
        }
        return apiResult;
    }

    private ApiResult executeSupplierInfo(Map<String, Object> params) throws Throwable {
        ApiResult relut = null;
        String datas = JSON.toJSONString((Object)params.get("data"));
        if (!StringUtils.isEmpty((String)datas)) {
            JSONArray suppliers = JSON.parseArray((String)datas);
            if (suppliers != null && suppliers.size() > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(suppliers.size());
                HashMap<Long, JSONObject> jsonDatas = new HashMap<Long, JSONObject>(suppliers.size());
                for (Object supplier : suppliers) {
                    JSONObject sup = JSON.parseObject((String)supplier.toString());
                    Long id = sup.getLong("id");
                    if (id != null && id != 0L) {
                        ids.add(id);
                        jsonDatas.put(id, sup);
                        continue;
                    }
                    this.apiService.createMasterData(sup, "bd_supplier");
                }
                if (ids.size() > 0) {
                    this.apiService.updateMasterData(ids, jsonDatas, "bd_supplier");
                }
                relut = ApiResult.success((Object)"operate successfully.");
            }
        } else {
            relut = ApiResult.fail((String)"The incoming JSON data is empty.");
        }
        return relut;
    }
}

