/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.mservice.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterWriter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class OtherInOutBillBizTypeUpgradeServiceImpl
implements IUpgradeService {
    private static Map<Long, Long> upDefaultBizTypes = new HashMap<Long, Long>(5);
    public static final String otherInBillType = "{\"_Type_\":\"entryentity\",\"biztypenumber\":{\"number\":\"TZ-YS-3542\",\"masterid\":2068378121018551296,\"_Type_\":\"bd_biztype\",\"multilanguagetext\":[{\"_Type_\":\"locale\",\"pkid\":\"4H1DK+HHFP0X\",\"name\":\"\u8c03\u8d26\u5165\u5e93\",\"description\":\"\u8c03\u6574\u5386\u53f2\u5e93\u5b58\u5355\u636e\u672a\u540c\u6b65\u5b58\u8d27\u6838\u7b97\u7684\u5176\u4ed6\u5165\u5e93\u4e1a\u52a1\",\"localeid\":\"zh_CN\"}],\"ispreset\":true,\"name\":{\"GLang\":\"\u8c03\u8d26\u5165\u5e93\",\"zh_CN\":\"\u8c03\u8d26\u5165\u5e93\"},\"id\":2068378121018551296},\"ispreset\":true,\"biztypenumber_id\":2068378121018551296,\"id\":0,\"isdefault\":false,\"seq\":5}";
    public static final String otherOutBillType = "{\"_Type_\":\"entryentity\",\"biztypenumber\":{\"number\":\"TZ-YS-3552\",\"masterid\":2068376310228462592,\"_Type_\":\"bd_biztype\",\"multilanguagetext\":[{\"_Type_\":\"locale\",\"pkid\":\"4H1D7SX1QBYH\",\"name\":\"\u8c03\u8d26\u51fa\u5e93\",\"description\":\"\u8c03\u6574\u5386\u53f2\u5e93\u5b58\u5355\u636e\u672a\u540c\u6b65\u5b58\u8d27\u6838\u7b97\u7684\u5176\u4ed6\u51fa\u5e93\u4e1a\u52a1\",\"localeid\":\"zh_CN\"}],\"ispreset\":true,\"name\":{\"GLang\":\"\u8c03\u8d26\u51fa\u5e93\",\"zh_CN\":\"\u8c03\u8d26\u51fa\u5e93\"},\"id\":2068376310228462592},\"ispreset\":true,\"biztypenumber_id\":2068376310228462592,\"id\":0,\"isdefault\":false,\"seq\":6}";
    private static Log logger = LogFactory.getLog(OtherInOutBillBizTypeUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ParameterWriter.removeBatchParameterCache(null, (String)"bos");
        upDefaultBizTypes.put(366342412236234752L, 2068378121018551296L);
        upDefaultBizTypes.put(366344074757678080L, 2068376310228462592L);
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fformid,fbilltypeid,fdata from t_bas_billtypeparameter  where ", new Object[0]).appendIn("fbilltypeid", new ArrayList<Long>(upDefaultBizTypes.keySet()));
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u53c2\u6570\u3002");
        DataSet billTypeDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder);
        logger.info("\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u53c2\u6570\u7ed3\u675f\u3002");
        while (billTypeDataSet.hasNext()) {
            Row next = billTypeDataSet.next();
            String formId = next.getString("fformid");
            Long billTypeId = next.getLong("fbilltypeid");
            String fdata = next.getString("fdata");
            Map bizTypeMap = (Map)JSON.parse((String)fdata);
            List entryList = (List)bizTypeMap.get("entryentity");
            boolean hadUpdate = false;
            for (Map entryEntity : entryList) {
                Object id = entryEntity.get("biztypenumber_id");
                boolean hadRelate = upDefaultBizTypes.get(billTypeId).equals(id);
                if (!hadRelate) continue;
                hadUpdate = true;
                break;
            }
            if (hadUpdate) continue;
            ArrayList preEntryList = new ArrayList(16);
            if (billTypeId.equals(366342412236234752L)) {
                Map otherInBillTypeMap = (Map)JSON.parseObject((String)otherInBillType, Map.class);
                entryList.add(otherInBillTypeMap);
            } else if (billTypeId.equals(366344074757678080L)) {
                Map otherOutBillTypeMap = (Map)JSON.parseObject((String)otherOutBillType, Map.class);
                entryList.add(otherOutBillTypeMap);
            }
            preEntryList.addAll(entryList);
            bizTypeMap.put("entryentity", preEntryList);
            JSONObject jsonObject = new JSONObject(bizTypeMap);
            ParameterWriter.saveBillTypeParameter((String)formId, (long)billTypeId, (String)jsonObject.toJSONString());
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }
}

