/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class RequireTypeUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String selSql = "select  fid,frequiretype from t_bd_manustrategy where frequiretype = 0";
        DBRoute sysRoute = new DBRoute("sys");
        HashSet<Long> ids = new HashSet<Long>(16);
        try (DataSet manustrategyDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)selSql);){
            while (manustrategyDataSet.hasNext()) {
                Row row = manustrategyDataSet.next();
                ids.add(row.getLong("fid"));
            }
        }
        String allManustrategyLSql = "select fid,fname,flocaleid from t_bd_manustrategy_L";
        HashMap<Long, Map> manustrategyNameMap = new HashMap<Long, Map>(16);
        try (DataSet manustrategyDataLSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)allManustrategyLSql);){
            while (manustrategyDataLSet.hasNext()) {
                Row row = manustrategyDataLSet.next();
                Map map = manustrategyNameMap.computeIfAbsent(row.getLong("fid"), k -> new HashMap(16));
                map.put(row.getString("flocaleid"), row.getString("fname"));
            }
        }
        ArrayList<Object[]> newRequireTypeParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> newRequireTypeLParams = new ArrayList<Object[]>(16);
        String allManustrategySql = "select fid,fnumber,frequiretype,FDEMANDOFFSET,FORDERINVOLVEDMRP,FISCURRENTSTOCK,FALLOWDROP,FALLOWINDEPENDENTREQ,FISINWAY FROM T_BD_MANUSTRATEGY WHERE FREQUIRETYPE = 0 ";
        String insertRequireTypeSql = "INSERT INTO T_BD_REQUIRETYPE (FID,FMASTERID,FNUMBER ,FDEMANDOFFSET,FORDERINVOLVEDMRP,FISCURRENTSTOCK,FALLOWDROP,FINDEPENDENTREQ,FISINWAY,FPROJECTREQ,FISADVANCEDEMAND,FDEMANDREDUCE,FSTATUS,FCREATETIME,FMODIFIERID,FENABLE,FMODIFYTIME,FCREATORID) VALUES (?,?,?,?,?,?,?,?,?,'0','0','0','C',{ts'2018-08-08  18:08:08'},1,'1',{ts'2018-08-08  18:08:08'},1)";
        String insertRequireTypeLSql = "INSERT INTO T_BD_REQUIRETYPE_L (FPKID, FID, FLOCALEID, FNAME) VALUES (?, ?, ?, ?)";
        String insertRequireTypeWaySql = "INSERT INTO T_BD_REQUIRETYPE_WAY(FID,FBASEDATAID,FPKID) VALUES (?, ?, ?)";
        List<Object[]> newRequireTypeWayParams = this.getRequireTypeParams("T_BD_MANUSTRATEGY_WAY", ids, sysRoute);
        String insertRequireTypeRangeSql = "INSERT INTO T_BD_REQUIRETYPE_RANGE(FID,FBASEDATAID,FPKID) VALUES (?, ?, ?)";
        List<Object[]> newRequireTypeRangeParams = this.getRequireTypeParams("T_BD_MANUSTRATEGY_RANGE", ids, sysRoute);
        String insertRequireTypeInvSql = "INSERT INTO T_BD_REQUIRETYPE_INV(FID,FBASEDATAID,FPKID) VALUES (?, ?, ?)";
        List<Object[]> newRequireTypeInvParams = this.getRequireTypeParams("T_BD_MANUSTRATEGY_INV", ids, sysRoute);
        String insertRequireTypeNoInvSql = "INSERT INTO T_BD_REQUIRETYPE_NO_INV(FID,FBASEDATAID,FPKID) VALUES (?, ?, ?)";
        List<Object[]> newRequireTypeNoInvParams = this.getRequireTypeParams("T_BD_MANUSTRATEGY_NO_INV", ids, sysRoute);
        try (DataSet manustrategyDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)allManustrategySql);){
            while (manustrategyDataSet.hasNext()) {
                Row row = manustrategyDataSet.next();
                Long manustrategyId = row.getLong("fid");
                String fnumber = row.getString("fnumber");
                Object[] newRequireTypeParam = new Object[]{manustrategyId, manustrategyId, fnumber, row.getString("FDEMANDOFFSET"), row.getString("FORDERINVOLVEDMRP"), row.getString("FISCURRENTSTOCK"), row.getString("FALLOWDROP"), row.getString("FALLOWINDEPENDENTREQ"), row.getString("FISINWAY")};
                Map map = (Map)manustrategyNameMap.get(manustrategyId);
                if (map == null || map.isEmpty()) continue;
                long[] lIds = DB.genLongIds((String)"T_BD_REQUIRETYPE_L", (int)map.size());
                int count = 0;
                for (Map.Entry l : map.entrySet()) {
                    Object[] newRequireTypeLParam = new Object[4];
                    String key = (String)l.getKey();
                    String value = (String)l.getValue();
                    newRequireTypeLParam[0] = lIds[count];
                    newRequireTypeLParam[1] = manustrategyId;
                    newRequireTypeLParam[2] = key;
                    newRequireTypeLParam[3] = value;
                    newRequireTypeLParams.add(newRequireTypeLParam);
                    ++count;
                }
                newRequireTypeParams.add(newRequireTypeParam);
            }
        }
        var25_33 = null;
        try (TXHandle handle = TX.requiresNew();){
            if (!newRequireTypeParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertRequireTypeSql, newRequireTypeParams);
            }
            if (!newRequireTypeLParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertRequireTypeLSql, newRequireTypeLParams);
            }
            if (!newRequireTypeWayParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertRequireTypeWaySql, newRequireTypeWayParams);
            }
            if (!newRequireTypeRangeParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertRequireTypeRangeSql, newRequireTypeRangeParams);
            }
            if (!newRequireTypeInvParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertRequireTypeInvSql, newRequireTypeInvParams);
            }
            if (!newRequireTypeNoInvParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertRequireTypeNoInvSql, newRequireTypeNoInvParams);
            }
            String updateManustrategySql = "UPDATE T_BD_MANUSTRATEGY SET frequiretype=FID WHERE FREQUIRETYPE=0 ";
            DB.execute((DBRoute)sysRoute, (String)updateManustrategySql);
        }
        catch (Throwable throwable) {
            var25_33 = throwable;
            throw throwable;
        }
        result.setSuccess(true);
        result.setLog("ManuStrategyGroup hisData update success");
        return result;
    }

    private List<Object[]> getRequireTypeParams(String table, Set<Long> ids, DBRoute sysRoute) {
        ArrayList<Object[]> newRequireTypeParams = new ArrayList<Object[]>(16);
        if (ids.isEmpty()) {
            return newRequireTypeParams;
        }
        String sql = "SELECT ENTRY.FID,ENTRY.FBASEDATAID,ENTRY.FPKID FROM " + table + " ENTRY INNER JOIN T_BD_MANUSTRATEGY M ON M.FID = ENTRY.FID WHERE M.FREQUIRETYPE = 0";
        try (DataSet manustrategyDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)sql);){
            while (manustrategyDataSet.hasNext()) {
                Row next = manustrategyDataSet.next();
                Long id = next.getLong("FID");
                if (!ids.contains(id)) continue;
                Object[] newRequireTypeParam = new Object[]{id, next.getLong("FBASEDATAID"), next.getLong("FPKID")};
                newRequireTypeParams.add(newRequireTypeParam);
            }
        }
        return newRequireTypeParams;
    }
}

