/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.master.business.custom.ext.BatchUpdExtCheckingImpl;
import kd.bd.master.business.custom.ext.IBatchUpdExtChecking;
import kd.bd.master.enums.EnableEnum;
import kd.bd.master.enums.MaterialTypeEnum;
import kd.bd.master.enums.StatusEnum;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.JSONUtils;

public class BatchUpdFieldHelper {
    private static final Log log = LogFactory.getLog(BatchUpdFieldHelper.class);
    public static final String KEY_CUSTOMER_COMBO_FIELD = "customercombofield";
    public static final String KEY_SUPPLIER_COMBO_FIELD = "suppliercombofield";
    public static final String KEY_MATERIAL_COMBO_FIELD = "materialcombofield";
    public static final String KEY_UPDATE_VALUE_F7 = "updatevaluef7";
    private static final String KEY_UPDATE_VALUE_COMBO = "updatevaluecombo";
    private static final String KEY_UPDATE_VALUE_MULCOMBO = "updatevaluemulcombo";
    private static final String KEY_UPDATE_VALUE_CHECKBOX = "updatevaluecheckbox";
    private static final String KEY_UPDATE_VALUE_QTY = "updatevalueqty";
    private static final String KEY_UPDATE_VALUE_TEXT = "updatevaluetext";
    private static final String KEY_ITEM_CLASS_TYPE_FIELD = "itemclasstypefield";
    private static final String MEASUREUNIT = "measureunit";
    private static final String KEY_MODIFY_TIME = "modifytime";
    private static final String KEY_MODIFIER = "modifier";
    private static final String KEY_ENTITYNUMBER_PARAM = "entityNumber";
    private static final String KEY_DATAIDS_PARAM = "dataIds";
    private static final String KEY_ID_NUMBER_MAP = "idNumberMap";
    public static final String KEY_OK_BTN = "btnok";
    private static final String KEY_ORG_FUNC_ID = "orgFuncId";
    private static final String KEY_TAXRATE = "taxrate";
    private static final String KEY_BOS_OPERATIONRESULT = "bos_operationresult";
    private static final String LINE_BREAK = "\r\n";
    private static final Set<String> CUSTOMER_FORBIDDEN_UPD_FIELDS = Stream.of("number", "name", "status", "creator", "modifier", "enable", "createtime", "modifytime", "group", "org", "createorg", "useorg", "ctrlstrategy", "sourcedata", "bitindex", "srcindex", "disabler", "disabledate", "simplename", "customer_status", "invoicecustomerid", "delivercustomerid", "paymentcustomerid", "type", "country", "bizpartner_address", "linkman", "bizpartner_phone", "bizpartner_fax", "societycreditcode", "orgcode", "biz_register_num", "tx_register_no", "artificialperson", "internal_company", "bizpartnerid", "picturefield", "bizpartner", "adminorg", "regcapital", "businessterm", "businessscope", "establishdate", "bizfunction", "postal_code", "url", "admindivision", "invoicetype", "invoicehold", "invoiceaddress", "idno", "bloccustomer", "simplepinyin", "customerstatus", "taxregistplace", "taxno", "duns", "curegcapital").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> SUPPLIER_FORBIDDEN_UPD_FIELDS = Stream.of("number", "name", "status", "creator", "modifier", "enable", "createtime", "modifytime", "org", "createorg", "useorg", "ctrlstrategy", "sourcedata", "bitindex", "srcindex", "disabler", "disabledate", "invoicesupplierid", "deliversupplierid", "receivingsupplierid", "issuppcolla", "adminorg", "simplename", "taxtype", "type", "bizpartner_address", "linkman", "bizpartner_phone", "bizpartner_fax", "societycreditcode", "orgcode", "biz_register_num", "tx_register_no", "artificialperson", "internal_company", "bizpartnerid", "group", "picturefield", "bizpartner", "malldate", "mallstatus", "regcapital", "businessterm", "businessscope", "establishdate", "bizfunction", "invoicehold", "payhold", "admindivision", "url", "postal_code", "invoicetype", "employee", "invoiceaddress", "idno", "blocsupplier", "simplepinyin", "billaddress", "supplier_status", "invaliddate", "simplesupplier", "country").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> MATERIAL_FORBIDDEN_UPD_FIELDS = Stream.of("number", "name", "status", "creator", "modifier", "enable", "createtime", "modifytime", "org", "createorg", "useorg", "ctrlstrategy", "sourcedata", "bitindex", "srcindex", "disabler", "disabledate", "baseunit", "approverid", "approvedate", "description", "oldnumber", "helpcode", "modelnum", "group", "materialtype", "materialform", "enablelot", "enableserial", "lifetime", "shelflife", "alertleadtime", "isuseauxpty", "serialunit", "enablelotsatinf", "lotsatinfoscheme", "enablesersatinf", "sersatinfoscheme", "enablelifemgr", "isdisposable", "isoutputrequest", "serialmu", "picturefield", "weightunit", "netweight", "grossweight", "height", "width", "length", "lengthunit", "volumnunit", "volume", "isenablematerialversion", "sparepart", "auxptyunit", "unitconvertdir", "simplepinyin", "completetag", "serviceattribute", "configproperties", "suite", "productline", "productfamily", "productseries", "productmodel", "deductiblerate").collect(Collectors.toCollection(HashSet::new));

    public static void showBatchUpdForm(IFormView view, IPageCache pageCache, String entityNumber, ListSelectedRowCollection selectedRows) {
        if (!BatchUpdFieldHelper.selectedRecordChecking(view, pageCache, entityNumber, selectedRows)) {
            return;
        }
        Map<String, Object> params = BatchUpdFieldHelper.prepareFormParams(entityNumber, selectedRows);
        view.showForm(FormShowParameterUtil.getDynamicForm("bd_batchupdfield", params, null, ShowType.Modal, ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539", (String)"BatchUpdFieldHelper_0", (String)"bd-master-business", (Object[])new Object[0])));
    }

    private static boolean selectedRecordChecking(IFormView view, IPageCache pageCache, String entityNumber, ListSelectedRowCollection selectedRows) {
        String bizOrg = pageCache.get("createOrg");
        String appNumber = view.getFormShowParameter().getAppId();
        StringBuilder invalidTipsBuilder = new StringBuilder();
        boolean checkPermission = true;
        if (selectedRows.isEmpty()) {
            return false;
        }
        if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)Long.parseLong(bizOrg), (String)appNumber, (String)entityNumber, (String)"4715a0df000000ac") == 0) {
            checkPermission = false;
        }
        int invalidTipsCount = 0;
        for (ListSelectedRow selectedRow : selectedRows) {
            if (selectedRow.getMainOrgId() != Long.parseLong(bizOrg)) {
                invalidTipsBuilder.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0e\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\uff1a%s", (String)"BatchUpdFieldHelper_1", (String)"bd-master-business", (Object[])new Object[0]), selectedRow.getNumber())).append(LINE_BREAK);
                ++invalidTipsCount;
                continue;
            }
            if (checkPermission) continue;
            invalidTipsBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u60a8\u6ca1\u6709\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u7684\u4fee\u6539\u6743\u9650\u3002", (String)"BatchUpdFieldHelper_5", (String)"bd-master-business", (Object[])new Object[0]), selectedRow.getNumber())).append(LINE_BREAK);
            ++invalidTipsCount;
        }
        if (invalidTipsCount == 1) {
            view.showTipNotification(invalidTipsBuilder.toString().replace(LINE_BREAK, ""));
            return false;
        }
        if (invalidTipsCount > 1) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("errorMsg", invalidTipsBuilder);
            view.showForm(FormShowParameterUtil.getOperResultForm(KEY_BOS_OPERATIONRESULT, params, null, ShowType.Modal));
            return false;
        }
        return true;
    }

    private static Map<String, Object> prepareFormParams(String entityNumber, ListSelectedRowCollection selectedRows) {
        ArrayList<Long> dataIds = new ArrayList<Long>(selectedRows.size());
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long id = (Long)row.getPrimaryKeyValue();
            dataIds.add(id);
            idNumberMap.put(id, row.getNumber());
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put(KEY_ENTITYNUMBER_PARAM, entityNumber);
        params.put(KEY_DATAIDS_PARAM, dataIds);
        params.put(KEY_ID_NUMBER_MAP, idNumberMap);
        return params;
    }

    public static void setUpdFieldVisibility(IFormView view) {
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
        if ("bd_customer".equals(entityNumber)) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_CUSTOMER_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_SUPPLIER_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_MATERIAL_COMBO_FIELD});
        } else if ("bd_supplier".equals(entityNumber)) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_SUPPLIER_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_CUSTOMER_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_MATERIAL_COMBO_FIELD});
        } else if ("bd_material".equals(entityNumber)) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_MATERIAL_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_CUSTOMER_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_SUPPLIER_COMBO_FIELD});
        } else {
            log.info("unsupport entityNumber:" + entityNumber);
            view.setVisible(Boolean.FALSE, new String[]{KEY_MATERIAL_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_CUSTOMER_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_SUPPLIER_COMBO_FIELD});
        }
    }

    public static void setUpdValVisibility(IFormView view) {
        IDataEntityProperty property = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (property == null) {
            return;
        }
        BatchUpdFieldHelper.hideAllUpdValControl(view);
        if (property instanceof MulComboProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_MULCOMBO});
        } else if (property instanceof ComboProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_COMBO});
        } else if (property instanceof BasedataProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_F7});
        } else if (property instanceof BooleanProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_CHECKBOX});
        } else if (property instanceof QtyProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_QTY});
        } else if (property instanceof TextProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_TEXT});
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"BatchUpdFieldHelper_26", (String)"bd-master-business", (Object[])new Object[0]));
        }
    }

    private static void hideAllUpdValControl(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_F7});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_COMBO});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_MULCOMBO});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_CHECKBOX});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_QTY});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_TEXT});
    }

    public static void setUpdValOptions(IFormView view, IDataModel dataModal) {
        IDataEntityProperty superFormFieldProp = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (superFormFieldProp instanceof MulComboProp) {
            dataModal.setValue(KEY_UPDATE_VALUE_MULCOMBO, (Object)"");
            MulComboProp comboProp = (MulComboProp)superFormFieldProp;
            List srcComboItems = comboProp.getComboItems();
            ArrayList<ComboItem> targComboItems = new ArrayList<ComboItem>(srcComboItems.size());
            ComboEdit targCombo = (ComboEdit)view.getControl(KEY_UPDATE_VALUE_MULCOMBO);
            ComboItem item = null;
            for (ValueMapItem srcComboItem : srcComboItems) {
                item = new ComboItem();
                item.setValue(srcComboItem.getValue());
                item.setCaption(srcComboItem.getName());
                targComboItems.add(item);
            }
            targCombo.setComboItems(targComboItems);
        } else if (superFormFieldProp instanceof ComboProp) {
            dataModal.setValue(KEY_UPDATE_VALUE_COMBO, (Object)"");
            ComboProp comboProp = (ComboProp)superFormFieldProp;
            List srcComboItems = comboProp.getComboItems();
            ArrayList<ComboItem> targComboItems = new ArrayList<ComboItem>(srcComboItems.size());
            ComboEdit targCombo = (ComboEdit)view.getControl(KEY_UPDATE_VALUE_COMBO);
            ComboItem item = null;
            for (ValueMapItem srcComboItem : srcComboItems) {
                item = new ComboItem();
                item.setValue(srcComboItem.getValue());
                item.setCaption(srcComboItem.getName());
                targComboItems.add(item);
            }
            targCombo.setComboItems(targComboItems);
        } else if (superFormFieldProp instanceof BasedataProp) {
            dataModal.setValue(KEY_UPDATE_VALUE_F7, (Object)"");
            BasedataProp basedataProp = (BasedataProp)superFormFieldProp;
            String baseDataId = basedataProp.getBaseEntityId();
            dataModal.setValue(KEY_ITEM_CLASS_TYPE_FIELD, (Object)baseDataId);
        } else if (superFormFieldProp instanceof QtyProp) {
            Map formShowParams = view.getFormShowParameter().getCustomParams();
            String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
            List dataIds = (List)formShowParams.get(KEY_DATAIDS_PARAM);
            QtyProp qtyProp = (QtyProp)superFormFieldProp;
            String measureUnitKey = qtyProp.getRelatedUnit();
            Long minPrecisionSalesUnitId = BatchUpdFieldHelper.queryMinPrecisionUnitId(entityNumber, dataIds, measureUnitKey);
            dataModal.setValue(MEASUREUNIT, (Object)minPrecisionSalesUnitId);
        }
    }

    private static Long queryMinPrecisionUnitId(String entityNumber, List<Long> dataIds, String measureUnitKey) {
        try (TraceSpan span = Tracer.create((String)"bd BatchUpdFieldHelper", (String)"queryMinPrecisionUnitId");){
            Long result = 0L;
            Map dataInfoMap = BusinessDataServiceHelper.loadFromCache((Object[])dataIds.toArray(), (String)entityNumber);
            List unitNotNullList = dataInfoMap.values().stream().filter(p -> p.getDynamicObject(measureUnitKey) != null).collect(Collectors.toList());
            Optional<DynamicObject> minPrecisionUnit = unitNotNullList.stream().map(s -> s.getDynamicObject(measureUnitKey)).min(Comparator.comparingInt(p -> p.getInt("precision")));
            if (minPrecisionUnit.isPresent()) {
                result = minPrecisionUnit.get().getLong("id");
            } else {
                log.info("bd BatchUpdFieldHelper.queryMinPrecisionUnitId: minPrecisionUnit is empty");
            }
            Long l = result;
            return l;
        }
    }

    public static void setUpdValProp(IFormView view, IDataModel dataModal) {
        IDataEntityProperty superFormFieldProp = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (superFormFieldProp instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)superFormFieldProp;
            HashMap prop = new HashMap(2);
            HashMap<String, String> editor = new HashMap<String, String>(2);
            editor.put("dsp", basedataProp.getDisplayProp());
            prop.put("item", editor);
            view.updateControlMetadata(KEY_UPDATE_VALUE_F7, prop);
        }
    }

    private static IDataEntityProperty getSuperFormFieldProp(IFormView view) {
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
        String updField = (String)view.getModel().getValue(BatchUpdFieldHelper.getUpdFieldNumber(entityNumber));
        MainEntityType superEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return superEntityType.findProperty(updField);
    }

    private static String getUpdFieldNumber(String entityNumber) {
        String result = "";
        switch (StringUtils.trimToEmpty((String)entityNumber)) {
            case "bd_customer": {
                result = KEY_CUSTOMER_COMBO_FIELD;
                break;
            }
            case "bd_supplier": {
                result = KEY_SUPPLIER_COMBO_FIELD;
                break;
            }
            case "bd_material": {
                result = KEY_MATERIAL_COMBO_FIELD;
                break;
            }
        }
        return result;
    }

    public static void batchUpdate(IFormView view, IDataModel dataModal) {
        boolean isExistNotSuppliesRecords;
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
        List ids = (List)formShowParams.get(KEY_DATAIDS_PARAM);
        ArrayList<Long> dataIds = new ArrayList<Long>(ids.size());
        if (ids != null && ids.size() > 0) {
            for (Object ob : ids) {
                dataIds.add(Long.parseLong(String.valueOf(ob)));
            }
        }
        Map idNumberMap = (Map)formShowParams.get(KEY_ID_NUMBER_MAP);
        String updField = (String)dataModal.getValue(BatchUpdFieldHelper.getUpdFieldNumber(entityNumber));
        Object updVal = "";
        IDataEntityProperty property = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (property instanceof MulComboProp) {
            updVal = dataModal.getValue(KEY_UPDATE_VALUE_MULCOMBO);
        } else if (property instanceof ComboProp) {
            updVal = dataModal.getValue(KEY_UPDATE_VALUE_COMBO);
        } else if (property instanceof BasedataProp) {
            Object updValF7 = dataModal.getValue(KEY_UPDATE_VALUE_F7);
            updVal = updValF7 instanceof DynamicObject ? ((DynamicObject)updValF7).getPkValue() : Integer.valueOf(0);
        } else if (property instanceof BooleanProp) {
            updVal = dataModal.getValue(KEY_UPDATE_VALUE_CHECKBOX);
        } else if (property instanceof QtyProp) {
            updVal = dataModal.getValue(KEY_UPDATE_VALUE_QTY);
        } else if (property instanceof TextProp) {
            updVal = dataModal.getValue(KEY_UPDATE_VALUE_TEXT);
        }
        if (!BatchUpdFieldHelper.updFieldChecking(view, entityNumber, updField)) {
            return;
        }
        StringBuilder errMsgBuilder = new StringBuilder();
        try (TraceSpan span = Tracer.create((String)"BatchUpdFieldHelper", (String)"networkMutexChecking");){
            StringBuilder checkingResult = BatchUpdFieldHelper.networkMutexChecking(view, entityNumber, dataIds);
            errMsgBuilder.append((CharSequence)checkingResult);
        }
        if ("bd_material".equals(entityNumber) && BatchUpdFieldHelper.isMaterialBizCheckbox(updField) && !dataIds.isEmpty()) {
            span = Tracer.create((String)"BatchUpdFieldHelper", (String)"materialBizInfoChecking");
            var12_14 = null;
            try {
                StringBuilder bizInfoCheckingResult = BatchUpdFieldHelper.materialBizInfoChecking(dataModal, dataIds);
                errMsgBuilder.append((CharSequence)bizInfoCheckingResult);
            }
            catch (Throwable bizInfoCheckingResult) {
                var12_14 = bizInfoCheckingResult;
                throw bizInfoCheckingResult;
            }
            finally {
                if (span != null) {
                    if (var12_14 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable bizInfoCheckingResult) {
                            var12_14.addSuppressed(bizInfoCheckingResult);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
        if ("bd_material".equals(entityNumber) && !dataIds.isEmpty() && "farmproducts".equals(updField) && ((Boolean)updVal).booleanValue() && (isExistNotSuppliesRecords = QueryServiceHelper.exists((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("materialtype", "!=", (Object)MaterialTypeEnum.SUPPLIES.getCode())}))) {
            dataIds.clear();
            errMsgBuilder.append(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u542b\u975e\u7269\u8d44\u7c7b\u578b\u7684\u7269\u6599\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BatchUpdFieldHelper_29", (String)"bd-master-business", (Object[])new Object[0]));
        }
        Object newUpdVal = updVal;
        BatchUpdExtCheckingImpl extCheckingImpl = new BatchUpdExtCheckingImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)extCheckingImpl, IBatchUpdExtChecking.class, (String)"SYS_BASEDATA_BATCHUPDATE_UPDATE", null);
        List extCheckingResultList = pluginProxy.callReplace(p -> p.doExtChecking(entityNumber, idNumberMap, dataIds, updField, newUpdVal));
        extCheckingResultList.stream().forEach(errMsgBuilder::append);
        DynamicObject[] updEntityArr = new DynamicObject[]{};
        if (!dataIds.isEmpty()) {
            try (TraceSpan span = Tracer.create((String)"BatchUpdFieldHelper", (String)"BusinessDataServiceHelper.load");){
                updEntityArr = BusinessDataServiceHelper.load((Object[])dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
            }
        }
        List<Map<String, Object>> beforeUpdateBillInfos = BatchUpdFieldHelper.getBeforeUpdateBillInfos(updEntityArr, updField);
        OperationResult updResult = new OperationResult();
        try (TraceSpan span = Tracer.create((String)"BatchUpdFieldHelper", (String)"doUpdate");){
            log.info("BatchUpdFieldHelper.batchUpdate,record num: " + dataIds.size());
            updResult = BatchUpdFieldHelper.doUpdate(entityNumber, updEntityArr, updField, updVal);
            if (!updResult.isSuccess()) {
                errMsgBuilder.append(BatchUpdFieldHelper.getOperateErrMsg(updResult));
            }
        }
        catch (Exception e) {
            log.error("BatchUpdFieldHelper.batchUpdate exception", (Throwable)e);
            errMsgBuilder.append(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a", (String)"BatchUpdFieldHelper_4", (String)"bd-master-business", (Object[])new Object[0])).append(e.getLocalizedMessage()).append(LINE_BREAK);
        }
        int totalRecordsCount = ((Map)formShowParams.get(KEY_ID_NUMBER_MAP)).size();
        List successPkIdList = updResult.getSuccessPkIds();
        HashSet successPkIdSet = new HashSet(successPkIdList.size());
        for (Object successPkId : successPkIdList) {
            successPkIdSet.add(successPkId);
        }
        int successRecordsCount = successPkIdSet.size();
        String batchUpdResult = BatchUpdFieldHelper.batchUpdResultTips(view, errMsgBuilder, totalRecordsCount, successRecordsCount);
        try (TraceSpan span = Tracer.create((String)"BatchUpdFieldHelper", (String)"saveOperLog");){
            BatchUpdFieldHelper.saveOperLog(entityNumber, batchUpdResult, beforeUpdateBillInfos, updField, updVal);
        }
    }

    private static boolean updFieldChecking(IFormView view, String entityNumber, String updField) {
        if (StringUtils.isBlank((CharSequence)updField)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6279\u6539\u5b57\u6bb5", (String)"BatchUpdFieldHelper_3", (String)"bd-master-business", (Object[])new Object[0]));
            return false;
        }
        boolean isValidFieldType = false;
        IDataEntityProperty property = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (property instanceof MulComboProp || property instanceof ComboProp || property instanceof AssistantProp || property instanceof BasedataProp || property instanceof BooleanProp || property instanceof QtyProp || property instanceof TextProp) {
            isValidFieldType = true;
        }
        if (!isValidFieldType) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"BatchUpdFieldHelper_26", (String)"bd-master-business", (Object[])new Object[0]));
            return false;
        }
        Set<String> forbiddenUpdFields = null;
        forbiddenUpdFields = "bd_customer".equals(entityNumber) ? CUSTOMER_FORBIDDEN_UPD_FIELDS : ("bd_supplier".equals(entityNumber) ? SUPPLIER_FORBIDDEN_UPD_FIELDS : MATERIAL_FORBIDDEN_UPD_FIELDS);
        if (forbiddenUpdFields.contains(updField)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u975e\u51fa\u5382\u9884\u7f6e\u7684\u6807\u51c6\u4ea7\u54c1\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u3002", (String)"BatchUpdFieldHelper_25", (String)"bd-master-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean isMaterialBizCheckbox(String fieldNum) {
        return "enablepur".equals(fieldNum) || "enablesale".equals(fieldNum) || "enableinv".equals(fieldNum) || "enableproduct".equals(fieldNum) || "enableasset".equals(fieldNum) || "enableoutsource".equals(fieldNum) || "enabletrustee".equals(fieldNum) || "enableconsign".equals(fieldNum) || "enablevmi".equals(fieldNum) || "enableinspect".equals(fieldNum);
    }

    private static StringBuilder materialBizInfoChecking(IDataModel dataModal, List<Long> dataIds) {
        boolean isExistFeeRecords;
        boolean isExistFeeOrSrvOrAssetRecords;
        LinkedList<String> materialTypeList;
        StringBuilder checkingResult = new StringBuilder();
        String updField = dataModal.getDataEntity().getString(KEY_MATERIAL_COMBO_FIELD);
        boolean updVal = dataModal.getDataEntity().getBoolean(KEY_UPDATE_VALUE_CHECKBOX);
        if ("enableasset".equals(updField) || "enableinspect".equals(updField)) {
            materialTypeList = new LinkedList<String>();
            materialTypeList.add(MaterialTypeEnum.FEE.getCode());
            materialTypeList.add(MaterialTypeEnum.SERVICE.getCode());
            boolean isExistFeeOrSrvRecords = QueryServiceHelper.exists((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("materialtype", "in", materialTypeList)});
            if (isExistFeeOrSrvRecords) {
                checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("feeOrSrv", updField)).append(LINE_BREAK);
                dataIds.clear();
                return checkingResult;
            }
        }
        if ("enableproduct".equals(updField) || "enableoutsource".equals(updField) || "enabletrustee".equals(updField) || "enablevmi".equals(updField)) {
            materialTypeList = new LinkedList();
            materialTypeList.add(MaterialTypeEnum.FEE.getCode());
            materialTypeList.add(MaterialTypeEnum.ASSET.getCode());
            materialTypeList.add(MaterialTypeEnum.SERVICE.getCode());
            isExistFeeOrSrvOrAssetRecords = QueryServiceHelper.exists((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("materialtype", "in", materialTypeList)});
            if (isExistFeeOrSrvOrAssetRecords) {
                checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("feeOrSrvOrAsset", updField)).append(LINE_BREAK);
                dataIds.clear();
                return checkingResult;
            }
        }
        if ("enableinv".equals(updField) && (isExistFeeRecords = QueryServiceHelper.exists((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("materialtype", "=", (Object)MaterialTypeEnum.FEE.getCode())}))) {
            checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("fee", updField)).append(LINE_BREAK);
            dataIds.clear();
            return checkingResult;
        }
        if ("enableconsign".equals(updField)) {
            LinkedList<String> materialTypeList2 = new LinkedList<String>();
            materialTypeList2.add(MaterialTypeEnum.FEE.getCode());
            materialTypeList2.add(MaterialTypeEnum.ASSET.getCode());
            isExistFeeOrSrvOrAssetRecords = QueryServiceHelper.exists((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("materialtype", "in", materialTypeList2)});
            if (isExistFeeOrSrvOrAssetRecords) {
                checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("feeOrAsset", updField)).append(LINE_BREAK);
                dataIds.clear();
                return checkingResult;
            }
        }
        if ("enablepur".equals(updField) && !updVal && BatchUpdFieldHelper.isExistBizInfo("enablepur")) {
            checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("other", updField)).append(LINE_BREAK);
            dataIds.clear();
        } else if ("enablesale".equals(updField) && !updVal && BatchUpdFieldHelper.isExistBizInfo("enablesale")) {
            checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("other", updField)).append(LINE_BREAK);
            dataIds.clear();
        } else if ("enableinv".equals(updField) && !updVal && BatchUpdFieldHelper.isExistBizInfo("enableinv")) {
            checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("other", updField)).append(LINE_BREAK);
            dataIds.clear();
        } else if ("enableproduct".equals(updField) && !updVal && BatchUpdFieldHelper.isExistBizInfo("enableproduct")) {
            checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("other", updField)).append(LINE_BREAK);
            dataIds.clear();
        } else if ("enableinspect".equals(updField) && !updVal && BatchUpdFieldHelper.isExistBizInfo("enableinspect")) {
            checkingResult.append(BatchUpdFieldHelper.getMaterialBizInfoCheckingMsg("other", updField)).append(LINE_BREAK);
            dataIds.clear();
        }
        return checkingResult;
    }

    private static String getMaterialBizInfoCheckingMsg(String materialType, String fieldNum) {
        String result = "";
        String fieldName = "";
        if ("enablepur".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u91c7\u8d2d", (String)"BatchUpdFieldHelper_13", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enablesale".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u9500\u552e", (String)"BatchUpdFieldHelper_14", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enableinv".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u5e93\u5b58", (String)"BatchUpdFieldHelper_15", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enableproduct".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u751f\u4ea7", (String)"BatchUpdFieldHelper_16", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enableasset".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u8d44\u4ea7", (String)"BatchUpdFieldHelper_17", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enableoutsource".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u59d4\u5916", (String)"BatchUpdFieldHelper_18", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enabletrustee".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u53d7\u6258", (String)"BatchUpdFieldHelper_19", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enableconsign".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u5bc4\u552e", (String)"BatchUpdFieldHelper_20", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enablevmi".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53efVMI", (String)"BatchUpdFieldHelper_21", (String)"bd-master-business", (Object[])new Object[0]);
        } else if ("enableinspect".equals(fieldNum)) {
            fieldName = ResManager.loadKDString((String)"\u53ef\u8d28\u68c0", (String)"BatchUpdFieldHelper_22", (String)"bd-master-business", (Object[])new Object[0]);
        }
        if ("fee".equals(materialType)) {
            result = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u542b\u8d39\u7528\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539%1$s\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_27", (String)"bd-master-business", (Object[])new Object[0]), fieldName);
        } else if ("feeOrAsset".equals(materialType)) {
            result = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u542b\u8d39\u7528\u6216\u8d44\u4ea7\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539%1$s\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_28", (String)"bd-master-business", (Object[])new Object[0]), fieldName);
        } else if ("feeOrSrv".equals(materialType)) {
            result = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u542b\u8d39\u7528\u6216\u670d\u52a1\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539%1$s\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_23", (String)"bd-master-business", (Object[])new Object[0]), fieldName);
        } else if ("feeOrSrvOrAsset".equals(materialType)) {
            result = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u542b\u8d39\u7528\u3001\u670d\u52a1\u6216\u8d44\u4ea7\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539%1$s\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_24", (String)"bd-master-business", (Object[])new Object[0]), fieldName);
        } else if ("other".equals(materialType)) {
            if ("enablepur".equals(fieldNum)) {
                result = ResManager.loadKDString((String)"\u5b58\u5728\u4efb\u610f\u4e00\u6761\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\uff0c\u5219\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u53ef\u91c7\u8d2d\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_8", (String)"bd-master-business", (Object[])new Object[0]);
            } else if ("enablesale".equals(fieldNum)) {
                result = ResManager.loadKDString((String)"\u5b58\u5728\u4efb\u610f\u4e00\u6761\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u7269\u6599\u9500\u552e\u4fe1\u606f\uff0c\u5219\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u53ef\u9500\u552e\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_9", (String)"bd-master-business", (Object[])new Object[0]);
            } else if ("enableinv".equals(fieldNum)) {
                result = ResManager.loadKDString((String)"\u5b58\u5728\u4efb\u610f\u4e00\u6761\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u5219\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u53ef\u5e93\u5b58\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_10", (String)"bd-master-business", (Object[])new Object[0]);
            } else if ("enableproduct".equals(fieldNum)) {
                result = ResManager.loadKDString((String)"\u5b58\u5728\u4efb\u610f\u4e00\u6761\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u5219\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u53ef\u751f\u4ea7\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_11", (String)"bd-master-business", (Object[])new Object[0]);
            } else if ("enableinspect".equals(fieldNum)) {
                result = ResManager.loadKDString((String)"\u5b58\u5728\u4efb\u610f\u4e00\u6761\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u7269\u6599\u8d28\u68c0\u4fe1\u606f\uff0c\u5219\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u53ef\u8d28\u68c0\u6807\u8bc6\u3002", (String)"BatchUpdFieldHelper_12", (String)"bd-master-business", (Object[])new Object[0]);
            }
        }
        return result;
    }

    private static boolean isExistBizInfo(String bizInfoFlag) {
        String entityName = "";
        switch (bizInfoFlag) {
            case "enablepur": {
                entityName = "bd_materialpurchaseinfo";
                break;
            }
            case "enablesale": {
                entityName = "bd_materialsalinfo";
                break;
            }
            case "enableinv": {
                entityName = "bd_materialinventoryinfo";
                break;
            }
            case "enableproduct": {
                entityName = "bd_materialmftinfo";
                break;
            }
            case "enableinspect": {
                entityName = "bd_inspect_cfg";
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)entityName)) {
            log.info("BatchUpdFieldHelper.isExistBizInfo: entityName is empty");
            return false;
        }
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getCode()), new QFilter("status", "=", (Object)StatusEnum.AUDIT.getCode())});
    }

    private static List<Map<String, Object>> getBeforeUpdateBillInfos(DynamicObject[] beforeUpdateDataArr, String updField) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (beforeUpdateDataArr == null || beforeUpdateDataArr.length == 0) {
            return result;
        }
        HashMap<String, Object> billInfoMap = null;
        for (DynamicObject beforeUpdateData : beforeUpdateDataArr) {
            billInfoMap = new HashMap<String, Object>(16);
            billInfoMap.put("billId", beforeUpdateData.getPkValue());
            billInfoMap.put("billNo", beforeUpdateData.get("number"));
            Object beforeUpdateVal = beforeUpdateData.get(updField);
            if (beforeUpdateVal instanceof DynamicObject) {
                beforeUpdateVal = beforeUpdateData.getDynamicObject(updField).getPkValue();
            }
            if (beforeUpdateVal == null) {
                beforeUpdateVal = "";
            }
            billInfoMap.put("beforeUpdateVal", beforeUpdateVal);
            result.add(billInfoMap);
        }
        return result;
    }

    private static void saveOperLog(String entityNumber, String batchUpdResult, List<Map<String, Object>> beforeUpdateBillInfos, String updField, Object updVal) {
        HashMap<String, Object> modifyContentTag = new HashMap<String, Object>(16);
        modifyContentTag.put("entity", entityNumber);
        modifyContentTag.put("operateResult", batchUpdResult);
        modifyContentTag.put("updateField", updField);
        modifyContentTag.put("updateVal", updVal);
        modifyContentTag.put("beforeUpdateBillInfoSize", beforeUpdateBillInfos.size());
        modifyContentTag.put("beforeUpdateBillInfos", beforeUpdateBillInfos);
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setBizAppID("0efa1992000000ac");
        logInfo.setBizObjID(entityNumber);
        logInfo.setOpName("batchupdate", "");
        String opDesc = batchUpdResult;
        if (opDesc.length() >= 250) {
            opDesc = opDesc.substring(0, 250);
        }
        logInfo.setOpDescription(opDesc);
        try {
            logInfo.setModifyContentTag(JSONUtils.toString(modifyContentTag));
        }
        catch (IOException e) {
            logInfo.setModifyContentTag("BatchUpdFieldHelper saveOperLog,call JSONUtils.toString err:" + e.getMessage());
            log.error("BatchUpdFieldHelper saveOperLog,call JSONUtils.toString err:", (Throwable)e);
        }
        ILogService logSrv = (ILogService)ServiceFactory.getService(ILogService.class);
        logSrv.addLog((AppLogInfo)logInfo);
    }

    private static StringBuilder networkMutexChecking(IFormView view, String entityNumber, List<Long> dataIds) {
        StringBuilder checkingResult = new StringBuilder();
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        Map idNumberMap = (Map)formShowParams.get(KEY_ID_NUMBER_MAP);
        try (DataMutex dataMutex = DataMutex.create();){
            Iterator<Long> iterator = dataIds.iterator();
            while (iterator.hasNext()) {
                Long dataId = iterator.next();
                Map info = dataMutex.getLockInfo(String.valueOf(dataId), MutexHelper.getMutexGroupId((String)entityNumber, (String)"modify"), entityNumber);
                if (info == null) continue;
                checkingResult.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u57fa\u7840\u6570\u636e\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BatchUpdFieldHelper_6", (String)"bd-master-business", (Object[])new Object[0]), idNumberMap.get(dataId))).append(LINE_BREAK);
                iterator.remove();
            }
        }
        catch (IOException e) {
            log.error("BatchUpdFieldHelper-networkMutexChecking exception", (Throwable)e);
        }
        return checkingResult;
    }

    private static OperationResult doUpdate(String entityNumber, DynamicObject[] updEntityArr, String updField, Object updVal) {
        Long curUserId = RequestContext.get().getCurrUserId();
        Date modifytime = new Date();
        OperationResult updResult = new OperationResult();
        if (updEntityArr == null || updEntityArr.length == 0) {
            return updResult;
        }
        for (DynamicObject updateEntity : updEntityArr) {
            updateEntity.set(updField, updVal);
            updateEntity.set(KEY_MODIFIER, (Object)curUserId);
            updateEntity.set(KEY_MODIFY_TIME, (Object)modifytime);
        }
        updResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])updEntityArr, (OperateOption)OperateOption.create());
        log.info("BatchUpdFieldHelper doUpdate: " + updEntityArr.length + " record, result: " + updResult.isSuccess());
        if (!updResult.isSuccess()) {
            log.error("BatchUpdFieldHelper doUpdate failed: " + BatchUpdFieldHelper.getOperateErrMsg(updResult));
        }
        return updResult;
    }

    private static String batchUpdResultTips(IFormView view, StringBuilder errMsg, int totalRecordsCount, int successRecordsCount) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)errMsg)) {
            String tip = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u5171\u4fee\u6539%s\u6761\u6570\u636e\u3002", (String)"BatchUpdFieldHelper_2", (String)"bd-master-business", (Object[])new Object[0]), totalRecordsCount);
            view.getParentView().showSuccessNotification(tip);
            result.append(tip);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u4fee\u6539\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"BatchUpdFieldHelper_7", (String)"bd-master-business", (Object[])new Object[0]), totalRecordsCount, successRecordsCount, totalRecordsCount - successRecordsCount);
            params.put("title", title);
            params.put("errorMsg", errMsg);
            view.getParentView().showForm(FormShowParameterUtil.getOperResultForm(KEY_BOS_OPERATIONRESULT, params, null, ShowType.Modal));
            result.append(title).append(':').append((CharSequence)errMsg);
        }
        view.sendFormAction(view.getParentView());
        view.close();
        return result.toString();
    }

    public static void updValF7Filter(BeforeF7SelectEvent f7Event, IFormView view) {
        IFormView parentView = view.getParentView();
        IPageCache pageCache = parentView == null ? null : (IPageCache)parentView.getService(IPageCache.class);
        Long bizOrg = 0L;
        String bizOrgStr = "";
        if (pageCache != null) {
            bizOrgStr = pageCache.get("createOrg");
        }
        if (StringUtils.isNotBlank((CharSequence)bizOrgStr)) {
            bizOrg = Long.valueOf(bizOrgStr);
        }
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        ListShowParameter param = (ListShowParameter)f7Event.getFormShowParameter();
        param.getListFilterParameter().getQFilters().add(filter);
        IDataEntityProperty dataEntityProperty = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (dataEntityProperty == null) {
            return;
        }
        if (dataEntityProperty instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)dataEntityProperty;
            String orgFunc = orgProp.getOrgFunc();
            param.setCustomParam(KEY_ORG_FUNC_ID, (Object)orgFunc);
        }
        if (KEY_TAXRATE.equals(dataEntityProperty.getName())) {
            BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
            String baseDataId = basedataProp.getBaseEntityId();
            log.info("[BatchUpdFieldHelper]set filter of taxrate\uff1abizOrg is: " + bizOrgStr);
            QFilter taxRateFilter = BaseDataServiceHelper.getBaseDataFilter((String)baseDataId, (Long)bizOrg);
            param.getListFilterParameter().getQFilters().add(taxRateFilter);
        }
        if ("salerid".equals(dataEntityProperty.getName()) || "purchaserid".equals(dataEntityProperty.getName())) {
            param.setCustomParam("isShowPartner", (Object)Boolean.FALSE);
        }
        if (dataEntityProperty instanceof AssistantProp) {
            AssistantProp assistantProp = (AssistantProp)dataEntityProperty;
            Long groupId = Long.parseLong(assistantProp.getAsstTypeId());
            QFilter groupFilter = new QFilter("group", "=", (Object)groupId);
            QFilter orgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)groupId, (Long)bizOrg);
            param.getListFilterParameter().getQFilters().add(groupFilter);
            param.getListFilterParameter().getQFilters().add(orgFilter);
        }
    }

    private static String getOperateErrMsg(OperationResult updResult) {
        StringBuilder errMsgBuilder = new StringBuilder();
        List allErrorOrValidateInfo = updResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo.isEmpty()) {
            errMsgBuilder.append(updResult.getMessage()).append(LINE_BREAK);
        } else {
            for (IOperateInfo operInfo : allErrorOrValidateInfo) {
                errMsgBuilder.append(operInfo.getMessage()).append(LINE_BREAK);
            }
        }
        return errMsgBuilder.toString();
    }
}

