/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Vector;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FillDataHelper {
    private static final Log log = LogFactory.getLog(FillDataHelper.class);
    public static final String FAIL_SOCIETYCREDITCODE = "fail_societycreditcode";
    public static final String FAIL_REGISTER_NO = "fail_register_no";
    public static final String FAIL_ARTIFICIALPERSON = "fail_artificialperson";
    public static final String FAIL_BUSINESSSCOPE = "fail_businessscope";
    public static final String FAIL_ESTABLISHDATE = "fail_establishdate";
    public static final String FAIL_BIZPARTNER_ADDRESS = "fail_bizpartner_address";
    public static final String FAIL_REGCAPITAL = "fail_regcapital";

    public static void input(IFormView view, IDataModel model, String propertyName, Object oldValue) {
        try {
            String oldStr;
            LocaleDynamicObjectCollection oldValueLocal;
            DynamicObject orCreateItemByLocaleId;
            view.setVisible(Boolean.FALSE, new String[]{FAIL_SOCIETYCREDITCODE, FAIL_REGISTER_NO, FAIL_ARTIFICIALPERSON, FAIL_BUSINESSSCOPE, FAIL_ESTABLISHDATE, "fail_admindivision", FAIL_BIZPARTNER_ADDRESS, FAIL_REGCAPITAL});
            String localeId = RequestContext.get().getLang().name();
            DynamicObject dataEntity = model.getDataEntity();
            ILocaleString newNameValue = dataEntity.getLocaleString("name");
            String newStr = "";
            if (Objects.nonNull(newNameValue) && StringUtils.isEmpty((String)(newStr = newNameValue.getLocaleValue()))) {
                return;
            }
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org == null) {
                return;
            }
            if (propertyName.equals("name") && Objects.nonNull(oldValue) && (orCreateItemByLocaleId = (oldValueLocal = (LocaleDynamicObjectCollection)oldValue).getOrCreateItemByLocaleId(localeId)) != null && newStr.equals(oldStr = orCreateItemByLocaleId.getString("name"))) {
                return;
            }
            Long orgId = (Long)org.getPkValue();
            String billId = model.getDataEntityType().getName();
            Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"input", (Object[])new Object[]{orgId, billId, "input", dataEntity});
            Map map = (Map)result;
            Object success = map.get("success");
            Object message = map.get("message");
            log.info("\u8c03\u7528\u586b\u5145\u7c7b\u63a5\u53e3\u5165\u53c2\uff1aname={},\u8fd4\u56de,success={},message={}", new Object[]{newStr, success, message});
            if (success == null || !success.equals(true)) {
                return;
            }
            Object dataObj = map.get("data");
            if (!(dataObj instanceof DynamicObject)) {
                return;
            }
            DynamicObject data = (DynamicObject)dataObj;
            FillDataHelper.update(view, model, propertyName, data);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u586b\u5145\u7c7b\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
    }

    private static void update(IFormView view, IDataModel model, String propertyName, DynamicObject data) {
        ArrayList<String> propNames = new ArrayList<String>(8);
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        model.beginInit();
        for (IDataEntityProperty iDataEntityProperty : properties) {
            Object value;
            String propName = iDataEntityProperty.getName();
            if (propName.equals(propertyName) || "multilanguagetext".equals(propName) || (value = data.get(propName)) == null) continue;
            if (value instanceof String) {
                if (!StringUtils.isNotEmpty((String)((String)value))) continue;
                model.setValue(propName, value);
                propNames.add(propName);
                continue;
            }
            model.setValue(propName, value);
            propNames.add(propName);
        }
        Map allEntities = model.getDataEntityType().getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            DynamicObjectCollection dyc;
            String key = (String)entry.getKey();
            if (!data.containsProperty(key) || !CollectionUtils.isNotEmpty((Collection)(dyc = data.getDynamicObjectCollection(key)))) continue;
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int rowIndex = 0;
            for (DynamicObject dy : dyc) {
                DataEntityPropertyCollection entryProperties = dy.getDataEntityType().getProperties();
                for (IDataEntityProperty iDataEntityProperty : entryProperties) {
                    String propName = iDataEntityProperty.getName();
                    vs.set(propName, dy.get(propName), rowIndex);
                }
                ++rowIndex;
            }
            AbstractFormDataModel modelvs = (AbstractFormDataModel)model;
            modelvs.deleteEntryData(key);
            modelvs.batchCreateNewEntryRow(key, vs);
            propNames.add(key);
        }
        model.endInit();
        for (String key : propNames) {
            view.updateView(key);
        }
    }

    private static Map<String, Object> check(DynamicObject dataEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return null;
        }
        Long orgId = (Long)org.getPkValue();
        String billId = dataEntity.getDataEntityType().getName();
        List<String> entityKeys = Collections.singletonList(billId);
        Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"loadBusinessInfos", (Object[])new Object[]{orgId, entityKeys, "input", dataEntity});
        Map data = (Map)result;
        log.info("\u8c03\u7528\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de,data={}", (Object)data);
        Object success = data.get("success");
        if (success != null && success.equals(true)) {
            Object dataObj = data.get("data");
            if (dataObj == null) {
                return null;
            }
            return (Map)dataObj;
        }
        return null;
    }

    public static boolean checkIsvData(IFormView view, IDataModel model) {
        try {
            DynamicObject dataEntity = model.getDataEntity();
            view.setVisible(Boolean.FALSE, new String[]{FAIL_SOCIETYCREDITCODE, FAIL_REGISTER_NO, FAIL_ARTIFICIALPERSON, FAIL_BUSINESSSCOPE, FAIL_ESTABLISHDATE, "fail_admindivision", FAIL_BIZPARTNER_ADDRESS, FAIL_REGCAPITAL});
            if (dataEntity.getPkValue() == null || (Long)dataEntity.getPkValue() == 0L) {
                return true;
            }
            Map<String, Object> backData = FillDataHelper.check(dataEntity);
            if (backData == null) {
                return true;
            }
            int i = 0;
            String societyCreditCodeUrl = (String)backData.get("societycreditcode");
            String societyCreditCode = dataEntity.getString("societycreditcode");
            if (StringUtils.isNotEmpty((String)societyCreditCodeUrl) && !societyCreditCodeUrl.equals(societyCreditCode)) {
                FillDataHelper.setTips(view, FAIL_SOCIETYCREDITCODE, societyCreditCodeUrl);
                ++i;
            }
            String txRegisterNoUrl = (String)backData.get("tx_register_no");
            String txRegisterNo = dataEntity.getString("tx_register_no");
            if (StringUtils.isNotEmpty((String)txRegisterNoUrl) && !txRegisterNoUrl.equals(txRegisterNo)) {
                FillDataHelper.setTips(view, FAIL_REGISTER_NO, txRegisterNoUrl);
                ++i;
            }
            String artificialPersonUrl = (String)backData.get("artificialperson");
            String artificialPerson = dataEntity.getString("artificialperson");
            if (StringUtils.isNotEmpty((String)artificialPersonUrl) && !artificialPersonUrl.equals(artificialPerson)) {
                FillDataHelper.setTips(view, FAIL_ARTIFICIALPERSON, artificialPersonUrl);
                ++i;
            }
            String businessScopeUrl = (String)backData.get("businessscope");
            String businessScope = dataEntity.getString("businessscope");
            if (StringUtils.isNotEmpty((String)businessScopeUrl) && !businessScopeUrl.equals(businessScope)) {
                FillDataHelper.setTips(view, FAIL_BUSINESSSCOPE, businessScopeUrl);
                ++i;
            }
            Date establishDateUrl = (Date)backData.get("establishdate");
            Date establishDate = dataEntity.getDate("establishdate");
            Date date = establishDate = establishDate == null ? new Date() : establishDate;
            if (establishDateUrl != null && establishDate.compareTo(establishDateUrl) != 0) {
                String formatDate = new SimpleDateFormat("yyyy-MM-dd").format(establishDateUrl);
                FillDataHelper.setTips(view, FAIL_ESTABLISHDATE, formatDate);
                ++i;
            }
            String bizPartnerAddressUrl = (String)backData.get("bizpartner_address");
            String bizPartnerAddress = dataEntity.getString("bizpartner_address");
            if (StringUtils.isNotEmpty((String)bizPartnerAddressUrl) && !bizPartnerAddressUrl.equals(bizPartnerAddress)) {
                FillDataHelper.setTips(view, FAIL_BIZPARTNER_ADDRESS, bizPartnerAddressUrl);
                ++i;
            }
            String regCapitalUrl = (String)backData.get("regcapital");
            String regCapital = dataEntity.getString("regcapital");
            if (StringUtils.isNotEmpty((String)regCapitalUrl) && !regCapitalUrl.equals(regCapital)) {
                FillDataHelper.setTips(view, FAIL_REGCAPITAL, regCapitalUrl);
                ++i;
            }
            return i == 0;
        }
        catch (Exception e) {
            log.error("\u5f81\u4fe1\u6839\u636e\u540d\u79f0\u68c0\u67e5\u4f01\u4e1a\u4fe1\u606f\u8c03\u7528\u68c0\u67e5\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
            return false;
        }
    }

    private static void setTips(IFormView view, String name, String tip) {
        view.setVisible(Boolean.TRUE, new String[]{name});
        Vector vector = (Vector)view.getControl(name);
        if (vector == null) {
            log.warn("setTips:\u6807\u8bc6 {} \u4e0d\u5b58\u5728", (Object)name);
            return;
        }
        Tips tips = new Tips();
        LocaleString local = new LocaleString();
        local.setLocaleValue(ResManager.loadKDString((String)"\u6240\u586b\u4fe1\u606f\u4e0e\u5927\u6570\u636e\u9a8c\u8bc1\u4e0d\u76f8\u7b26\uff0c\u5927\u6570\u636e\u4fe1\u606f\u4e3a\uff1a{0}\u3002", (String)"FillDataHelper_0", (String)"bd-master-business", (Object[])new Object[]{tip}));
        tips.setContent(local);
        tips.setType("text");
        tips.setShowIcon(false);
        tips.setTriggerType("hover");
        vector.addTips(tips);
    }
}

