/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.util.TemplateMaterialUtil;
import kd.bd.master.vo.MaterialReleaseBillVo;
import kd.bd.master.vo.MaterialValueVo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class TemplateMaterialHelper {
    private static Log log = LogFactory.getLog(TemplateMaterialHelper.class);
    private static final String MATERIAL_SQL = "select fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid from t_bd_materialusereg where fdataid in(";
    private static final String MATERIAL_SQL_U = "select fuseorgid,fdataid from t_bd_material_u where fdataid in(";
    private static final String MATLINVENTORYINFO_SQL = "select fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid from t_bd_materialinvinfousereg where fdataid in(";
    private static final String MATLINVENTORYINFO_SQL_EXC = "select fuseorgid,fdataid,fcreateorgid,fnewdataid from t_bd_materialinvinfoexc where fdataid in(";
    private static final String MATERIALSALINFO_SQL = "select fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid from t_bd_materialsalinfousereg where fdataid in(";
    private static final String MATERIALSALINFO_SQL_EXC = "select fuseorgid,fdataid,fcreateorgid,fnewdataid from t_bd_materialsalinfoexc where fdataid in(";
    private static final String MATERIALPURINFO_SQL = "select fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid from t_bd_materialpurinfousereg where fdataid in(";
    private static final String MATERIALPURINFO_SQL_EXC = "select fuseorgid,fdataid,fcreateorgid,fnewdataid from t_bd_materialpurinfoexc where fdataid in(";
    private static final String MATERIALMFTINFO_SQL = "select fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid from t_bd_materialmftinfousereg where fdataid in(";
    private static final String MATERIALMFTINFO_SQL_EXC = "select fuseorgid,fdataid,fcreateorgid,fnewdataid from t_bd_materialmftinfoexc where fdataid in(";
    private static final String INSPECT_CFG_SQL = "select fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid from t_bd_inspect_cfgusereg where fdataid in(";
    private static final String INSPECT_CFG_SQL_EXC = "select fuseorgid,fdataid,fcreateorgid,fnewdataid from t_bd_inspect_cfgexc where fdataid in(";
    private static final String MATERIALCALINFO_SQL = "select fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid from t_bd_materialcalinfousereg where fdataid in(";
    private static final String MATERIALCALINFO_SQL_EXC = "select fuseorgid,fdataid,fcreateorgid,fnewdataid from t_bd_materialcalinfoexc where fdataid in(";
    private static final String MATERIALPLAN_SQL = "select fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid from t_mpdm_materialplanusereg where fdataid in(";
    private static final String MATERIALPLAN_SQL_EXC = "select fuseorgid,fdataid,fcreateorgid,fnewdataid from t_mpdm_materialplanexc where fdataid in(";

    public static DynamicObject getTemplateMaterial(IDataModel model, IFormView view, Object newValue, int rowIndex, ChangeData valueSet) {
        DynamicObject material = null;
        DynamicObject entryMatrial = valueSet.getDataEntity();
        DynamicObject baseunit = entryMatrial.getDynamicObject("baseunit");
        DynamicObject group = entryMatrial.getDynamicObject("group");
        String materialtype = entryMatrial.getString("materialtype");
        String ctrlstrategy = (String)model.getValue("ctrlstrategy");
        if (baseunit != null && group != null && !StringUtils.isEmpty((String)materialtype)) {
            String sql = "select t1.fid from t_bd_material t1 inner join t_bd_material_s t2 on t1.fid=t2.fid inner join t_bd_materialgroupdetail t3 on t1.fid=t3.fmaterialid where t1.fstatus='C' and t1.fenable='1' and t1.fbaseunit='";
            StringBuilder sqlbf = new StringBuilder();
            sqlbf.append("select t1.fid from t_bd_material t1 inner join t_bd_material_s t2 on t1.fid=t2.fid inner join t_bd_materialgroupdetail t3 on t1.fid=t3.fmaterialid where t1.fstatus='C' and t1.fenable='1' and t1.fbaseunit='");
            sqlbf.append(baseunit.getPkValue());
            sqlbf.append("' and t1.fctrlstrategy='");
            sqlbf.append(ctrlstrategy);
            sqlbf.append("' and t2.fmaterialtype='");
            sqlbf.append(materialtype);
            sqlbf.append("' and t3.fgroupid='");
            sqlbf.append(group.getPkValue());
            sqlbf.append("' ");
            try (DataSet ds = DB.queryDataSet((String)"TemplateMaterialHelper.getTemplateMaterial", (DBRoute)DBRoute.basedata, (String)sqlbf.toString(), null);){
                ArrayList<String> ids = null;
                for (Row row : ds) {
                    if (row.getString("fid") == null || StringUtils.isEmpty((String)String.valueOf(row.getString("fid")))) continue;
                    ids = new ArrayList<String>(1);
                    ids.add(row.getString("fid"));
                    break;
                }
                if (ids != null && ids.size() > 0) {
                    material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong((String)ids.get(0)))});
                    model.setValue("istempmaterial", (Object)Boolean.TRUE, rowIndex);
                } else {
                    model.setValue("istempmaterial", (Object)Boolean.FALSE, rowIndex);
                }
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"templatematerial"});
            }
        } else {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"templatematerial"});
        }
        return material;
    }

    public Map<String, String> createMaterialAndStrategyData(List<MaterialReleaseBillVo> datas, Set<Long> materialPk) throws KDBizException {
        Map tempMaterials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "in", materialPk)});
        HashMap<String, String> numberMap = new HashMap<String, String>();
        if (datas == null || datas.size() == 0 || tempMaterials == null || tempMaterials.size() == 0) {
            log.error("Template material or material and material strategy data to be created is empty.");
            return numberMap;
        }
        Map tempMultimeasureunit = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (QFilter[])new QFilter[]{new QFilter("materialid", "in", materialPk)});
        Map tempMaterialgroupdetail = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (QFilter[])new QFilter[]{new QFilter("material", "in", materialPk)});
        Map materialinventoryinfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialPk)});
        Map materialsalinfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialsalinfo", (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialPk)});
        Map materialpurchaseinfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialpurchaseinfo", (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialPk)});
        Map materialmftinfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialPk)});
        Map inspectcfgInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_inspect_cfg", (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialPk)});
        Map materialcalinfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialcalinfo", (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialPk)});
        Map materialplanInfo = BusinessDataServiceHelper.loadFromCache((String)"mpdm_materialplan", (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialPk)});
        for (MaterialReleaseBillVo materialReleaseBillVo : datas) {
            this.createMaterialAssociationData(tempMaterials, tempMultimeasureunit, tempMaterialgroupdetail, materialinventoryinfo, materialsalinfo, materialpurchaseinfo, materialmftinfo, inspectcfgInfo, materialcalinfo, materialplanInfo, materialReleaseBillVo, numberMap);
        }
        return numberMap;
    }

    private void createMaterialAssociationData(Map<Object, DynamicObject> tempMaterials, Map<Object, DynamicObject> tempMultimeasureunit, Map<Object, DynamicObject> tempMaterialgroupdetail, Map<Object, DynamicObject> materialinventoryinfo, Map<Object, DynamicObject> materialsalinfo, Map<Object, DynamicObject> materialpurchaseinfo, Map<Object, DynamicObject> materialmftinfo, Map<Object, DynamicObject> inspectcfgInfo, Map<Object, DynamicObject> materialcalinfo, Map<Object, DynamicObject> materialplaninfo, MaterialReleaseBillVo materialReleaseBillVo, Map<String, String> numberMap) throws KDBizException {
        int i;
        StringBuffer dataIds;
        List<DynamicObject> materialDatas = materialReleaseBillVo.getDatas();
        ArrayList<MaterialValueVo> materialPksList = new ArrayList<MaterialValueVo>(materialDatas.size());
        MaterialValueVo materialValueVo = null;
        HashMap<String, DynamicObject> materialDynsMap = new HashMap<String, DynamicObject>(materialDatas.size());
        String proposer = materialReleaseBillVo.getProposer();
        long[] ids = DB.genLongIds((String)"T_BD_MATERIAL", (int)materialDatas.size());
        DynamicObject tempMaterial = null;
        String number = "";
        HashSet<String> numbers = new HashSet<String>(materialDatas.size());
        ArrayList<DynamicObject> materialRs = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> multimeasureunitRes = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> materialgroupdetailRes = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> materialinventoryinfoRes = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> materialsalinfoRes = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> materialpurchaseinfoRes = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> materialmftinfoRes = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> inspectcfgInfoRes = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> materialcalinfoRes = new ArrayList<DynamicObject>(materialDatas.size());
        ArrayList<DynamicObject> materialplaninfoRes = new ArrayList<DynamicObject>(materialDatas.size());
        HashSet<Long> materialinventoryinfoUseOrgIds = new HashSet<Long>();
        HashSet<Long> materialsalinfoUseOrgIds = new HashSet<Long>();
        HashSet<Long> materialpurchaseinfoUseOrgIds = new HashSet<Long>();
        HashSet<Long> materialmftinfoUseOrgIds = new HashSet<Long>();
        HashSet<Long> inspectcfgInfoUseOrgIds = new HashSet<Long>();
        HashSet<Long> materialcalinfoUseOrgIds = new HashSet<Long>();
        HashSet<Long> materialplaninfoUseOrgIds = new HashSet<Long>();
        Set<Long> materialOrgSet = null;
        Set<Long> materialinventoryinfoOrgSet = null;
        Set<Long> materialsalinfoOrgSet = null;
        Set<Long> materialpurchaseinfoOrgSet = null;
        Set<Long> materialmftinfoOrgSet = null;
        Set<Long> inspectcfgInfoOrgSet = null;
        Set<Long> materialcalinfoOrgSet = null;
        Set<Long> materialplaninfoOrgSet = null;
        CloneUtils cloneUtils = new CloneUtils(false, true);
        HashSet<String> materialPks = new HashSet<String>(materialDatas.size());
        DataEntityPropertyCollection propertyCollection = tempMaterials.get(materialDatas.get(0).getDynamicObject("templatematerial").getPkValue()).getDynamicObjectType().getProperties();
        HashSet<String> propertys = null;
        if (propertyCollection != null && propertyCollection.size() > 0) {
            propertys = new HashSet<String>(propertyCollection.size());
            for (IDataEntityProperty property : propertyCollection) {
                if (!property.getName().startsWith("st_")) continue;
                propertys.add(property.getName());
            }
        }
        HashMap<String, List<String>> multunitqueryMap = new HashMap<String, List<String>>(tempMultimeasureunit.size());
        ArrayList<String> list = null;
        for (Map.Entry<Object, DynamicObject> map : tempMultimeasureunit.entrySet()) {
            if (multunitqueryMap.containsKey(map.getValue().getDynamicObject("materialid").getString("id"))) {
                ((List)multunitqueryMap.get(((DynamicObject)map.getValue()).getDynamicObject("materialid").getString("id"))).add(String.valueOf(map.getKey()));
                continue;
            }
            list = new ArrayList<String>();
            list.add(String.valueOf(map.getKey()));
            multunitqueryMap.put(((DynamicObject)map.getValue()).getDynamicObject("materialid").getString("id"), list);
        }
        HashMap<String, List<String>> groupdetailqueryMap = new HashMap<String, List<String>>(tempMaterialgroupdetail.size());
        for (Map.Entry entry : tempMaterialgroupdetail.entrySet()) {
            if (groupdetailqueryMap.containsKey(((DynamicObject)entry.getValue()).getDynamicObject("material").getString("id"))) {
                ((List)groupdetailqueryMap.get(((DynamicObject)entry.getValue()).getDynamicObject("material").getString("id"))).add(String.valueOf(entry.getKey()));
                continue;
            }
            list = new ArrayList();
            list.add(String.valueOf(entry.getKey()));
            groupdetailqueryMap.put(((DynamicObject)entry.getValue()).getDynamicObject("material").getString("id"), list);
        }
        HashMap<String, List<String>> materialinventoryinfoQueryMap = new HashMap<String, List<String>>(materialinventoryinfo.size());
        for (Map.Entry<Object, DynamicObject> entry : materialinventoryinfo.entrySet()) {
            if (materialinventoryinfoQueryMap.containsKey(entry.getValue().getDynamicObject("masterid").getString("id"))) {
                ((List)materialinventoryinfoQueryMap.get(entry.getValue().getDynamicObject("masterid").getString("id"))).add(String.valueOf(entry.getKey()));
                continue;
            }
            list = new ArrayList();
            list.add(String.valueOf(entry.getKey()));
            materialinventoryinfoQueryMap.put(entry.getValue().getDynamicObject("masterid").getString("id"), list);
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(materialsalinfo.size());
        for (Map.Entry<Object, DynamicObject> entry : materialsalinfo.entrySet()) {
            if (hashMap.containsKey(entry.getValue().getDynamicObject("masterid").getString("id"))) {
                ((List)hashMap.get(entry.getValue().getDynamicObject("masterid").getString("id"))).add(String.valueOf(entry.getKey()));
                continue;
            }
            list = new ArrayList();
            list.add(String.valueOf(entry.getKey()));
            hashMap.put(entry.getValue().getDynamicObject("masterid").getString("id"), list);
        }
        HashMap<String, List<String>> hashMap2 = new HashMap<String, List<String>>(materialpurchaseinfo.size());
        for (Map.Entry<Object, DynamicObject> entry : materialpurchaseinfo.entrySet()) {
            if (hashMap2.containsKey(entry.getValue().getDynamicObject("masterid").getString("id"))) {
                ((List)hashMap2.get(entry.getValue().getDynamicObject("masterid").getString("id"))).add(String.valueOf(entry.getKey()));
                continue;
            }
            list = new ArrayList();
            list.add(String.valueOf(entry.getKey()));
            hashMap2.put(entry.getValue().getDynamicObject("masterid").getString("id"), list);
        }
        HashMap<String, List<String>> hashMap3 = new HashMap<String, List<String>>(materialmftinfo.size());
        for (Map.Entry<Object, DynamicObject> entry : materialmftinfo.entrySet()) {
            if (hashMap3.containsKey(entry.getValue().getDynamicObject("masterid").getString("id"))) {
                ((List)hashMap3.get(entry.getValue().getDynamicObject("masterid").getString("id"))).add(String.valueOf(entry.getKey()));
                continue;
            }
            list = new ArrayList();
            list.add(String.valueOf(entry.getKey()));
            hashMap3.put(entry.getValue().getDynamicObject("masterid").getString("id"), list);
        }
        HashMap<String, List<String>> hashMap4 = new HashMap<String, List<String>>(inspectcfgInfo.size());
        for (Map.Entry<Object, DynamicObject> entry : inspectcfgInfo.entrySet()) {
            if (hashMap4.containsKey(entry.getValue().getDynamicObject("masterid").getString("id"))) {
                ((List)hashMap4.get(entry.getValue().getDynamicObject("masterid").getString("id"))).add(String.valueOf(entry.getKey()));
                continue;
            }
            list = new ArrayList();
            list.add(String.valueOf(entry.getKey()));
            hashMap4.put(entry.getValue().getDynamicObject("masterid").getString("id"), list);
        }
        HashMap<String, List<String>> hashMap5 = new HashMap<String, List<String>>(materialcalinfo.size());
        for (Map.Entry<Object, DynamicObject> entry : materialcalinfo.entrySet()) {
            if (hashMap5.containsKey(entry.getValue().getDynamicObject("masterid").getString("id"))) {
                ((List)hashMap5.get(entry.getValue().getDynamicObject("masterid").getString("id"))).add(String.valueOf(entry.getKey()));
                continue;
            }
            list = new ArrayList();
            list.add(String.valueOf(entry.getKey()));
            hashMap5.put(entry.getValue().getDynamicObject("masterid").getString("id"), list);
        }
        HashMap<String, List<String>> hashMap6 = new HashMap<String, List<String>>(materialplaninfo.size());
        for (Map.Entry<Object, DynamicObject> entry : materialplaninfo.entrySet()) {
            if (hashMap6.containsKey(entry.getValue().getDynamicObject("masterid").getString("id"))) {
                ((List)hashMap6.get(entry.getValue().getDynamicObject("masterid").getString("id"))).add(String.valueOf(entry.getKey()));
                continue;
            }
            list = new ArrayList();
            list.add(String.valueOf(entry.getKey()));
            hashMap6.put(entry.getValue().getDynamicObject("masterid").getString("id"), list);
        }
        Object var61_75 = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_propertiesconfig", (QFilter[])new QFilter[]{new QFilter("targetobj", "=", (Object)"bd_material"), new QFilter("enable", "=", (Object)"1")});
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        HashSet<String> standardproperties = new HashSet<String>();
        if (dynamicObject != null && dynamicObject.getDynamicObjectCollection("colsmap") != null && dynamicObject.getDynamicObjectCollection("colsmap").size() > 0) {
            for (DynamicObject prop : dynamicObject.getDynamicObjectCollection("colsmap")) {
                if (prop.getString("targetobjcol") != null && propertys != null && propertys.size() > 0 && !propertys.contains(prop.getString("targetobjcol"))) {
                    standardproperties.add(prop.getString("targetobjcol"));
                }
                if (prop.getString("targetobjcol") == null || !prop.getString("targetobjcol").startsWith("st_")) continue;
                map.put(prop.getString("targetobjcol"), false);
            }
        }
        for (int i2 = 0; i2 < materialDatas.size(); ++i2) {
            DynamicObject material;
            tempMaterial = tempMaterials.get(materialDatas.get(i2).getDynamicObject("templatematerial").getPkValue());
            DynamicObject newMaterial = (DynamicObject)cloneUtils.clone(tempMaterial.getDataEntityType(), (Object)tempMaterial);
            newMaterial.set("id", (Object)ids[i2]);
            newMaterial.set("masterid", (Object)ids[i2]);
            String string = CodeRuleServiceHelper.getNumber((String)"bd_material", (DynamicObject)tempMaterial, (String)RequestContext.get().getLoginOrg());
            if (!StringUtils.isEmpty((String)string)) {
                material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)string), new QFilter("createorg", "=", newMaterial.getDynamicObject("createorg").getPkValue())});
                if (material != null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TemplateMaterialHelper_0", (String)"bd-master-business", (Object[])new Object[0]), string));
                }
                newMaterial.set("number", (Object)string);
                numberMap.put(materialDatas.get(i2).getString("id"), string);
            } else {
                number = materialDatas.get(i2).getString("applynumber");
                material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("createorg", "=", newMaterial.getDynamicObject("createorg").getPkValue())});
                if (numbers.contains(number) || material != null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TemplateMaterialHelper_0", (String)"bd-master-business", (Object[])new Object[0]), number));
                }
                numbers.add(number);
                newMaterial.set("number", (Object)number);
                numberMap.put(materialDatas.get(i2).getString("id"), materialDatas.get(i2).getString("applynumber"));
            }
            if (propertys != null && propertys.size() > 0) {
                for (String property : propertys) {
                    if (!map.containsKey(property)) continue;
                    if (((Boolean)map.get(property)).booleanValue()) {
                        newMaterial.set(property, tempMaterial.get(property));
                        continue;
                    }
                    newMaterial.set(property, materialDatas.get(i2).get(property));
                }
            }
            newMaterial.set("name", materialDatas.get(i2).get("materialname"));
            if (!StringUtils.isEmpty((String)materialDatas.get(i2).getLocaleString("modelnum").getLocaleValue())) {
                newMaterial.set("modelnum", materialDatas.get(i2).get("modelnum"));
            }
            newMaterial.set("oldnumber", null);
            newMaterial.set("approvedate", (Object)new Date());
            this.setPublicAttribute(proposer, newMaterial);
            if (standardproperties.size() > 0) {
                for (String prop : standardproperties) {
                    newMaterial.set(prop, null);
                }
            }
            materialRs.add(newMaterial);
            materialValueVo = new MaterialValueVo(tempMaterial.getString("id"), ids[i2]);
            materialPksList.add(materialValueVo);
            materialDynsMap.put(tempMaterial.getString("id"), newMaterial);
            materialPks.add(tempMaterial.getString("id"));
            this.newMultimeasureUnitData(tempMultimeasureunit, tempMaterial, multimeasureunitRes, cloneUtils, multunitqueryMap, newMaterial);
            this.newMaterialgroupDetail(tempMaterialgroupdetail, tempMaterial, materialgroupdetailRes, cloneUtils, groupdetailqueryMap, newMaterial);
            materialinventoryinfoOrgSet = this.newMaterialinventoryinfoData(materialinventoryinfo, materialDynsMap, tempMaterial, materialinventoryinfoRes, cloneUtils, materialinventoryinfoQueryMap, proposer, materialinventoryinfoUseOrgIds);
            materialsalinfoOrgSet = this.newMaterialsalinfoData(materialsalinfo, materialDynsMap, tempMaterial, materialsalinfoRes, cloneUtils, hashMap, proposer, materialsalinfoUseOrgIds);
            materialpurchaseinfoOrgSet = this.newMaterialpurchaseinfoData(materialpurchaseinfo, materialDynsMap, tempMaterial, materialpurchaseinfoRes, cloneUtils, hashMap2, proposer, materialpurchaseinfoUseOrgIds);
            materialmftinfoOrgSet = this.newMaterialmftinfoData(materialmftinfo, materialDynsMap, tempMaterial, materialmftinfoRes, cloneUtils, hashMap3, proposer, materialmftinfoUseOrgIds);
            inspectcfgInfoOrgSet = this.newInspectcfgInfoData(inspectcfgInfo, materialDynsMap, tempMaterial, inspectcfgInfoRes, cloneUtils, hashMap4, proposer, inspectcfgInfoUseOrgIds);
            materialcalinfoOrgSet = this.newMaterialcalInfoData(materialcalinfo, materialDynsMap, tempMaterial, materialcalinfoRes, cloneUtils, hashMap5, proposer, materialcalinfoUseOrgIds);
            materialplaninfoOrgSet = this.newMaterialplaninfoData(materialplaninfo, materialDynsMap, tempMaterial, materialplaninfoRes, cloneUtils, hashMap6, proposer, materialplaninfoUseOrgIds);
        }
        try {
            materialOrgSet = this.generateMaterialAllocationData(materialPks, materialPksList);
            dataIds = new StringBuffer();
            for (i = 0; i < materialRs.size(); ++i) {
                if (i == materialRs.size() - 1) {
                    dataIds.append(((DynamicObject)materialRs.get(i)).getLong("id"));
                    continue;
                }
                dataIds.append(((DynamicObject)materialRs.get(i)).getLong("id")).append(",");
            }
            if (materialRs.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])materialRs.toArray(new DynamicObject[materialRs.size()]));
                BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])materialRs.toArray(new DynamicObject[materialRs.size()]));
                if (materialOrgSet != null && materialOrgSet.size() > 0) {
                    this.executeUtableData(materialOrgSet, dataIds, "T_BD_MATERIALUSEREG", "T_BD_MATERIAL_U", "T_BD_MATERIALEXC", DBRoute.basedata);
                }
            }
        }
        catch (Exception e) {
            log.error("materialallocationdata fail:" + new Throwable(e));
            return;
        }
        if (multimeasureunitRes.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])multimeasureunitRes.toArray(new DynamicObject[multimeasureunitRes.size()]));
        }
        if (materialgroupdetailRes.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])materialgroupdetailRes.toArray(new DynamicObject[materialgroupdetailRes.size()]));
        }
        if (materialinventoryinfoRes.size() > 0) {
            dataIds = new StringBuffer();
            for (i = 0; i < materialinventoryinfoRes.size(); ++i) {
                if (i == materialinventoryinfoRes.size() - 1) {
                    dataIds.append(((DynamicObject)materialinventoryinfoRes.get(i)).getLong("id"));
                    continue;
                }
                dataIds.append(((DynamicObject)materialinventoryinfoRes.get(i)).getLong("id")).append(",");
            }
            SaveServiceHelper.save((DynamicObject[])materialinventoryinfoRes.toArray(new DynamicObject[materialinventoryinfoRes.size()]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])materialinventoryinfoRes.toArray(new DynamicObject[materialinventoryinfoRes.size()]));
            if (materialinventoryinfoOrgSet != null && materialinventoryinfoOrgSet.size() > 0) {
                this.executeUtableData(materialinventoryinfoOrgSet, dataIds, "T_BD_MATERIALINVINFOUSEREG", "T_BD_MATERIALINVINFO_U", "T_BD_MATERIALINVINFOEXC", DBRoute.basedata);
            }
        }
        if (materialsalinfoRes.size() > 0) {
            dataIds = new StringBuffer();
            for (i = 0; i < materialsalinfoRes.size(); ++i) {
                if (i == materialsalinfoRes.size() - 1) {
                    dataIds.append(((DynamicObject)materialsalinfoRes.get(i)).getLong("id"));
                    continue;
                }
                dataIds.append(((DynamicObject)materialsalinfoRes.get(i)).getLong("id")).append(",");
            }
            SaveServiceHelper.save((DynamicObject[])materialsalinfoRes.toArray(new DynamicObject[materialsalinfoRes.size()]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])materialsalinfoRes.toArray(new DynamicObject[materialsalinfoRes.size()]));
            if (materialsalinfoOrgSet != null && materialsalinfoOrgSet.size() > 0) {
                this.executeUtableData(materialsalinfoOrgSet, dataIds, "T_BD_MATERIALSALINFOUSEREG", "T_BD_MATERIALSALINFO_U", "T_BD_MATERIALSALINFOEXC", DBRoute.basedata);
            }
        }
        if (materialpurchaseinfoRes.size() > 0) {
            dataIds = new StringBuffer();
            for (i = 0; i < materialpurchaseinfoRes.size(); ++i) {
                if (i == materialpurchaseinfoRes.size() - 1) {
                    dataIds.append(((DynamicObject)materialpurchaseinfoRes.get(i)).getLong("id"));
                    continue;
                }
                dataIds.append(((DynamicObject)materialpurchaseinfoRes.get(i)).getLong("id")).append(",");
            }
            SaveServiceHelper.save((DynamicObject[])materialpurchaseinfoRes.toArray(new DynamicObject[materialpurchaseinfoRes.size()]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])materialpurchaseinfoRes.toArray(new DynamicObject[materialpurchaseinfoRes.size()]));
            if (materialpurchaseinfoOrgSet != null && materialpurchaseinfoOrgSet.size() > 0) {
                this.executeUtableData(materialpurchaseinfoOrgSet, dataIds, "T_BD_MATERIALPURINFOUSEREG", "T_BD_MATERIALPURINFO_U", "T_BD_MATERIALPURINFOEXC", DBRoute.basedata);
            }
        }
        if (materialmftinfoRes.size() > 0) {
            dataIds = new StringBuffer();
            for (i = 0; i < materialmftinfoRes.size(); ++i) {
                if (i == materialmftinfoRes.size() - 1) {
                    dataIds.append(((DynamicObject)materialmftinfoRes.get(i)).getLong("id"));
                    continue;
                }
                dataIds.append(((DynamicObject)materialmftinfoRes.get(i)).getLong("id")).append(",");
            }
            SaveServiceHelper.save((DynamicObject[])materialmftinfoRes.toArray(new DynamicObject[materialmftinfoRes.size()]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])materialmftinfoRes.toArray(new DynamicObject[materialmftinfoRes.size()]));
            if (materialmftinfoOrgSet != null && materialmftinfoOrgSet.size() > 0) {
                this.executeUtableData(materialmftinfoOrgSet, dataIds, "T_BD_MATERIALMFTINFOUSEREG", "T_BD_MATERIALMFTINFO_U", "T_BD_MATERIALMFTINFOEXC", DBRoute.basedata);
            }
        }
        if (inspectcfgInfoRes.size() > 0) {
            dataIds = new StringBuffer();
            for (i = 0; i < inspectcfgInfoRes.size(); ++i) {
                if (i == inspectcfgInfoRes.size() - 1) {
                    dataIds.append(((DynamicObject)inspectcfgInfoRes.get(i)).getLong("id"));
                    continue;
                }
                dataIds.append(((DynamicObject)inspectcfgInfoRes.get(i)).getLong("id")).append(",");
            }
            SaveServiceHelper.save((DynamicObject[])inspectcfgInfoRes.toArray(new DynamicObject[inspectcfgInfoRes.size()]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])inspectcfgInfoRes.toArray(new DynamicObject[inspectcfgInfoRes.size()]));
            if (inspectcfgInfoOrgSet != null && inspectcfgInfoOrgSet.size() > 0) {
                this.executeUtableData(inspectcfgInfoOrgSet, dataIds, "T_BD_INSPECT_CFGUSEREG", "T_BD_INSPECT_CFG_U", "T_BD_INSPECT_CFGEXC", DBRoute.basedata);
            }
        }
        if (materialcalinfoRes.size() > 0) {
            dataIds = new StringBuffer();
            for (i = 0; i < materialcalinfoRes.size(); ++i) {
                if (i == materialcalinfoRes.size() - 1) {
                    dataIds.append(((DynamicObject)materialcalinfoRes.get(i)).getLong("id"));
                    continue;
                }
                dataIds.append(((DynamicObject)materialcalinfoRes.get(i)).getLong("id")).append(",");
            }
            SaveServiceHelper.save((DynamicObject[])materialcalinfoRes.toArray(new DynamicObject[materialcalinfoRes.size()]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])materialcalinfoRes.toArray(new DynamicObject[materialcalinfoRes.size()]));
            if (materialcalinfoOrgSet != null && materialcalinfoOrgSet.size() > 0) {
                this.executeUtableData(materialcalinfoOrgSet, dataIds, "T_BD_MATERIALCALINFOUSEREG", "T_BD_MATERIALCALINFO_U", "T_BD_MATERIALCALINFOEXC", DBRoute.basedata);
            }
        }
        if (materialplaninfoRes.size() > 0) {
            dataIds = new StringBuffer();
            for (i = 0; i < materialplaninfoRes.size(); ++i) {
                if (i == materialplaninfoRes.size() - 1) {
                    dataIds.append(((DynamicObject)materialplaninfoRes.get(i)).getLong("id"));
                    continue;
                }
                dataIds.append(((DynamicObject)materialplaninfoRes.get(i)).getLong("id")).append(",");
            }
            SaveServiceHelper.save((DynamicObject[])materialplaninfoRes.toArray(new DynamicObject[materialplaninfoRes.size()]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])materialplaninfoRes.toArray(new DynamicObject[materialplaninfoRes.size()]));
            if (materialplaninfoOrgSet != null && materialplaninfoOrgSet.size() > 0) {
                this.executeUtableData(materialplaninfoOrgSet, dataIds, "T_MPDM_MATERIALPLANUSEREG", "T_MPDM_MATERIALPLAN_U", "T_MPDM_MATERIALPLANEXC", DBRoute.of((String)"scm"));
            }
        }
    }

    private void executeUtableData(Set<Long> materialinfoOrgSet, StringBuffer dataIds, String table_usereg, String table_u, String table_exc, DBRoute dbRoute) {
        ArrayList<SqlParameter[]> sqlparams = new ArrayList<SqlParameter[]>(materialinfoOrgSet.size());
        SqlParameter[] sqlParams = null;
        for (Long useOrgId : materialinfoOrgSet) {
            sqlParams = new SqlParameter[]{new SqlParameter("FUSEORGID", -5, (Object)useOrgId), new SqlParameter("FUSEORGID", -5, (Object)useOrgId), new SqlParameter("FUSEORGID", -5, (Object)useOrgId)};
            sqlparams.add(sqlParams);
        }
        if (sqlparams != null && sqlparams.size() > 0) {
            String sql = TemplateMaterialUtil.getUseRangeTable(dataIds.toString(), table_usereg, table_u, table_exc);
            DB.executeBatch((DBRoute)dbRoute, (String)sql, sqlparams);
        }
    }

    private void setPublicAttribute(String proposer, DynamicObject object) {
        object.set("createtime", (Object)new Date());
        object.set("modifytime", (Object)new Date());
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)proposer);
        object.set("creator", (Object)user);
        object.set("modifier", (Object)user);
    }

    private Set<Long> newMaterialplaninfoData(Map<Object, DynamicObject> materialplaninfo, Map<String, DynamicObject> materialDynsMap, DynamicObject tempMaterial, List<DynamicObject> materialplaninfoRes, CloneUtils cloneUtils, Map<String, List<String>> materialplaninfoQueryMap, String proposer, Set<Long> materialplaninfoUseOrgIds) {
        DynamicObject materialplaninfoObjDyn = null;
        List<String> materialplaninfoDynList = materialplaninfoQueryMap.get(tempMaterial.getString("id"));
        if (materialplaninfoDynList != null && materialplaninfoDynList.size() > 0) {
            HashMap<String, String> materialplaninfoMap = new HashMap<String, String>(materialplaninfoDynList.size());
            HashSet<String> materialplaninfoPksPks = new HashSet<String>(materialplaninfoDynList.size());
            long[] materialplaninfoPks = DB.genLongIds((String)"T_MPDM_MATERIALPLAN", (int)materialplaninfoDynList.size());
            int materialplaninfoCount = 0;
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)"mpdm_materialplan");
            for (String materialplan : materialplaninfoDynList) {
                DynamicObject materialplaninfoObj = materialplaninfo.get(Long.valueOf(materialplan));
                materialplaninfoObjDyn = (DynamicObject)cloneUtils.clone(materialplaninfoObj.getDataEntityType(), (Object)materialplaninfoObj);
                materialplaninfoObjDyn.set("masterid", (Object)materialDynsMap.get(materialplaninfoObj.getDynamicObject("masterid").getString("id")));
                materialplaninfoObjDyn.set("id", (Object)materialplaninfoPks[materialplaninfoCount]);
                if (!"masterid".equals(masterIdPropName)) {
                    materialplaninfoObjDyn.set(masterIdPropName, (Object)materialplaninfoPks[materialplaninfoCount]);
                }
                this.setPublicAttribute(proposer, materialplaninfoObjDyn);
                materialplaninfoRes.add(materialplaninfoObjDyn);
                materialplaninfoPksPks.add(materialplaninfoObj.getDynamicObject("masterid").getString("id"));
                materialplaninfoMap.put(materialplaninfoObj.getString("id") + materialplaninfoObj.getDynamicObject("createorg").getString("id"), String.valueOf(materialplaninfoPks[materialplaninfoCount]));
                ++materialplaninfoCount;
            }
            if (materialplaninfoPksPks.size() > 0 && materialplaninfoMap.size() > 0) {
                try {
                    materialplaninfoUseOrgIds = this.generateMaterialplaninfoAllocationData(materialplaninfoPksPks, materialplaninfoMap);
                }
                catch (Exception e) {
                    log.error("generateInspectcfgAllocationData fail:" + new Throwable(e));
                }
            }
        }
        return materialplaninfoUseOrgIds;
    }

    private Set<Long> newMaterialcalInfoData(Map<Object, DynamicObject> materialcalinfo, Map<String, DynamicObject> materialDynsMap, DynamicObject tempMaterial, List<DynamicObject> materialcalinfoRes, CloneUtils cloneUtils, Map<String, List<String>> materialcalinfoQueryMap, String proposer, Set<Long> materialcalinfoUseOrgIds) {
        DynamicObject materialcalinfoObjDyn = null;
        List<String> materialcalinfoDynList = materialcalinfoQueryMap.get(tempMaterial.getString("id"));
        if (materialcalinfoDynList != null && materialcalinfoDynList.size() > 0) {
            HashMap<String, String> materialcalinfoMap = new HashMap<String, String>(materialcalinfoDynList.size());
            HashSet<String> materialcalinfoPksPks = new HashSet<String>(materialcalinfoDynList.size());
            long[] materialcalinfoPks = DB.genLongIds((String)"T_BD_MATERIALCALINFO", (int)materialcalinfoDynList.size());
            int materialcalinfoCount = 0;
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)"bd_materialcalinfo");
            for (String materialcal : materialcalinfoDynList) {
                DynamicObject materialcalinfoObj = materialcalinfo.get(Long.valueOf(materialcal));
                materialcalinfoObjDyn = (DynamicObject)cloneUtils.clone(materialcalinfoObj.getDataEntityType(), (Object)materialcalinfoObj);
                materialcalinfoObjDyn.set("masterid", (Object)materialDynsMap.get(materialcalinfoObj.getDynamicObject("masterid").getString("id")));
                materialcalinfoObjDyn.set("id", (Object)materialcalinfoPks[materialcalinfoCount]);
                if (!"masterid".equals(masterIdPropName)) {
                    materialcalinfoObjDyn.set(masterIdPropName, (Object)materialcalinfoPks[materialcalinfoCount]);
                }
                this.setPublicAttribute(proposer, materialcalinfoObjDyn);
                materialcalinfoObjDyn.set("audittime", (Object)new Date());
                materialcalinfoRes.add(materialcalinfoObjDyn);
                materialcalinfoPksPks.add(materialcalinfoObj.getDynamicObject("masterid").getString("id"));
                materialcalinfoMap.put(materialcalinfoObj.getString("id") + materialcalinfoObj.getDynamicObject("createorg").getString("id"), String.valueOf(materialcalinfoPks[materialcalinfoCount]));
                ++materialcalinfoCount;
            }
            if (materialcalinfoPksPks.size() > 0 && materialcalinfoMap.size() > 0) {
                try {
                    materialcalinfoUseOrgIds = this.generateMaterialcalinfoAllocationData(materialcalinfoPksPks, materialcalinfoMap);
                }
                catch (Exception e) {
                    log.error("generateMaterialcalinfoAllocationData fail:" + new Throwable(e));
                }
            }
        }
        return materialcalinfoUseOrgIds;
    }

    private Set<Long> newInspectcfgInfoData(Map<Object, DynamicObject> inspectcfgInfo, Map<String, DynamicObject> materialDynsMap, DynamicObject tempMaterial, List<DynamicObject> inspectcfgInfoRes, CloneUtils cloneUtils, Map<String, List<String>> inspectcfgInfoQueryMap, String proposer, Set<Long> inspectcfgInfoUseOrgIds) {
        DynamicObject inspectcfgObjDyn = null;
        List<String> inspectcfgInfoDynList = inspectcfgInfoQueryMap.get(tempMaterial.getString("id"));
        if (inspectcfgInfoDynList != null && inspectcfgInfoDynList.size() > 0) {
            HashMap<String, String> inspectcfgInfoMap = new HashMap<String, String>(inspectcfgInfoDynList.size());
            HashSet<String> inspectcfgInfoPksPks = new HashSet<String>(inspectcfgInfoDynList.size());
            long[] inspectcfgInfoPks = DB.genLongIds((String)"T_BD_INSPECT_CFG", (int)inspectcfgInfoDynList.size());
            int inspectcfgInfoCount = 0;
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)"bd_inspect_cfg");
            for (String inspectcfg : inspectcfgInfoDynList) {
                DynamicObject inspectcfgObj = inspectcfgInfo.get(Long.valueOf(inspectcfg));
                inspectcfgObjDyn = (DynamicObject)cloneUtils.clone(inspectcfgObj.getDataEntityType(), (Object)inspectcfgObj);
                inspectcfgObjDyn.set("masterid", (Object)materialDynsMap.get(inspectcfgObj.getDynamicObject("masterid").getString("id")));
                inspectcfgObjDyn.set("id", (Object)inspectcfgInfoPks[inspectcfgInfoCount]);
                if (!"masterid".equals(masterIdPropName)) {
                    inspectcfgObjDyn.set(masterIdPropName, (Object)inspectcfgInfoPks[inspectcfgInfoCount]);
                }
                this.setPublicAttribute(proposer, inspectcfgObjDyn);
                inspectcfgObjDyn.set("auditdate", (Object)new Date());
                inspectcfgInfoRes.add(inspectcfgObjDyn);
                inspectcfgInfoPksPks.add(inspectcfgObj.getDynamicObject("masterid").getString("id"));
                inspectcfgInfoMap.put(inspectcfgObj.getString("id") + inspectcfgObj.getDynamicObject("createorg").getString("id"), String.valueOf(inspectcfgInfoPks[inspectcfgInfoCount]));
                ++inspectcfgInfoCount;
            }
            if (inspectcfgInfoPksPks.size() > 0 && inspectcfgInfoMap.size() > 0) {
                try {
                    inspectcfgInfoUseOrgIds = this.generateInspectcfgAllocationData(inspectcfgInfoPksPks, inspectcfgInfoMap);
                }
                catch (Exception e) {
                    log.error("generateInspectcfgAllocationData fail:" + new Throwable(e));
                }
            }
        }
        return inspectcfgInfoUseOrgIds;
    }

    private Set<Long> newMaterialmftinfoData(Map<Object, DynamicObject> materialmftinfo, Map<String, DynamicObject> materialDynsMap, DynamicObject tempMaterial, List<DynamicObject> materialmftinfoRes, CloneUtils cloneUtils, Map<String, List<String>> materialmftinfoQueryMap, String proposer, Set<Long> materialmftinfoUseOrgIds) {
        DynamicObject materialmftinfoObjDyn = null;
        List<String> materialmftinfoDynList = materialmftinfoQueryMap.get(tempMaterial.getString("id"));
        if (materialmftinfoDynList != null && materialmftinfoDynList.size() > 0) {
            HashMap<String, String> materialmftinfoMap = new HashMap<String, String>(materialmftinfoDynList.size());
            HashSet<String> materialmftinfoPksPks = new HashSet<String>(materialmftinfoDynList.size());
            long[] materialmftinfoPks = DB.genLongIds((String)"T_BD_MATERIALMFTINFO", (int)materialmftinfoDynList.size());
            int materialmftinfoCount = 0;
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)"bd_materialmftinfo");
            for (String inspectcfg : materialmftinfoDynList) {
                DynamicObject materialmftinfoObj = materialmftinfo.get(Long.valueOf(inspectcfg));
                materialmftinfoObjDyn = (DynamicObject)cloneUtils.clone(materialmftinfoObj.getDataEntityType(), (Object)materialmftinfoObj);
                materialmftinfoObjDyn.set("masterid", (Object)materialDynsMap.get(materialmftinfoObj.getDynamicObject("masterid").getString("id")));
                materialmftinfoObjDyn.set("id", (Object)materialmftinfoPks[materialmftinfoCount]);
                if (!"masterid".equals(masterIdPropName)) {
                    materialmftinfoObjDyn.set(masterIdPropName, (Object)materialmftinfoPks[materialmftinfoCount]);
                }
                this.setPublicAttribute(proposer, materialmftinfoObjDyn);
                materialmftinfoObjDyn.set("audittime", (Object)new Date());
                materialmftinfoRes.add(materialmftinfoObjDyn);
                materialmftinfoPksPks.add(materialmftinfoObj.getDynamicObject("masterid").getString("id"));
                materialmftinfoMap.put(materialmftinfoObj.getString("id") + materialmftinfoObj.getDynamicObject("createorg").getString("id"), String.valueOf(materialmftinfoPks[materialmftinfoCount]));
                ++materialmftinfoCount;
            }
            if (materialmftinfoPksPks.size() > 0 && materialmftinfoMap.size() > 0) {
                try {
                    materialmftinfoUseOrgIds = this.generateMaterialmftinfoAllocationData(materialmftinfoPksPks, materialmftinfoMap);
                }
                catch (Exception e) {
                    log.error("generateMaterialmftinfoAllocationData fail:" + new Throwable(e));
                }
            }
        }
        return materialmftinfoUseOrgIds;
    }

    private Set<Long> newMaterialpurchaseinfoData(Map<Object, DynamicObject> materialpurchaseinfo, Map<String, DynamicObject> materialDynsMap, DynamicObject tempMaterial, List<DynamicObject> materialpurchaseinfoRes, CloneUtils cloneUtils, Map<String, List<String>> materialpurchaseinfoQueryMap, String proposer, Set<Long> materialpurchaseinfoUseOrgIds) {
        DynamicObject materialpurchaseinfoDyn = null;
        List<String> materialpurchaseinfoDynList = materialpurchaseinfoQueryMap.get(tempMaterial.getString("id"));
        if (materialpurchaseinfoDynList != null && materialpurchaseinfoDynList.size() > 0) {
            HashMap<String, String> materialpurchaseMap = new HashMap<String, String>(materialpurchaseinfoDynList.size());
            HashSet<String> materialpurchaseinfoPks = new HashSet<String>(materialpurchaseinfoDynList.size());
            long[] materialpurchasePks = DB.genLongIds((String)"T_BD_MATERIALPURINFO", (int)materialpurchaseinfoDynList.size());
            int materialpurchaseCount = 0;
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)"bd_materialpurchaseinfo");
            for (String materialpurchase : materialpurchaseinfoDynList) {
                DynamicObject purchaseObj = materialpurchaseinfo.get(Long.valueOf(materialpurchase));
                materialpurchaseinfoDyn = (DynamicObject)cloneUtils.clone(purchaseObj.getDataEntityType(), (Object)purchaseObj);
                materialpurchaseinfoDyn.set("masterid", (Object)materialDynsMap.get(purchaseObj.getDynamicObject("masterid").getString("id")));
                materialpurchaseinfoDyn.set("id", (Object)materialpurchasePks[materialpurchaseCount]);
                if (!"masterid".equals(masterIdPropName)) {
                    materialpurchaseinfoDyn.set(masterIdPropName, (Object)materialpurchasePks[materialpurchaseCount]);
                }
                this.setPublicAttribute(proposer, materialpurchaseinfoDyn);
                materialpurchaseinfoDyn.set("audittime", (Object)new Date());
                materialpurchaseinfoRes.add(materialpurchaseinfoDyn);
                materialpurchaseinfoPks.add(purchaseObj.getDynamicObject("masterid").getString("id"));
                materialpurchaseMap.put(purchaseObj.getString("id") + purchaseObj.getDynamicObject("createorg").getString("id"), String.valueOf(materialpurchasePks[materialpurchaseCount]));
                ++materialpurchaseCount;
            }
            if (materialpurchaseinfoPks.size() > 0 && materialpurchaseMap.size() > 0) {
                try {
                    materialpurchaseinfoUseOrgIds = this.generateMaterialpurchaseAllocationData(materialpurchaseinfoPks, materialpurchaseMap);
                }
                catch (Exception e) {
                    log.error("materialpurchaseinfoallocationdata fail:" + new Throwable(e));
                }
            }
        }
        return materialpurchaseinfoUseOrgIds;
    }

    private Set<Long> newMaterialsalinfoData(Map<Object, DynamicObject> materialsalinfo, Map<String, DynamicObject> materialDynsMap, DynamicObject tempMaterial, List<DynamicObject> materialsalinfoRes, CloneUtils cloneUtils, Map<String, List<String>> materialsalinfoQueryMap, String proposer, Set<Long> materialsalinfoUseOrgIds) {
        DynamicObject materialsalinfoDyn = null;
        List<String> materialsalinfoDynList = materialsalinfoQueryMap.get(tempMaterial.getString("id"));
        if (materialsalinfoDynList != null && materialsalinfoDynList.size() > 0) {
            HashMap<String, String> materialsalMap = new HashMap<String, String>(materialsalinfoDynList.size());
            HashSet<String> materialsalinfoPks = new HashSet<String>(materialsalinfoDynList.size());
            int materialsalCount = 0;
            long[] materialsalPks = DB.genLongIds((String)"T_BD_MATERIALSALINFO", (int)materialsalinfoDynList.size());
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)"bd_materialsalinfo");
            for (String saleInfo : materialsalinfoDynList) {
                DynamicObject saleInfoObj = materialsalinfo.get(Long.valueOf(saleInfo));
                materialsalinfoDyn = (DynamicObject)cloneUtils.clone(saleInfoObj.getDataEntityType(), (Object)saleInfoObj);
                materialsalinfoDyn.set("masterid", (Object)materialDynsMap.get(saleInfoObj.getDynamicObject("masterid").getString("id")));
                materialsalinfoDyn.set("id", (Object)materialsalPks[materialsalCount]);
                if (!"masterid".equals(masterIdPropName)) {
                    materialsalinfoDyn.set(masterIdPropName, (Object)materialsalPks[materialsalCount]);
                }
                this.setPublicAttribute(proposer, materialsalinfoDyn);
                materialsalinfoDyn.set("audittime", (Object)new Date());
                materialsalinfoRes.add(materialsalinfoDyn);
                materialsalinfoPks.add(saleInfoObj.getDynamicObject("masterid").getString("id"));
                materialsalMap.put(saleInfoObj.getString("id") + saleInfoObj.getDynamicObject("createorg").getString("id"), String.valueOf(materialsalPks[materialsalCount]));
                ++materialsalCount;
            }
            if (materialsalinfoPks.size() > 0 && materialsalMap.size() > 0) {
                try {
                    materialsalinfoUseOrgIds = this.generateMaterialsalAllocationData(materialsalinfoPks, materialsalMap);
                }
                catch (Exception e) {
                    log.error("materialsalinfoallocationdata fail:" + new Throwable(e));
                }
            }
        }
        return materialsalinfoUseOrgIds;
    }

    private Set<Long> newMaterialinventoryinfoData(Map<Object, DynamicObject> materialinventoryinfo, Map<String, DynamicObject> materialDynsMap, DynamicObject tempMaterial, List<DynamicObject> materialinventoryinfoRes, CloneUtils cloneUtils, Map<String, List<String>> materialinventoryinfoQueryMap, String proposer, Set<Long> materialinventoryinfoUseOrgIds) {
        DynamicObject materialinventoryinfoDyn = null;
        List<String> materialinventoryinfoDynList = materialinventoryinfoQueryMap.get(tempMaterial.getString("id"));
        if (materialinventoryinfoDynList != null && materialinventoryinfoDynList.size() > 0) {
            HashMap<String, String> materialinventoryMap = new HashMap<String, String>(materialinventoryinfoDynList.size());
            HashSet<String> materialinventoryinfoPks = new HashSet<String>(materialinventoryinfoDynList.size());
            long[] materialinventoryPks = DB.genLongIds((String)"T_BD_MATERIALINVINFO", (int)materialinventoryinfoDynList.size());
            int materialinventoryCount = 0;
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)"bd_materialinventoryinfo");
            for (String inventory : materialinventoryinfoDynList) {
                DynamicObject inventoryObj = materialinventoryinfo.get(Long.valueOf(inventory));
                materialinventoryinfoDyn = (DynamicObject)cloneUtils.clone(inventoryObj.getDataEntityType(), (Object)inventoryObj);
                materialinventoryinfoDyn.set("masterid", (Object)materialDynsMap.get(inventoryObj.getDynamicObject("masterid").getString("id")));
                materialinventoryinfoDyn.set("id", (Object)materialinventoryPks[materialinventoryCount]);
                if (!"masterid".equals(masterIdPropName)) {
                    materialinventoryinfoDyn.set(masterIdPropName, (Object)materialinventoryPks[materialinventoryCount]);
                }
                this.setPublicAttribute(proposer, materialinventoryinfoDyn);
                materialinventoryinfoDyn.set("audittime", (Object)new Date());
                materialinventoryinfoRes.add(materialinventoryinfoDyn);
                materialinventoryinfoPks.add(inventoryObj.getDynamicObject("masterid").getString("id"));
                materialinventoryMap.put(inventoryObj.getString("id") + inventoryObj.getDynamicObject("createorg").getString("id"), String.valueOf(materialinventoryPks[materialinventoryCount]));
                ++materialinventoryCount;
            }
            if (materialinventoryinfoPks.size() > 0 && materialinventoryMap.size() > 0) {
                try {
                    materialinventoryinfoUseOrgIds = this.generateMatlinventoryAllocationData(materialinventoryinfoPks, materialinventoryMap);
                }
                catch (Exception e) {
                    log.error("matlinventoryallocationdata fail:" + new Throwable(e));
                }
            }
        }
        return materialinventoryinfoUseOrgIds;
    }

    private void newMaterialgroupDetail(Map<Object, DynamicObject> tempMultimeasureunit, DynamicObject tempMaterial, List<DynamicObject> materialgroupdetailRes, CloneUtils cloneUtils, Map<String, List<String>> groupdetailqueryMap, DynamicObject material) {
        DynamicObject materialgroupdetail = null;
        List<String> materialgroupList = groupdetailqueryMap.get(tempMaterial.getString("id"));
        if (materialgroupList != null && materialgroupList.size() > 0) {
            for (String materialgroup : materialgroupList) {
                DynamicObject materialgroupObj = tempMultimeasureunit.get(Long.valueOf(materialgroup));
                materialgroupdetail = (DynamicObject)cloneUtils.clone(materialgroupObj.getDataEntityType(), (Object)materialgroupObj);
                materialgroupdetail.set("material", (Object)material);
                materialgroupdetailRes.add(materialgroupdetail);
            }
        }
    }

    private void newMultimeasureUnitData(Map<Object, DynamicObject> tempMultimeasureunit, DynamicObject tempMaterial, List<DynamicObject> multimeasureunitRes, CloneUtils cloneUtils, Map<String, List<String>> multunitqueryMap, DynamicObject material) {
        DynamicObject multimeasureunit = null;
        List<String> multunitList = multunitqueryMap.get(tempMaterial.getString("id"));
        if (multunitList != null && multunitList.size() > 0) {
            for (String mults : multunitList) {
                DynamicObject multimeasureunitObj = tempMultimeasureunit.get(Long.valueOf(mults));
                multimeasureunit = (DynamicObject)cloneUtils.clone(multimeasureunitObj.getDataEntityType(), (Object)multimeasureunitObj);
                multimeasureunit.set("materialid", (Object)material);
                multimeasureunitRes.add(multimeasureunit);
            }
        }
    }

    private Set<Long> generateMaterialAllocationData(Set<String> materialPks, List<MaterialValueVo> materialPksList) {
        StringBuffer materialSb = new StringBuffer();
        materialSb.append(MATERIAL_SQL);
        HashSet<Long> useOrgIds = null;
        StringBuffer materialUSql = new StringBuffer();
        materialUSql.append(MATERIAL_SQL_U);
        if (materialPks.size() > 0) {
            TXHandle tx;
            useOrgIds = new HashSet<Long>(materialPks.size());
            DataSet regds = DB.queryDataSet((String)"generateAllocationData.createMaterialData.usereg", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialPks, materialSb), null);
            DataSet uds = DB.queryDataSet((String)"generateAllocationData.createMaterialData.u", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialPks, materialUSql), null);
            if (materialPksList.size() > 0 && regds.hasNext()) {
                ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
                for (MaterialValueVo throwable : materialPksList) {
                    List<Object[]> objects2 = TemplateMaterialUtil.getMarterialInsertCondition(throwable, regds.copy(), useOrgIds);
                    insertParams.addAll(objects2);
                }
                if (insertParams != null && insertParams.size() > 0) {
                    tx = TX.requiresNew((String)"generateMaterialAllocationData_reg");
                    Throwable throwable = null;
                    try {
                        DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialAllocationDataSql(), insertParams);
                    }
                    catch (Throwable objects2) {
                        Throwable throwable2 = objects2;
                        throw objects2;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable objects2) {
                                    throwable.addSuppressed(objects2);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
            }
            if (materialPksList.size() > 0 && uds.hasNext()) {
                ArrayList<Object[]> insertUParams = new ArrayList<Object[]>();
                for (MaterialValueVo materialValueVo : materialPksList) {
                    List<Object[]> objects = TemplateMaterialUtil.getMarterialUInsertCondition(materialValueVo, uds.copy());
                    insertUParams.addAll(objects);
                }
                if (insertUParams != null && insertUParams.size() > 0) {
                    tx = TX.requiresNew((String)"generateMaterialAllocationData_u");
                    Throwable throwable = null;
                    try {
                        DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialUAllocationDataSql(), insertUParams);
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
            }
        }
        return useOrgIds;
    }

    private Set<Long> generateMatlinventoryAllocationData(Set<String> materialinventoryinfoPks, Map<String, String> materialinventoryMap) {
        StringBuffer materialinventoryinfoSb = new StringBuffer();
        materialinventoryinfoSb.append(MATLINVENTORYINFO_SQL);
        StringBuffer materialinventoryinfoExcSb = new StringBuffer();
        materialinventoryinfoExcSb.append(MATLINVENTORYINFO_SQL_EXC);
        HashSet<Long> useOrgIds = null;
        if (materialinventoryinfoPks.size() > 0) {
            List<Object[]> insertexcParams;
            useOrgIds = new HashSet<Long>(materialinventoryinfoPks.size());
            DataSet ds = DB.queryDataSet((String)"generateAllocationData.generateMatlinventoryAllocationData.usereg", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialinventoryinfoPks, materialinventoryinfoSb), null);
            DataSet excds = DB.queryDataSet((String)"generateAllocationData.generateMatlinventoryAllocationData.exc", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialinventoryinfoPks, materialinventoryinfoExcSb), null);
            List<Object[]> insertUseregParams = TemplateMaterialUtil.getInsertCondition(materialinventoryMap, ds.copy(), useOrgIds);
            if (insertUseregParams != null && insertUseregParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMatlinventoryAllocationDatas.usereg");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialinvinfoAllocationDataSql(), insertUseregParams);
                }
            }
            if ((insertexcParams = TemplateMaterialUtil.getInsertExcCondition(materialinventoryMap, excds.copy())) != null && insertexcParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMatlinventoryAllocationDatas.exc");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialinvinfoExcAllocationDataSql(), insertexcParams);
                }
            }
        }
        return useOrgIds;
    }

    private Set<Long> generateMaterialsalAllocationData(Set<String> materialsalinfoPks, Map<String, String> materialsalMap) {
        StringBuffer materialsalinfoSb = new StringBuffer();
        materialsalinfoSb.append(MATERIALSALINFO_SQL);
        StringBuffer materialsalinfoExcSb = new StringBuffer();
        materialsalinfoExcSb.append(MATERIALSALINFO_SQL_EXC);
        HashSet<Long> useOrgIds = null;
        if (materialsalinfoPks.size() > 0) {
            List<Object[]> insertexcParams;
            useOrgIds = new HashSet<Long>(materialsalinfoPks.size());
            DataSet ds = DB.queryDataSet((String)"generateAllocationData.generateMaterialsalAllocationData.usereg", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialsalinfoPks, materialsalinfoSb), null);
            DataSet excds = DB.queryDataSet((String)"generateAllocationData.generateMaterialsalAllocationData.exc", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialsalinfoPks, materialsalinfoExcSb), null);
            List<Object[]> insertParams = TemplateMaterialUtil.getInsertCondition(materialsalMap, ds.copy(), useOrgIds);
            if (insertParams != null && insertParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialsalAllocationData.usereg");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialsalinfoAllocationDataSql(), insertParams);
                }
            }
            if ((insertexcParams = TemplateMaterialUtil.getInsertExcCondition(materialsalMap, excds.copy())) != null && insertexcParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialsalAllocationData.exc");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialsalinfoExcAllocationDataSql(), insertexcParams);
                }
            }
        }
        return useOrgIds;
    }

    private Set<Long> generateMaterialpurchaseAllocationData(Set<String> materialpurchaseinfoPks, Map<String, String> materialpurchaseMap) {
        StringBuffer materialpurchaseinfoSb = new StringBuffer();
        materialpurchaseinfoSb.append(MATERIALPURINFO_SQL);
        StringBuffer materialpurchaseinfoExcSb = new StringBuffer();
        materialpurchaseinfoExcSb.append(MATERIALPURINFO_SQL_EXC);
        HashSet<Long> useOrgIds = null;
        if (materialpurchaseinfoPks.size() > 0) {
            List<Object[]> insertexcParams;
            useOrgIds = new HashSet<Long>(materialpurchaseinfoPks.size());
            DataSet ds = DB.queryDataSet((String)"generateAllocationData.generateMaterialpurchaseAllocationData.usereg", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialpurchaseinfoPks, materialpurchaseinfoSb), null);
            DataSet excds = DB.queryDataSet((String)"generateAllocationData.generateMaterialsalAllocationData.exc", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialpurchaseinfoPks, materialpurchaseinfoExcSb), null);
            List<Object[]> insertParams = TemplateMaterialUtil.getInsertCondition(materialpurchaseMap, ds.copy(), useOrgIds);
            if (insertParams != null && insertParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialpurchaseAllocationData.usereg");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialpurinfoAllocationDataSql(), insertParams);
                }
            }
            if ((insertexcParams = TemplateMaterialUtil.getInsertExcCondition(materialpurchaseMap, excds.copy())) != null && insertexcParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialpurchaseAllocationData.exc");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialpurinfoExcAllocationDataSql(), insertexcParams);
                }
            }
        }
        return useOrgIds;
    }

    private Set<Long> generateMaterialmftinfoAllocationData(Set<String> materialmftinfoPksPks, Map<String, String> materialmftinfoMap) {
        StringBuffer materialmftinfoSb = new StringBuffer();
        materialmftinfoSb.append(MATERIALMFTINFO_SQL);
        StringBuffer materialmftinfoExcSb = new StringBuffer();
        materialmftinfoExcSb.append(MATERIALMFTINFO_SQL_EXC);
        HashSet<Long> useOrgIds = null;
        if (materialmftinfoPksPks.size() > 0) {
            List<Object[]> insertexcParams;
            useOrgIds = new HashSet<Long>(materialmftinfoPksPks.size());
            DataSet ds = DB.queryDataSet((String)"generateAllocationData.generateMaterialmftinfoAllocationData.usereg", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialmftinfoPksPks, materialmftinfoSb), null);
            DataSet excds = DB.queryDataSet((String)"generateAllocationData.generateMaterialmftinfoAllocationData.exc", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialmftinfoPksPks, materialmftinfoExcSb), null);
            List<Object[]> insertParams = TemplateMaterialUtil.getInsertCondition(materialmftinfoMap, ds.copy(), useOrgIds);
            if (insertParams != null && insertParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialmftinfoAllocationData.usereg");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialmftinfoAllocationDataSql(), insertParams);
                }
            }
            if ((insertexcParams = TemplateMaterialUtil.getInsertExcCondition(materialmftinfoMap, excds.copy())) != null && insertexcParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialmftinfoAllocationData.exc");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialmftinfoExcAllocationDataSql(), insertexcParams);
                }
            }
        }
        return useOrgIds;
    }

    private Set<Long> generateInspectcfgAllocationData(Set<String> inspectcfgInfoPksPks, Map<String, String> inspectcfgInfoMap) {
        StringBuffer InspectcfgSb = new StringBuffer();
        InspectcfgSb.append(INSPECT_CFG_SQL);
        StringBuffer InspectcfgExcSb = new StringBuffer();
        InspectcfgExcSb.append(INSPECT_CFG_SQL_EXC);
        HashSet<Long> useOrgIds = null;
        if (inspectcfgInfoPksPks.size() > 0) {
            List<Object[]> insertexcParams;
            useOrgIds = new HashSet<Long>(inspectcfgInfoPksPks.size());
            DataSet ds = DB.queryDataSet((String)"generateAllocationData.generateInspectcfgAllocationData.usereg", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(inspectcfgInfoPksPks, InspectcfgSb), null);
            DataSet excds = DB.queryDataSet((String)"generateAllocationData.generateInspectcfgAllocationData.exc", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(inspectcfgInfoPksPks, InspectcfgExcSb), null);
            List<Object[]> insertParams = TemplateMaterialUtil.getInsertCondition(inspectcfgInfoMap, ds.copy(), useOrgIds);
            if (insertParams != null && insertParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateInspectcfgAllocationData.usereg");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getInspectcfgAllocationDataSql(), insertParams);
                }
            }
            if ((insertexcParams = TemplateMaterialUtil.getInsertExcCondition(inspectcfgInfoMap, excds.copy())) != null && insertexcParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateInspectcfgAllocationData.exc");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getInspectcfgExcAllocationDataSql(), insertexcParams);
                }
            }
        }
        return useOrgIds;
    }

    private Set<Long> generateMaterialcalinfoAllocationData(Set<String> materialcalinfoPksPks, Map<String, String> materialcalinfoMap) {
        StringBuffer materialcalinfoSb = new StringBuffer();
        materialcalinfoSb.append(MATERIALCALINFO_SQL);
        StringBuffer materialcalinfoExcSb = new StringBuffer();
        materialcalinfoExcSb.append(MATERIALCALINFO_SQL_EXC);
        HashSet<Long> useOrgIds = null;
        if (materialcalinfoPksPks.size() > 0) {
            List<Object[]> insertexcParams;
            useOrgIds = new HashSet<Long>(materialcalinfoPksPks.size());
            DataSet ds = DB.queryDataSet((String)"generateAllocationData.generateMaterialcalinfoAllocationData.usereg", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialcalinfoPksPks, materialcalinfoSb), null);
            DataSet excds = DB.queryDataSet((String)"generateAllocationData.generateMaterialcalinfoAllocationData.exc", (DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.concatenateCondition(materialcalinfoPksPks, materialcalinfoExcSb), null);
            List<Object[]> insertParams = TemplateMaterialUtil.getInsertCondition(materialcalinfoMap, ds.copy(), useOrgIds);
            if (insertParams != null && insertParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialcalinfoAllocationData.usereg");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialcalinfoAllocationDataSql(), insertParams);
                }
            }
            if ((insertexcParams = TemplateMaterialUtil.getInsertExcCondition(materialcalinfoMap, excds.copy())) != null && insertexcParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialcalinfoAllocationData.exc");){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getMaterialcalinfoExcAllocationDataSql(), insertexcParams);
                }
            }
        }
        return useOrgIds;
    }

    private Set<Long> generateMaterialplaninfoAllocationData(Set<String> materialplaninfoPksPks, Map<String, String> materialplaninfoMap) {
        StringBuffer materialplaninfoSb = new StringBuffer();
        materialplaninfoSb.append(MATERIALPLAN_SQL);
        StringBuffer materialplaninfoExcSb = new StringBuffer();
        materialplaninfoExcSb.append(MATERIALPLAN_SQL_EXC);
        HashSet<Long> useOrgIds = null;
        if (materialplaninfoPksPks.size() > 0) {
            List<Object[]> insertexcParams;
            useOrgIds = new HashSet<Long>(materialplaninfoPksPks.size());
            DataSet ds = DB.queryDataSet((String)"generateAllocationData.generateMaterialplaninfoAllocationData.usereg", (DBRoute)DBRoute.of((String)"scm"), (String)TemplateMaterialUtil.concatenateCondition(materialplaninfoPksPks, materialplaninfoSb), null);
            DataSet excds = DB.queryDataSet((String)"generateAllocationData.generateMaterialplaninfoAllocationData.exc", (DBRoute)DBRoute.of((String)"scm"), (String)TemplateMaterialUtil.concatenateCondition(materialplaninfoPksPks, materialplaninfoExcSb), null);
            List<Object[]> insertParams = TemplateMaterialUtil.getInsertCondition(materialplaninfoMap, ds.copy(), useOrgIds);
            if (insertParams != null && insertParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialplaninfoAllocationData.usereg");){
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)TemplateMaterialUtil.getMaterialplaninfoAllocationDataSql(), insertParams);
                }
            }
            if ((insertexcParams = TemplateMaterialUtil.getInsertExcCondition(materialplaninfoMap, excds.copy())) != null && insertexcParams.size() > 0) {
                try (TXHandle tx = TX.requiresNew((String)"generateMaterialplaninfoAllocationData.exc");){
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)TemplateMaterialUtil.getMaterialplaninfoExcAllocationDataSql(), insertexcParams);
                }
            }
        }
        return useOrgIds;
    }
}

