/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.inf;

import java.util.HashMap;
import java.util.Map;
import kd.bd.master.inf.DefaultSelectStrategy;
import kd.bd.master.inf.IColsSelectStrategy;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MetaHelper {
    private IColsSelectStrategy strategy;
    private MainEntityType meta;

    public MetaHelper(IColsSelectStrategy strategy, MainEntityType meta) {
        if (meta == null) {
            throw new KDBizException(this.getMsgMetaHelperError());
        }
        this.meta = meta;
        this.strategy = strategy == null ? new DefaultSelectStrategy() : strategy;
    }

    private String getMsgMetaHelperError() {
        return ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetaHelper_0", (String)"bd-master-business", (Object[])new Object[0]);
    }

    public MetaHelper(IColsSelectStrategy strategy, String metaNo) {
        this(strategy, MetadataServiceHelper.getDataEntityType((String)metaNo));
    }

    public MetaHelper(String metaNo) {
        this(null, metaNo);
    }

    public MetaHelper(MainEntityType meta) {
        this(null, meta);
    }

    private String getRootId() {
        return "0";
    }

    public String buildTree2JSON() {
        return SerializationUtils.toJsonString((Object)this.buildTree());
    }

    public String buildTreeWithEntry2JSON(String entityNumber) {
        return SerializationUtils.toJsonString((Object)this.buildTreeWithEntry(entityNumber));
    }

    public TreeNode buildTreeWithEntry(String entityNumber) {
        TreeNode entryNode;
        TreeNode subEntryNode;
        EntryType grandParent;
        TreeNode entryNode2;
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            parent = pro.getParent();
            if (parent instanceof MainEntityType) {
                this.strategy.buildNodeHead(root, pro, entityNumber);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                entryNode2 = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNodeEntry(entryNode2, pro, entityNumber);
                if (nodeMap.containsKey(entryNode2.getId())) continue;
                nodeMap.put(entryNode2.getId(), entryNode2);
                root.addChild(entryNode2);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            subEntryNode = this.getEntryNode(nodeMap, parent);
            entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNodeEntry(entryNode, subEntryNode, pro, entityNumber);
            if (nodeMap.containsKey(subEntryNode.getId())) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            entryNode.addChild(subEntryNode);
        }
        for (IDataEntityProperty pro : allFields.values()) {
            parent = pro.getParent();
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent) || (entryNode2 = this.getEntryNode(nodeMap, parent)).getChildren() != null && entryNode2.getChildren().size() != 0) continue;
                root.deleteChildNode(entryNode2.getId());
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            subEntryNode = this.getEntryNode(nodeMap, parent);
            entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            if (entryNode.getChildren() == null || entryNode.getChildren().size() == 0) {
                root.deleteChildNode(entryNode.getId());
            }
            if (subEntryNode.getChildren() != null && subEntryNode.getChildren().size() != 0) continue;
            root.deleteChildNode(subEntryNode.getId());
        }
        return root;
    }

    public TreeNode buildTree() {
        Map allFields = this.meta.getAllFields();
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            parent = pro.getParent();
            if (parent instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if ((!(parent instanceof EntryType) || !(parent.getParent() instanceof MainEntityType)) && parent instanceof EntryType && !(parent.getParent() instanceof EntryType)) continue;
        }
        return root;
    }

    private TreeNode getEntryNode(Map<String, TreeNode> nodeMap, IDataEntityType entryPro) {
        String entryName = entryPro.getName();
        TreeNode entryNode = nodeMap.get(entryName);
        if (entryNode == null) {
            entryNode = this.strategy.getTreeNode(this.getRootId(), entryName, entryPro.getDisplayName().toString());
            entryNode.setIsOpened(true);
        }
        return entryNode;
    }
}

