/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.service;

import java.util.List;
import kd.bd.master.inf.MatserListInf;
import kd.bd.master.util.CharacterHandleUtil;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class SupplierListService
implements MatserListInf {
    private static final String QUERY_SQL1 = "select t1.fid,t1.fnumber as fnumber,case when t3.fname is null then t1.fname when t3.fname='' then t1.fname when t3.fname=' ' then t1.fname else t3.fname end as fname,t1.fcreateorgid as fcreateorgid,t1.fuseorgid as fuseorgid,t1.fenable as fenable,t1.fstatus,t1.Fsupplierid,t1.fsupmasterid from t_bd_suppliersite t1 inner join t_bd_suppliersite_l t3 on t1.fid = t3.fid where t1.fcreateorgid=t1.fuseorgid and t3.flocaleid ='";
    private static final String QUERY_SQL2 = " union select t1.fid,t1.fnumber as fnumber,case when t3.fname is null then t1.fname when t3.fname=''  then t1.fname when t3.fname=' ' then t1.fname else t3.fname end as fname,t2.fcreateorgid as fcreateorgid ,t2.fuseorgid as fuseorgid,  t1.fenable as fenable,t1.fstatus,t1.Fsupplierid,t1.fsupmasterid from t_bd_suppliersite t1  left join (select b.fuseorgid,b.fdataid,b.fcreateorgid,b.fadminorgid,b.fctrlstrategy,b.fisassign,b.fassignorgid  from t_bd_suppliersiteusereg b where(select count(1) as num from t_bd_suppliersiteexc a where a.fuseorgid = b.fuseorgid  and a.fdataid=b.fdataid and a.fcreateorgid=b.fcreateorgid) = 0) t2 on t1.fid = t2.fdataid  inner join t_bd_suppliersite_l t3 on t1.fid = t3.fid where t2.fcreateorgid is not null and t2.fuseorgid is not null and t3.flocaleid ='";

    @Override
    public String getListDataSql(List<QFilter> qfs, String useOrgPk) {
        return this.getSupListDataSql(qfs, useOrgPk);
    }

    private String getSupListDataSql(List<QFilter> qfs, String useOrgPk) {
        String enableStr = null;
        String supplierIdStr = null;
        String likeStr = null;
        String[] conditions = null;
        String[] strAll = null;
        Object orgStr = null;
        String numberStr = null;
        String nameStr = null;
        String queryStr = "";
        String lang = (Lang.get() == null ? "zh_CN" : String.valueOf(Lang.get())).concat("'");
        if (qfs != null && qfs.size() > 0) {
            for (QFilter qf : qfs) {
                if ("enable".equals(qf.getProperty())) {
                    enableStr = CharacterHandleUtil.getEnableString(qf);
                    continue;
                }
                if ("supplier.id".equals(qf.getProperty())) {
                    supplierIdStr = " and t1.fsupplierid ='" + qf.getValue() + "'";
                    continue;
                }
                if ("userorg.id".equals(qf.getProperty())) {
                    orgStr = qf.getValue();
                    continue;
                }
                if ("number".equals(qf.getProperty())) {
                    numberStr = " and f" + qf;
                    continue;
                }
                if ("name".equals(qf.getProperty())) {
                    nameStr = " and t3.fname " + qf.getCP().concat("'") + qf.getValue() + "'";
                    continue;
                }
                if (!"1".equals(qf.getProperty())) continue;
                likeStr = String.valueOf(qf.getValue());
                strAll = CharacterHandleUtil.getFuzzyQuery(likeStr, "#");
            }
            if (strAll != null && strAll.length == 2) {
                for (int i = 0; i < strAll.length; ++i) {
                    if (i == 0) {
                        conditions = strAll[i].split(",");
                        continue;
                    }
                    if (i != 1) continue;
                    queryStr = strAll[i];
                    break;
                }
            }
            if (orgStr == null) {
                orgStr = useOrgPk;
            }
        }
        StringBuffer sql = new StringBuffer(QUERY_SQL1);
        sql.append(lang);
        if (orgStr != null) {
            sql.append(" and t1.fcreateorgid =");
            sql.append(orgStr);
        }
        if (StringUtils.isNotEmpty(enableStr)) {
            sql.append(enableStr);
        }
        CharacterHandleUtil.getQueryString(enableStr, supplierIdStr, numberStr, conditions, nameStr, queryStr, sql);
        sql.append(QUERY_SQL2);
        sql.append(lang);
        if (orgStr != null) {
            sql.append(" and t2.fuseorgid =");
            sql.append(orgStr);
        }
        CharacterHandleUtil.getQueryString(enableStr, supplierIdStr, numberStr, conditions, nameStr, queryStr, sql);
        sql.append(" order by fnumber,fname");
        return sql.toString();
    }
}

