/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bd.macc.common.constant.CommonConstant;
import kd.bd.macc.common.helper.AppIdHelper;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CostTypeHelper {
    public static DynamicObject[] getCostType(IFormView view) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(CostTypeHelper.getCostTypeByAppNum(view));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qfilters.add(baseDataFilter);
        }
        return BusinessDataServiceHelper.load((String)"cad_costtype", (String)"number,name,id", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"type asc");
    }

    public static QFilter getCtrlBaseDataFilter() {
        Long currAcctOrg = RequestContext.getOrCreate().getOrgId();
        return BaseDataServiceHelper.getBaseDataFilter((String)"cad_costtype", (Long)currAcctOrg);
    }

    public static boolean isUseMatVersion(Long costTypeId) {
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"isuseversion", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costTypeId)});
        if (costType == null) {
            return true;
        }
        return !costType.getBoolean("isuseversion");
    }

    public static QFilter getScaCostType() {
        return new QFilter("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
    }

    public static QFilter getCostTypeByAppNum(IFormView view) {
        String appNum = AppIdHelper.getCurAppNum(view);
        if ("aca".equals(appNum)) {
            return new QFilter("type", "in", (Object)new String[]{"1", "2"});
        }
        return new QFilter("type", "in", (Object)new String[]{"0", "1", "2"});
    }

    public static DynamicObject[] getCostTypes() {
        return CostTypeHelper.getCostTypesBy("0");
    }

    public static DynamicObject[] getCostTypesBy(String type) {
        String selectProperties = "number,name,id,type";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            qfilters.add(new QFilter("type", "=", (Object)type));
        }
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qfilters.add(baseDataFilter);
        }
        DynamicObject[] costTypes = BusinessDataServiceHelper.load((String)"cad_costtype", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]));
        return costTypes;
    }

    public static DynamicObject[] getCostTypeByOrgsRanges(String type) {
        Object[] costTypes;
        ArrayList<Object> list = new ArrayList<Object>(10);
        String selectProperties = "number,name,id,type";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            qfilters.add(new QFilter("type", "=", (Object)type));
        }
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qfilters.add(baseDataFilter);
        }
        if (!CadEmptyUtils.isEmpty(costTypes = BusinessDataServiceHelper.load((String)"cad_costtype", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0])))) {
            list.addAll(Arrays.asList(costTypes));
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject getCostTypesById(Long costTypeId) {
        String selectProperties = "number,name,id,type";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("id", "=", (Object)costTypeId));
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]));
        return costType;
    }

    public static DynamicObject[] getCostTypesByStrage(String type, String strage) {
        String selectProperties = "number,name,id,type";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            qfilters.add(new QFilter("type", "=", (Object)type));
        }
        qfilters.add(new QFilter("ctrlstrategy", "=", (Object)strage));
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] costTypes = BusinessDataServiceHelper.load((String)"cad_costtype", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]));
        return costTypes;
    }
}

