/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.common.helper;

import kd.bd.macc.common.dto.ProgressParamDto;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ProgressHelper {
    private static int MAX_Threads = 10;
    private static ThreadPool threadPool = null;
    private static final Log LOG = LogFactory.getLog(ProgressHelper.class);
    public static final String Result_success = "success";
    private static final String KEY_PRE = "progress:";
    private static final String KEY_APPID = "macc";

    public static void excute(IFormView view, String progressId, String titile, Runnable task) {
        ProgressHelper.excute(view, progressId, titile, task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void excute(IFormView view, String progressId, String titile, Runnable task, CloseCallBack closeCallBack) {
        Class<ProgressHelper> clazz = ProgressHelper.class;
        synchronized (ProgressHelper.class) {
            if (threadPool == null) {
                threadPool = ThreadPools.newCachedThreadPool((String)"Progress2Helper", (int)2, (int)MAX_Threads);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cad_common_progress");
            showParameter.setCaption(titile);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParam("progressId", (Object)progressId);
            if (closeCallBack != null) {
                showParameter.setCloseCallBack(closeCallBack);
            }
            ProgressHelper.setProgressParam(progressId, new ProgressParamDto());
            view.showForm(showParameter);
            view.showLoading(new LocaleString());
            threadPool.execute(task);
            return;
        }
    }

    public static void setProgress(String progressId, String opContent, int complete, int total, String unit) {
        ProgressHelper.setProgress(progressId, opContent, complete, total, unit, -1);
    }

    public static void setProgress(String progressId, String opContent, int complete, int total, String unit, int duration) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam(progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        paramDto.setComplete(complete);
        paramDto.setTotal(total);
        paramDto.setUnit(unit);
        if (duration >= 0) {
            paramDto.setDurationTimes(duration);
        } else {
            paramDto.setDurationTimes(null);
        }
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    public static void setProgress(String progressId, String opContent, int complete, String unit) {
        ProgressHelper.setProgress(progressId, opContent, complete, unit, -1);
    }

    public static void setProgress(String progressId, String opContent, int complete, String unit, int duration) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam(progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (paramDto.getComplete() == null) {
            paramDto.setComplete(0);
        }
        paramDto.setComplete(paramDto.getComplete() + complete);
        paramDto.setUnit(unit);
        if (duration >= 0) {
            paramDto.setDurationTimes(duration);
        } else {
            paramDto.setDurationTimes(null);
        }
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    public static void showError(String progressId, String error) {
        ProgressParamDto paramDto;
        if (StringUtils.isBlank((CharSequence)error)) {
            return;
        }
        if (error.length() > 30) {
            error = error.substring(0, 30);
        }
        if ((paramDto = ProgressHelper.getProgressParam(progressId)) == null) {
            return;
        }
        paramDto.setError(error);
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    public static void showSuccess(String progressId, String msg) {
        ProgressHelper.showSuccess(progressId, msg, -1);
    }

    public static void showSuccess(String progressId, String msg, int duration) {
        ProgressParamDto paramDto;
        if (StringUtils.isBlank((CharSequence)msg)) {
            return;
        }
        if (msg.length() > 30) {
            msg = msg.substring(0, 30);
        }
        if ((paramDto = ProgressHelper.getProgressParam(progressId)) == null) {
            return;
        }
        paramDto.setSuccess(msg);
        if (duration >= 0) {
            paramDto.setDurationTimes(duration);
        } else {
            paramDto.setDurationTimes(null);
        }
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    public static ProgressParamDto getProgressParam(String progressId) {
        try {
            if (StringUtils.isEmpty((CharSequence)progressId)) {
                return null;
            }
            return (ProgressParamDto)AppCache.get((String)KEY_APPID).get(KEY_PRE + progressId, ProgressParamDto.class);
        }
        catch (Exception ex) {
            LOG.error(ResManager.loadKDString((String)"\u83b7\u53d6\u8fdb\u5ea6\u6761\u8fd0\u884c\u53c2\u6570\u51fa\u73b0\u9519\u8bef\uff1a", (String)"ProgressHelper_0", (String)"macc-cad-common", (Object[])new Object[0]) + ex.getMessage());
            return null;
        }
    }

    public static void setProgressParam(String progressId, ProgressParamDto paramDto) {
        try {
            AppCache.get((String)KEY_APPID).put(KEY_PRE + progressId, (Object)paramDto);
        }
        catch (Exception ex) {
            LOG.error(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8fdb\u5ea6\u6761\u8fd0\u884c\u53c2\u6570\u51fa\u73b0\u9519\u8bef\uff1a", (String)"ProgressHelper_1", (String)"macc-cad-common", (Object[])new Object[0]) + ex.getMessage());
        }
    }

    public static void clearProgressParam(String progressId) {
        try {
            AppCache.get((String)KEY_APPID).remove(KEY_PRE + progressId);
        }
        catch (Exception ex) {
            LOG.error(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8fdb\u5ea6\u6761\u8fd0\u884c\u53c2\u6570\u51fa\u73b0\u9519\u8bef\uff1a", (String)"ProgressHelper_1", (String)"macc-cad-common", (Object[])new Object[0]) + ex.getMessage());
        }
    }
}

