/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.Iterator;
import java.util.Set;
import kd.bd.sbd.business.helper.LotCodeRuleHelper;
import kd.bd.sbd.enums.LotCodeItemTypeEnum;
import kd.bd.sbd.enums.UseModeEnum;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class LotCodeRuleValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("splitsign");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject entity = data.getDataEntity();
            String splitSign = entity.getString("splitsign");
            if (",".equals(splitSign)) {
                this.addMessage(data, ResManager.loadKDString((String)"\u6bb5\u95f4\u5206\u5272\u7b26\u4e0d\u5141\u8bb8\u4f7f\u7528\u201c,\u201d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"SBS-E-132020", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("entryentity");
            Iterator iterator = entry.iterator();
            boolean flagExtendedDataEntityExit = false;
            while (iterator.hasNext()) {
                DynamicObject dd = (DynamicObject)iterator.next();
                if (dd.getDynamicObject("lotprop") != null) continue;
                flagExtendedDataEntityExit = true;
                this.addMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u5b9e\u4f53\u201c\u7f16\u7801\u8bbe\u7f6e\u201d\u5fc5\u5f55\u3002", (String)"LotCodeRuleValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                break;
            }
            if (flagExtendedDataEntityExit) break;
            int sernum = 0;
            for (DynamicObject row : entry) {
                String typeValue = row.getDynamicObject("lotprop").getString("type");
                if (!StringUtils.isNotEmpty((String)typeValue) || !LotCodeItemTypeEnum.SERIALNUM.getValue().equals(typeValue)) continue;
                ++sernum;
                String value = row.getString("settingvalue").trim();
                if (!StringUtils.isNotEmpty((String)value)) continue;
                if (!LotCodeRuleHelper.isInteger((String)value)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u6d41\u6c34\u53f7\u7684\u8bbe\u7f6e\u503c\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\u3002", (String)"LotCodeRuleValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    continue;
                }
                if (value.length() <= 10) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u6d41\u6c34\u53f7\u7684\u8bbe\u7f6e\u503c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u5341\u4f4d\u3002", (String)"LotCodeRuleValidator_3", (String)"bd-sbd-opplugin", (Object[])new Object[0]), row.getInt("seq")));
            }
            boolean useinserial = entity.getBoolean("useinserial");
            if (!(useinserial || entity.getBoolean("useinlot") || entity.getBoolean("useintracknumber"))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u4e2a\u9002\u7528\u6279\u53f7\u6216\u9002\u7528\u5e8f\u5217\u53f7\u6216\u9002\u7528\u8ddf\u8e2a\u53f7\u3002", (String)"LotCodeRuleValidator_4", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (sernum > 1) {
                this.addMessage(data, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u6d41\u6c34\u53f7\u7f16\u7801\u3002", (String)"LotCodeRuleValidator_5", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            } else if (sernum == 0 && useinserial) {
                this.addMessage(data, ResManager.loadKDString((String)"\u52fe\u9009\u9002\u7528\u5e8f\u5217\u53f7\u65f6\u7f16\u7801\u89c4\u5219\u5fc5\u987b\u8bbe\u7f6e\u552f\u4e00\u7684\u6d41\u6c34\u53f7\u3002", (String)"LotCodeRuleValidator_6", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            StringBuilder sb = new StringBuilder();
            for (DynamicObject row : entry) {
                DynamicObject lotprop = row.getDynamicObject("lotprop");
                if (lotprop == null) continue;
                LotCodeItemTypeEnum key = LotCodeItemTypeEnum.getLotCodeItemTypeEnumByValue((String)lotprop.getString("type"));
                switch (key) {
                    case CONST: {
                        if (!StringUtils.isEmpty((String)row.getString("settingvalue").trim())) break;
                        sb.append(ResManager.loadKDString((String)"\u8bbe\u7f6e\u503c", (String)"LotCodeRuleValidator_7", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    case DATE: {
                        if (!StringUtils.isEmpty((String)row.getString("format").trim())) break;
                        if (sb.length() > 0) {
                            sb.append('\uff0c');
                        }
                        sb.append(ResManager.loadKDString((String)"\u683c\u5f0f", (String)"LotCodeRuleValidator_8", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    case SERIALNUM: {
                        if (StringUtils.isEmpty((String)row.getString("settingvalue").trim())) {
                            sb.append(ResManager.loadKDString((String)"\u8bbe\u7f6e\u503c", (String)"LotCodeRuleValidator_7", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        }
                        if (0 == row.getInt("length")) {
                            if (sb.length() > 0) {
                                sb.append('\uff0c');
                            }
                            sb.append(ResManager.loadKDString((String)"\u957f\u5ea6", (String)"LotCodeRuleValidator_9", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        }
                        if (0 != row.getInt("step")) break;
                        if (sb.length() > 0) {
                            sb.append('\uff0c');
                        }
                        sb.append(ResManager.loadKDString((String)"\u6b65\u957f", (String)"LotCodeRuleValidator_10", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    case SEQ: 
                    case TXT: {
                        if (StringUtils.isEmpty((String)row.getString("attusingmode"))) {
                            sb.append(ResManager.loadKDString((String)"\u4f7f\u7528\u6a21\u5f0f", (String)"UseModeEnum_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                            break;
                        }
                        if (UseModeEnum.CUT != UseModeEnum.getUseModeEnumEnumByValue((String)row.getString("attusingmode"))) break;
                        if (StringUtils.isEmpty((String)row.getString("format").trim())) {
                            sb.append(ResManager.loadKDString((String)"\u683c\u5f0f", (String)"LotCodeRuleValidator_8", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        }
                        if (0 == row.getInt("length")) {
                            if (sb.length() > 0) {
                                sb.append('\uff0c');
                            }
                            sb.append(ResManager.loadKDString((String)"\u957f\u5ea6", (String)"LotCodeRuleValidator_9", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        }
                        if (!StringUtils.isEmpty((String)row.getString("addchar").trim())) break;
                        if (sb.length() > 0) {
                            sb.append('\uff0c');
                        }
                        sb.append(ResManager.loadKDString((String)"\u8865\u4f4d\u7b26\u53f7", (String)"LotCodeRuleValidator_11", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                if (sb.length() > 0) {
                    sb.append('\u3002');
                    this.addMessage(data, this.getEntrySeqMsg(row, key) + sb);
                }
                sb.setLength(0);
            }
        }
    }

    private String getEntrySeqMsg(DynamicObject row, LotCodeItemTypeEnum en) {
        return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s\u5143\u7d20\u5fc5\u987b\u5f55\u5165", (String)"LotCodeRuleValidator_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]), row.getInt("seq"), en.getName());
    }
}

