/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.er.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkDeprecated;

public class ErReimburseSettingUtil {
    private static Log log = LogFactory.getLog(ErReimburseSettingUtil.class);
    public static final String RELATIONENTITY = "er_reimbursesetting_rel";
    public static final String SELECTFIELDS = "user,reimburselevel,company";

    public static Map<Long, Map<Long, Object>> getReimburseLevel(List<Object> users, Function<DynamicObject, Object> getValueWay) {
        HashMap<Long, Map<Long, Object>> reimburseLevelMap = new HashMap<Long, Map<Long, Object>>(16);
        QFilter q1 = new QFilter("user", "in", users);
        Map result = BusinessDataServiceHelper.loadFromCache((String)RELATIONENTITY, (String)SELECTFIELDS, (QFilter[])new QFilter[]{q1});
        Iterator iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject relation = (DynamicObject)iterator.next().getValue();
            HashMap<Long, Object> innerMap = (HashMap<Long, Object>)reimburseLevelMap.get(relation.getLong("user.id"));
            if (innerMap == null) {
                innerMap = new HashMap<Long, Object>(2);
                reimburseLevelMap.put(relation.getLong("user.id"), innerMap);
            }
            innerMap.put(relation.getLong("company.id"), getValueWay.apply(relation));
        }
        return reimburseLevelMap;
    }

    public static Map<Object, Object> getReimburseLevel(Long user, List<Long> orgs) {
        QFilter q1 = new QFilter("user", "=", (Object)user);
        QFilter q2 = new QFilter("company", "in", orgs);
        DynamicObjectCollection result = QueryServiceHelper.query((String)RELATIONENTITY, (String)SELECTFIELDS, (QFilter[])new QFilter[]{q1, q2});
        Iterator iterator = result.iterator();
        HashMap<Object, Object> reimburseLevelMap = new HashMap<Object, Object>(result.size());
        while (iterator.hasNext()) {
            DynamicObject entry = (DynamicObject)iterator.next();
            reimburseLevelMap.put(entry.get("company"), entry.get("reimburselevel"));
        }
        return reimburseLevelMap;
    }

    public static DynamicObject getUser(Long userId) {
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,email,number,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
    }

    public static Long initCompanyByDept(Long deptId) {
        Map company;
        Long companyId = 0L;
        try {
            String fromOrgType = "01";
            String toOrgType = "01";
            Long billTypeId = 0L;
            companyId = OrgServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)deptId, (Long)billTypeId);
        }
        catch (Exception fromOrgType) {
            // empty catch block
        }
        if (companyId == 0L && (company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId)) != null) {
            companyId = (Long)company.get("id");
        }
        return companyId;
    }

    public static Long getPk(Object entity) {
        if (entity instanceof DynamicObject) {
            return (Long)((DynamicObject)entity).getPkValue();
        }
        if (entity instanceof Long) {
            return (Long)entity;
        }
        if (entity instanceof Integer) {
            return Long.valueOf(entity.toString());
        }
        return null;
    }

    public static Map<String, Object> getUserMap(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DynamicObject user = ErReimburseSettingUtil.getUser(userId);
        if (user != null) {
            resultMap.put("tel", user.get("phone"));
            resultMap.put("name", user.get("name"));
            resultMap.put("number", user.get("number"));
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            for (DynamicObject userEntry : userEntrys) {
                boolean isPartjob = userEntry.getBoolean("ispartjob");
                resultMap.put("applierpositionstr", userEntry.getString("position"));
                DynamicObject dept = userEntry.getDynamicObject("dpt");
                resultMap.put("org", dept);
                if (isPartjob) continue;
                break;
            }
        }
        return resultMap;
    }

    @SdkDeprecated
    public static void updateRelation(Long user, DynamicObjectCollection reimburselevelentry) {
        QFilter q1 = new QFilter("user", "=", (Object)user);
        QFilter q2 = new QFilter("company", "in", reimburselevelentry.stream().map(v -> v.getDynamicObject("company").getPkValue()).collect(Collectors.toList()));
        DeleteServiceHelper.delete((String)RELATIONENTITY, (QFilter[])new QFilter[]{q1, q2});
        ArrayList<DynamicObject> inserts = new ArrayList<DynamicObject>(reimburselevelentry.size());
        for (int i = 0; i < reimburselevelentry.size(); ++i) {
            if (((DynamicObject)reimburselevelentry.get(i)).get("entryreimburselevel") == null) continue;
            DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)RELATIONENTITY);
            log.info("relation----------->");
            inserts.add(relation);
            relation.set("user", (Object)user);
            relation.set("reimburselevel", ((DynamicObject)reimburselevelentry.get(i)).get("entryreimburselevel"));
            relation.set("company", ((DynamicObject)reimburselevelentry.get(i)).get("company"));
        }
        SaveServiceHelper.save((DynamicObject[])inserts.toArray(new DynamicObject[0]));
        Map<String, Object> userMap = ErReimburseSettingUtil.getUserMap(user);
        DynamicObject dept = (DynamicObject)userMap.get("org");
        Long deptId = (Long)dept.getPkValue();
        Long orgId = ErReimburseSettingUtil.initCompanyByDept(deptId);
        if (orgId != null) {
            QFilter filter = new QFilter("user", "=", (Object)user);
            filter.and(new QFilter("company", "=", (Object)orgId));
            DynamicObject relOb = BusinessDataServiceHelper.loadSingleFromCache((String)RELATIONENTITY, (String)"reimburselevel", (QFilter[])new QFilter[]{filter});
            if (null != relOb) {
                Long lvId = ErReimburseSettingUtil.getPk(relOb.get("reimburselevel"));
                QFilter userFilter = new QFilter("id", "=", (Object)user);
                DynamicObject relUserOb = BusinessDataServiceHelper.loadSingleFromCache((String)"er_reimbursesetting", (String)"reimburselevel", (QFilter[])new QFilter[]{userFilter});
                if (lvId != null) {
                    relUserOb.set("reimburselevel", (Object)lvId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{relUserOb});
                }
            }
        }
    }
}

