/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.projectkind;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import org.jetbrains.annotations.NotNull;

public class ProjectKindTreeService {
    private static final Log logger = LogFactory.getLog(ProjectKindTreeService.class);
    private static final String BD_KIND = "bd_projectkind";
    public static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String FIELD_ID = "id";
    private static final String FIELD_PARENT = "parent";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_LONGNUMBER = "longnumber";
    private TreeFilterParameter treeFilterParameter;

    public TreeFilterParameter getTreeFilterParameter() {
        return this.treeFilterParameter;
    }

    public void setTreeFilterParameter(TreeFilterParameter treeFilterParameter) {
        this.treeFilterParameter = treeFilterParameter;
    }

    private List<DynamicObject> getTreeData(Long orgId) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (this.getTreeFilterParameter() != null) {
            qFilterList.addAll(this.getTreeFilterParameter().getQFilters());
        }
        QFilter authorizedProjectKindFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)BD_KIND, (Long)orgId);
        logger.info("orgId:{}, authorizedProjectKindFilter:{}", (Object)orgId, (Object)authorizedProjectKindFilter);
        qFilterList.add(authorizedProjectKindFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.Checked.toString());
        qFilterList.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.Enable.toString());
        qFilterList.add(enableFilter);
        logger.info("\u6784\u5efa\u9879\u76ee\u5206\u7c7b\u6811\u65f6\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a{}", qFilterList);
        DynamicObject[] authorizedProjectKind = BusinessDataServiceHelper.load((String)BD_KIND, (String)String.join((CharSequence)",", FIELD_ID, FIELD_PARENT, FIELD_LONGNUMBER), (QFilter[])qFilterList.toArray(new QFilter[0]));
        List authorizedProjectKindList = Arrays.stream(authorizedProjectKind).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(o -> o.getPkValue().toString()))), ArrayList::new));
        Collections.sort(authorizedProjectKindList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Collator instance = Collator.getInstance();
                String source = o1.getLocaleString(ProjectKindTreeService.FIELD_NAME).getLocaleValue() != null ? o1.getLocaleString(ProjectKindTreeService.FIELD_NAME).getLocaleValue() : "";
                String target = o2.getLocaleString(ProjectKindTreeService.FIELD_NAME).getLocaleValue() != null ? o2.getLocaleString(ProjectKindTreeService.FIELD_NAME).getLocaleValue() : "";
                return instance.compare(source, target);
            }
        });
        return authorizedProjectKindList;
    }

    public List<TreeNode> getChildNode(Long orgId, Boolean showNumber) {
        List<DynamicObject> treeData = this.getTreeData(orgId);
        return this.getChildNode(treeData.toArray(new DynamicObject[0]), showNumber);
    }

    @NotNull
    private List<TreeNode> getChildNode(DynamicObject[] treeDataCol, Boolean showNumber) {
        Map<Long, DynamicObjectCollection> childMap = this.getChildMap(treeDataCol);
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        for (DynamicObject treeData : treeDataCol) {
            boolean hasParent = treeData.get(FIELD_PARENT) != null;
            boolean bl = hasParent = hasParent && Arrays.stream(treeDataCol).anyMatch(entry -> StringUtils.equals((CharSequence)((DynamicObject)treeData.get(FIELD_PARENT)).getPkValue().toString(), (CharSequence)entry.getPkValue().toString()));
            if (hasParent) continue;
            TreeNode treeNode = this.constructTreeNode(treeData, childMap, null, showNumber);
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    public Map<Long, DynamicObjectCollection> getChildMap(DynamicObject[] allNodes) {
        HashMap<Long, DynamicObjectCollection> childMap = new HashMap<Long, DynamicObjectCollection>();
        for (DynamicObject treeData : allNodes) {
            if (treeData.get(FIELD_PARENT) == null) continue;
            DynamicObject parent = (DynamicObject)treeData.get(FIELD_PARENT);
            Long parentId = (Long)parent.getPkValue();
            DynamicObjectCollection col = childMap.get(parentId) != null ? (DynamicObjectCollection)childMap.get(parentId) : new DynamicObjectCollection();
            col.add((Object)treeData);
            childMap.put((Long)parent.getPkValue(), col);
        }
        return childMap;
    }

    private TreeNode constructTreeNode(DynamicObject treeData, Map<Long, DynamicObjectCollection> childMap, String parentId, Boolean showNumber) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)BD_KIND);
        String nameProperty = ((BasedataEntityType)refMainType).getNameProperty();
        nameProperty = StringUtils.isBlank((CharSequence)nameProperty) ? FIELD_NAME : nameProperty;
        String treeNodeName = treeData.get(nameProperty).toString();
        if (Boolean.TRUE.equals(showNumber)) {
            String numberProperty = ((BasedataEntityType)refMainType).getNumberProperty();
            numberProperty = StringUtils.isBlank((CharSequence)numberProperty) ? FIELD_NUMBER : numberProperty;
            String treeNodeNumber = treeData.get(numberProperty).toString();
            treeNodeName = treeNodeName + "\uff08" + treeNodeNumber + "\uff09";
        }
        TreeNode treeNode = new TreeNode(parentId, treeData.getPkValue().toString(), treeNodeName, true);
        treeNode.setLongNumber(treeData.getString(FIELD_LONGNUMBER));
        Long dataId = (Long)treeData.getPkValue();
        if (null == childMap.get(dataId)) {
            treeNode.setChildren(null);
            return treeNode;
        }
        DynamicObjectCollection childDataCol = childMap.get(dataId);
        for (DynamicObject childData : childDataCol) {
            TreeNode childNode = this.constructTreeNode(childData, childMap, treeNode.getId(), showNumber);
            treeNode.addChild(childNode);
        }
        return treeNode;
    }

    public List<DynamicObject> getTreeDataByOrgList(List<Long> orgList) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (this.getTreeFilterParameter() != null) {
            qFilterList.addAll(this.getTreeFilterParameter().getQFilters());
        }
        QFilter authorizedProjectKindOrFilter = BaseDataServiceHelper.getBaseDataFilter((String)BD_KIND, orgList, (boolean)true);
        logger.info("orgList:{}, authorizedProjectKindFilter:{}", orgList, (Object)authorizedProjectKindOrFilter);
        qFilterList.add(authorizedProjectKindOrFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.Checked.toString());
        qFilterList.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.Enable.toString());
        qFilterList.add(enableFilter);
        logger.info("\u6784\u5efa\u9879\u76ee\u5206\u7c7b\u6811\u65f6\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a{}", qFilterList);
        DynamicObject[] authorizedProjectKind = BusinessDataServiceHelper.load((String)BD_KIND, (String)String.join((CharSequence)",", FIELD_ID, FIELD_PARENT, FIELD_LONGNUMBER), (QFilter[])qFilterList.toArray(new QFilter[0]));
        List authorizedProjectKindList = Arrays.stream(authorizedProjectKind).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(o -> o.getPkValue().toString()))), ArrayList::new));
        authorizedProjectKindList.sort((o1, o2) -> {
            Collator instance = Collator.getInstance();
            String source = o1.getLocaleString(FIELD_NAME).getLocaleValue() != null ? o1.getLocaleString(FIELD_NAME).getLocaleValue() : "";
            String target = o2.getLocaleString(FIELD_NAME).getLocaleValue() != null ? o2.getLocaleString(FIELD_NAME).getLocaleValue() : "";
            return instance.compare(source, target);
        });
        return authorizedProjectKindList;
    }

    public List<TreeNode> getChildNodeByOrgList(List<Long> orgList, Boolean showNumber) {
        List<DynamicObject> treeData = this.getTreeDataByOrgList(orgList);
        return this.getChildNode(treeData.toArray(new DynamicObject[0]), showNumber);
    }
}

