/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.bom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bd.macc.common.helper.CalcDimenHelper;
import kd.bd.macc.common.helper.CalcKeyHelper;
import kd.bd.macc.common.helper.ConfigTrackHelper;
import kd.bd.macc.common.helper.OrgHelper;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class CadCostBomEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit copentrymaterial = (BasedataEdit)this.getControl("copentrymaterial");
        copentrymaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entrymaterial = (BasedataEdit)this.getControl("entrymaterial");
        entrymaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costType = (BasedataEdit)this.getControl("manuorg");
        costType.addBeforeF7SelectListener(evt -> {
            ArrayList orgIdList;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
            if (createorg != null) {
                List productOrgs;
                orgIdList = new ArrayList();
                List useProOrg = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList((Long)createorg.getPkValue()), (String)"04");
                if (!CollectionUtils.isEmpty((Collection)useProOrg)) {
                    orgIdList.addAll(useProOrg);
                }
                if (!CollectionUtils.isEmpty((Collection)(productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)((Long)createorg.getPkValue()), (boolean)false)))) {
                    orgIdList.addAll(productOrgs);
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"CadCostBomEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("id", "in", orgIdList));
        });
        BasedataEdit createorgControl = (BasedataEdit)this.getControl("createorg");
        createorgControl.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg");
            if (manuorg != null) {
                List productOrgs;
                ArrayList orgIdList = new ArrayList();
                List useProOrg = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList((Long)manuorg.getPkValue()), (String)"10");
                if (!CollectionUtils.isEmpty((Collection)useProOrg)) {
                    orgIdList.addAll(useProOrg);
                }
                if (!CollectionUtils.isEmpty((Collection)(productOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)((Long)manuorg.getPkValue()), (String)"10")))) {
                    orgIdList.addAll(productOrgs);
                }
                qFilters.add(new QFilter("id", "in", orgIdList));
            }
        });
        BasedataEdit entryconfiguredcodeControl = (BasedataEdit)this.getControl("entryconfiguredcode");
        entryconfiguredcodeControl.addBeforeF7SelectListener(evt -> {
            int row = evt.getRow();
            DynamicObject entrymaterialDy = (DynamicObject)this.getModel().getValue("entrymaterial", row);
            if (entrymaterialDy == null) {
                return;
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Set configs = ConfigTrackHelper.getConfigCodeIds(Collections.singleton(entrymaterialDy.getLong("masterid")));
            if (!CadEmptyUtils.isEmpty((Set)configs)) {
                qFilters.add(new QFilter("material", "in", (Object)configs));
            }
        });
        BasedataEdit bomType = (BasedataEdit)this.getControl("type");
        bomType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("purpose", "not in", (Object)new String[]{"B", "C"}));
        });
    }

    public void afterCreateNewData(EventObject e) {
        String manuorg;
        this.getModel().setValue("yieldrate", (Object)1);
        this.getView().setVisible(Boolean.TRUE, new String[]{"acptbi_copentry_new", "acptbi_copentry_delete", "acptbi_entry_new", "acptbi_entry_delete"});
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && !StringUtils.isEmpty((Object)(manuorg = parentView.getPageCache().get("manuorg")))) {
            this.getModel().setValue("manuorg", (Object)Long.valueOf(manuorg));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changManuorgStatus();
        this.changeEntryStatus();
        DynamicObject entry_one = this.getModel().getEntryRowEntity("entry", 0);
        if (entry_one == null) {
            return;
        }
        String ownertype = entry_one.getString("ownertype");
        if ("bos_org".equals(ownertype)) {
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"owner"});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"wbs", "entryisreplace", "entryreplaceplan", "entryreplacemethod", "entryisreplaceplanmm", "entryreplacestra", "entryrepbynum", "entrygrouprepclass", "entrykittingrepclass", "entryreplaceratio", "entrybyratio"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.getModel().setValue("auxproperty", (Object)CalcDimenHelper.getAffectAuxpty((Object)dataEntity.get("material"), (Object)dataEntity.get("auxproperty")));
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", dataEntity.get("material.masterid"));
            keycolMap.put("auxproperty", dataEntity.get("auxproperty.id"));
            keycolMap.put("configuredcode", dataEntity.get("configuredcode.id"));
            this.getModel().setValue("keycol", (Object)CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol());
            DynamicObjectCollection copentrys = dataEntity.getDynamicObjectCollection("copentry");
            for (int i = 0; i < copentrys.size(); ++i) {
                DynamicObject copentry = (DynamicObject)copentrys.get(i);
                this.getModel().setValue("copentryauxproperty", (Object)CalcDimenHelper.getAffectAuxpty((Object)copentry.get("copentrymaterial"), (Object)copentry.get("copentryauxproperty")), i);
                HashMap<String, Object> coEntryKeycolMap = new HashMap<String, Object>(16);
                coEntryKeycolMap.put("material", copentry.get("copentrymaterial.masterid"));
                coEntryKeycolMap.put("auxproperty", copentry.get("copentryauxproperty.id"));
                coEntryKeycolMap.put("configuredcode", dataEntity.get("configuredcode.id"));
                this.getModel().setValue("copentrykeycol", (Object)CalcKeyHelper.getCalcKey(coEntryKeycolMap, new ArrayList(), (boolean)true).getKeycol(), i);
            }
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                this.getModel().setValue("entryauxproperty", (Object)CalcDimenHelper.getAffectAuxpty((Object)entry.get("entrymaterial"), (Object)entry.get("entryauxproperty")), i);
                HashMap<String, Object> entryKeycolMap = new HashMap<String, Object>(16);
                entryKeycolMap.put("material", entry.get("entrymaterial.masterid"));
                entryKeycolMap.put("auxproperty", entry.get("entryauxproperty.id"));
                entryKeycolMap.put("configuredcode", entry.get("entryconfiguredcode.id"));
                this.getModel().setValue("entrykeycol", (Object)CalcKeyHelper.getCalcKey(entryKeycolMap, new ArrayList(), (boolean)true).getKeycol(), i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValueObj = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "ownertype": {
                String newValue = (String)newValueObj;
                if (!"bos_org".equals(newValue)) {
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"owner"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"owner"});
                break;
            }
            case "entrymaterial": {
                if (newValueObj == null) {
                    this.getModel().setValue("entryconfiguredcode", null, rowIndex);
                } else {
                    String configproperties = ((DynamicObject)newValueObj).getString("configproperties");
                    if (!"2".equals(configproperties)) {
                        this.getModel().setValue("entryconfiguredcode", null, rowIndex);
                    }
                }
                this.changeEntryStatus();
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if (!"entry".equals(entryProp._collectionItemPropertyType.getName())) {
            return;
        }
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        RowDataEntity rowDataEntity = rowDataEntities[0];
        String ownertype = rowDataEntity.getDataEntity().getString("ownertype");
        if ("bos_org".equals(ownertype)) {
            this.getView().setEnable(Boolean.valueOf(false), rowDataEntity.getRowIndex(), new String[]{"owner"});
        }
        this.changeEntryStatus();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        String propertyName = property.getName();
        ArrayList props = Lists.newArrayList((Object[])new String[]{"material", "copentrymaterial", "entrymaterial"});
        if (props.contains(propertyName)) {
            DynamicObject createorg = this.getModel().getDataEntity().getDynamicObject("createorg");
            if (createorg == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"CadCostBomEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            param.setCustomParam("isShowAllNoOrg", (Object)"true");
            QFilter materialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)createorg.getLong("id"));
            materialFilter.and(new QFilter("configproperties", "!=", (Object)"2"));
            QFilter enableproduct = new QFilter("enableproduct", "=", (Object)Character.valueOf('1'));
            if (!"entrymaterial".equals(propertyName)) {
                materialFilter.and(enableproduct);
            }
            qFilters.add(materialFilter);
        }
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("createorg");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }

    private void changeEntryStatus() {
        int rowCount = this.getModel().getEntryRowCount("entry");
        if (rowCount >= 0) {
            for (int i = 0; i <= rowCount; ++i) {
                DynamicObject matObj = (DynamicObject)this.getModel().getValue("entrymaterial", i);
                Boolean fileEnable = false;
                if (matObj != null) {
                    fileEnable = matObj != null && "2".equals(matObj.getString("configproperties"));
                }
                this.getView().setEnable(fileEnable, i, new String[]{"entryconfiguredcode"});
            }
        }
    }
}

