/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SubElementEntryEdit
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(SubElementEntryEdit.class);
    public static final String CALLBACKID_EXPENSEITEM = "callbackid_expenseitem";
    public static final String ENTITY_ENTRY = "expenseitemlist";
    public static final String EXPENSEITEMID = "expenseitemid";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addListener();
    }

    protected void addListener() {
        BasedataEdit ele = (BasedataEdit)this.getControl("subelement");
        ele.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            List<Object> list = this.getAllSubElementBy(this.getCostTypeId());
            if (list != null && !list.isEmpty()) {
                filters.add(new QFilter("id", "in", list));
                filters.add(new QFilter("type", "in", Collections.singletonList("002")));
            } else {
                filters.add(new QFilter("id", "=", (Object)-1L));
            }
            filterParameter.setQFilters(filters);
        });
    }

    private List<Object> getAllSubElementBy(Long costTypeId) {
        if (costTypeId == null || costTypeId == 0L) {
            return null;
        }
        DynamicObject costType = BusinessDataServiceHelper.loadSingle((Object)costTypeId, (String)"cad_costtype");
        DynamicObjectCollection elements = null;
        if (costType != null && costType.getDynamicObject("elementtype") != null) {
            QFilter eleTypeFilter = new QFilter("elementtype", "=", costType.getDynamicObject("elementtype").getPkValue());
            elements = QueryServiceHelper.query((String)"cad_elementdetail", (String)"id,subelement", (QFilter[])new QFilter[]{eleTypeFilter});
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(elements.size());
        elements.forEach(s -> list.add(s.get("subelement")));
        return list;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save"});
    }

    private Set<Long> getAllFormExpenseItemId() {
        HashSet<Long> ids = new HashSet<Long>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTITY_ENTRY);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return ids;
        }
        for (DynamicObject row : rows) {
            DynamicObject expenseitem = row.getDynamicObject(EXPENSEITEMID);
            if (expenseitem == null) continue;
            ids.add(expenseitem.getLong("id"));
        }
        return ids;
    }

    private Set<Long> getAllDbExpenseItemIdBy(Long costTypeId, Long subElementId) {
        if (subElementId == null || costTypeId == null) {
            return null;
        }
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter subElementFilter = new QFilter("subelement", "=", (Object)subElementId);
        HashSet<Long> ids = new HashSet<Long>();
        DynamicObjectCollection expenseitems = QueryServiceHelper.query((String)"cad_subelemententry", (String)"id,expenseitem", (QFilter[])new QFilter[]{costTypeFilter, subElementFilter});
        if (expenseitems == null) {
            return null;
        }
        for (DynamicObject row : expenseitems) {
            ids.add(row.getLong("expenseitem"));
        }
        return ids;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_add": {
                Long costTypeId = this.getCostTypeId();
                if (costTypeId == null || costTypeId < 1L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"SubElementEntryEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                    break;
                }
                this.openExpenseItemF7();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costtype"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (!"subelement".equals(name)) {
            return;
        }
        if (newValue != null) {
            Set<Long> mids = this.getAllDbExpenseItemIdBy(this.getCostTypeId(), ((DynamicObject)newValue).getLong("id"));
            this.fillExpenseItemInfo(mids);
        } else if (this.getModel().getEntryRowCount(ENTITY_ENTRY) > 0) {
            this.getModel().deleteEntryData(ENTITY_ENTRY);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long subElementId = (Long)fsp.getCustomParam("subelement");
        Set<Long> mids = this.getAllDbExpenseItemIdBy(this.getCostTypeId(), subElementId);
        this.fillExpenseItemInfo(mids);
        this.getModel().setValue("subelement", (Object)subElementId);
        this.getModel().setValue("costtype", (Object)this.getCostTypeId());
    }

    private void openExpenseItemF7() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"er_expenseitemedit", (boolean)true);
        ListFilterParameter filterParam = new ListFilterParameter();
        filterParam.getQFilters().add(new QFilter("status", "=", (Object)"C"));
        filterParam.getQFilters().add(new QFilter("enable", "=", (Object)true));
        filterParam.getQFilters().add(new QFilter("isleaf", "=", (Object)true));
        DynamicObject costType = BusinessDataServiceHelper.loadSingle((Object)this.getCostTypeId(), (String)"cad_costtype");
        Long orgId = costType.getDynamicObject("createorg").getLong("id");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)orgId);
        if (baseDataFilter != null) {
            filterParam.getQFilters().add(baseDataFilter);
        }
        lsp.setListFilterParameter(filterParam);
        lsp.setSelectedRows(this.getAllFormExpenseItemId().toArray());
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_EXPENSEITEM));
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection ids = (ListSelectedRowCollection)e.getReturnData();
        if (ids == null || ids.size() <= 0) {
            return;
        }
        switch (actionId) {
            case "callbackid_expenseitem": {
                this.fillExpenseItemInfo(ids);
                break;
            }
        }
    }

    private void fillExpenseItemInfo(ListSelectedRowCollection rows) {
        TreeSet<Long> mids = new TreeSet<Long>();
        for (ListSelectedRow row : rows) {
            mids.add((Long)row.getPrimaryKeyValue());
        }
        this.fillExpenseItemInfo(mids);
    }

    private void fillExpenseItemInfo(Set<Long> mids) {
        if (mids == null) {
            return;
        }
        IDataModel model = this.getModel();
        if (model.getEntryRowCount(ENTITY_ENTRY) > 0) {
            model.deleteEntryData(ENTITY_ENTRY);
        }
        for (Long mid : mids) {
            int orgListIndex = model.createNewEntryRow(ENTITY_ENTRY);
            model.setValue(EXPENSEITEMID, (Object)mid, orgListIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if ("btn_save".equals(btn.getKey())) {
            this.save();
        }
    }

    private Long getCostTypeId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String costTypeId = (String)fsp.getCustomParam("costtype");
        if (StringUtils.isEmpty((CharSequence)costTypeId)) {
            return 0L;
        }
        return Long.parseLong(costTypeId);
    }

    private Long getSubelementId() {
        DynamicObject subelement = (DynamicObject)this.getModel().getValue("subelement");
        if (subelement == null) {
            return 0L;
        }
        return subelement.getLong("id");
    }

    private void save() {
        Set<Long> ids = this.getAllFormExpenseItemId();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (!CadEmptyUtils.isEmpty(ids)) {
            for (Long matId : ids) {
                DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"cad_subelemententry");
                item.set("subelement", (Object)this.getSubelementId());
                item.set("costtype", (Object)this.getCostTypeId());
                item.set("expenseitem", (Object)matId);
                item.set("creater", (Object)RequestContext.get().getUserId());
                item.set("modifier", (Object)RequestContext.get().getUserId());
                item.set("modifydate", (Object)new Date());
                item.set("createdate", (Object)new Date());
                list.add(item);
            }
        }
        try (TXHandle txHandle = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"cad_subelemententry", (QFilter[])QFilter.of((String)"subelement = ? and costtype = ?", (Object[])new Object[]{this.getSubelementId(), this.getCostTypeId()}).toArray());
                if (!CadEmptyUtils.isEmpty(list)) {
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_subelemententry");
                    SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SubElementEntryEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                txHandle.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SubElementEntryEdit_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

