/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class BOMVersionUtil {
    private static final String BD_BOMVERSIONRULE = "bd_bomversionrule_new";
    private static final String BD_BOMVERSION = "bd_bomversion_new";
    private static final String KEY_VERSION = "version";
    private static final String KEY_TYPE = "type";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_NAME = "name";
    private static final String KEY_BOMVERSIONRULE = "bomversionrule";
    private static final Log log = LogFactory.getLog(BOMVersionUtil.class);

    public static DynamicObject getAutoVersion(Object orgId, Object materId, Object ruleId) {
        QFilter qFilter = new QFilter("id", "=", ruleId);
        DynamicObject rules = BusinessDataServiceHelper.loadSingleFromCache((String)BD_BOMVERSIONRULE, (String)"entryentity.version,entryentity.id", (QFilter[])new QFilter[]{qFilter});
        if (rules == null) {
            return null;
        }
        DynamicObjectCollection entryrules = rules.getDynamicObjectCollection("entryentity");
        Set<String> versionSet = entryrules.stream().map(p -> p.getString(KEY_VERSION)).collect(Collectors.toSet());
        Set<String> existsSet = BOMVersionUtil.checkIsQuoteVersion(orgId, materId, versionSet);
        for (DynamicObject row : entryrules) {
            String version = row.getString(KEY_VERSION);
            if (existsSet.contains(materId + "_" + version)) continue;
            return row;
        }
        return null;
    }

    public static Set<String> checkIsQuoteVersion(Object orgId, Object materId, Set<String> versions) {
        HashSet<String> isExistsSet = new HashSet<String>(16);
        if (orgId != null && materId != null && versions != null && !versions.isEmpty()) {
            QFilter qFilter = new QFilter(KEY_MATERIAL, "=", materId);
            QFilter qFilter2 = new QFilter(KEY_NAME, "in", versions);
            QFilter qFilter4 = new QFilter(KEY_TYPE, "=", (Object)"A");
            DynamicObjectCollection coll = QueryServiceHelper.query((String)BD_BOMVERSION, (String)"material,createorg,name", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter4});
            for (DynamicObject version : coll) {
                isExistsSet.add(version.getLong(KEY_MATERIAL) + "_" + version.getString(KEY_NAME));
            }
        }
        return isExistsSet;
    }

    public static Boolean isQuoteVersion(Object ruleid, Object materId, String version) {
        if (ruleid != null && materId != null && StringUtils.isNotBlank((CharSequence)version)) {
            QFilter qFilter = new QFilter(KEY_MATERIAL, "=", materId);
            QFilter qFilter2 = new QFilter(KEY_NAME, "=", (Object)version);
            QFilter qFilter3 = new QFilter(KEY_BOMVERSIONRULE, "=", ruleid);
            QFilter qFilter4 = new QFilter(KEY_TYPE, "=", (Object)"A");
            if (QueryServiceHelper.exists((String)BD_BOMVERSION, (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3, qFilter4})) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Deprecated
    public static DynamicObject autoCreateBOMVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Date validdate, Date invaliddate) {
        if (BOMVersionUtil.checkExists(createorg, material, rule)) {
            return null;
        }
        return BOMVersionUtil.buildVersion(createorg, material, rule, BOMVersionUtil.getValidDate(validdate), BOMVersionUtil.getInValidDate(invaliddate), 0L);
    }

    private static String getAutoVersionNumber(String materialNumber, String ruleNumber, String version, String type) {
        StringBuilder versionNumber = new StringBuilder();
        versionNumber.append(materialNumber);
        versionNumber.append('-');
        versionNumber.append(ruleNumber);
        versionNumber.append('-');
        versionNumber.append("B".equals(type) ? "route" : ("C".equals(type) ? "formula" : "bom"));
        versionNumber.append('-');
        versionNumber.append(version);
        return versionNumber.toString();
    }

    public static DynamicObject getDefaultVersionRule(String type) {
        String defField = "B".equals(type) ? "isdefaultroute" : ("C".equals(type) ? "isdefaultprograme" : "isdefault");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterType = new QFilter("multype", "like", (Object)("%" + type + "%"));
        QFilter qFilter2 = new QFilter(defField, "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)BD_BOMVERSIONRULE, (String)"id,number,entryentity.version", (QFilter[])new QFilter[]{qFilter2, qFilterStatus, qFilterEnable, qFilterType});
    }

    public static void autoCreateBOMVersion(Long createorgid, Long materialid, Long ruleid) {
        DynamicObject rule;
        DynamicObject material;
        DynamicObject createorg = BusinessDataServiceHelper.loadSingleFromCache((Object)createorgid, (String)"bos_org", (String)"id,number");
        if (BOMVersionUtil.checkExists(createorg, material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialid, (String)"bd_material", (String)"id,number"), rule = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleid, (String)BD_BOMVERSIONRULE, (String)"id,number,entryentity.id,entryentity.version"))) {
            return;
        }
        Date validdate = new Date();
        Date invaliddate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            invaliddate = sdf.parse("2999-12-31");
        }
        catch (ParseException e) {
            log.error("SimpleDateFormat ParseException", (Throwable)e);
        }
        BOMVersionUtil.buildVersion(createorg, material, rule, validdate, invaliddate, 0L);
    }

    private static DynamicObject getMateria(DynamicObject bom) {
        Object masterId;
        DynamicObject material = bom.getDynamicObject(KEY_MATERIAL);
        if (material != null && (masterId = material.get("masterid")) instanceof DynamicObject) {
            return (DynamicObject)masterId;
        }
        return material;
    }

    public static DynamicObject getBomType(DynamicObject bom) {
        Long bomTypeId;
        DynamicObject bomType = bom.getDynamicObject(KEY_TYPE);
        if (bomType == null) {
            DynamicObject newBom = QueryServiceHelper.queryOne((String)bom.getDynamicObjectType().getName(), (String)KEY_TYPE, (QFilter[])new QFilter[]{new QFilter("id", "=", bom.getPkValue())});
            if (newBom == null) {
                return null;
            }
            bomTypeId = newBom.getLong(KEY_TYPE);
        } else {
            bomTypeId = (Long)bomType.getPkValue();
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)bomTypeId, (String)"mpdm_bomtype", (String)"isversion,versionrule");
    }

    public static DynamicObject getBomTypeDefVersionRule(DynamicObject bom) {
        DynamicObject versionRuleNew;
        DynamicObject bomTypeNew = BOMVersionUtil.getBomType(bom);
        if (bomTypeNew == null) {
            return null;
        }
        boolean isversion = bomTypeNew.getBoolean("isversion");
        DynamicObject versionRule = bomTypeNew.getDynamicObject("versionrule");
        DynamicObject dynamicObject = versionRuleNew = isversion && versionRule != null ? versionRule : null;
        if (versionRuleNew != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((String)BD_BOMVERSIONRULE, (String)"id,number,entryentity.version", (QFilter[])new QFilter[]{new QFilter("id", "=", versionRuleNew.getPkValue())});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject createAndGetBomVersion(DynamicObject bom, boolean isCreate, Set<Long> unVersionIdSet) {
        DynamicObject createorg = bom.getDynamicObject("createorg");
        DynamicObject material = BOMVersionUtil.getMateria(bom);
        DynamicObject rule = BOMVersionUtil.getBomTypeDefVersionRule(bom);
        if (rule == null) {
            rule = BOMVersionUtil.getDefaultVersionRule("A");
        }
        if (rule == null) {
            if (!isCreate) {
                return null;
            }
            ErrorCode ec = new ErrorCode("rule", ResManager.loadKDString((String)"\u9ed8\u8ba4\u7248\u672c\u89c4\u5219\u672a\u627e\u5230\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\u3002", (String)"BOMVersionUtil_2", (String)"bd-sbd-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        String lockKey = "mmc_bomversion_" + String.valueOf(material == null ? Integer.valueOf(0) : material.getPkValue());
        DLock lock = DLock.create((String)lockKey, (String)lockKey);
        lock.lock();
        try {
            DynamicObject newBomVersion = BOMVersionUtil.getBomVersion(createorg, material, rule, (Long)bom.getPkValue(), unVersionIdSet, bom.getDataEntityType().getName());
            if (newBomVersion == null && isCreate) {
                Date validdate = new Date();
                Date invaliddate = null;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    invaliddate = sdf.parse("2999-12-31");
                }
                catch (ParseException e) {
                    log.error("SimpleDateFormat ParseException", (Throwable)e);
                }
                newBomVersion = BOMVersionUtil.buildVersion(createorg, material, rule, validdate, invaliddate, (Long)bom.getPkValue());
            }
            DynamicObject dynamicObject = newBomVersion;
            return dynamicObject;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject createBomEntryVersion(DynamicObject bom, DynamicObject material) {
        DynamicObject createorg = bom.getDynamicObject("createorg");
        DynamicObject rule = BOMVersionUtil.getBomTypeDefVersionRule(bom);
        if (rule == null) {
            rule = BOMVersionUtil.getDefaultVersionRule("A");
        }
        if (rule == null) {
            ErrorCode ec = new ErrorCode("rule", ResManager.loadKDString((String)"\u9ed8\u8ba4\u7248\u672c\u89c4\u5219\u672a\u627e\u5230\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\u3002", (String)"BOMVersionUtil_2", (String)"bd-sbd-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        Date validdate = new Date();
        Date invaliddate = BOMVersionUtil.getInValidDate(null);
        String lockKey = "mmc_bomversion_" + String.valueOf(material.getPkValue());
        DLock lock = DLock.create((String)lockKey, (String)lockKey);
        lock.lock();
        try {
            DynamicObject newBomVersion = BOMVersionUtil.getBomVersionByMaterial((Long)createorg.getPkValue(), (Long)material.getPkValue(), (Long)rule.getPkValue());
            if (newBomVersion == null) {
                newBomVersion = BOMVersionUtil.buildVersion(createorg, material, rule, validdate, invaliddate, (Long)bom.getPkValue());
            }
            DynamicObject dynamicObject = newBomVersion;
            return dynamicObject;
        }
        finally {
            lock.unlock();
        }
    }

    private static QFilter[] buildQFilter(Long orgID, Long materialID, Long versionRuleId) {
        Date date = new Date();
        QFilter qFilterMater = new QFilter(KEY_MATERIAL, "=", (Object)materialID);
        qFilterMater.and(new QFilter("enable", "=", (Object)"1"));
        qFilterMater.and(new QFilter("status", "=", (Object)"C"));
        qFilterMater.and(new QFilter("effectdate", "<=", (Object)date));
        qFilterMater.and(new QFilter("invaliddate", ">", (Object)date));
        qFilterMater.and(new QFilter(KEY_TYPE, "=", (Object)"A"));
        if (versionRuleId != null && !versionRuleId.equals(0L)) {
            qFilterMater.and(new QFilter(KEY_BOMVERSIONRULE, "=", (Object)versionRuleId));
        }
        return new QFilter[]{qFilterMater};
    }

    public static DynamicObject getBomVersionByMaterial(Long orgID, Long materialID, Long versionRuleId) {
        Long id = 0L;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-BomversionUtil-getBomVersionByMaterial", (String)BD_BOMVERSION, (String)"id,versionname.entryseq entryseq", (QFilter[])BOMVersionUtil.buildQFilter(orgID, materialID, versionRuleId), (String)"versionname.entryseq desc").top(1);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                id = arow.getLong("id");
            }
        }
        return id.equals(0L) ? null : BOMVersionUtil.getCurrentVersionById(id);
    }

    public static DynamicObject getBomVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Long bomId, String entityName) {
        return BOMVersionUtil.getBomVersion(createorg, material, rule, bomId, null, entityName);
    }

    public static DynamicObject getBomVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Long bomId, Set<Long> unVersionIdSet, String entityName) {
        Long materialId = 0L;
        if (material != null) {
            materialId = (Long)material.getPkValue();
        }
        QFilter qFilter = new QFilter(KEY_MATERIAL, "=", (Object)materialId);
        qFilter.and(new QFilter(KEY_BOMVERSIONRULE, "=", rule.getPkValue()));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter(KEY_TYPE, "=", (Object)"A"));
        if (unVersionIdSet != null && !unVersionIdSet.isEmpty()) {
            qFilter.and(new QFilter("id", "not in", unVersionIdSet));
        }
        Date date = new Date();
        QFilter qFilterDate = new QFilter("effectdate", "<=", (Object)date);
        qFilterDate.and(new QFilter("invaliddate", ">", (Object)date));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)BD_BOMVERSION, (String)"id,name,versionname.entryseq entryseq", (QFilter[])new QFilter[]{qFilter, qFilterDate}, (String)"versionname.entryseq desc ");
        Set versionIdSet = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
        if (versionIdSet == null || versionIdSet.isEmpty()) {
            return null;
        }
        String bomEntityNumber = entityName == null || "".equals(entityName) ? "pdm_mftbom" : entityName;
        List<Long> versionIdList = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        qFilter = new QFilter("materialid", "=", (Object)materialId);
        qFilter.and(new QFilter(KEY_VERSION, "in", versionIdSet));
        qFilter.and(new QFilter("id", "<>", (Object)bomId));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)bomEntityNumber, (Long)createorg.getLong("id")));
        DynamicObjectCollection bomVersionColl = QueryServiceHelper.query((String)bomEntityNumber, (String)KEY_VERSION, (QFilter[])new QFilter[]{qFilter}, (String)"");
        Set<Long> bomVersionIdSet = bomVersionColl.stream().map(p -> p.getLong(KEY_VERSION)).collect(Collectors.toSet());
        Long maxVersionId = BOMVersionUtil.getNotUsedVersionId(versionIdList, bomVersionIdSet);
        return maxVersionId == null || maxVersionId.equals(0L) ? null : BOMVersionUtil.getCurrentVersionById(maxVersionId);
    }

    public static Long getNotUsedVersionId(List<Long> versionIdList, Set<Long> bomVersionIdSet) {
        int maxSeq = -1;
        int size = versionIdList.size();
        int i = 0;
        while (i < size) {
            Long id = versionIdList.get(i);
            if (bomVersionIdSet.contains(id)) {
                maxSeq = i - 1;
                break;
            }
            maxSeq = i++;
        }
        return maxSeq >= 0 ? versionIdList.get(maxSeq) : Long.valueOf(0L);
    }

    public static boolean checkExists(DynamicObject createorg, DynamicObject material, DynamicObject rule) {
        if (material != null && rule != null) {
            QFilter matefilter = new QFilter(KEY_MATERIAL, "=", material.getPkValue());
            QFilter vseionfilter = new QFilter(KEY_BOMVERSIONRULE, "=", rule.getPkValue());
            return QueryServiceHelper.exists((String)BD_BOMVERSION, (QFilter[])new QFilter[]{matefilter, vseionfilter});
        }
        return false;
    }

    public static DynamicObject buildVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Date validdate, Date invaliddate, Long srcBillId) {
        if (createorg == null) {
            ErrorCode ec = new ErrorCode("createorg", ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\u3002", (String)"BOMVersionUtil_0", (String)"bd-sbd-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        if (material == null) {
            ErrorCode ec = new ErrorCode(KEY_MATERIAL, ResManager.loadKDString((String)"\u7269\u6599\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\u3002", (String)"BOMVersionUtil_1", (String)"bd-sbd-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        if (rule == null) {
            ErrorCode ec = new ErrorCode("rule", ResManager.loadKDString((String)"\u9ed8\u8ba4\u7248\u672c\u89c4\u5219\u672a\u627e\u5230\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\u3002", (String)"BOMVersionUtil_2", (String)"bd-sbd-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        DynamicObject version = BOMVersionUtil.getAutoVersionWithDynamicObject(createorg.getPkValue(), material.getPkValue(), rule.getPkValue());
        if (version == null) {
            ErrorCode ec = new ErrorCode(KEY_VERSION, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u7528\u7248\u672c\u53f7\uff0c\u4e0d\u5141\u8bb8\u521b\u5efaBOM\u7248\u672c\u3002", (String)"BOMVersionUtil_3", (String)"bd-sbd-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        ORM orm = ORM.create();
        DynamicObject bomversion = orm.newDynamicObject(BD_BOMVERSION);
        DynamicObject versionf7 = BusinessDataServiceHelper.loadSingleFromCache((Object)version.getLong("id"), (String)"bd_bomversionruleentry_f7", (String)"id,version,entryseq");
        bomversion.set(KEY_NAME, (Object)version.getString(KEY_VERSION));
        bomversion.set(KEY_BOMVERSIONRULE, (Object)rule);
        bomversion.set(KEY_TYPE, (Object)"A");
        bomversion.set(KEY_MATERIAL, (Object)material);
        bomversion.set("createorg", (Object)createorg);
        bomversion.set("effectdate", (Object)BOMVersionUtil.getValidDate(validdate));
        bomversion.set("invaliddate", (Object)BOMVersionUtil.getInValidDate(invaliddate));
        bomversion.set("enable", (Object)"1");
        bomversion.set("status", (Object)"C");
        bomversion.set("ctrlstrategy", (Object)"5");
        bomversion.set("srcbillid", (Object)srcBillId);
        bomversion.set("versionname", (Object)versionf7);
        bomversion.set("number", (Object)BOMVersionUtil.getAutoVersionNumber(material.getString("number"), rule.getString("number"), versionf7.getString(KEY_VERSION), "A"));
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)BD_BOMVERSION, (DynamicObject[])new DynamicObject[]{bomversion}, (OperateOption)BOMVersionUtil.getOperateOption());
        if (!operateResult.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo info : operateResult.getAllErrorOrValidateInfo()) {
                sb.append(info.getMessage()).append('\n');
            }
            if (sb.length() <= 0) {
                sb.append(operateResult.getMessage());
            }
            ErrorCode ec = new ErrorCode("save", sb.toString());
            throw new KDBizException(ec, new Object[0]);
        }
        List addPkIds = operateResult.getSuccessPkIds();
        QFilter qFilter3 = new QFilter("id", "in", (Object)addPkIds);
        return BOMVersionUtil.getCurrentVersionByFilter(qFilter3);
    }

    public static OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    public static Date getValidDate(Date validdate) {
        return validdate == null ? new Date() : validdate;
    }

    public static Date getInValidDate(Date invaliddate) {
        if (invaliddate == null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                invaliddate = sdf.parse("2999-12-31");
            }
            catch (ParseException e) {
                log.error("SimpleDateFormat ParseException", (Throwable)e);
            }
        }
        return invaliddate;
    }

    public static DynamicObject getAutoVersionWithDynamicObject(Object orgId, Object materId, Object ruleId) {
        int maxSeq = BOMVersionUtil.getExistsVersionMaxSeq(orgId, materId, ruleId);
        return BOMVersionUtil.getNotBomVersionDynamicObject(ruleId, maxSeq);
    }

    private static int getExistsVersionMaxSeq(Object orgId, Object materId, Object ruleId) {
        QFilter qFilter1 = new QFilter(KEY_MATERIAL, "=", materId);
        QFilter qFilter2 = new QFilter(KEY_BOMVERSIONRULE, "=", ruleId);
        QFilter qFilter3 = new QFilter(KEY_TYPE, "=", (Object)"A");
        String selectProperties = "versionname.entryseq entryseq";
        int maxSeq = -1;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(BOMVersionUtil.class.getName() + "getExistsVersionMaxSeq"), (String)BD_BOMVERSION, (String)selectProperties, (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)" versionname.entryseq desc ");){
            for (Row arow : ds) {
                if (maxSeq >= arow.getInteger("entryseq")) continue;
                maxSeq = arow.getInteger("entryseq");
            }
        }
        return maxSeq;
    }

    private static DynamicObject getNotBomVersionDynamicObject(Object ruleId, int maxSeq) {
        DynamicObjectCollection rules;
        QFilter qFilter = new QFilter("id", "=", ruleId);
        if (maxSeq >= 0) {
            qFilter.and(new QFilter("entryentity.seq", ">", (Object)maxSeq));
        }
        if ((rules = QueryServiceHelper.query((String)BD_BOMVERSIONRULE, (String)"entryentity.id id,entryentity.version version,entryentity.seq seq", (QFilter[])new QFilter[]{qFilter}, (String)"entryentity.seq")) == null || rules.isEmpty()) {
            return null;
        }
        return (DynamicObject)rules.get(0);
    }

    public static DynamicObject getInitVersion(DynamicObject createorg, DynamicObject material, String type) {
        if (material == null || createorg == null) {
            return null;
        }
        DynamicObject rule = BOMVersionUtil.getDefaultVersionRule(type);
        return rule == null ? null : BOMVersionUtil.getVersion(createorg, material, rule, type);
    }

    public static DynamicObject getVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, String type) {
        QFilter qFilter = new QFilter(KEY_MATERIAL, "=", material.getPkValue());
        qFilter.and(new QFilter(KEY_BOMVERSIONRULE, "=", rule.getPkValue()));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter(KEY_TYPE, "=", (Object)type));
        Date date = new Date();
        QFilter qFilterDate = new QFilter("effectdate", "<=", (Object)date);
        qFilterDate.and(new QFilter("invaliddate", ">", (Object)date));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)BD_BOMVERSION, (String)"id,name,versionname.entryseq entryseq", (QFilter[])new QFilter[]{qFilter, qFilterDate}, (String)"versionname.entryseq");
        Set versionIdSet = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
        if (versionIdSet == null || versionIdSet.isEmpty()) {
            return null;
        }
        List versionIdList = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        return BOMVersionUtil.getCurrentVersionById((Long)versionIdList.get(0));
    }

    public static DynamicObject getCurrentVersionById(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return BOMVersionUtil.getCurrentVersionByFilter(qFilter);
    }

    public static DynamicObject getCurrentVersionByFilter(QFilter qfilter) {
        return BusinessDataServiceHelper.loadSingle((String)BD_BOMVERSION, (String)BOMVersionUtil.getVersonSelectProperties(), (QFilter[])new QFilter[]{qfilter});
    }

    private static String getVersonSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",name");
        sb.append(",material");
        sb.append(",ecnbillno");
        sb.append(",srcbillid");
        return sb.toString();
    }

    public static boolean isAutoGenEntryVersion(Long orgId) {
        return BOMVersionUtil.getBizAppParam(orgId, "bomsubmitautogenvera", "fmm");
    }

    public static boolean isAutoGenCopEntryVersion(Long orgId) {
        return BOMVersionUtil.getBizAppParam(orgId, "bomsubmitautogenverb", "fmm");
    }

    public static boolean isEnableProgrameVersion(Long orgId) {
        return BOMVersionUtil.getBizAppParam(orgId, "isopeprogrameversion", "fmm", false);
    }

    public static boolean getBizAppParam(Long orgId, String paramNumber, String bizAppNum) {
        return BOMVersionUtil.getBizAppParam(orgId, paramNumber, bizAppNum, true);
    }

    public static boolean getBizAppParam(Long orgId, String paramNumber, String bizAppNum, Object defaultValue) {
        AppParam appParam = new AppParam();
        DynamicObject bizApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizAppNum)});
        appParam.setAppId(bizApp.getString("id"));
        String orgfunc = bizApp.getString("orgfunc");
        if (StringUtils.isEmpty((CharSequence)orgfunc)) {
            orgfunc = "15";
        }
        appParam.setViewType(orgfunc);
        appParam.setOrgId(orgId);
        appParam.setActBookId(Long.valueOf(0L));
        Map syPparams = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return (Boolean)syPparams.getOrDefault(paramNumber, defaultValue);
    }
}

