/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.formplugin.classstandard;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.gmc.common.f7.F7Utils;
import kd.bd.gmc.common.util.CommonUtils;
import kd.bd.gmc.util.ItemClassStandardUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class GroupClassStandardList
extends StandardTreeListPlugin {
    private static Log logger = LogFactory.getLog(GroupClassStandardList.class);
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String NO_GROUP = "0";
    public static final String PROP_ID = "id";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_GROUP = "group";
    public static final String PROP_LONGNUMBER = "longnumber";
    private static final String PARAM_INIT_GROUP_ID = "initGROUPId";
    private static final String USEORG_FILEDNAME = "useorg.id";
    public static final String OP_OPEN = "btn_open";
    public static final String CP_GROUPSTANDARD = "groupStandard";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getValue(PROP_STANDARDLST) == null) {
            TreeNode root;
            TreeView treeView;
            ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
            List<Map<String, Object>> standardLists = this.getComData();
            this.setComboEdit(standardLists);
            String groupStandard = "";
            if (param.getCustomParam(CP_GROUPSTANDARD) != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam(CP_GROUPSTANDARD).toString())) {
                groupStandard = param.getCustomParam(CP_GROUPSTANDARD).toString();
            }
            String defGroupStandard = "1";
            ArrayList<String> standardIds = new ArrayList<String>();
            if (standardLists != null && standardLists.size() > 0) {
                for (Map<String, Object> standardMap : standardLists) {
                    standardIds.add(standardMap.get(PROP_ID).toString());
                }
            }
            if (standardIds == null || standardIds.size() == 0) {
                treeView = this.getTreeListView().getTreeView();
                root = this.getTreeModel().createRootNode();
                if (root == null) {
                    this.treeListView.refreshTreeView();
                } else {
                    this.treeListView.getTreeView().deleteAllNodes();
                    treeView.addNode(root);
                    this.getModel().setValue(PROP_STANDARDLST, (Object)"");
                    treeView.treeNodeClick("", root.getId());
                }
                return;
            }
            if (!standardIds.contains(defGroupStandard)) {
                groupStandard = (String)standardIds.get(0);
            }
            if (!StringUtils.isBlank((CharSequence)groupStandard)) {
                this.getModel().setValue(PROP_STANDARDLST, (Object)groupStandard);
            } else {
                this.getModel().setValue(PROP_STANDARDLST, (Object)defGroupStandard);
            }
            this.getView().updateView(PROP_STANDARDLST);
            if (groupStandard != null && !groupStandard.equals(defGroupStandard)) {
                treeView = this.getTreeListView().getTreeView();
                root = this.getTreeModel().createRootNode();
                if (root == null) {
                    this.treeListView.refreshTreeView();
                } else {
                    this.treeListView.getTreeView().deleteAllNodes();
                    treeView.addNode(root);
                    treeView.treeNodeClick("", root.getId());
                }
            }
        }
    }

    private QFilter genRefreshFilter(String nodeId) {
        if (ROOTNODEID.equals(nodeId)) {
            return null;
        }
        QFilter qFilter = null;
        Object classStandardId = this.getModel().getValue(PROP_STANDARDLST);
        QFilter f1 = new QFilter("classstandardid", "=", (Object)Long.parseLong(classStandardId.toString()));
        QFilter[] qFilters = null;
        if (null != nodeId && !NO_GROUP.equals(nodeId)) {
            List<Long> groupIds = this.queryGroupsByGroupId("mdr_item_class", classStandardId, nodeId);
            QFilter f2 = new QFilter("goodsclasssid", "in", groupIds);
            qFilters = new QFilter[]{f1, f2};
        } else {
            qFilters = new QFilter[]{f1};
        }
        HashSet<Long> itemIdSets = new HashSet<Long>();
        DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)"bd_itemclassentry", (String)PROP_ID, (QFilter[])qFilters);
        for (DynamicObject itemDynObj : itemDynObjColl) {
            itemIdSets.add(itemDynObj.getLong(PROP_ID));
        }
        qFilter = NO_GROUP.equals(nodeId) ? new QFilter(PROP_ID, "not in", itemIdSets) : new QFilter(PROP_ID, "in", itemIdSets);
        return qFilter;
    }

    private List<Long> queryGroupsByGroupId(String entity, Object standardId, Object id) {
        if (id == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)entity, (String)"longnumber,isleaf", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "=", (Object)Long.parseLong(id.toString()))});
        if (queryOne.getBoolean("isleaf")) {
            list.add(Long.parseLong(id.toString()));
            return list;
        }
        String longnumber = queryOne.getString(PROP_LONGNUMBER);
        QFilter f1 = new QFilter(PROP_LONGNUMBER, "like", (Object)(longnumber + "%"));
        QFilter f2 = new QFilter("standard", "=", (Object)Long.parseLong(standardId.toString()));
        QFilter[] qFilters = new QFilter[]{f1, f2};
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(ItemClassStandardUtils.class.getName(), entity, PROP_ID, qFilters);){
            for (Row row : ds) {
                if (row.getString(PROP_ID) == null) continue;
                list.add(Long.parseLong(row.getString(PROP_ID)));
            }
        }
        return list;
    }

    private List<Map<String, Object>> getComData() {
        QFilter[] qFilterArray;
        String createOrg = this.getPageCache().get("createOrg");
        QFilter enableFilter = F7Utils.getEnableFilter();
        QFilter authorizedFilter = null;
        if (createOrg != null) {
            authorizedFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_goodsclassstandard", (Long)Long.parseLong(createOrg));
        } else {
            DynamicObjectCollection authorizedOrgs = CommonUtils.getAllCuOrg((String)"bd_goodsclassstandard");
            if (authorizedOrgs == null || authorizedOrgs.size() == 0) {
                return new ArrayList<Map<String, Object>>(0);
            }
            HashSet<Object> filterStrSet = new HashSet<Object>();
            authorizedFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_goodsclassstandard", (Long)((DynamicObject)authorizedOrgs.get(0)).getLong(PROP_ID));
            if (!CommonUtils.isNull((Object)authorizedFilter)) {
                filterStrSet.add(authorizedFilter.getValue());
            }
            QFilter idFilter = null;
            int count = authorizedOrgs.size();
            for (int i = 1; i < count; ++i) {
                if (authorizedFilter == null) {
                    authorizedFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_goodsclassstandard", (Long)((DynamicObject)authorizedOrgs.get(i)).getLong(PROP_ID));
                    if (CommonUtils.isNull((Object)authorizedFilter)) continue;
                    filterStrSet.add(authorizedFilter.getValue());
                    continue;
                }
                idFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_goodsclassstandard", (Long)((DynamicObject)authorizedOrgs.get(i)).getLong(PROP_ID));
                if (CommonUtils.isNull((Object)idFilter)) continue;
                if (!filterStrSet.contains(idFilter.getValue())) {
                    authorizedFilter.or(idFilter);
                    continue;
                }
                filterStrSet.add(idFilter.getValue());
            }
        }
        if (authorizedFilter == null) {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = enableFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[2];
            qFilterArray3[0] = enableFilter;
            qFilterArray = qFilterArray3;
            qFilterArray3[1] = authorizedFilter;
        }
        QFilter[] qfilers = qFilterArray;
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"bd_goodsclassstandard", (String)String.join((CharSequence)",", PROP_ID, "number", "name", "ispreset"), (QFilter[])qfilers);
        if (bizMap == null || bizMap.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> listStandard = new ArrayList<Map<String, Object>>(16);
        for (Map.Entry entry : bizMap.entrySet()) {
            DynamicObject dyStandard = (DynamicObject)entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put(PROP_ID, dyStandard.get(PROP_ID).toString());
            map.put("name", dyStandard.get("name").toString());
            map.put("ispreset", dyStandard.getBoolean("ispreset") ? "1" : NO_GROUP);
            listStandard.add(map);
        }
        return listStandard;
    }

    private void setComboEdit(List<Map<String, Object>> orgDataList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, this.setComboItems(orgDataList));
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private Map<String, LocaleString> setComboItems(List<Map<String, Object>> orgModelList) {
        HashMap<String, LocaleString> comboItems = new HashMap<String, LocaleString>(16);
        if (orgModelList != null && orgModelList.size() > 0) {
            boolean isPreset = false;
            Object standardId = 1;
            for (Map<String, Object> map : orgModelList) {
                if (!"1".equals((String)map.get("ispreset"))) continue;
                standardId = map.get(PROP_ID);
                isPreset = true;
                break;
            }
            for (Map<String, Object> map : orgModelList) {
                String id = (String)map.get(PROP_ID);
                String fName = (String)map.get("name");
                comboItems.put(id, new LocaleString(fName));
            }
            if (!isPreset) {
                standardId = orgModelList.get(0).get(PROP_ID);
            }
            this.getModel().setValue(PROP_STANDARDLST, standardId);
        }
        return comboItems;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        if (NO_GROUP.equals(nodeId)) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{OP_OPEN});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5206\u7c7b\u6807\u51c6\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel treeModel;
        String nodeId = e.getNodeId().toString();
        if (NO_GROUP.equalsIgnoreCase(nodeId)) {
            e.setChildNodes(new ArrayList());
            return;
        }
        String isOpenAll = this.getPageCache().get("isOpenAll");
        boolean flag = false;
        if (isOpenAll != null && Boolean.TRUE.toString().equals(isOpenAll)) {
            flag = true;
        }
        String textFormat = "";
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            textFormat = treeListModel.getTextFormat();
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId, flag, flag, textFormat);
        if (nodeId.equals(this.getTreeModel().getRoot().getId())) {
            String NODE_NAME_UNKNOWN = ResManager.loadKDString((String)"\u672a\u5206\u7c7b", (String)"GroupClassStandardList_0", (String)"bd-gmc-formplugin", (Object[])new Object[0]);
            TreeNode noOrgNode = new TreeNode(nodeId, NO_GROUP, NODE_NAME_UNKNOWN, false);
            treeNodes.add(noOrgNode);
        }
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId, boolean isGetAllSub, boolean isOpen, String textFormat) {
        DynamicObject[] loads;
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Object value = this.getModel().getValue(PROP_STANDARDLST);
        if (CommonUtils.isNull((Object)value) && CommonUtils.isNull((Object)this.getModel().getValue(PROP_STANDARDLST))) {
            value = "1";
        }
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = NO_GROUP;
        }
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.parseLong(value.toString()));
        QFilter qFilter2 = new QFilter(PROP_PARENT, "=", (Object)Long.parseLong(nodeId));
        for (DynamicObject group : loads = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2})) {
            if (group.getPkValue() == null) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getPkValue().toString());
            treeNode.setParentid(group.get(PROP_PARENT) == null ? ROOTNODEID : group.getDynamicObject(PROP_PARENT).getPkValue().toString());
            String name = group.getLocaleString("name").getLocaleValue();
            String number = group.getString("number");
            if (StringUtils.isBlank((CharSequence)name)) {
                name = group.getString("name");
            }
            String text = "";
            if (StringUtils.isNotBlank((CharSequence)textFormat)) {
                text = textFormat.replace("{name}", name).replace("{code}", number);
            }
            if (StringUtils.isBlank((CharSequence)text)) {
                treeNode.setText(name);
            } else {
                treeNode.setText(text);
            }
            treeNode.setLongNumber(group.getString(PROP_LONGNUMBER));
            Object parentNode = group.get("isleaf");
            if (parentNode != null && !((Boolean)parentNode).booleanValue()) {
                if (isGetAllSub) {
                    treeNode.addChildren(this.getTreeChildren(group.getPkValue().toString(), isGetAllSub, isOpen, textFormat));
                } else {
                    treeNode.addChildren(new ArrayList());
                }
            }
            if (isOpen) {
                treeNode.setIsOpened(isOpen);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctr = (Control)evt.getSource();
        if (ctr == null) {
            return;
        }
        String itemkey = ctr.getKey();
        if (OP_OPEN.equals(itemkey)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            String oldFocusNodeId = treeView.getTreeState().getFocusNodeId();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.getPageCache().put("isOpenAll", "true");
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                this.treeListView.getTreeView().queryTreeNodeChildren(root.getParentid(), root.getId());
                if (oldFocusNodeId != null && !ROOTNODEID.equals(oldFocusNodeId)) {
                    this.getPageCache().put("isOpenAll", "true");
                    treeView.treeNodeClick("", oldFocusNodeId);
                }
                this.getPageCache().remove("isOpenAll");
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        List qFilters = e.getQFilters();
        QFilter filter = this.genRefreshFilter(nodeId);
        if (filter != null) {
            qFilters.add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String orgId = null;
        for (Map customFiter : customFiterList) {
            String createOrg;
            List orgIds;
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            if (orgId.equals(createOrg = this.getPageCache().get("createOrg"))) {
                return;
            }
            this.getPageCache().put("createOrg", orgId);
            List<Map<String, Object>> orgList = this.getComData();
            this.setComboEdit(orgList);
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
            break;
        }
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }
}

