/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.formplugin.itemclass;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.gmc.common.f7.F7Utils;
import kd.bd.gmc.common.util.CommonUtils;
import kd.bd.gmc.util.ItemClassStandardUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ItemClassTreeList
extends StandardTreeListPlugin {
    private static Log logger = LogFactory.getLog(ItemClassTreeList.class);
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String NO_GROUP = "1";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_GROUP = "group";
    public static final String PROP_LONGNUMBER = "longnumber";
    public static final String PROP_ENABLE = "enable";
    public static final char SPLIT_LONG_NUMBER = '!';
    public static final String AP_BILL_LIST = "billlistap";
    public static final String OP_OPEN = "btn_open";
    private static final String ISCONTAINLOWER = "iscontainlower";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.TRUE, new String[]{ISCONTAINLOWER});
        if (this.getModel().getValue(PROP_STANDARDLST) == null) {
            TreeNode root;
            TreeView treeView;
            List<DynamicObject> standardList = this.getComData();
            this.setComboEdit(standardList);
            String groupStandard = this.getClassStandardId();
            String defGroupStandard = NO_GROUP;
            ArrayList<String> standardIdList = new ArrayList<String>();
            if (standardList != null && standardList.size() > 0) {
                for (DynamicObject standardDynObj : standardList) {
                    standardIdList.add(standardDynObj.get("id").toString());
                }
            }
            if (standardIdList == null || standardIdList.size() == 0) {
                treeView = this.getTreeListView().getTreeView();
                root = this.getTreeModel().createRootNode();
                if (root == null) {
                    this.treeListView.refreshTreeView();
                } else {
                    this.treeListView.getTreeView().deleteAllNodes();
                    treeView.addNode(root);
                    this.getModel().setValue(PROP_STANDARDLST, (Object)"");
                    treeView.treeNodeClick("", root.getId());
                }
                return;
            }
            if (!standardIdList.contains(defGroupStandard)) {
                groupStandard = (String)standardIdList.get(0);
            }
            if (!StringUtils.isBlank((CharSequence)groupStandard)) {
                this.getModel().setValue(PROP_STANDARDLST, (Object)groupStandard);
            } else {
                this.getModel().setValue(PROP_STANDARDLST, (Object)defGroupStandard);
            }
            this.getView().updateView(PROP_STANDARDLST);
            if (groupStandard != null && !groupStandard.equals(defGroupStandard)) {
                treeView = this.getTreeListView().getTreeView();
                root = this.getTreeModel().createRootNode();
                if (root == null) {
                    this.treeListView.refreshTreeView();
                } else {
                    this.treeListView.getTreeView().deleteAllNodes();
                    treeView.addNode(root);
                    treeView.treeNodeClick("", root.getId());
                }
            }
        }
    }

    private QFilter genRefreshFilter(String nodeId) {
        QFilter qFilter = null;
        String classStandardId = (String)this.getModel().getValue(PROP_STANDARDLST);
        if (CommonUtils.isNull((Object)classStandardId)) {
            classStandardId = this.getClassStandardId();
        }
        this.getPageCache().put("standard", classStandardId);
        qFilter = new QFilter("standard", "=", (Object)Long.parseLong(classStandardId));
        if (ROOTNODEID.equals(nodeId) || nodeId == null) {
            return qFilter;
        }
        boolean iscontainlower = true;
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if (param.isLookUp()) {
            iscontainlower = (Boolean)this.getModel().getValue(ISCONTAINLOWER);
        }
        long classId = Long.parseLong(nodeId);
        if (iscontainlower) {
            List<Long> groupIds = this.queryGroupsByGroupId("mdr_item_class", classStandardId, nodeId);
            qFilter = qFilter.and(new QFilter("id", "in", groupIds));
        } else {
            QFilter filter = new QFilter("id", "in", (Object)classId);
            qFilter = qFilter.and(filter);
        }
        return qFilter;
    }

    private String getClassStandardId() {
        String classStandardId = NO_GROUP;
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if (param.getCustomParam("groupStandard") != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam("groupStandard").toString())) {
            classStandardId = param.getCustomParam("groupStandard").toString();
        }
        return classStandardId;
    }

    private List<Long> queryGroupsByGroupId(String entity, Object standardId, Object id) {
        if (id == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>(1);
        long itemClassId = Long.parseLong(id.toString());
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)entity, (String)String.join((CharSequence)",", PROP_LONGNUMBER, "isleaf"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)itemClassId)});
        if (queryOne != null) {
            if (queryOne.getBoolean("isleaf")) {
                list.add(itemClassId);
                return list;
            }
            String longnumber = queryOne.getString(PROP_LONGNUMBER);
            QFilter f1 = new QFilter(PROP_LONGNUMBER, "like", (Object)(longnumber + ".%"));
            QFilter f2 = new QFilter("standard", "=", (Object)Long.parseLong(standardId.toString()));
            QFilter[] qFilters = new QFilter[]{f1, f2};
            ORM ormOV = ORM.create();
            try (DataSet ds = ormOV.queryDataSet(ItemClassStandardUtils.class.getName(), entity, "id", qFilters);){
                for (Row row : ds) {
                    if (row.getString("id") == null) continue;
                    list.add(row.getLong("id"));
                }
            }
            list.add(itemClassId);
        }
        return list;
    }

    private List<DynamicObject> getComData() {
        QFilter[] qFilterArray;
        String createOrg = this.getPageCache().get("createOrg");
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String defGroupStandard = "";
        if (param.getCustomParam("groupStandard") != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam("groupStandard").toString())) {
            defGroupStandard = param.getCustomParam("groupStandard").toString();
        }
        boolean isSelfRun = "ocdbd_selfrunitemclass".equals(param.getBillFormId());
        if (NO_GROUP.equals(param.getCustomParam("classtype"))) {
            isSelfRun = true;
        }
        if (isSelfRun) {
            defGroupStandard = NO_GROUP;
        }
        QFilter enableFilter = F7Utils.getEnableFilter();
        QFilter authorizedFilter = null;
        if (StringUtils.isBlank((CharSequence)defGroupStandard)) {
            if (createOrg != null) {
                authorizedFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_goodsclassstandard", (Long)Long.parseLong(createOrg));
            }
        } else {
            authorizedFilter = new QFilter("id", "=", (Object)Long.parseLong(defGroupStandard));
        }
        enableFilter = enableFilter.and(new QFilter("scope", "like", (Object)"%0%"));
        if (authorizedFilter == null) {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = enableFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[2];
            qFilterArray3[0] = enableFilter;
            qFilterArray = qFilterArray3;
            qFilterArray3[1] = authorizedFilter;
        }
        QFilter[] qfilers = qFilterArray;
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"bd_goodsclassstandard", (String)String.join((CharSequence)",", "id", "number", "name", "ispreset"), (QFilter[])qfilers);
        if (bizMap == null || bizMap.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(bizMap.values());
    }

    private void setComboEdit(List<DynamicObject> standardList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, this.setComboItems(standardList));
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        if (CollectionUtils.isEmpty(value)) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private Map<String, LocaleString> setComboItems(List<DynamicObject> standardList) {
        HashMap<String, LocaleString> comboItems = new HashMap<String, LocaleString>();
        if (standardList != null && standardList.size() > 0) {
            for (DynamicObject map : standardList) {
                String id = map.getString("id");
                String fName = map.getString("name");
                comboItems.put(id, new LocaleString(fName));
            }
            this.getModel().setValue(PROP_STANDARDLST, this.getDefaultStandardId(standardList));
        }
        return comboItems;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{OP_OPEN});
        this.getView().setVisible(Boolean.TRUE, new String[]{ISCONTAINLOWER});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
        this.getView().setVisible(Boolean.TRUE, new String[]{ISCONTAINLOWER});
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5206\u7c7b\u6807\u51c6\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel treeModel;
        String nodeId = e.getNodeId().toString();
        if (NO_GROUP.equalsIgnoreCase(nodeId)) {
            e.setChildNodes(new ArrayList());
            return;
        }
        String isOpenAll = this.getPageCache().get("isOpenAll");
        boolean flag = false;
        if (isOpenAll != null && Boolean.TRUE.toString().equals(isOpenAll)) {
            flag = true;
        }
        String textFormat = "";
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            textFormat = treeListModel.getTextFormat();
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId, flag, flag, textFormat);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId, boolean isGetAllSub, boolean isOpen, String textFormat) {
        DynamicObject[] loads;
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Object classStandardId = this.getModel().getValue(PROP_STANDARDLST);
        if (CommonUtils.isNull((Object)classStandardId)) {
            classStandardId = this.getClassStandardId();
        }
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.parseLong(classStandardId.toString()));
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = "0";
        }
        qFilter.and(new QFilter(PROP_PARENT, "=", (Object)Long.parseLong(nodeId)));
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isSelfRun = "ocdbd_selfrunitemclass".equals(param.getBillFormId());
        if (NO_GROUP.equals(param.getCustomParam("classtype"))) {
            isSelfRun = true;
        }
        qFilter.and(new QFilter("classtype", isSelfRun ? "=" : "!=", (Object)NO_GROUP));
        Object obj = param.getCustomParam("createchannelid");
        if (obj instanceof Long) {
            qFilter.and(new QFilter("createchannelid", "=", (Object)Long.parseLong(obj.toString())));
        }
        qFilter.and(PROP_ENABLE, "=", (Object)NO_GROUP);
        for (DynamicObject group : loads = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)String.join((CharSequence)",", "id", "number", "name", PROP_PARENT, PROP_LONGNUMBER, "isleaf"), (QFilter[])qFilter.toArray(), (String)"number")) {
            if (group.getPkValue() == null) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getPkValue().toString());
            treeNode.setParentid(group.get(PROP_PARENT) == null ? ROOTNODEID : group.get(PROP_PARENT).toString());
            String name = group.getLocaleString("name").getLocaleValue();
            String number = group.getString("number");
            if (StringUtils.isBlank((CharSequence)name)) {
                name = group.getString("name");
            }
            String text = "-";
            if (StringUtils.isNotBlank((CharSequence)textFormat)) {
                if (textFormat.contains("{name}") && StringUtils.isNotBlank((CharSequence)name)) {
                    text = textFormat.replace("{name}", name);
                }
                if (textFormat.contains("{code}") && StringUtils.isNotBlank((CharSequence)number)) {
                    text = textFormat.replace("{code}", number);
                }
            }
            if (StringUtils.isBlank((CharSequence)text)) {
                treeNode.setText(name);
            } else {
                treeNode.setText(text);
            }
            treeNode.setLongNumber(group.getString(PROP_LONGNUMBER));
            Object parentNode = group.get("isleaf");
            if (parentNode != null && !((Boolean)parentNode).booleanValue()) {
                if (isGetAllSub) {
                    treeNode.addChildren(this.getTreeChildren(group.getPkValue().toString(), isGetAllSub, isOpen, textFormat));
                } else {
                    treeNode.addChildren(new ArrayList());
                }
            }
            if (isOpen) {
                treeNode.setIsOpened(isOpen);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctr = (Control)evt.getSource();
        if (ctr == null) {
            return;
        }
        String itemkey = ctr.getKey();
        if (OP_OPEN.equals(itemkey)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            String oldFocusNodeId = treeView.getTreeState().getFocusNodeId();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.getPageCache().put("isOpenAll", "true");
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                this.treeListView.getTreeView().queryTreeNodeChildren(root.getParentid(), root.getId());
                if (oldFocusNodeId != null && !ROOTNODEID.equals(oldFocusNodeId)) {
                    this.getPageCache().put("isOpenAll", "true");
                    treeView.treeNodeClick("", oldFocusNodeId);
                }
                this.getPageCache().remove("isOpenAll");
            }
        }
    }

    public static List<String> getAllSuperiorLongnumber(String longnumber) {
        if (StringUtils.isBlank((CharSequence)longnumber) || longnumber.indexOf(46) == -1) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> superiorLongnumberSet = new ArrayList<String>(32);
        String superiorLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)".");
        superiorLongnumberSet.add(superiorLongnumber);
        while (superiorLongnumber.indexOf(33) > 0) {
            superiorLongnumber = StringUtils.substringBeforeLast((String)superiorLongnumber, (String)".");
            superiorLongnumberSet.add(superiorLongnumber);
        }
        return superiorLongnumberSet;
    }

    private Object getDefaultStandardId(List<DynamicObject> standards) {
        Object standardId = NO_GROUP;
        if (standards == null) {
            standards = this.getComData();
        }
        if (standards != null && standards.size() > 0) {
            boolean isPreset = false;
            for (DynamicObject map : standards) {
                if (!map.getBoolean("ispreset")) continue;
                standardId = map.get("id");
                isPreset = true;
            }
            if (!isPreset) {
                standardId = standards.get(0).get("id");
            }
        }
        return standardId;
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter;
        super.setFilter(e);
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        List qFilters = e.getQFilters();
        if (!ROOTNODEID.equals(nodeId)) {
            Iterator iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter qFilter = (QFilter)iterator.next();
                String property = qFilter.getProperty();
                if (!PROP_GROUP.equals(property) && !PROP_LONGNUMBER.equals(property)) continue;
                iterator.remove();
            }
        }
        if ((filter = this.genRefreshFilter(nodeId)) != null) {
            qFilters.add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
        } else if (ISCONTAINLOWER.equals(propertyName)) {
            this.treeListView.refreshTreeView();
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{ISCONTAINLOWER});
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }
}

