/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bd.sbd.business.helper.BillTreeBuildParameter;
import kd.bd.sbd.business.helper.EntityParseHelper;
import kd.bd.sbd.business.helper.LotCodeEntityParseHelper;
import kd.bd.sbd.enums.LotCodeItemTypeEnum;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;

public class LotCodeItemEditPlugin
extends AbstractBasePlugIn
implements ClickListener,
ItemClickListener,
BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object modifier = this.getModel().getValue("modifier");
        if (modifier == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Object status = this.getModel().getValue("modifier");
        if (status != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pagepanel"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"entryentity", "appbill", "billfieldname"});
        BasedataEdit edit = (BasedataEdit)this.getControl("appbill");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String sourceKey;
        Control source = (Control)evt.getSource();
        switch (sourceKey = source.getKey().toLowerCase()) {
            case "billfieldname": {
                this.createAppBillFieldList();
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (entry == null || entry.size() == 0) {
            this.getModel().createNewEntryRow("entryentity");
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            eg.selectRows(0);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit edit = (BasedataEdit)arg0.getSource();
        switch (edit.getKey()) {
            case "appbill": {
                List<String> numbers = this.getAllAppBillNumbers();
                if (numbers.size() <= 0) break;
                QFilter filter = new QFilter("number", "not in", (Object)numbers.toArray());
                ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
                param.getListFilterParameter().getQFilters().add(filter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        switch (propName) {
            case "type": {
                this.getModel().deleteEntryData("entryentity");
                String type = (String)this.getModel().getValue("type");
                if (!LotCodeItemTypeEnum.TXT.getValue().equals(type) && !LotCodeItemTypeEnum.DATE.getValue().equals(type) && !LotCodeItemTypeEnum.SEQ.getValue().equals(type)) break;
                this.getModel().createNewEntryRow("entryentity");
                break;
            }
            case "appbill": {
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex = valueSet[i].getRowIndex();
                    this.getModel().setValue("billfieldname", null, rowIndex);
                }
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("billfieldname".equalsIgnoreCase(sourceFldKey) && StringUtils.isNotNull((Object)returnData)) {
            String type;
            String[] split;
            String fieldId = returnData.toString();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject appBillDO = (DynamicObject)this.getModel().getValue("appbill", rowIndex);
            String appBill = appBillDO.getString("number");
            MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)appBill);
            if (fieldId.indexOf(46) > 0) {
                String firstProp = fieldId.substring(0, fieldId.indexOf(46));
                fieldId = fieldId.substring(fieldId.indexOf(46) + 1);
                if (!"billhead".equals(firstProp)) {
                    this.getModel().setValue("entryentityid", (Object)firstProp, rowIndex);
                } else {
                    this.getModel().setValue("entryentityid", null, rowIndex);
                }
            }
            if ((split = fieldId.split("\\.")).length > 3) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9009\u62e9\u5355\u636e\u4e0a3\u7ea7\u4ee5\u4e0a\u7684\u5f15\u7528\u5c5e\u6027\u3002", (String)"SBD-W-080400", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                return;
            }
            IDataEntityProperty spiltProp = null;
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    spiltProp = srcbillMainType.findProperty(split[i]);
                    continue;
                }
                if (spiltProp instanceof FlexProp) {
                    spiltProp = new TextProp();
                    break;
                }
                String baseEntityId = ((BasedataProp)spiltProp).getBaseEntityId();
                spiltProp = MetadataServiceHelper.getDataEntityType((String)baseEntityId).findProperty(split[i]);
            }
            if (StringUtils.isBlank((String)(type = (String)this.getModel().getValue("type")))) {
                return;
            }
            switch (type) {
                case "A": {
                    if (spiltProp instanceof TextProp) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u6587\u672c\u7c7b\u578b\u5c5e\u6027\u3002", (String)"SBD-W-500765", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                case "B": {
                    if (spiltProp instanceof DateProp) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u65e5\u671f\u7c7b\u578b\u5c5e\u6027\u3002", (String)"SBD-W-755005", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                case "C": {
                    if (spiltProp instanceof IntegerProp) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u6570\u5b57\u7c7b\u578b\u5c5e\u6027\u3002", (String)"SBD-W-668604", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcbillMainType, (String)fieldId);
            this.getModel().setValue("billfieldid", (Object)fieldId, rowIndex);
            this.getModel().setValue("billfieldname", (Object)fieldCaption, rowIndex);
        }
    }

    private void createAppBillFieldList() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject appBillDO = (DynamicObject)this.getModel().getValue("appbill", rowIndex);
        if (appBillDO == null || appBillDO.getPkValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9002\u7528\u5355\u636e\u3002", (String)"LotCodeItemEditPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String appBill = appBillDO.getString("number");
        MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)appBill);
        String type = (String)this.getModel().getValue("type");
        TextProp targetProperty = null;
        if (StringUtils.isEmpty((String)type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5c5e\u6027\u7c7b\u578b\u3002", (String)"LotCodeItemEditPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (LotCodeItemTypeEnum.TXT.getValue().equals(type)) {
            targetProperty = new TextProp();
        } else if (LotCodeItemTypeEnum.DATE.getValue().equals(type)) {
            targetProperty = new DateTimeProp();
        } else if (LotCodeItemTypeEnum.SEQ.getValue().equals(type)) {
            targetProperty = new EntryProp();
        }
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(appBillMainType, null, (IDataEntityProperty)targetProperty);
        TreeNode appBillNode = LotCodeEntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        List children = appBillNode.getChildren();
        if (children == null) {
            this.showSelectFieldForm(appBillNode, "billfieldname");
            return;
        }
        for (TreeNode child : children) {
            List children1;
            if (!"billentry".equals(child.getId()) || (children1 = child.getChildren()) == null) continue;
            for (TreeNode treeNode : children1) {
                if (!"material".equals(treeNode.getId())) continue;
                List children2 = treeNode.getChildren();
                children2.removeIf(next -> "material.number".equals(next.getId()));
                children2.removeIf(next -> "material.name".equals(next.getId()));
            }
        }
        this.showSelectFieldForm(appBillNode, "billfieldname");
    }

    private List<String> getAllAppBillNumbers() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<String> billIds = new ArrayList<String>();
        if (entry != null && entry.size() > 0) {
            entry.forEach(p -> {
                String number = p.getString("appbill.number");
                if (StringUtils.isNotEmpty((String)number)) {
                    billIds.add(number);
                }
            });
        }
        return billIds;
    }

    private void showSelectFieldForm(TreeNode billNode, String fieldCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setDataChanged(false);
    }
}

