/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bd.sbd.business.helper.ManuStrategyConfigInitHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ManuStrategyConfigListPlugin
extends AbstractListPlugin {
    private static final String INIT = "init";
    private static final String REFRESH = "refresh";
    private static final String INIT_IDS = "init_ids";

    public void afterBindData(EventObject e) {
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userID, (AdminType)AdminType.Administrator);
        if (!isAdmin) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tbldel", "tbldisable", "barinit"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)INIT) && e.getOperationResult().isSuccess()) {
            List successPkIds = e.getOperationResult().getSuccessPkIds();
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(key, (IFormPlugin)this);
            confirmCallBack.setView(this.getView());
            this.getPageCache().put(INIT_IDS, SerializationUtils.toJsonString((Object)successPkIds));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4f1a\u8986\u76d6\u66f4\u65b0\u5f53\u524d\u6570\u636e\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u521d\u59cb\u5316\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u8986\u76d6\u5df2\u6709\u6570\u636e\u3002", (String)"MRPInitDataList_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && INIT.equals(e.getCallBackId())) {
            List ids = null;
            String jsonStr = this.getPageCache().get(INIT_IDS);
            if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
                ids = SerializationUtils.fromJsonStringToList((String)jsonStr, Long.class);
            }
            if (ids != null && !ids.isEmpty()) {
                this.invokeInitOp(ids);
            }
        }
    }

    private void invokeInitOp(List<Object> successPkIds) {
        if (successPkIds != null && !successPkIds.isEmpty()) {
            ManuStrategyConfigInitHelper.initMrpData(successPkIds);
            this.getView().invokeOperation(REFRESH);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"ManuStrategyConfigListPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        }
    }
}

