/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.mds;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;

public class PurDemandDefinitionPlugin
extends AbstractFormPlugin {
    private static final String BAR_DISABLE = "bar_disable";
    private static final String BAR_EANABLE = "bar_enable";
    private static final String KEY_ENDDATE = "enddate";
    private static final String KEY_STARTDATE = "startdate";
    private static final String SUBMIT = "submit";

    public void afterBindData(EventObject e) {
        String enable = (String)this.getModel().getValue("enable");
        if (enable != null) {
            if ("0".equals(enable)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_EANABLE});
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_EANABLE});
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
            }
        }
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel dm = this.getModel();
        if (dm == null) {
            return;
        }
        RequestContext rc = RequestContext.get();
        Long curOrgID = rc == null ? -1L : rc.getOrgId();
        Object createOrgObj = dm.getValue("createorg");
        if (createOrgObj == null && curOrgID > 0L) {
            dm.setValue("createorg", (Object)curOrgID);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"disable", (CharSequence)operateKey)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_EANABLE});
        }
        if (StringUtils.equals((CharSequence)"enable", (CharSequence)operateKey)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_EANABLE});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
        }
        super.afterDoOperation(args);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        if (SUBMIT.equals(key) && !this.dateValidation()) {
            args.setCancel(true);
        }
        super.beforeDoOperation(args);
    }

    private void chgend(Object newValue) {
        if (null == newValue) {
            return;
        }
        Date end = (Date)newValue;
        Date start = (Date)this.getModel().getValue(KEY_STARTDATE);
        Date c = new Date(System.currentTimeMillis());
        if (this.comp(c, end) || null != start && this.comp(start, end)) {
            this.getModel().setValue(KEY_ENDDATE, null);
        }
    }

    private void chgstart(Object newValue) {
        if (null == newValue) {
            return;
        }
        Date start = (Date)newValue;
        Date c = new Date(System.currentTimeMillis());
        if (!this.comp(start, c)) {
            this.getModel().setValue(KEY_STARTDATE, null);
            return;
        }
        Date end = (Date)this.getModel().getValue(KEY_ENDDATE);
        if (null != end && this.comp(start, end)) {
            this.getModel().setValue(KEY_ENDDATE, null);
        }
    }

    private boolean dateValidation() {
        Date start = (Date)this.getModel().getValue(KEY_STARTDATE);
        Date end = (Date)this.getModel().getValue(KEY_ENDDATE);
        Date now = new Date(System.currentTimeMillis());
        if (start != null && !this.comp(start, now)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u64cd\u4f5c\u65f6\u95f4\u3002", (String)"PurDemandDefinitionPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (end != null && this.comp(now, end)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u64cd\u4f5c\u65f6\u95f4\u3002", (String)"PurDemandDefinitionPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (start != null && end != null && this.comp(start, end)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u751f\u6548\u65f6\u95f4\u3002", (String)"PurDemandDefinitionPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        String keyProp = e.getProperty().getName();
        if (KEY_STARTDATE.equals(keyProp)) {
            this.chgstart(newValue);
            return;
        }
        if (KEY_ENDDATE.equals(keyProp)) {
            this.chgend(newValue);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    private boolean comp(Date comp, Date now) {
        Calendar nCal = Calendar.getInstance();
        nCal.setTime(now);
        Calendar cCal = Calendar.getInstance();
        cCal.setTime(comp);
        if (cCal.get(1) > nCal.get(1)) {
            return true;
        }
        if (cCal.get(1) < nCal.get(1)) {
            return false;
        }
        if (cCal.get(2) > nCal.get(2)) {
            return true;
        }
        if (cCal.get(2) < nCal.get(2)) {
            return false;
        }
        return cCal.get(5) >= nCal.get(5);
    }
}

