/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.flow.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bd.gbs.core.flow.common.Enum.FlowCardJumpTypeEnum;
import kd.bd.gbs.core.flow.common.util.FlowPermissionUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.AppInfo;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.util.FileNameUtils;

public class BusinessFlowCardServiceHelper {
    private static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+", "&"};
    private static final Log log = LogFactory.getLog(BusinessFlowCardServiceHelper.class);
    private static final String SELECT_FLOW_FIELDS = String.join((CharSequence)",", "id", "creator", "createtime", "modifier", "modifytime", "config", "config_tag", "number", "name");
    public static final String SELECT_FLOWNODE_FIELDS = "nodeid,flowscheme,name,tip";

    public static JSONArray getFlowConfigArray(List<Long> flowIdList) {
        DynamicObject[] flowDymArr = BusinessFlowCardServiceHelper.queryFlowConfByIds(flowIdList);
        if (flowDymArr.length < 1) {
            return null;
        }
        HashMap<Long, DynamicObject> flowIdMap = new HashMap<Long, DynamicObject>(flowDymArr.length);
        for (DynamicObject flowDym : flowDymArr) {
            flowIdMap.put(flowDym.getLong("id"), flowDym);
        }
        JSONArray jsonArr = new JSONArray(flowDymArr.length);
        for (Long flowId : flowIdList) {
            if (flowIdMap.get(flowId) == null) continue;
            jsonArr.add((Object)BusinessFlowCardServiceHelper.handleFlowConfigLang((DynamicObject)flowIdMap.get(flowId)));
        }
        return jsonArr;
    }

    public static JSONObject getFlowConfig(long flowId) {
        DynamicObject flowConfigDym = BusinessFlowCardServiceHelper.queryFlowConfById(flowId);
        if (flowConfigDym == null) {
            log.error("flowId: {} is illegal.", (Object)flowId);
            return new JSONObject();
        }
        return BusinessFlowCardServiceHelper.handleFlowConfigLang(flowConfigDym);
    }

    public static Long saveFlowConfig(Long flowId, String appId, JSONObject flowConfig) {
        DynamicObject flowConfigDym = BusinessFlowCardServiceHelper.buildOrGetFlowDym(flowId, appId, flowConfig);
        long pk = BusinessFlowCardServiceHelper.saveFlowConf(flowConfigDym);
        BusinessFlowCardServiceHelper.saveFlowNodes(pk, flowConfig);
        return pk;
    }

    private static void saveFlowNodes(long flowId, JSONObject flowConfig) {
        int delete = BusinessFlowCardServiceHelper.deleteAllFlowNodeByFlowId(flowId);
        log.info("the count {} of delete flow nodes.", (Object)delete);
        BusinessFlowCardServiceHelper.saveFlowNodes(BusinessFlowCardServiceHelper.buildNewFlowNodes(flowId, flowConfig));
    }

    private static DynamicObject[] buildNewFlowNodes(long flowId, JSONObject flowConfig) {
        ArrayList<DynamicObject> nodeDymList = new ArrayList<DynamicObject>(16);
        JSONArray nodeDataArr = flowConfig.getJSONArray("nodes");
        for (Object data : nodeDataArr) {
            String content;
            LinkedHashMap nodeMap = (LinkedHashMap)data;
            String nodeId = (String)nodeMap.get("id");
            LinkedHashMap nodePropMap = (LinkedHashMap)nodeMap.get("properties");
            String nodeType = (String)nodePropMap.get("type");
            if (nodeType.equals("node-judge")) continue;
            DynamicObject nodeDym = BusinessDataServiceHelper.newDynamicObject((String)"gbs_flownode");
            nodeDym.set("nodeid", (Object)nodeId);
            nodeDym.set("flowscheme_id", (Object)flowId);
            String nodeName = (String)nodePropMap.get("name");
            nodeDym.set("name", (Object)nodeName);
            if (nodeType.equals("node-item")) {
                String tip = (String)nodePropMap.get("tip");
                if (!StringUtils.isEmpty((CharSequence)tip)) {
                    nodeDym.set("tip", (Object)tip);
                }
            } else if (nodeType.equals("node-text") && !StringUtils.isEmpty((CharSequence)(content = (String)nodePropMap.get("content")))) {
                nodeDym.set("tip", (Object)content);
            }
            nodeDymList.add(nodeDym);
        }
        return nodeDymList.toArray(new DynamicObject[0]);
    }

    private static DynamicObject buildOrGetFlowDym(Long flowId, String appId, JSONObject config) {
        DynamicObject flowScheme;
        Date date = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        if (flowId == null) {
            flowScheme = BusinessDataServiceHelper.newDynamicObject((String)"gbs_flowscheme");
            flowId = DB.genLongId((String)"t_gbs_flowscheme");
            flowScheme.set("id", (Object)flowId);
            flowScheme.set("creator", (Object)userId);
            flowScheme.set("createtime", (Object)date);
            flowScheme.set("bizapp", (Object)appId);
            String number = CodeRuleServiceHelper.getNumber((String)"gbs_flowscheme", (DynamicObject)flowScheme, null);
            if (StringUtils.isEmpty((CharSequence)number) || "".equals(number.trim())) {
                number = "LCDH-" + flowId;
            }
            flowScheme.set("number", (Object)number);
        } else {
            flowScheme = BusinessFlowCardServiceHelper.queryFlowConfById(flowId);
        }
        config.fluentPut("id", (Object)flowId.toString());
        flowScheme.set("name", (Object)config.getString("name"));
        if (StringUtils.isNotBlank((Object)config)) {
            JSONArray nodeDataArr = config.getJSONArray("nodes");
            for (Object data : nodeDataArr) {
                String filePath;
                LinkedHashMap nodeMap = (LinkedHashMap)data;
                String nodeId = (String)nodeMap.get("id");
                LinkedHashMap nodePropMap = (LinkedHashMap)nodeMap.get("properties");
                if (!"upload".equals(nodePropMap.get("iconType")) || nodePropMap.get("icon") == null || StringUtils.isEmpty((CharSequence)(filePath = (String)nodePropMap.get("icon")))) continue;
                String realPath = BusinessFlowCardServiceHelper.fileUpload(nodeId, filePath);
                nodePropMap.put("icon", realPath);
            }
            flowScheme.set("config_tag", (Object)JSON.toJSONString((Object)config));
        }
        flowScheme.set("modifier", (Object)userId);
        flowScheme.set("modifytime", (Object)date);
        return flowScheme;
    }

    private static JSONObject handleFlowConfigLang(DynamicObject flowConfigDym) {
        JSONObject result = new JSONObject();
        String config = flowConfigDym.getString("config_tag");
        if (StringUtils.isBlank((CharSequence)config)) {
            return result;
        }
        result = JSON.parseObject((String)config);
        result.put("name", (Object)BusinessFlowCardServiceHelper.getLocaleValue(flowConfigDym, "name"));
        JSONArray nodeDatas = result.getJSONArray("nodes");
        if (CollectionUtils.isEmpty((Collection)nodeDatas)) {
            return result;
        }
        long flowId = flowConfigDym.getLong("id");
        Object[] flowNodes = BusinessFlowCardServiceHelper.queryFlowNodesByFlowId(flowId);
        if (ArrayUtils.isEmpty((Object[])flowNodes)) {
            return result;
        }
        Map<String, String> nameMapping = Arrays.stream(flowNodes).collect(Collectors.toMap(node -> node.getString("nodeid"), node -> BusinessFlowCardServiceHelper.getLocaleValue(node, "name"), (k1, k2) -> k2));
        Map<String, String> tipMapping = Arrays.stream(flowNodes).collect(Collectors.toMap(node -> node.getString("nodeid"), node -> BusinessFlowCardServiceHelper.getLocaleValue(node, "tip"), (k1, k2) -> k2));
        Long userId = RequestContext.get().getCurrUserId();
        HashMap<String, Boolean> appPermissionMap = new HashMap<String, Boolean>(16);
        HashMap<String, AppInfo> appInfoMap = new HashMap<String, AppInfo>(16);
        for (Object data : nodeDatas) {
            String tipMsg;
            JSONObject next = (JSONObject)data;
            String nodeType = next.getString("type");
            if (nodeType.equals("node-judge")) continue;
            String nodeId = next.getString("id");
            JSONObject jsonProp = next.getJSONObject("properties");
            if (!StringUtils.isEmpty((CharSequence)nameMapping.get(nodeId))) {
                jsonProp.put("name", (Object)nameMapping.get(nodeId));
            }
            Boolean hasPermission = true;
            if ("node-item".equals(nodeType)) {
                String jumpType;
                tipMsg = tipMapping.get(nodeId);
                if (!StringUtils.isEmpty((CharSequence)tipMsg)) {
                    jsonProp.put("tip", (Object)tipMsg);
                }
                if (StringUtils.isEmpty((CharSequence)(jumpType = jsonProp.getString("jumpType")))) continue;
                jsonProp.put("disabled", (Object)Boolean.FALSE);
                String jumpId = jsonProp.getString("jumpId");
                String appId = jsonProp.getString("appId");
                if (StringUtils.isEmpty((CharSequence)jumpId)) continue;
                if (jumpType.equals(FlowCardJumpTypeEnum.APP.getJumpType())) {
                    if (StringUtils.isEmpty((CharSequence)appId)) continue;
                    hasPermission = FlowPermissionUtil.checkAppMenuPermission(appId, jumpId, userId, appInfoMap, appPermissionMap);
                } else {
                    if (jumpType.equals(FlowCardJumpTypeEnum.LINK.getJumpType())) continue;
                    String appNum = FormMetadataCache.getFormConfig((String)jumpId).getBizAppNumber();
                    hasPermission = appNum == null ? Boolean.valueOf(false) : Boolean.valueOf(FlowPermissionUtil.checkAppPermission(appNum, userId, appInfoMap, appPermissionMap));
                }
                if (hasPermission.booleanValue()) continue;
                jsonProp.put("disabled", (Object)Boolean.TRUE);
                continue;
            }
            if (!"node-text".equals(nodeType) || StringUtils.isEmpty((CharSequence)(tipMsg = tipMapping.get(nodeId)))) continue;
            jsonProp.put("content", (Object)tipMsg);
        }
        return result;
    }

    private static String getLocaleValue(DynamicObject dyn, String propertyName) {
        ILocaleString localeString = dyn.getLocaleString(propertyName);
        String localeValue = localeString.getLocaleValue();
        if (StringUtils.isNotBlank((CharSequence)localeValue)) {
            return localeValue;
        }
        String defValue = dyn.getString(propertyName);
        if (StringUtils.isNotBlank((CharSequence)defValue)) {
            return defValue;
        }
        return "";
    }

    private static DynamicObject queryFlowConfById(long flowId) {
        return BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"gbs_flowscheme", (String)SELECT_FLOW_FIELDS);
    }

    private static DynamicObject[] queryFlowConfByIds(List<Long> flowIdList) {
        return BusinessDataServiceHelper.loadFromCache((String)"gbs_flowscheme", (String)SELECT_FLOW_FIELDS, (QFilter[])new QFilter("id", "in", flowIdList).toArray()).values().toArray(new DynamicObject[0]);
    }

    private static DynamicObject[] queryFlowNodesByFlowId(long flowId) {
        QFilter qFilter = new QFilter("flowscheme.id", "=", (Object)flowId);
        return BusinessDataServiceHelper.load((String)"gbs_flownode", (String)SELECT_FLOWNODE_FIELDS, (QFilter[])qFilter.toArray());
    }

    private static long saveFlowConf(DynamicObject flowConf) {
        Object[] saved = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{flowConf});
        return ((DynamicObject)saved[0]).getLong("id");
    }

    private static void saveFlowNodes(DynamicObject[] dynamicObject) {
        SaveServiceHelper.save((DynamicObject[])dynamicObject);
    }

    private static int deleteAllFlowNodeByFlowId(long flowId) {
        QFilter qFilter = new QFilter("flowscheme_id", "=", (Object)flowId);
        return DeleteServiceHelper.delete((String)"gbs_flownode", (QFilter[])qFilter.toArray());
    }

    private static String fileUpload(String fileName, String fieldPath) {
        InputStream downloadInputStream = null;
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            String[] queryParams = new URL(fieldPath).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            if (downloadFileParams.get("configKey") == null) {
                return fieldPath;
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            fileName = content.getFilename();
            downloadInputStream = content.getInputStream();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        String path = BusinessFlowCardServiceHelper.getRandomFilePath(fileName, "gbs_flowscheme", "gbs");
        FileItem fileItem = new FileItem(fileName, path, downloadInputStream);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try {
            path = fileService.upload(fileItem);
            path = UrlService.getAttachmentDownloadUrl((String)path);
        }
        catch (Exception e2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25", (String)"BusinessFlowCardServiceHelper_1", (String)"bd-gbs-core", (Object[])new Object[0]));
        }
        return path;
    }

    private static String getRandomFilePath(String fileName, String formId, String appId) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)uuid, (String)BusinessFlowCardServiceHelper.replaceSpeSymbol(fileName));
    }

    private static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }
}

