/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.flow.common.util;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class FlowPermissionUtil {
    private static Log logger = LogFactory.getLog(FlowPermissionUtil.class);

    public static boolean checkAppPermission(String appNum, Long userId, Map<String, AppInfo> appInfoMap, Map<String, Boolean> appPermissionMap) {
        String appId;
        boolean isPermission = false;
        AppInfo app = appInfoMap.get(appNum);
        if (app == null) {
            app = AppMetadataCache.getAppInfo((String)appNum);
            if (app == null) {
                return isPermission;
            }
            appInfoMap.put(appNum, app);
        }
        if (appPermissionMap.get(appId = app.getId()) != null) {
            return appPermissionMap.get(appId);
        }
        isPermission = PermissionServiceHelper.checkUserBizApp((Long)userId, (String)app.getId());
        appPermissionMap.put(app.getId(), isPermission);
        return isPermission;
    }

    public static boolean checkAppMenuPermission(String appId, String menuId, Long userId, Map<String, AppInfo> appInfoMap, Map<String, Boolean> appPermissionMap) {
        boolean isPermission = false;
        if (appPermissionMap.get(appId) != null) {
            isPermission = appPermissionMap.get(appId);
        } else {
            isPermission = PermissionServiceHelper.checkUserBizApp((Long)userId, (String)appId);
            appPermissionMap.put(appId, isPermission);
        }
        if (!isPermission) {
            return isPermission;
        }
        String appNum = AppMetadataCache.getAppNumberById((String)appId);
        AppInfo app = appInfoMap.get(appNum);
        if (app == null) {
            app = AppMetadataCache.getAppInfo((String)appNum);
            if (app == null) {
                return false;
            }
            appInfoMap.put(appNum, app);
        }
        if (StringUtils.isNotBlank((CharSequence)menuId)) {
            AppMenuInfo menu = null;
            try {
                menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
            }
            catch (Exception e) {
                logger.error("checkAppMenuPermission", (Throwable)e);
            }
            if (menu != null) {
                String formNumber = menu.getFormId();
                String parameterType = menu.getParamType();
                String permItem = menu.getPermission();
                if (formNumber != null) {
                    isPermission = StringUtils.isBlank((CharSequence)permItem) ? ("ListShowParameter".equalsIgnoreCase(parameterType) || "ReportShowParameter".equalsIgnoreCase(parameterType) || "FormShowParameter".equalsIgnoreCase(parameterType) ? PermissionServiceHelper.hasViewPermission((long)userId, (String)app.getId(), (String)formNumber) : ("BillShowParameter".equalsIgnoreCase(parameterType) || "BaseShowParameter".equalsIgnoreCase(parameterType) ? PermissionServiceHelper.hasNewPermission((long)userId, (String)app.getId(), (String)formNumber) : PermissionServiceHelper.hasViewPermission((long)userId, (String)app.getId(), (String)formNumber))) : PermissionServiceHelper.hasSpecificPerm((long)userId, (String)app.getId(), (String)formNumber, (String)permItem);
                }
            }
        }
        return isPermission;
    }
}

