/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.flow.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.sqlscript.PreInsDataScriptBuilder;

public class FlowSchemeExportUtil {
    public static final Map<String, String> TABLE_FIELDMAP = new HashMap<String, String>();

    public static Map<String, Map<String, Object>> expSql(List<Long> infoIdList, Map<Long, List<String>> nodeMap) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map<String, String> tableFieldMap = TABLE_FIELDMAP;
        HashMap<String, Map<String, Object>> resultSqlMap = new HashMap<String, Map<String, Object>>(16);
        for (Long infoId : infoIdList) {
            StringBuilder resultSqlBuilder = new StringBuilder();
            Object xmlObj = null;
            for (Map.Entry<String, String> tableFieldEntry : tableFieldMap.entrySet()) {
                Map map;
                String tableName = tableFieldEntry.getKey();
                String selectFileds = tableFieldEntry.getValue();
                StringBuilder whereSqlBuilder = new StringBuilder();
                whereSqlBuilder.append("fid ");
                if (tableName.contains("t_gbs_flowscheme")) {
                    whereSqlBuilder.append("= ");
                    whereSqlBuilder.append(infoId);
                } else {
                    List<String> nodeIdList = nodeMap.get(infoId);
                    if (nodeIdList.isEmpty()) continue;
                    whereSqlBuilder.append("in (");
                    for (String nodeId : nodeIdList) {
                        whereSqlBuilder.append("'");
                        whereSqlBuilder.append(nodeId);
                        whereSqlBuilder.append("'");
                        whereSqlBuilder.append(',');
                    }
                    whereSqlBuilder = new StringBuilder(whereSqlBuilder.substring(0, whereSqlBuilder.length() - 1));
                    whereSqlBuilder.append(')');
                }
                if (tableName.equals("t_gbs_flownode_l") || tableName.equals("t_gbs_flowscheme_l")) {
                    whereSqlBuilder.append(" and flocaleid = 'zh_CN'");
                }
                try {
                    map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), tableName, selectFileds, whereSqlBuilder.toString(), null, null);
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
                }
                if (resultSqlBuilder.length() < 1) {
                    resultSqlBuilder.append((String)map.get("sql"));
                } else {
                    resultSqlBuilder.append("\n");
                    resultSqlBuilder.append((String)map.get("sql"));
                }
                if (map.get("xml") == null) continue;
                xmlObj = map.get("xml");
            }
            HashMap<String, String> sqlValueMap = new HashMap<String, String>(16);
            sqlValueMap.put("sql", resultSqlBuilder.toString());
            sqlValueMap.put("xml", (String)xmlObj);
            resultSqlMap.put(String.valueOf(infoId), sqlValueMap);
        }
        return resultSqlMap;
    }

    public static String getZipName(String flowNumber, boolean isSingle) {
        StringBuilder zipNameBuilder = new StringBuilder();
        if (isSingle) {
            zipNameBuilder.append(flowNumber);
        } else {
            zipNameBuilder.append("gbs_flow_preinsdata");
        }
        zipNameBuilder.append(".zip");
        return zipNameBuilder.toString();
    }

    static {
        TABLE_FIELDMAP.put("t_gbs_flowscheme", "fid,fnumber,fname,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fconfig,fconfig_tag,fispreset,fbizappid");
        TABLE_FIELDMAP.put("t_gbs_flowscheme_l", "fpkid,fid,flocaleid,fname");
        TABLE_FIELDMAP.put("t_gbs_flownode", "fid,fname,fflowschemeid,fnodeid,ftip");
        TABLE_FIELDMAP.put("t_gbs_flownode_l", "fpkid,fid,flocaleid,fname,ftip");
    }
}

