/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.kit.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KitConfigSingleton {
    private static final Logger log = LoggerFactory.getLogger(KitConfigSingleton.class);
    private String xhsecret = "";
    private String kitsecret = "";

    public static KitConfigSingleton getInstance() {
        return Inner.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKitConfig() {
        Properties prop = new Properties();
        InputStream kitConfig = null;
        try {
            String fielname = "/Huaweikit/KitConfig.properties";
            String fieldpath = KitConfigSingleton.class.getResource("").getPath();
            log.info("Kit fieldpath" + fieldpath);
            kitConfig = KitConfigSingleton.class.getResourceAsStream(fielname);
            prop.load(kitConfig);
            this.xhsecret = prop.getProperty("xhsecret");
            this.kitsecret = prop.getProperty("kitsecret");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (kitConfig != null) {
                try {
                    kitConfig.close();
                }
                catch (IOException e) {
                    log.error("Failed to close kitConfig stream", (Throwable)e);
                }
            }
            prop.clear();
        }
    }

    public String getXhsecret() {
        this.checkAndInit();
        return this.xhsecret;
    }

    public String getKitsecret() {
        this.checkAndInit();
        return this.kitsecret;
    }

    private void checkAndInit() {
        if ("".equals(this.xhsecret) || "".equals(this.kitsecret)) {
            this.initKitConfig();
        }
    }

    private static class Inner {
        private static final KitConfigSingleton instance = new KitConfigSingleton();

        private Inner() {
        }
    }
}

