/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class AddressDeletePlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(AddressDeletePlugin.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        log.info("AddressDeletePlugin.endOperationTransaction, record num:" + (e.getDataEntities() == null ? "null" : Integer.valueOf(e.getDataEntities().length)));
        try (TraceSpan span = Tracer.create((String)"AddressDeletePlugin", (String)"afterExecuteOperationTransaction");){
            DynamicObject[] datas;
            if (e.getDataEntities() != null && e.getDataEntities().length > 0 && (datas = e.getDataEntities()) != null && datas.length > 0) {
                String type = datas[0].getDataEntityType().getName();
                DynamicObject[] addressDatas = null;
                List masterPks = Arrays.asList(datas).stream().map(sp -> sp.getString("id")).collect(Collectors.toList());
                if ("bd_supplier".equals(type)) {
                    addressDatas = BusinessDataServiceHelper.load((String)"bd_address", (String)"id", (QFilter[])new QFilter[]{new QFilter("supplierid", "in", masterPks)});
                } else if ("bd_customer".equals(type)) {
                    addressDatas = BusinessDataServiceHelper.load((String)"bd_address", (String)"id", (QFilter[])new QFilter[]{new QFilter("customerid", "in", masterPks)});
                }
                if (addressDatas != null && addressDatas.length > 0) {
                    ArrayList<Long> ids = new ArrayList<Long>(addressDatas.length);
                    for (DynamicObject ad : addressDatas) {
                        ids.add(ad.getLong("id"));
                    }
                    OperateOption op = OperateOption.create();
                    OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"bd_address", (Object[])ids.toArray(new Long[ids.size()]), (OperateOption)op);
                    if (!result.isSuccess()) {
                        StringBuilder errorinfo = new StringBuilder();
                        List errorInfoList = result.getAllErrorOrValidateInfo();
                        for (IOperateInfo ipinfo : errorInfoList) {
                            errorinfo.append(ipinfo.getMessage());
                            errorinfo.append('\n');
                        }
                        throw new KDBizException(errorinfo.toString());
                    }
                }
            }
        }
    }
}

