/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bd.master.enums.StatusEnum;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MasterDataImportOp
extends BatchImportPlugin {
    private final Log log = LogFactory.getLog(MasterDataImportOp.class);
    public static final String IMPORTTYPE = "importtype";
    public static final String IMPORTTYPE_NEW = "new";

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 1000;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        try (TraceSpan span = Tracer.create((String)"MasterDataImportOp", (String)"beforeSave");){
            this.removeGroupDataId(billdatas);
        }
    }

    private void removeGroupDataId(List<ImportBillData> billdatas) {
        for (ImportBillData billdata : billdatas) {
            JSONObject data = billdata.getData();
            List entry_standards = (List)data.get((Object)"entry_groupstandard");
            if (entry_standards == null || entry_standards.size() <= 0) continue;
            for (Map entry_standard : entry_standards) {
                if (!entry_standard.containsKey("id")) continue;
                entry_standard.remove("id");
            }
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        try (TraceSpan span = Tracer.create((String)"MasterDataImportOp", (String)"beforeImportBill");){
            if (rowdatas.isEmpty()) {
                ApiResult apiResult = null;
                return apiResult;
            }
            this.beforeImportBill(rowdatas, logger);
        }
        return super.save(rowdatas, logger);
    }

    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map<String, Long> groupIds = this.setGroupData(rowdatas);
        Map<String, String> statusMap = this.queryDataStatusByNumber(rowdatas);
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        try (TraceSpan span = Tracer.create((String)"MasterDataImportOp", (String)"validateDataStatus");){
            while (iterator.hasNext()) {
                this.validateDataStatus(logger, iterator, statusMap, groupIds);
            }
        }
    }

    private void putGroupId(ImportBillData rowdata, Map<String, Long> groupIds, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject data = rowdata.getData();
        List entry_standards = (List)data.get((Object)"entry_groupstandard");
        if (entry_standards == null || entry_standards.size() <= 0) {
            return;
        }
        for (Map entry_standard : entry_standards) {
            String key;
            Long groupid;
            Map standard = (Map)entry_standard.get("standardid");
            if (StringUtils.isBlank((Object)standard)) continue;
            if (standard.get("number") == null) {
                int errMsgRowIndex = rowdata.getStartIndex();
                logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u7248\u4e2d\u5206\u7c7b\u6807\u51c6.\u5206\u7c7b\u6807\u51c6\u7f16\u7801\u5217\u672a\u653e\u51fa\u6216\u4e3a\u7a7a\u3002", (String)"MasterDataImportOp_3", (String)"bd-master-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
            String standardNumber = standard.get("number").toString();
            Map group = (Map)entry_standard.get("groupid");
            if (StringUtils.isBlank((Object)group)) continue;
            if (group.get("number") == null) {
                int errMsgRowIndex = rowdata.getStartIndex();
                logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u7248\u4e2d\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u5217\u672a\u653e\u51fa\u6216\u4e3a\u7a7a\u3002", (String)"MasterDataImportOp_4", (String)"bd-master-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
            String groupNumber = group.get("number").toString();
            if (StringUtils.isBlank((CharSequence)groupNumber) || !StringUtils.isNotBlank((Object)(groupid = groupIds.get(key = groupNumber + '_' + standardNumber)))) continue;
            group.put("id", groupid);
        }
    }

    private Map<String, Long> setGroupData(List<ImportBillData> rowdatas) {
        ImportContext ctx = this.ctx;
        String billFormId = ctx.getBillFormId();
        HashSet<String> groupNumbers = new HashSet<String>(rowdatas.size());
        HashSet<String> standardNumbers = new HashSet<String>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            List entry_standards = (List)data.get((Object)"entry_groupstandard");
            if (entry_standards == null || entry_standards.size() <= 0) continue;
            for (Map entry_standard : entry_standards) {
                String groupNumber;
                Map standard = (Map)entry_standard.get("standardid");
                if (StringUtils.isBlank((Object)standard)) continue;
                String standardNumber = (String)standard.get("number");
                standardNumbers.add(standardNumber);
                Map group = (Map)entry_standard.get("groupid");
                if (StringUtils.isBlank((Object)group) || StringUtils.isBlank((CharSequence)(groupNumber = (String)group.get("number")))) continue;
                groupNumbers.add(groupNumber);
            }
        }
        QFilter qFilterParent = new QFilter("number", "in", groupNumbers);
        QFilter qFilterStandard = new QFilter("standard.number", "in", standardNumbers);
        String masterDataNumber = GroupStandardUtils.getMasterDataNumber((String)billFormId);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)(masterDataNumber + "group"), (String)"id,number,standard.number,fullname", (QFilter[])new QFilter[]{qFilterParent, qFilterStandard});
        HashMap<String, Long> groupIds = new HashMap<String, Long>(loadFromCache.size());
        for (DynamicObject entity : loadFromCache.values()) {
            String number = entity.getString("number");
            String standardNumber = entity.getDynamicObject("standard").getString("number");
            groupIds.put(number + '_' + standardNumber, entity.getLong("id"));
        }
        return groupIds;
    }

    private Map<String, String> queryDataStatusByNumber(List<ImportBillData> importRowdatas) {
        HashMap<String, String> statusMap = new HashMap<String, String>(16);
        try (TraceSpan span = Tracer.create((String)"MasterDataImportOp", (String)"queryDataStatusByNumber");){
            Map importParamMap = this.ctx.getOption();
            String importType = importParamMap.get(IMPORTTYPE).toString();
            LinkedList<String> queryNumberList = new LinkedList<String>();
            for (ImportBillData importRow : importRowdatas) {
                JSONObject importRowJsonData = importRow.getData();
                String importDataStatus = importRowJsonData.getString("status");
                if (StringUtils.isEmpty((CharSequence)importDataStatus) || "null".equals(importDataStatus)) {
                    importRowJsonData.put("status", (Object)StatusEnum.SAVE.getCode());
                    importDataStatus = importRowJsonData.getString("status");
                }
                if (!StatusEnum.SAVE.getCode().equals(importDataStatus) || IMPORTTYPE_NEW.equals(importType)) continue;
                queryNumberList.add(importRowJsonData.getString("number"));
            }
            this.log.info("MasterDataImportOp-importType:" + importType + ",queryNumberList:" + queryNumberList);
            Map dynamicObjMap = new HashMap(queryNumberList.size());
            if (queryNumberList.size() > 0) {
                dynamicObjMap = BusinessDataServiceHelper.loadFromCache((String)this.ctx.getBillFormId(), (String)"id,number,createorg,status", (QFilter[])new QFilter[]{new QFilter("number", "in", queryNumberList)});
            }
            for (DynamicObject dynamicObj : dynamicObjMap.values()) {
                String number = dynamicObj.getString("number");
                DynamicObject createOrg = dynamicObj.getDynamicObject("createorg");
                String orgNumber = createOrg == null ? "" : createOrg.getString("number");
                String key = number + "_" + orgNumber;
                String status = dynamicObj.getString("status");
                statusMap.put(key, status);
            }
            this.log.info("MasterDataImportOp-statusMap:" + statusMap);
        }
        return statusMap;
    }

    private void validateDataStatus(ImportLogger logger, Iterator<ImportBillData> iterator, Map<String, String> statusMap, Map<String, Long> groupIds) {
        ImportBillData importRowData = iterator.next();
        JSONObject importRowJsonData = importRowData.getData();
        Map importParamMap = this.ctx.getOption();
        String importType = importParamMap.get(IMPORTTYPE).toString();
        String importDataStatus = importRowJsonData.getString("status");
        if (StringUtils.isEmpty((CharSequence)importDataStatus) || "null".equals(importDataStatus)) {
            importRowJsonData.put("status", (Object)StatusEnum.SAVE.getCode());
            importDataStatus = importRowJsonData.getString("status");
        }
        if (!StatusEnum.SAVE.getCode().equals(importDataStatus)) {
            int errMsgRowIndex = importRowData.getStartIndex();
            logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u6682\u5b58\u624d\u80fd\u5bfc\u5165\u66f4\u65b0\u3002", (String)"MasterDataImportOp_1", (String)"bd-master-opplugin", (Object[])new Object[0])).fail();
            iterator.remove();
            return;
        }
        if (StatusEnum.SAVE.getCode().equals(importDataStatus) && !IMPORTTYPE_NEW.equals(importType)) {
            String number = importRowJsonData.getString("number");
            JSONObject createOrg = importRowJsonData.getJSONObject("createorg");
            String orgNumber = createOrg == null ? "" : createOrg.getString("number");
            String key = number + "_" + orgNumber;
            String status = statusMap.get(key);
            if (StringUtils.isNotBlank((CharSequence)status) && !StatusEnum.SAVE.getCode().equals(status)) {
                int errMsgRowIndex = importRowData.getStartIndex();
                logger.log(Integer.valueOf(errMsgRowIndex), String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MasterDataImportOp_2", (String)"bd-master-opplugin", (Object[])new Object[0]), StatusEnum.getDescByCode((String)status))).fail();
                iterator.remove();
                return;
            }
        }
        this.putGroupId(importRowData, groupIds, iterator, logger);
    }
}

