/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.bill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.master.helper.TemplateMaterialHelper;
import kd.bd.master.util.TemplateMaterialUtil;
import kd.bd.master.validator.bill.MaterialReleaseBillAuditValidator;
import kd.bd.master.vo.MaterialReleaseBillVo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;

public class MaterialReleaseBillAuditPlugin
extends AbstractOperationServicePlugIn {
    private TemplateMaterialHelper templateMaterialHelper = new TemplateMaterialHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("ctrlstrategy");
        e.getFieldKeys().add("proposer");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("templatematerial");
        e.getFieldKeys().add("istempmaterial");
        e.getFieldKeys().add("baseunit");
        e.getFieldKeys().add("materialtype");
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("applynumber");
        e.getFieldKeys().add("materialname");
        e.getFieldKeys().add("modelnum");
        e.getFieldKeys().add("formalmaterialnumber");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MaterialReleaseBillAuditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (e.getDataEntities() == null || e.getDataEntities().length <= 0) {
            return;
        }
        ArrayList<MaterialReleaseBillVo> datas = new ArrayList<MaterialReleaseBillVo>(e.getDataEntities().length);
        HashSet<Long> materialPk = new HashSet<Long>();
        MaterialReleaseBillVo materialReleaseBillVo = null;
        DynamicObject tmpmaterial = null;
        String ctrlstrategy = null;
        ArrayList<DynamicObject> materials = null;
        for (DynamicObject dataEntity : e.getDataEntities()) {
            materialReleaseBillVo = new MaterialReleaseBillVo();
            ctrlstrategy = dataEntity.getString("ctrlstrategy");
            materialReleaseBillVo.setCtrlstrategy(ctrlstrategy);
            String proposer = dataEntity.getDynamicObject("proposer").getString("id");
            materialReleaseBillVo.setProposer(proposer);
            DynamicObjectCollection billentrys = dataEntity.getDynamicObjectCollection("billentry");
            if (billentrys != null && billentrys.size() > 0) {
                materials = new ArrayList<DynamicObject>(billentrys.size());
                for (DynamicObject material : billentrys) {
                    tmpmaterial = material.getDynamicObject("templatematerial");
                    if (tmpmaterial == null) continue;
                    materials.add(material);
                    materialPk.add(tmpmaterial.getLong("id"));
                }
            }
            materialReleaseBillVo.setDatas(materials);
            datas.add(materialReleaseBillVo);
        }
        Map numberMap = null;
        try {
            numberMap = this.templateMaterialHelper.createMaterialAndStrategyData(datas, materialPk);
        }
        catch (KDBizException e2) {
            e.setCancel(true);
            e.setCancelMessage(e2.getMessage());
            return;
        }
        if (numberMap != null && numberMap.size() > 0) {
            List updateParams = TemplateMaterialUtil.getUpdateCondition((Map)numberMap);
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)TemplateMaterialUtil.getAppmaterialsEntryDataSql(), (List)updateParams);
        }
    }
}

