/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.api;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bd.assistant.service.ExchangeRateService;
import kd.bos.api.ApiRequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;

public class BaseDataAPI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getExchangeRate() {
        try (ApiRequestContext ctx = ApiRequestContext.get();){
            String exchangeTableIDStr = ctx.getRequest().getParameter("exchangeTableID");
            String sourceCurrencyIDStr = ctx.getRequest().getParameter("sourceCurrencyID");
            String targetCurrencyIDStr = ctx.getRequest().getParameter("targetCurrencyID");
            String dateStr = ctx.getRequest().getParameter("date");
            Long exchangeTableID = 0L;
            Long sourceCurrencyID = 0L;
            Long targetCurrencyID = 0L;
            Date date = null;
            try {
                exchangeTableID = Long.valueOf(exchangeTableIDStr);
                sourceCurrencyID = Long.valueOf(sourceCurrencyIDStr);
                targetCurrencyID = Long.valueOf(targetCurrencyIDStr);
                if (!StringUtils.isEmpty((String)dateStr)) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    date = df.parse(dateStr);
                }
            }
            catch (Exception e) {
                String errorCode = "";
                String errorMessage = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a %s", (String)"BaseDataAPI_1", (String)"bd-assistant-webapi", (Object[])new Object[0]), e.getMessage());
                ctx.writeError(errorCode, errorMessage);
                ctx.close();
                return;
            }
            ExchangeRateService exchangeRateService = new ExchangeRateService();
            BigDecimal exchangeRate = exchangeRateService.getExchangeRate(exchangeTableID, sourceCurrencyID, targetCurrencyID, date);
            ctx.writeSuccess((Object)exchangeRate);
        }
    }
}

