/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class DrpUserAssignRoleImportPlugin
implements IImportPlugin {
    private Map<String, DynamicObject> drpUserCache = new HashMap<String, DynamicObject>(500);
    private Map<String, DynamicObject> mdrCustomerCache = new HashMap<String, DynamicObject>(500);
    private Map<String, DynamicObject> roleCache = new HashMap<String, DynamicObject>(500);
    private List<Object> drpUserpkIds = new ArrayList<Object>(500);

    public void init(Map<String, Object> importParams) {
        super.init(importParams);
    }

    public boolean resolve(Map<String, ImportLogger> urls, BiFunction<Map<String, Object>, Map<String, Object>, List<ImportLogger.ImportLog>> dataHandler) {
        return super.resolve(urls, dataHandler);
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String phone;
        String number;
        if (data.get("name") != null || StringUtils.isEmpty((String)String.valueOf(data.get("name")))) {
            importlogs.add(new ImportLogger.ImportLog("\u59d3\u540d\u5fc5\u987b\u5f55\u5165\uff01"));
            return false;
        }
        if ((data.get("number") != null || StringUtils.isEmpty((String)String.valueOf(data.get("number")))) && (data.get("phone") != null || StringUtils.isEmpty((String)String.valueOf(data.get("phone"))))) {
            importlogs.add(new ImportLogger.ImportLog("\u624b\u673a\u548c\u5de5\u53f7\u5fc5\u987b\u6709\u4e8c\u9009\u4e00\u5f55\u5165\uff01"));
            return false;
        }
        if (data.get("drpusertype") != null || StringUtils.isEmpty((String)String.valueOf(data.get("drpusertype")))) {
            importlogs.add(new ImportLogger.ImportLog("\u7528\u6237\u5206\u7c7b\u5fc5\u987b\u5f55\u5165\uff01"));
            return false;
        }
        String name = String.valueOf(data.get("name"));
        String key = this.buildDrpUserCacheKey(name, number = String.valueOf(data.get("number")), phone = String.valueOf(data.get("phone")));
        DynamicObject drpUser = this.drpUserCache.get(key);
        if (drpUser == null) {
            QFilter[] filters = new QFilter[2];
            filters[0] = new QFilter("name", "=", (Object)name);
            if (!StringUtils.isEmpty((String)number)) {
                filters[1] = new QFilter("number", "=", (Object)number);
            } else if (!StringUtils.isEmpty((String)phone)) {
                filters[1] = new QFilter("phone", "=", (Object)phone);
            }
            drpUser = QueryServiceHelper.queryOne((String)"drp_usergroup_user", (String)"id,usertype", (QFilter[])filters);
            drpUser = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id,usertype", (QFilter[])filters);
            DynamicObject aa = this.querySecUser(name, number, phone);
            if (drpUser == null) {
                drpUser = BusinessDataServiceHelper.newDynamicObject((String)"drp_usergroup_user");
            }
            this.drpUserCache.put(key, drpUser);
        }
        if (drpUser.getLong("id") == 0L) {
            importlogs.add(new ImportLogger.ImportLog("\u6839\u636e\u59d3\u540d\uff0c(\u5de5\u53f7\u6216\u624b\u673a) \u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237\u4fe1\u606f\uff01"));
            return false;
        }
        if (!(drpUser.getString("usertype").contains("1") || drpUser.getString("usertype").contains("2") || drpUser.getString("usertype").contains("4") || drpUser.getString("usertype").contains("6"))) {
            importlogs.add(new ImportLogger.ImportLog("\u8be5\u7528\u6237\u4e0d\u662f\u6e20\u9053\u7528\u6237\uff01"));
            return false;
        }
        if (data.get("mdrcustomer") == null) {
            importlogs.add(new ImportLogger.ImportLog("\u6e20\u9053\u3002\u7f16\u7801\u5fc5\u987b\u5f55\u5165\uff01"));
            return false;
        }
        String customerNumber = this.getF7Number(data, "mdrcustomer");
        if (StringUtils.isEmpty((String)customerNumber)) {
            importlogs.add(new ImportLogger.ImportLog("\u6e20\u9053\u3002\u7f16\u7801\u5fc5\u987b\u5f55\u5165\uff01"));
            return false;
        }
        DynamicObject mdrCustomer = this.mdrCustomerCache.get(customerNumber);
        if (mdrCustomer == null) {
            mdrCustomer = BusinessDataServiceHelper.loadSingleFromCache((String)"mdr_customer", (String)"id", (QFilter[])new QFilter("number", "=", (Object)customerNumber).toArray());
            if (mdrCustomer == null) {
                mdrCustomer = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer");
            }
            this.mdrCustomerCache.put(customerNumber, mdrCustomer);
        }
        if (mdrCustomer.getLong("id") == 0L) {
            importlogs.add(new ImportLogger.ImportLog("\u6839\u636e\u6e20\u9053\u7f16\u7801\u627e\u4e0d\u5230\u6e20\u9053\u4fe1\u606f\uff01"));
            return false;
        }
        if (!data.containsKey("role")) {
            importlogs.add(new ImportLogger.ImportLog("\u89d2\u8272\u3002\u7f16\u7801\u5fc5\u987b\u5f55\u5165\uff01"));
            return false;
        }
        String roleNumber = this.getF7Number(data, "role");
        if (StringUtils.isEmpty((String)roleNumber)) {
            importlogs.add(new ImportLogger.ImportLog("\u89d2\u8272\u3002\u7f16\u7801\u5fc5\u987b\u5f55\u5165\uff01"));
            return false;
        }
        DynamicObject role = this.roleCache.get(roleNumber);
        if (role == null) {
            role = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_role", (String)"id", (QFilter[])new QFilter("number", "=", (Object)roleNumber).toArray());
            if (role == null) {
                role = BusinessDataServiceHelper.newDynamicObject((String)"perm_role");
            }
            this.roleCache.put(roleNumber, role);
        }
        if (StringUtils.isEmpty((String)role.getString("id"))) {
            importlogs.add(new ImportLogger.ImportLog("\u6839\u636e\u89d2\u8272\u7f16\u7801\u627e\u4e0d\u5230\u89d2\u8272\uff01"));
            return false;
        }
        return super.beforeImportData(data, option, importlogs);
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String key = this.buildDrpUserCacheKey(data.get("name"), data.get("number"), data.get("phone"));
        Object drpUserPkId = this.drpUserCache.get(key).get("id");
        if (!this.drpUserpkIds.contains(drpUserPkId)) {
            DynamicObject drpUser = BusinessDataServiceHelper.loadSingle((Object)drpUserPkId, (String)"drp_usergroup_user");
            drpUser.set("drpusertype", data.get("drpusertype"));
            SaveServiceHelper.save((IDataEntityType)drpUser.getDataEntityType(), (Object[])new DynamicObject[]{drpUser});
            this.drpUserpkIds.add(drpUserPkId);
        }
        long userId = Long.parseLong(drpUserPkId.toString());
        long mdrCustomerId = this.mdrCustomerCache.get(this.getF7Number(data, "mdrcustomer")).getLong("id");
        String roleId = this.roleCache.get(this.getF7Number(data, "role")).getString("id");
        DynamicObject permUserRole = BusinessDataServiceHelper.loadSingle((String)"perm_userrole", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("org", "=", (Object)mdrCustomerId), new QFilter("dimtype", "=", (Object)"mdr_customer"), new QFilter("role", "=", (Object)roleId)});
        if (permUserRole == null) {
            DynamicObject userRoleNewObj = this.createUserRoleNewObj(userId, mdrCustomerId, roleId);
            SaveServiceHelper.save((IDataEntityType)userRoleNewObj.getDataEntityType(), (Object[])new DynamicObject[]{userRoleNewObj});
        }
        return this.drpUserpkIds;
    }

    private DynamicObject createUserRoleNewObj(Object userId, Object mdrCustomerId, Object roleId) {
        DynamicObject userRoleNewObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userrole");
        userRoleNewObj.set("org", mdrCustomerId);
        userRoleNewObj.set("role", roleId);
        userRoleNewObj.set("user", userId);
        userRoleNewObj.set("dimtype", (Object)"mdr_customer");
        userRoleNewObj.set("source", (Object)"2");
        return userRoleNewObj;
    }

    private DynamicObject querySecUser(String name, String number, String phone) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT T1.FID,T1.FUSERTYPE ");
        sql.append("FROM T_SEC_USER T1 ");
        sql.append("LEFT JOIN T_SEC_USER_l T10 ON T1.FID = T10.FID ");
        sql.append("WHERE T10.FTRUENAME = ? AND T10.FLOCALEID = ? ");
        Map result = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql.toString(), (Object[])new Object[]{RequestContext.get().getLang().getLangTag(), name}, (ResultSetHandler)new ResultSetHandler<Map<Object, Object>>(){

            public Map<Object, Object> handle(ResultSet rs) throws Exception {
                HashMap<Object, Object> result = new HashMap<Object, Object>(2);
                while (rs.next()) {
                    result.put("id", rs.getObject("FID"));
                    result.put("usertype", rs.getObject("FUSERTYPE"));
                }
                return result;
            }
        });
        DynamicObject drpUserGroupUser = BusinessDataServiceHelper.newDynamicObject((String)"drp_usergroup_user");
        drpUserGroupUser.set("id", result.get("id"));
        drpUserGroupUser.set("usertype", result.get("usertype"));
        return drpUserGroupUser;
    }

    private String getF7Number(Map<String, Object> data, String f7Id) {
        return String.valueOf(((Map)data.get(f7Id)).get("number"));
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        super.afterImportData(pkIds, importlogs);
    }

    private String buildDrpUserCacheKey(Object name, Object number, Object phone) {
        return name + "#" + number + "#" + phone;
    }
}

