/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bd.pbd.plugin.DrpUserAssignBasePlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class DrpUserAssignRolePlugin
extends DrpUserAssignBasePlugin {
    private static final String F_TOOLBAR = "toolbarap";
    private static final String TOOLBAR_ORG = "toolbar_org";
    private static final String BARITEM_COPY_PERM = "copy_perm";
    private static final String LIST_ORG = "list_org";
    private static final String LIST_ROLE = "list_role";
    private static final String ENTRYFIELD_ROLE_ID = "role_identity";
    private static final String ENTRYFIELD_ROLE_NUMBER = "role_number";
    private static final String ENTRYFIELD_DIMOBJ_ID = "dim_identity";

    @Override
    public void initialize() {
        super.initialize();
        Toolbar orgToolBar = (Toolbar)this.getControl(TOOLBAR_ORG);
        orgToolBar.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if (itemKey.equals(DrpUserAssignRolePlugin.BARITEM_COPY_PERM)) {
                    DrpUserAssignRolePlugin.this.copyPerm();
                }
            }
        });
        String filterAppNumsStr = "bbc,mdr,dpa,dbd";
        ArrayList<String> filterAppIds = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)filterAppNumsStr) && !filterAppNumsStr.equals("BASE") && !filterAppNumsStr.equals("SCP")) {
            if (filterAppNumsStr.contains(",")) {
                List<String> filterAppNums = Arrays.asList(filterAppNumsStr.split(","));
                for (String filterAppNum : filterAppNums) {
                    if (StringUtils.isEmpty((String)filterAppNum)) continue;
                    String filterAppId = AppMetadataCache.getAppInfo((String)filterAppNum.trim().toLowerCase()).getId();
                    filterAppIds.add(filterAppId);
                }
            } else {
                String filterAppId = AppMetadataCache.getAppInfo((String)filterAppNumsStr).getId();
                filterAppIds.add(filterAppId);
            }
        }
        this.getPageCache().put("CustomQFilter_RoleIds", new QFilter("bizdomain", "in", filterAppIds).toSerializedString());
    }

    private void copyPerm() {
        EntryGrid eg = (EntryGrid)this.getControl(LIST_ORG);
        int[] selectCounts = eg.getEntryState().getSelectedRows();
        if (selectCounts == null || selectCounts.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5df2\u6388\u6743\u6e20\u9053\u884c\u89d2\u8272\u590d\u5236\uff01", (String)"DrpUserAssignRolePlugin_0", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectCounts.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5df2\u6388\u6743\u6e20\u9053\u8fdb\u884c\u89d2\u8272\u590d\u5236\uff01", (String)"DrpUserAssignRolePlugin_1", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        int selectIndex = selectCounts[0];
        DynamicObject row_org = this.getModel().getEntryRowEntity(LIST_ORG, selectIndex);
        ArrayList<String> copyRoleIds = new ArrayList<String>();
        DynamicObjectCollection row_sub_roles = row_org.getDynamicObjectCollection(LIST_ROLE);
        for (DynamicObject row_sub_role : row_sub_roles) {
            copyRoleIds.add(row_sub_role.getString(ENTRYFIELD_ROLE_ID));
        }
        if (CollectionUtils.isEmpty(copyRoleIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6e20\u9053\u672a\u6388\u6743\uff0c\u8bf7\u9009\u62e9\u5df2\u6388\u6743\u6e20\u9053\uff01", (String)"DrpUserAssignRolePlugin_2", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount(LIST_ORG);
        for (int i = 0; i < entryRowCount; ++i) {
            if (i == selectIndex) continue;
            row_org = this.getModel().getEntryRowEntity(LIST_ORG, i);
            row_sub_roles = row_org.getDynamicObjectCollection(LIST_ROLE);
            for (String copyRoleId : copyRoleIds) {
                boolean ifFound = false;
                for (int j = 0; j < row_sub_roles.size(); ++j) {
                    DynamicObject roleRow = (DynamicObject)row_sub_roles.get(j);
                    String curRowRoleId = roleRow.getString(ENTRYFIELD_ROLE_ID);
                    if (!curRowRoleId.equals(copyRoleId)) continue;
                    ifFound = true;
                    break;
                }
                if (ifFound) continue;
                this.getModel().setEntryCurrentRowIndex(LIST_ORG, i);
                int newIndex = this.getModel().createNewEntryRow(LIST_ROLE);
                this.getModel().setValue(ENTRYFIELD_ROLE_ID, (Object)copyRoleId, newIndex);
                this.getModel().setValue(ENTRYFIELD_ROLE_NUMBER, (Object)copyRoleId, newIndex);
            }
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u89d2\u8272\u590d\u5236\u6210\u529f\u3002", (String)"DrpUserAssignRolePlugin_3", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected Toolbar getToolbar() {
        return (Toolbar)this.getControl(F_TOOLBAR);
    }

    @Override
    protected String getLeftEntryControlKey() {
        return LIST_ORG;
    }

    @Override
    protected String getDimIdentityControlKey() {
        return ENTRYFIELD_DIMOBJ_ID;
    }
}

