/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.elasticsearch.dts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.fulltext.mapping.ESFullTextMapper;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.common.util.PinYinUtil;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PurSelfMalESFullTextMapper
extends ESFullTextMapper {
    private static final Log log = LogFactory.getLog(PurSelfMalESFullTextMapper.class);
    private static final Set<String> filterRowSet = new HashSet<String>(32);
    private static final String filterRowStr = "ftaxprefpolicy,ftaxrate,fasstunitid,ftaxprice,fmaterielid,fminpackqty,fprice,fstatus,fmasterid,fspecification,fminorderqty,fistaxpref,fgoodsdetail_tag,fgoodsdetail,fpackinglist,fspecification_tag,fcurrid,fguarantee,funitid,ftaxcode,fcatlongnumber,fbizpartnerid,fenable,fftstatus";
    private static final String GOODS_SELECTFIELDS = "id,name,number,category.id,category.name,category.number,category.longnumber,brand.id,brand.number,brand.name,model,centralpurtype,taxprice,source,mallstatus,thumbnail,supplier.id,supplier.name";

    public List<RowInfo> preHandle(List<RowInfo> rowInfos) {
        Iterator<RowInfo> dataIterator = rowInfos.iterator();
        while (dataIterator.hasNext()) {
            RowInfo rowInfo = dataIterator.next();
            if (!rowInfo.getTable().equalsIgnoreCase("t_mal_prod")) {
                dataIterator.remove();
                continue;
            }
            if (null != rowInfo.getData().get("fsource") && !"1".equalsIgnoreCase(rowInfo.getData().get("fsource").toString())) {
                dataIterator.remove();
                continue;
            }
            if (null != rowInfo.getData() && null != rowInfo.getData().get("fid") && null != rowInfo.getType() && rowInfo.getType().equalsIgnoreCase("insert")) continue;
            dataIterator.remove();
        }
        if (!CollectionUtils.isEmpty(rowInfos)) {
            HashSet<Long> goodsIds = new HashSet<Long>();
            for (RowInfo rowInfo : rowInfos) {
                if (rowInfo.getTable().equalsIgnoreCase("t_mal_prod")) {
                    if (null == rowInfo.getData().get("fid")) {
                        log.error("\u65b0\u7248\u5546\u57ce\u7535\u5546\u5546\u54c1\u540c\u6b65\u5168\u6587\u68c0\u7d22\u5e93\u3002fid\u5f02\u5e38\uff1adata: key= " + rowInfo.getKey() + " ,type=" + rowInfo.getType() + " ,rowInfo.data=" + rowInfo.getData());
                        continue;
                    }
                    goodsIds.add(Long.valueOf(rowInfo.getData().get("fid").toString()));
                    rowInfo.getData().entrySet().removeIf(entry -> filterRowSet.contains(entry.getKey()));
                    if (null != rowInfo.getData().get("fid")) {
                        rowInfo.getData().put("id", rowInfo.getData().remove("fid"));
                    }
                    if (null != rowInfo.getData().get("fbrandid")) {
                        rowInfo.getData().put("brandid", rowInfo.getData().remove("fbrandid").toString());
                    }
                    if (null != rowInfo.getData().get("fclassid")) {
                        rowInfo.getData().put("classid", rowInfo.getData().remove("fclassid").toString());
                    }
                    if (null != rowInfo.getData().get("fnumber")) {
                        rowInfo.getData().put("number", rowInfo.getData().remove("fnumber").toString());
                    }
                    if (null != rowInfo.getData().get("fsource")) {
                        rowInfo.getData().put("source", rowInfo.getData().remove("fsource").toString());
                    }
                    if (null != rowInfo.getData().get("fthumbnail")) {
                        rowInfo.getData().put("mainpic", rowInfo.getData().remove("fthumbnail"));
                    }
                    if (null != rowInfo.getData().get("fmallstatus")) {
                        rowInfo.getData().put("mallstatus", rowInfo.getData().remove("fmallstatus").toString());
                    }
                    if (null != rowInfo.getData().get("fshopprice")) {
                        rowInfo.getData().put("price", rowInfo.getData().remove("fshopprice"));
                    }
                    if (null != rowInfo.getData().get("fsupplierid")) {
                        rowInfo.getData().put("supplierid", rowInfo.getData().remove("fsupplierid").toString());
                    }
                }
                if (!rowInfo.getTable().equalsIgnoreCase("t_mal_prod_l")) continue;
                rowInfo.getData().remove("fid");
                rowInfo.getData().remove("fpkid");
                rowInfo.getData().remove("fname");
                rowInfo.getData().remove("FName");
                rowInfo.getData().remove("fmodel");
                rowInfo.getData().remove("flocaleid");
                rowInfo.getData().remove("fremark");
                rowInfo.getData().remove("fdescription");
                rowInfo.getData().remove("fkeyword");
            }
            DynamicObjectCollection goodsArray = QueryServiceHelper.query((String)"pbd_goods", (String)GOODS_SELECTFIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", goodsIds)});
            block2: for (RowInfo rowInfo : rowInfos) {
                if (!rowInfo.getTable().equalsIgnoreCase("t_mal_prod")) continue;
                String id = rowInfo.getData().get("id").toString();
                for (DynamicObject goods : goodsArray) {
                    String goodsId = goods.getString("id");
                    if (!goodsId.equalsIgnoreCase(id)) continue;
                    rowInfo.getData().put("centralpurtype", goods.getString("centralpurtype"));
                    rowInfo.getData().put("model", goods.getString("model"));
                    rowInfo.getData().put("name_" + RequestContext.get().getLang().getLocale().toString().toLowerCase(), goods.getString("name"));
                    rowInfo.getData().put("classnumber", goods.getString("category.number"));
                    rowInfo.getData().put("classlongnumber", goods.getString("category.longnumber"));
                    rowInfo.getData().put("classname", goods.getString("category.name"));
                    rowInfo.getData().put("brandnumber", goods.getString("brand.number"));
                    rowInfo.getData().put("brandname", goods.getString("brand.name"));
                    rowInfo.getData().put("suppliername", goods.getString("supplier.name"));
                    continue block2;
                }
            }
            return rowInfos;
        }
        return rowInfos;
    }

    public Map<String, Object> convert2Es(String tableName, RowInfo row) {
        Map dataMap = row.getData();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : dataMap.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("price")) {
                result.put((String)entry.getKey() + "_" + FTDataType.FLOAT, entry.getValue());
                continue;
            }
            result.put((String)entry.getKey() + "_" + FTDataType.STRING, entry.getValue());
        }
        ArrayList<FieldValue> fvList = new ArrayList<FieldValue>();
        String pkId = row.getKey();
        FieldValue fvPkId = new FieldValue("pkid", (Object)String.valueOf(pkId));
        fvList.add(fvPkId);
        FieldValue fvEntityName = new FieldValue("entityname", (Object)"pbd_goods");
        fvList.add(fvEntityName);
        for (Map.Entry entry : dataMap.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase("name_zh_cn") && !((String)entry.getKey()).equalsIgnoreCase("suppliername")) continue;
            String filedName = (String)entry.getKey();
            Object pyValue = entry.getValue();
            try {
                pyValue = PinYinUtil.getMergePinyin((String)(pyValue + ""));
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                log.error("\u65b0\u7248\u5546\u57ce\u5546\u54c1\u540c\u6b65\u5168\u6587\u68c0\u7d22\u5e93\u3002trans py error\uff1a" + (Object)((Object)e));
            }
            FieldValue fvFieldNamePY = new FieldValue(filedName.replace("_zh_cn", "") + "_py_string", pyValue);
            fvList.add(fvFieldNamePY);
        }
        fvList.forEach(v -> result.put(v.getName(), v.getValue()));
        return result;
    }

    static {
        String[] split = filterRowStr.split(",");
        filterRowSet.addAll(Arrays.asList(split));
    }
}

